/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims.internal;

import android.app.PendingIntent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsConfig;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsRegistrationListener;
import com.android.ims.internal.IImsUt;

public interface IImsMMTelFeature
extends IInterface {
    public int startSession(PendingIntent var1, IImsRegistrationListener var2) throws RemoteException;

    public void endSession(int var1) throws RemoteException;

    public boolean isConnected(int var1, int var2) throws RemoteException;

    public boolean isOpened() throws RemoteException;

    public int getFeatureStatus() throws RemoteException;

    public void addRegistrationListener(IImsRegistrationListener var1) throws RemoteException;

    public void removeRegistrationListener(IImsRegistrationListener var1) throws RemoteException;

    public ImsCallProfile createCallProfile(int var1, int var2, int var3) throws RemoteException;

    public IImsCallSession createCallSession(int var1, ImsCallProfile var2) throws RemoteException;

    public IImsCallSession getPendingCallSession(int var1, String var2) throws RemoteException;

    public IImsUt getUtInterface() throws RemoteException;

    public IImsConfig getConfigInterface() throws RemoteException;

    public void turnOnIms() throws RemoteException;

    public void turnOffIms() throws RemoteException;

    public IImsEcbm getEcbmInterface() throws RemoteException;

    public void setUiTTYMode(int var1, Message var2) throws RemoteException;

    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsMMTelFeature {
        private static final String DESCRIPTOR = "com.android.ims.internal.IImsMMTelFeature";
        static final int TRANSACTION_startSession = 1;
        static final int TRANSACTION_endSession = 2;
        static final int TRANSACTION_isConnected = 3;
        static final int TRANSACTION_isOpened = 4;
        static final int TRANSACTION_getFeatureStatus = 5;
        static final int TRANSACTION_addRegistrationListener = 6;
        static final int TRANSACTION_removeRegistrationListener = 7;
        static final int TRANSACTION_createCallProfile = 8;
        static final int TRANSACTION_createCallSession = 9;
        static final int TRANSACTION_getPendingCallSession = 10;
        static final int TRANSACTION_getUtInterface = 11;
        static final int TRANSACTION_getConfigInterface = 12;
        static final int TRANSACTION_turnOnIms = 13;
        static final int TRANSACTION_turnOffIms = 14;
        static final int TRANSACTION_getEcbmInterface = 15;
        static final int TRANSACTION_setUiTTYMode = 16;
        static final int TRANSACTION_getMultiEndpointInterface = 17;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IImsMMTelFeature asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IImsMMTelFeature) {
                return (IImsMMTelFeature)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startSession";
                }
                case 2: {
                    return "endSession";
                }
                case 3: {
                    return "isConnected";
                }
                case 4: {
                    return "isOpened";
                }
                case 5: {
                    return "getFeatureStatus";
                }
                case 6: {
                    return "addRegistrationListener";
                }
                case 7: {
                    return "removeRegistrationListener";
                }
                case 8: {
                    return "createCallProfile";
                }
                case 9: {
                    return "createCallSession";
                }
                case 10: {
                    return "getPendingCallSession";
                }
                case 11: {
                    return "getUtInterface";
                }
                case 12: {
                    return "getConfigInterface";
                }
                case 13: {
                    return "turnOnIms";
                }
                case 14: {
                    return "turnOffIms";
                }
                case 15: {
                    return "getEcbmInterface";
                }
                case 16: {
                    return "setUiTTYMode";
                }
                case 17: {
                    return "getMultiEndpointInterface";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    PendingIntent _arg0 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    IImsRegistrationListener _arg1 = IImsRegistrationListener.Stub.asInterface(data.readStrongBinder());
                    int _result = this.startSession(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.endSession(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _result = this.isConnected(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isOpened();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _result = this.getFeatureStatus();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    IImsRegistrationListener _arg0 = IImsRegistrationListener.Stub.asInterface(data.readStrongBinder());
                    this.addRegistrationListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    IImsRegistrationListener _arg0 = IImsRegistrationListener.Stub.asInterface(data.readStrongBinder());
                    this.removeRegistrationListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ImsCallProfile _result = this.createCallProfile(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ImsCallProfile _arg1 = 0 != data.readInt() ? ImsCallProfile.CREATOR.createFromParcel(data) : null;
                    IImsCallSession _result = this.createCallSession(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IImsCallSession _result = this.getPendingCallSession(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    IImsUt _result = this.getUtInterface();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    IImsConfig _result = this.getConfigInterface();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    this.turnOnIms();
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    this.turnOffIms();
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    IImsEcbm _result = this.getEcbmInterface();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Message _arg1 = 0 != data.readInt() ? Message.CREATOR.createFromParcel(data) : null;
                    this.setUiTTYMode(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    IImsMultiEndpoint _result = this.getMultiEndpointInterface();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IImsMMTelFeature impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IImsMMTelFeature getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IImsMMTelFeature {
            private IBinder mRemote;
            public static IImsMMTelFeature sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startSession(PendingIntent incomingCallIntent, IImsRegistrationListener listener) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (incomingCallIntent != null) {
                        _data.writeInt(1);
                        incomingCallIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().startSession(incomingCallIntent, listener);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void endSession(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().endSession(sessionId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isConnected(int callSessionType, int callType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(callSessionType);
                    _data.writeInt(callType);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isConnected(callSessionType, callType);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOpened() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isOpened();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFeatureStatus() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getFeatureStatus();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addRegistrationListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeRegistrationListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImsCallProfile createCallProfile(int sessionId, int callSessionType, int callType) throws RemoteException {
                ImsCallProfile _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(callSessionType);
                    _data.writeInt(callType);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ImsCallProfile imsCallProfile = Stub.getDefaultImpl().createCallProfile(sessionId, callSessionType, callType);
                        return imsCallProfile;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ImsCallProfile.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsCallSession createCallSession(int sessionId, ImsCallProfile profile) throws RemoteException {
                IImsCallSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    if (profile != null) {
                        _data.writeInt(1);
                        profile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImsCallSession iImsCallSession = Stub.getDefaultImpl().createCallSession(sessionId, profile);
                        return iImsCallSession;
                    }
                    _reply.readException();
                    _result = IImsCallSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsCallSession getPendingCallSession(int sessionId, String callId) throws RemoteException {
                IImsCallSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeString(callId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImsCallSession iImsCallSession = Stub.getDefaultImpl().getPendingCallSession(sessionId, callId);
                        return iImsCallSession;
                    }
                    _reply.readException();
                    _result = IImsCallSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsUt getUtInterface() throws RemoteException {
                IImsUt _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImsUt iImsUt = Stub.getDefaultImpl().getUtInterface();
                        return iImsUt;
                    }
                    _reply.readException();
                    _result = IImsUt.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsConfig getConfigInterface() throws RemoteException {
                IImsConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImsConfig iImsConfig = Stub.getDefaultImpl().getConfigInterface();
                        return iImsConfig;
                    }
                    _reply.readException();
                    _result = IImsConfig.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void turnOnIms() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().turnOnIms();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void turnOffIms() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().turnOffIms();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsEcbm getEcbmInterface() throws RemoteException {
                IImsEcbm _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImsEcbm iImsEcbm = Stub.getDefaultImpl().getEcbmInterface();
                        return iImsEcbm;
                    }
                    _reply.readException();
                    _result = IImsEcbm.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUiTTYMode(int uiTtyMode, Message onComplete) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uiTtyMode);
                    if (onComplete != null) {
                        _data.writeInt(1);
                        onComplete.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setUiTTYMode(uiTtyMode, onComplete);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
                IImsMultiEndpoint _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImsMultiEndpoint iImsMultiEndpoint = Stub.getDefaultImpl().getMultiEndpointInterface();
                        return iImsMultiEndpoint;
                    }
                    _reply.readException();
                    _result = IImsMultiEndpoint.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IImsMMTelFeature {
        @Override
        public int startSession(PendingIntent incomingCallIntent, IImsRegistrationListener listener) throws RemoteException {
            return 0;
        }

        @Override
        public void endSession(int sessionId) throws RemoteException {
        }

        @Override
        public boolean isConnected(int callSessionType, int callType) throws RemoteException {
            return false;
        }

        @Override
        public boolean isOpened() throws RemoteException {
            return false;
        }

        @Override
        public int getFeatureStatus() throws RemoteException {
            return 0;
        }

        @Override
        public void addRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
        }

        @Override
        public void removeRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
        }

        @Override
        public ImsCallProfile createCallProfile(int sessionId, int callSessionType, int callType) throws RemoteException {
            return null;
        }

        @Override
        public IImsCallSession createCallSession(int sessionId, ImsCallProfile profile) throws RemoteException {
            return null;
        }

        @Override
        public IImsCallSession getPendingCallSession(int sessionId, String callId) throws RemoteException {
            return null;
        }

        @Override
        public IImsUt getUtInterface() throws RemoteException {
            return null;
        }

        @Override
        public IImsConfig getConfigInterface() throws RemoteException {
            return null;
        }

        @Override
        public void turnOnIms() throws RemoteException {
        }

        @Override
        public void turnOffIms() throws RemoteException {
        }

        @Override
        public IImsEcbm getEcbmInterface() throws RemoteException {
            return null;
        }

        @Override
        public void setUiTTYMode(int uiTtyMode, Message onComplete) throws RemoteException {
        }

        @Override
        public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

