/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims.internal;

import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.telecom.Connection;
import android.telecom.Log;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.ims.internal.IImsVideoCallCallback;
import com.android.ims.internal.IImsVideoCallProvider;
import com.android.ims.internal.VideoPauseTracker;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ImsVideoCallProviderWrapper
extends Connection.VideoProvider {
    private static final int MSG_RECEIVE_SESSION_MODIFY_REQUEST = 1;
    private static final int MSG_RECEIVE_SESSION_MODIFY_RESPONSE = 2;
    private static final int MSG_HANDLE_CALL_SESSION_EVENT = 3;
    private static final int MSG_CHANGE_PEER_DIMENSIONS = 4;
    private static final int MSG_CHANGE_CALL_DATA_USAGE = 5;
    private static final int MSG_CHANGE_CAMERA_CAPABILITIES = 6;
    private static final int MSG_CHANGE_VIDEO_QUALITY = 7;
    private final IImsVideoCallProvider mVideoCallProvider;
    private final ImsVideoCallCallback mBinder;
    private RegistrantList mDataUsageUpdateRegistrants = new RegistrantList();
    private final Set<ImsVideoProviderWrapperCallback> mCallbacks = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
    private VideoPauseTracker mVideoPauseTracker = new VideoPauseTracker();
    private boolean mUseVideoPauseWorkaround = false;
    private int mCurrentVideoState;
    private boolean mIsVideoEnabled = true;
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        @Override
        public void binderDied() {
            ImsVideoCallProviderWrapper.this.mVideoCallProvider.asBinder().unlinkToDeath(this, 0);
        }
    };
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    VideoProfile videoProfile = (VideoProfile)msg.obj;
                    if (!VideoProfile.isVideo(ImsVideoCallProviderWrapper.this.mCurrentVideoState) && VideoProfile.isVideo(videoProfile.getVideoState()) && !ImsVideoCallProviderWrapper.this.mIsVideoEnabled) {
                        Log.i(ImsVideoCallProviderWrapper.this, "receiveSessionModifyRequest: requestedVideoState=%s; rejecting as video is disabled.", videoProfile.getVideoState());
                        try {
                            ImsVideoCallProviderWrapper.this.mVideoCallProvider.sendSessionModifyResponse(new VideoProfile(0));
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        return;
                    }
                    ImsVideoCallProviderWrapper.this.receiveSessionModifyRequest(videoProfile);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        int status = (Integer)args.arg1;
                        VideoProfile requestProfile = (VideoProfile)args.arg2;
                        VideoProfile responseProfile = (VideoProfile)args.arg3;
                        ImsVideoCallProviderWrapper.this.receiveSessionModifyResponse(status, requestProfile, responseProfile);
                        for (ImsVideoProviderWrapperCallback callback : ImsVideoCallProviderWrapper.this.mCallbacks) {
                            if (callback == null) continue;
                            callback.onReceiveSessionModifyResponse(status, requestProfile, responseProfile);
                        }
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 3: {
                    ImsVideoCallProviderWrapper.this.handleCallSessionEvent((Integer)msg.obj);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        int width = (Integer)args.arg1;
                        int height = (Integer)args.arg2;
                        ImsVideoCallProviderWrapper.this.changePeerDimensions(width, height);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 5: {
                    ImsVideoCallProviderWrapper.this.setCallDataUsage((Long)msg.obj);
                    ImsVideoCallProviderWrapper.this.mDataUsageUpdateRegistrants.notifyResult(msg.obj);
                    break;
                }
                case 6: {
                    ImsVideoCallProviderWrapper.this.changeCameraCapabilities((VideoProfile.CameraCapabilities)msg.obj);
                    break;
                }
                case 7: {
                    ImsVideoCallProviderWrapper.this.changeVideoQuality(msg.arg1);
                    break;
                }
            }
        }
    };

    public void registerForDataUsageUpdate(Handler h, int what, Object obj) {
        this.mDataUsageUpdateRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForDataUsageUpdate(Handler h) {
        this.mDataUsageUpdateRegistrants.remove(h);
    }

    public void addImsVideoProviderCallback(ImsVideoProviderWrapperCallback callback) {
        this.mCallbacks.add(callback);
    }

    public void removeImsVideoProviderCallback(ImsVideoProviderWrapperCallback callback) {
        this.mCallbacks.remove(callback);
    }

    public ImsVideoCallProviderWrapper(IImsVideoCallProvider videoProvider) throws RemoteException {
        this.mVideoCallProvider = videoProvider;
        if (videoProvider != null) {
            this.mVideoCallProvider.asBinder().linkToDeath(this.mDeathRecipient, 0);
            this.mBinder = new ImsVideoCallCallback();
            this.mVideoCallProvider.setCallback(this.mBinder);
        } else {
            this.mBinder = null;
        }
    }

    @VisibleForTesting
    public ImsVideoCallProviderWrapper(IImsVideoCallProvider videoProvider, VideoPauseTracker videoPauseTracker) throws RemoteException {
        this(videoProvider);
        this.mVideoPauseTracker = videoPauseTracker;
    }

    @Override
    public void onSetCamera(String cameraId) {
        try {
            this.mVideoCallProvider.setCamera(cameraId, Binder.getCallingUid());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onSetPreviewSurface(Surface surface) {
        try {
            this.mVideoCallProvider.setPreviewSurface(surface);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onSetDisplaySurface(Surface surface) {
        try {
            this.mVideoCallProvider.setDisplaySurface(surface);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onSetDeviceOrientation(int rotation) {
        try {
            this.mVideoCallProvider.setDeviceOrientation(rotation);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onSetZoom(float value) {
        try {
            this.mVideoCallProvider.setZoom(value);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onSendSessionModifyRequest(VideoProfile fromProfile, VideoProfile toProfile) {
        if (fromProfile == null || toProfile == null) {
            Log.w(this, "onSendSessionModifyRequest: null profile in request.", new Object[0]);
            return;
        }
        try {
            if (ImsVideoCallProviderWrapper.isResumeRequest(fromProfile.getVideoState(), toProfile.getVideoState()) && !VideoProfile.isPaused(this.mCurrentVideoState)) {
                Log.i(this, "onSendSessionModifyRequest: fromVideoState=%s, toVideoState=%s; skipping resume request - already resumed.", VideoProfile.videoStateToString(fromProfile.getVideoState()), VideoProfile.videoStateToString(toProfile.getVideoState()));
                return;
            }
            toProfile = this.maybeFilterPauseResume(fromProfile, toProfile, 1);
            int fromVideoState = fromProfile.getVideoState();
            int toVideoState = toProfile.getVideoState();
            Log.i(this, "onSendSessionModifyRequest: fromVideoState=%s, toVideoState=%s; ", VideoProfile.videoStateToString(fromProfile.getVideoState()), VideoProfile.videoStateToString(toProfile.getVideoState()));
            this.mVideoCallProvider.sendSessionModifyRequest(fromProfile, toProfile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onSendSessionModifyResponse(VideoProfile responseProfile) {
        try {
            this.mVideoCallProvider.sendSessionModifyResponse(responseProfile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onRequestCameraCapabilities() {
        try {
            this.mVideoCallProvider.requestCameraCapabilities();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onRequestConnectionDataUsage() {
        try {
            this.mVideoCallProvider.requestCallDataUsage();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onSetPauseImage(Uri uri) {
        try {
            this.mVideoCallProvider.setPauseImage(uri);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    public static boolean isPauseRequest(int from, int to) {
        boolean fromPaused = VideoProfile.isPaused(from);
        boolean toPaused = VideoProfile.isPaused(to);
        return !fromPaused && toPaused;
    }

    @VisibleForTesting
    public static boolean isResumeRequest(int from, int to) {
        boolean fromPaused = VideoProfile.isPaused(from);
        boolean toPaused = VideoProfile.isPaused(to);
        return fromPaused && !toPaused;
    }

    @VisibleForTesting
    public static boolean isTurnOffCameraRequest(int from, int to) {
        return VideoProfile.isTransmissionEnabled(from) && !VideoProfile.isTransmissionEnabled(to);
    }

    @VisibleForTesting
    public static boolean isTurnOnCameraRequest(int from, int to) {
        return !VideoProfile.isTransmissionEnabled(from) && VideoProfile.isTransmissionEnabled(to);
    }

    @VisibleForTesting
    public VideoProfile maybeFilterPauseResume(VideoProfile fromProfile, VideoProfile toProfile, int source) {
        int fromVideoState = fromProfile.getVideoState();
        int toVideoState = toProfile.getVideoState();
        boolean isPauseSpecialCase = source == 1 && VideoProfile.isPaused(fromVideoState) && VideoProfile.isPaused(toVideoState);
        boolean isPauseRequest = ImsVideoCallProviderWrapper.isPauseRequest(fromVideoState, toVideoState) || isPauseSpecialCase;
        boolean isResumeRequest = ImsVideoCallProviderWrapper.isResumeRequest(fromVideoState, toVideoState);
        if (isPauseRequest) {
            Log.i(this, "maybeFilterPauseResume: isPauseRequest (from=%s, to=%s)", VideoProfile.videoStateToString(fromVideoState), VideoProfile.videoStateToString(toVideoState));
            if (!this.mVideoPauseTracker.shouldPauseVideoFor(source) && !isPauseSpecialCase) {
                toProfile = new VideoProfile(toVideoState &= 0xFFFFFFFB, toProfile.getQuality());
            }
        } else if (isResumeRequest) {
            boolean isTurnOffCameraRequest = ImsVideoCallProviderWrapper.isTurnOffCameraRequest(fromVideoState, toVideoState);
            boolean isTurnOnCameraRequest = ImsVideoCallProviderWrapper.isTurnOnCameraRequest(fromVideoState, toVideoState);
            if (this.mUseVideoPauseWorkaround && (isTurnOffCameraRequest || isTurnOnCameraRequest)) {
                Log.i(this, "maybeFilterPauseResume: isResumeRequest, but camera turning on/off so skipping (from=%s, to=%s)", VideoProfile.videoStateToString(fromVideoState), VideoProfile.videoStateToString(toVideoState));
                return toProfile;
            }
            Log.i(this, "maybeFilterPauseResume: isResumeRequest (from=%s, to=%s)", VideoProfile.videoStateToString(fromVideoState), VideoProfile.videoStateToString(toVideoState));
            if (!this.mVideoPauseTracker.shouldResumeVideoFor(source)) {
                toProfile = new VideoProfile(toVideoState |= 4, toProfile.getQuality());
            }
        }
        return toProfile;
    }

    public void pauseVideo(int fromVideoState, int source) {
        if (this.mVideoPauseTracker.shouldPauseVideoFor(source)) {
            VideoProfile fromProfile = new VideoProfile(fromVideoState);
            VideoProfile toProfile = new VideoProfile(fromVideoState | 4);
            try {
                Log.i(this, "pauseVideo: fromVideoState=%s, toVideoState=%s", VideoProfile.videoStateToString(fromProfile.getVideoState()), VideoProfile.videoStateToString(toProfile.getVideoState()));
                this.mVideoCallProvider.sendSessionModifyRequest(fromProfile, toProfile);
            }
            catch (RemoteException remoteException) {}
        } else {
            Log.i(this, "pauseVideo: video already paused", new Object[0]);
        }
    }

    public void resumeVideo(int fromVideoState, int source) {
        if (this.mVideoPauseTracker.shouldResumeVideoFor(source)) {
            VideoProfile fromProfile = new VideoProfile(fromVideoState);
            VideoProfile toProfile = new VideoProfile(fromVideoState & 0xFFFFFFFB);
            try {
                Log.i(this, "resumeVideo: fromVideoState=%s, toVideoState=%s", VideoProfile.videoStateToString(fromProfile.getVideoState()), VideoProfile.videoStateToString(toProfile.getVideoState()));
                this.mVideoCallProvider.sendSessionModifyRequest(fromProfile, toProfile);
            }
            catch (RemoteException remoteException) {}
        } else {
            Log.i(this, "resumeVideo: remaining paused (paused from other sources)", new Object[0]);
        }
    }

    public boolean wasVideoPausedFromSource(int source) {
        return this.mVideoPauseTracker.wasVideoPausedFromSource(source);
    }

    public void setUseVideoPauseWorkaround(boolean useVideoPauseWorkaround) {
        this.mUseVideoPauseWorkaround = useVideoPauseWorkaround;
    }

    public void onVideoStateChanged(int newVideoState) {
        if (VideoProfile.isPaused(this.mCurrentVideoState) && !VideoProfile.isPaused(newVideoState)) {
            Log.i(this, "onVideoStateChanged: currentVideoState=%s, newVideoState=%s, clearing pending pause requests.", VideoProfile.videoStateToString(this.mCurrentVideoState), VideoProfile.videoStateToString(newVideoState));
            this.mVideoPauseTracker.clearPauseRequests();
        } else {
            Log.d(this, "onVideoStateChanged: currentVideoState=%s, newVideoState=%s", VideoProfile.videoStateToString(this.mCurrentVideoState), VideoProfile.videoStateToString(newVideoState));
        }
        this.mCurrentVideoState = newVideoState;
    }

    public void setIsVideoEnabled(boolean isVideoEnabled) {
        this.mIsVideoEnabled = isVideoEnabled;
    }

    private final class ImsVideoCallCallback
    extends IImsVideoCallCallback.Stub {
        private ImsVideoCallCallback() {
        }

        @Override
        public void receiveSessionModifyRequest(VideoProfile VideoProfile2) {
            ImsVideoCallProviderWrapper.this.mHandler.obtainMessage(1, VideoProfile2).sendToTarget();
        }

        @Override
        public void receiveSessionModifyResponse(int status, VideoProfile requestProfile, VideoProfile responseProfile) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = status;
            args.arg2 = requestProfile;
            args.arg3 = responseProfile;
            ImsVideoCallProviderWrapper.this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        @Override
        public void handleCallSessionEvent(int event) {
            ImsVideoCallProviderWrapper.this.mHandler.obtainMessage(3, event).sendToTarget();
        }

        @Override
        public void changePeerDimensions(int width, int height) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = width;
            args.arg2 = height;
            ImsVideoCallProviderWrapper.this.mHandler.obtainMessage(4, args).sendToTarget();
        }

        @Override
        public void changeVideoQuality(int videoQuality) {
            ImsVideoCallProviderWrapper.this.mHandler.obtainMessage(7, videoQuality, 0).sendToTarget();
        }

        @Override
        public void changeCallDataUsage(long dataUsage) {
            ImsVideoCallProviderWrapper.this.mHandler.obtainMessage(5, dataUsage).sendToTarget();
        }

        @Override
        public void changeCameraCapabilities(VideoProfile.CameraCapabilities cameraCapabilities) {
            ImsVideoCallProviderWrapper.this.mHandler.obtainMessage(6, cameraCapabilities).sendToTarget();
        }
    }

    public static interface ImsVideoProviderWrapperCallback {
        public void onReceiveSessionModifyResponse(int var1, VideoProfile var2, VideoProfile var3);
    }
}

