/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims.internal.uce.uceservice;

import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.ims.internal.uce.uceservice.IUceService;
import java.util.HashMap;

public class ImsUceManager {
    private static final String LOG_TAG = "ImsUceManager";
    private static final String UCE_SERVICE = "uce";
    private IUceService mUceService = null;
    private UceServiceDeathRecipient mDeathReceipient = new UceServiceDeathRecipient();
    private Context mContext;
    private int mPhoneId;
    private static HashMap<Integer, ImsUceManager> sUceManagerInstances = new HashMap();
    public static final String ACTION_UCE_SERVICE_UP = "com.android.ims.internal.uce.UCE_SERVICE_UP";
    public static final String ACTION_UCE_SERVICE_DOWN = "com.android.ims.internal.uce.UCE_SERVICE_DOWN";
    public static final int UCE_SERVICE_STATUS_FAILURE = 0;
    public static final int UCE_SERVICE_STATUS_ON = 1;
    public static final int UCE_SERVICE_STATUS_CLOSED = 2;
    public static final int UCE_SERVICE_STATUS_READY = 3;
    public static final String EXTRA_PHONE_ID = "android:phone_id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImsUceManager getInstance(Context context, int phoneId) {
        HashMap<Integer, ImsUceManager> hashMap = sUceManagerInstances;
        synchronized (hashMap) {
            if (sUceManagerInstances.containsKey(phoneId)) {
                return sUceManagerInstances.get(phoneId);
            }
            ImsUceManager uceMgr = new ImsUceManager(context, phoneId);
            sUceManagerInstances.put(phoneId, uceMgr);
            return uceMgr;
        }
    }

    private ImsUceManager(Context context, int phoneId) {
        this.mContext = context;
        this.mPhoneId = phoneId;
        this.createUceService(true);
    }

    public IUceService getUceServiceInstance() {
        return this.mUceService;
    }

    private String getUceServiceName(int phoneId) {
        return UCE_SERVICE;
    }

    public void createUceService(boolean checkService) {
        IBinder binder;
        if (checkService && (binder = ServiceManager.checkService(this.getUceServiceName(this.mPhoneId))) == null) {
            return;
        }
        IBinder b = ServiceManager.getService(this.getUceServiceName(this.mPhoneId));
        if (b != null) {
            try {
                b.linkToDeath(this.mDeathReceipient, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mUceService = IUceService.Stub.asInterface(b);
    }

    private class UceServiceDeathRecipient
    implements IBinder.DeathRecipient {
        private UceServiceDeathRecipient() {
        }

        @Override
        public void binderDied() {
            ImsUceManager.this.mUceService = null;
            if (ImsUceManager.this.mContext != null) {
                Intent intent = new Intent(ImsUceManager.ACTION_UCE_SERVICE_DOWN);
                intent.putExtra(ImsUceManager.EXTRA_PHONE_ID, ImsUceManager.this.mPhoneId);
                ImsUceManager.this.mContext.sendBroadcast(new Intent(intent));
            }
        }
    }
}

