/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.alsa;

import android.util.Slog;
import com.android.internal.alsa.LineTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class AlsaCardsParser {
    private static final String TAG = "AlsaCardsParser";
    protected static final boolean DEBUG = false;
    private static final String kAlsaFolderPath = "/proc/asound";
    private static final String kCardsFilePath = "/proc/asound/cards";
    private static final String kDeviceAddressPrefix = "/dev/bus/usb/";
    private static LineTokenizer mTokenizer = new LineTokenizer(" :[]");
    private ArrayList<AlsaCardRecord> mCardRecords = new ArrayList();
    public static final int SCANSTATUS_NOTSCANNED = -1;
    public static final int SCANSTATUS_SUCCESS = 0;
    public static final int SCANSTATUS_FAIL = 1;
    public static final int SCANSTATUS_EMPTY = 2;
    private int mScanStatus = -1;

    public int scan() {
        this.mCardRecords = new ArrayList();
        File cardsFile = new File(kCardsFilePath);
        try {
            FileReader reader = new FileReader(cardsFile);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                AlsaCardRecord cardRecord = new AlsaCardRecord();
                cardRecord.parse(line, 0);
                line = bufferedReader.readLine();
                if (line == null) break;
                cardRecord.parse(line, 1);
                int cardNum = cardRecord.mCardNum;
                String cardFolderPath = "/proc/asound/card" + cardNum;
                File usbbusFile = new File(cardFolderPath + "/usbbus");
                if (usbbusFile.exists()) {
                    FileReader usbbusReader = new FileReader(usbbusFile);
                    String deviceAddress = new BufferedReader(usbbusReader).readLine();
                    if (deviceAddress != null) {
                        cardRecord.setDeviceAddress(kDeviceAddressPrefix + deviceAddress);
                    }
                    usbbusReader.close();
                }
                this.mCardRecords.add(cardRecord);
            }
            reader.close();
            this.mScanStatus = this.mCardRecords.size() > 0 ? 0 : 2;
        }
        catch (FileNotFoundException e) {
            this.mScanStatus = 1;
        }
        catch (IOException e) {
            this.mScanStatus = 1;
        }
        return this.mScanStatus;
    }

    public int getScanStatus() {
        return this.mScanStatus;
    }

    public AlsaCardRecord findCardNumFor(String deviceAddress) {
        for (AlsaCardRecord cardRec : this.mCardRecords) {
            if (!cardRec.isUsb() || !cardRec.mUsbDeviceAddress.equals(deviceAddress)) continue;
            return cardRec;
        }
        return null;
    }

    private void Log(String heading) {
    }

    public class AlsaCardRecord {
        private static final String TAG = "AlsaCardRecord";
        private static final String kUsbCardKeyStr = "at usb-";
        int mCardNum = -1;
        String mField1 = "";
        String mCardName = "";
        String mCardDescription = "";
        private String mUsbDeviceAddress = null;

        public int getCardNum() {
            return this.mCardNum;
        }

        public String getCardName() {
            return this.mCardName;
        }

        public String getCardDescription() {
            return this.mCardDescription;
        }

        public void setDeviceAddress(String usbDeviceAddress) {
            this.mUsbDeviceAddress = usbDeviceAddress;
        }

        private boolean parse(String line, int lineIndex) {
            int tokenIndex = 0;
            int delimIndex = 0;
            if (lineIndex == 0) {
                tokenIndex = mTokenizer.nextToken(line, tokenIndex);
                delimIndex = mTokenizer.nextDelimiter(line, tokenIndex);
                try {
                    this.mCardNum = Integer.parseInt(line.substring(tokenIndex, delimIndex));
                }
                catch (NumberFormatException e) {
                    Slog.e(TAG, "Failed to parse line " + lineIndex + " of " + AlsaCardsParser.kCardsFilePath + ": " + line.substring(tokenIndex, delimIndex));
                    return false;
                }
                tokenIndex = mTokenizer.nextToken(line, delimIndex);
                delimIndex = mTokenizer.nextDelimiter(line, tokenIndex);
                this.mField1 = line.substring(tokenIndex, delimIndex);
                tokenIndex = mTokenizer.nextToken(line, delimIndex);
                this.mCardName = line.substring(tokenIndex);
            } else if (lineIndex == 1 && (tokenIndex = mTokenizer.nextToken(line, 0)) != -1) {
                boolean isUsb;
                int keyIndex = line.indexOf(kUsbCardKeyStr);
                boolean bl = isUsb = keyIndex != -1;
                if (isUsb) {
                    this.mCardDescription = line.substring(tokenIndex, keyIndex - 1);
                }
            }
            return true;
        }

        boolean isUsb() {
            return this.mUsbDeviceAddress != null;
        }

        public String textFormat() {
            return this.mCardName + " : " + this.mCardDescription + " [addr:" + this.mUsbDeviceAddress + "]";
        }

        public void log(int listIndex) {
            Slog.d(TAG, "" + listIndex + " [" + this.mCardNum + " " + this.mCardName + " : " + this.mCardDescription + " usb:" + this.isUsb());
        }
    }
}

