/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.app.ResolverActivity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

abstract class AbstractResolverComparator
implements Comparator<ResolverActivity.ResolvedComponentInfo> {
    private static final int NUM_OF_TOP_ANNOTATIONS_TO_USE = 3;
    private static final boolean DEBUG = false;
    private static final String TAG = "AbstractResolverComp";
    protected AfterCompute mAfterCompute;
    protected final PackageManager mPm;
    protected final UsageStatsManager mUsm;
    protected String[] mAnnotations;
    protected String mContentType;
    private final boolean mHttp;
    private final String mDefaultBrowserPackageName;
    static final int RANKER_SERVICE_RESULT = 0;
    static final int RANKER_RESULT_TIMEOUT = 1;
    private static final int WATCHDOG_TIMEOUT_MILLIS = 500;
    protected final Handler mHandler = new Handler(Looper.getMainLooper()){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (!AbstractResolverComparator.this.mHandler.hasMessages(1)) break;
                    AbstractResolverComparator.this.handleResultMessage(msg);
                    AbstractResolverComparator.this.mHandler.removeMessages(1);
                    AbstractResolverComparator.this.afterCompute();
                    break;
                }
                case 1: {
                    AbstractResolverComparator.this.mHandler.removeMessages(0);
                    AbstractResolverComparator.this.afterCompute();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    };

    AbstractResolverComparator(Context context, Intent intent) {
        String scheme = intent.getScheme();
        this.mHttp = "http".equals(scheme) || "https".equals(scheme);
        this.mContentType = intent.getType();
        this.getContentAnnotations(intent);
        this.mPm = context.getPackageManager();
        this.mUsm = (UsageStatsManager)context.getSystemService("usagestats");
        this.mDefaultBrowserPackageName = this.mHttp ? this.mPm.getDefaultBrowserPackageNameAsUser(UserHandle.myUserId()) : null;
    }

    private void getContentAnnotations(Intent intent) {
        ArrayList<String> annotations = intent.getStringArrayListExtra("android.intent.extra.CONTENT_ANNOTATIONS");
        if (annotations != null) {
            int size = annotations.size();
            if (size > 3) {
                size = 3;
            }
            this.mAnnotations = new String[size];
            for (int i = 0; i < size; ++i) {
                this.mAnnotations[i] = annotations.get(i);
            }
        }
    }

    void setCallBack(AfterCompute afterCompute) {
        this.mAfterCompute = afterCompute;
    }

    protected final void afterCompute() {
        AfterCompute afterCompute = this.mAfterCompute;
        if (afterCompute != null) {
            afterCompute.afterCompute();
        }
    }

    @Override
    public final int compare(ResolverActivity.ResolvedComponentInfo lhsp, ResolverActivity.ResolvedComponentInfo rhsp) {
        ResolveInfo lhs = lhsp.getResolveInfoAt(0);
        ResolveInfo rhs = rhsp.getResolveInfoAt(0);
        if (lhs.targetUserId != -2) {
            return rhs.targetUserId != -2 ? 0 : 1;
        }
        if (rhs.targetUserId != -2) {
            return -1;
        }
        if (this.mHttp) {
            boolean rhsSpecific;
            if (this.isDefaultBrowser(lhs)) {
                return -1;
            }
            if (this.isDefaultBrowser(rhs)) {
                return 1;
            }
            boolean lhsSpecific = ResolverActivity.isSpecificUriMatch(lhs.match);
            if (lhsSpecific != (rhsSpecific = ResolverActivity.isSpecificUriMatch(rhs.match))) {
                return lhsSpecific ? -1 : 1;
            }
        }
        return this.compare(lhs, rhs);
    }

    @Override
    abstract int compare(ResolveInfo var1, ResolveInfo var2);

    final void compute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        this.beforeCompute();
        this.doCompute(targets);
    }

    abstract void doCompute(List<ResolverActivity.ResolvedComponentInfo> var1);

    abstract float getScore(ComponentName var1);

    abstract void handleResultMessage(Message var1);

    final void updateChooserCounts(String packageName, int userId, String action) {
        if (this.mUsm != null) {
            this.mUsm.reportChooserSelection(packageName, userId, this.mContentType, this.mAnnotations, action);
        }
    }

    void updateModel(ComponentName componentName) {
    }

    void beforeCompute() {
        if (this.mHandler == null) {
            Log.d(TAG, "Error: Handler is Null; Needs to be initialized.");
            return;
        }
        this.mHandler.sendEmptyMessageDelayed(1, 500L);
    }

    void destroy() {
        this.mHandler.removeMessages(0);
        this.mHandler.removeMessages(1);
        this.afterCompute();
    }

    private boolean isDefaultBrowser(ResolveInfo ri) {
        if (ri.targetUserId != -2) {
            return false;
        }
        return ri.activityInfo.packageName != null && ri.activityInfo.packageName.equals(this.mDefaultBrowserPackageName);
    }

    static interface AfterCompute {
        public void afterCompute();
    }
}

