/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.UnsupportedAppUsage;
import android.app.Activity;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.app.AlertController;

public abstract class AlertActivity
extends Activity
implements DialogInterface {
    @UnsupportedAppUsage
    protected AlertController mAlert;
    @UnsupportedAppUsage
    protected AlertController.AlertParams mAlertParams;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAlert = AlertController.create(this, this, this.getWindow());
        this.mAlertParams = new AlertController.AlertParams(this);
    }

    @Override
    public void cancel() {
        this.finish();
    }

    @Override
    public void dismiss() {
        if (!this.isFinishing()) {
            this.finish();
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return AlertActivity.dispatchPopulateAccessibilityEvent(this, event);
    }

    public static boolean dispatchPopulateAccessibilityEvent(Activity act, AccessibilityEvent event) {
        event.setClassName(Dialog.class.getName());
        event.setPackageName(act.getPackageName());
        WindowManager.LayoutParams params = act.getWindow().getAttributes();
        boolean isFullScreen = params.width == -1 && params.height == -1;
        event.setFullScreen(isFullScreen);
        return false;
    }

    @UnsupportedAppUsage
    protected void setupAlert() {
        this.mAlert.installContent(this.mAlertParams);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mAlert.onKeyDown(keyCode, event)) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mAlert.onKeyUp(keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }
}

