/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.prediction.AppPredictor;
import android.app.prediction.AppTarget;
import android.app.prediction.AppTargetEvent;
import android.app.prediction.AppTargetId;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Message;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.app.AbstractResolverComparator;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverRankerServiceResolverComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;

class AppPredictionServiceResolverComparator
extends AbstractResolverComparator {
    private static final String TAG = "APSResolverComparator";
    private static final boolean DEBUG = false;
    private final AppPredictor mAppPredictor;
    private final Context mContext;
    private final Map<ComponentName, Integer> mTargetRanks = new HashMap<ComponentName, Integer>();
    private final UserHandle mUser;
    private final Intent mIntent;
    private final String mReferrerPackage;
    private ResolverRankerServiceResolverComparator mResolverRankerService;

    AppPredictionServiceResolverComparator(Context context, Intent intent, String referrerPackage, AppPredictor appPredictor, UserHandle user) {
        super(context, intent);
        this.mContext = context;
        this.mIntent = intent;
        this.mAppPredictor = appPredictor;
        this.mUser = user;
        this.mReferrerPackage = referrerPackage;
    }

    @Override
    int compare(ResolveInfo lhs, ResolveInfo rhs) {
        if (this.mResolverRankerService != null) {
            return this.mResolverRankerService.compare(lhs, rhs);
        }
        Integer lhsRank = this.mTargetRanks.get(new ComponentName(lhs.activityInfo.packageName, lhs.activityInfo.name));
        Integer rhsRank = this.mTargetRanks.get(new ComponentName(rhs.activityInfo.packageName, rhs.activityInfo.name));
        if (lhsRank == null && rhsRank == null) {
            return 0;
        }
        if (lhsRank == null) {
            return -1;
        }
        if (rhsRank == null) {
            return 1;
        }
        return lhsRank - rhsRank;
    }

    @Override
    void doCompute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        if (targets.isEmpty()) {
            this.mHandler.sendEmptyMessage(0);
            return;
        }
        ArrayList<AppTarget> appTargets = new ArrayList<AppTarget>();
        for (ResolverActivity.ResolvedComponentInfo target : targets) {
            appTargets.add(new AppTarget.Builder(new AppTargetId(target.name.flattenToString()), target.name.getPackageName(), this.mUser).setClassName(target.name.getClassName()).build());
        }
        this.mAppPredictor.sortTargets(appTargets, Executors.newSingleThreadExecutor(), sortedAppTargets -> {
            if (sortedAppTargets.isEmpty()) {
                this.mResolverRankerService = new ResolverRankerServiceResolverComparator(this.mContext, this.mIntent, this.mReferrerPackage, () -> this.mHandler.sendEmptyMessage(0));
                this.mResolverRankerService.compute(targets);
            } else {
                Message msg = Message.obtain(this.mHandler, 0, sortedAppTargets);
                msg.sendToTarget();
            }
        });
    }

    @Override
    void handleResultMessage(Message msg) {
        if (msg.what == 0 && msg.obj != null) {
            List sortedAppTargets = (List)msg.obj;
            for (int i = 0; i < sortedAppTargets.size(); ++i) {
                this.mTargetRanks.put(new ComponentName(((AppTarget)sortedAppTargets.get(i)).getPackageName(), ((AppTarget)sortedAppTargets.get(i)).getClassName()), i);
            }
        } else if (msg.obj == null && this.mResolverRankerService == null) {
            Log.e(TAG, "Unexpected null result");
        }
    }

    @Override
    float getScore(ComponentName name) {
        if (this.mResolverRankerService != null) {
            return this.mResolverRankerService.getScore(name);
        }
        Integer rank = this.mTargetRanks.get(name);
        if (rank == null) {
            Log.w(TAG, "Score requested for unknown component.");
            return 0.0f;
        }
        int consecutiveSumOfRanks = (this.mTargetRanks.size() - 1) * this.mTargetRanks.size() / 2;
        return 1.0f - (float)rank.intValue() / (float)consecutiveSumOfRanks;
    }

    @Override
    void updateModel(ComponentName componentName) {
        if (this.mResolverRankerService != null) {
            this.mResolverRankerService.updateModel(componentName);
            return;
        }
        this.mAppPredictor.notifyAppTargetEvent(new AppTargetEvent.Builder(new AppTarget.Builder(new AppTargetId(componentName.toString()), componentName.getPackageName(), this.mUser).setClassName(componentName.getClassName()).build(), 1).build());
    }

    @Override
    void destroy() {
        if (this.mResolverRankerService != null) {
            this.mResolverRankerService.destroy();
            this.mResolverRankerService = null;
        }
    }
}

