/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.prediction.AppPredictionContext;
import android.app.prediction.AppPredictionManager;
import android.app.prediction.AppPredictor;
import android.app.prediction.AppTarget;
import android.app.prediction.AppTargetEvent;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.content.res.Configuration;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.metrics.LogMaker;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.DeviceConfig;
import android.service.chooser.ChooserTarget;
import android.service.chooser.IChooserTargetResult;
import android.service.chooser.IChooserTargetService;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.HashedStringCache;
import android.util.Log;
import android.util.Size;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AbstractResolverComparator;
import com.android.internal.app.AppPredictionServiceResolverComparator;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverListController;
import com.android.internal.app.ResolverRankerServiceResolverComparator;
import com.android.internal.app.ResolverTargetActionsDialogFragment;
import com.android.internal.app.SimpleIconFactory;
import com.android.internal.content.PackageMonitor;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.ImageUtils;
import com.android.internal.widget.ResolverDrawerLayout;
import com.google.android.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChooserActivity
extends ResolverActivity {
    private static final String TAG = "ChooserActivity";
    public static final String EXTRA_PRIVATE_RETAIN_IN_ON_STOP = "com.android.internal.app.ChooserActivity.EXTRA_PRIVATE_RETAIN_IN_ON_STOP";
    private static final String PREF_NUM_SHEET_EXPANSIONS = "pref_num_sheet_expansions";
    private static final boolean DEBUG = false;
    private static final boolean USE_PREDICTION_MANAGER_FOR_DIRECT_TARGETS = true;
    private static final boolean USE_PREDICTION_MANAGER_FOR_SHARE_ACTIVITIES = true;
    private static final String APP_PREDICTION_SHARE_UI_SURFACE = "share";
    public static final String LAUNCH_LOCATON_DIRECT_SHARE = "direct_share";
    private static final int APP_PREDICTION_SHARE_TARGET_QUERY_PACKAGE_LIMIT = 20;
    public static final String APP_PREDICTION_INTENT_FILTER_KEY = "intent_filter";
    private AppPredictor mAppPredictor;
    private AppPredictor.Callback mAppPredictorCallback;
    private Map<ChooserTarget, AppTarget> mDirectShareAppTargetCache;
    private static final boolean USE_SHORTCUT_MANAGER_FOR_DIRECT_TARGETS = true;
    private static final boolean USE_CHOOSER_TARGET_SERVICE_FOR_DIRECT_TARGETS = true;
    private static final int NO_DIRECT_SHARE_ANIM_IN_MILLIS = 200;
    private static final float DIRECT_SHARE_EXPANSION_RATE = 0.78f;
    private static final int SHARE_TARGET_QUERY_PACKAGE_LIMIT = 20;
    private static final int QUERY_TARGET_SERVICE_LIMIT = 5;
    private static final int DEFAULT_SALT_EXPIRATION_DAYS = 7;
    private int mMaxHashSaltDays = DeviceConfig.getInt("systemui", "hash_salt_max_days", 7);
    private Bundle mReplacementExtras;
    private IntentSender mChosenComponentSender;
    private IntentSender mRefinementIntentSender;
    private RefinementResultReceiver mRefinementResultReceiver;
    private ChooserTarget[] mCallerChooserTargets;
    private ComponentName[] mFilteredComponentNames;
    private Intent mReferrerFillInIntent;
    private long mChooserShownTime;
    protected boolean mIsSuccessfullySelected;
    private long mQueriedTargetServicesTimeMs;
    private long mQueriedSharingShortcutsTimeMs;
    private ChooserListAdapter mChooserListAdapter;
    private ChooserRowAdapter mChooserRowAdapter;
    private int mChooserRowServiceSpacing;
    private int mCurrAvailableWidth = 0;
    private static final float CALLER_TARGET_SCORE_BOOST = 900.0f;
    private static final float SHORTCUT_TARGET_SCORE_BOOST = 90.0f;
    private static final String TARGET_DETAILS_FRAGMENT_TAG = "targetDetailsFragment";
    private static final int MAX_RANKED_TARGETS = 4;
    private final List<ChooserTargetServiceConnection> mServiceConnections = new ArrayList<ChooserTargetServiceConnection>();
    private final Set<ComponentName> mServicesRequested = new HashSet<ComponentName>();
    private static final int MAX_LOG_RANK_POSITION = 12;
    @VisibleForTesting
    public static final int LIST_VIEW_UPDATE_INTERVAL_IN_MILLIS = 250;
    private static final int MAX_EXTRA_INITIAL_INTENTS = 2;
    private static final int MAX_EXTRA_CHOOSER_TARGETS = 2;
    private boolean mListViewDataChanged = false;
    private static final int CONTENT_PREVIEW_IMAGE = 1;
    private static final int CONTENT_PREVIEW_FILE = 2;
    private static final int CONTENT_PREVIEW_TEXT = 3;
    protected MetricsLogger mMetricsLogger;
    private List<ResolverActivity.DisplayResolveInfo> mSortedList = new ArrayList<ResolverActivity.DisplayResolveInfo>();
    private ContentPreviewCoordinator mPreviewCoord;
    private final ChooserHandler mChooserHandler = new ChooserHandler();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        int i;
        int count;
        Parcelable[] targetsParcelable;
        long intentReceivedTime = System.currentTimeMillis();
        this.mIsSuccessfullySelected = false;
        Intent intent = this.getIntent();
        Object targetParcelable = intent.getParcelableExtra("android.intent.extra.INTENT");
        if (!(targetParcelable instanceof Intent)) {
            Log.w(TAG, "Target is not an intent: " + targetParcelable);
            this.finish();
            super.onCreate(null);
            return;
        }
        Intent target = (Intent)targetParcelable;
        if (target != null) {
            this.modifyTargetIntent(target);
        }
        if ((targetsParcelable = intent.getParcelableArrayExtra("android.intent.extra.ALTERNATE_INTENTS")) != null) {
            boolean offset = target == null;
            Intent[] additionalTargets = new Intent[offset ? targetsParcelable.length - 1 : targetsParcelable.length];
            for (int i2 = 0; i2 < targetsParcelable.length; ++i2) {
                if (!(targetsParcelable[i2] instanceof Intent)) {
                    Log.w(TAG, "EXTRA_ALTERNATE_INTENTS array entry #" + i2 + " is not an Intent: " + targetsParcelable[i2]);
                    this.finish();
                    super.onCreate(null);
                    return;
                }
                Intent additionalTarget = (Intent)targetsParcelable[i2];
                if (i2 == 0 && target == null) {
                    target = additionalTarget;
                    this.modifyTargetIntent(target);
                    continue;
                }
                additionalTargets[offset ? i2 - 1 : i2] = additionalTarget;
                this.modifyTargetIntent(additionalTarget);
            }
            this.setAdditionalTargets(additionalTargets);
        }
        this.mReplacementExtras = intent.getBundleExtra("android.intent.extra.REPLACEMENT_EXTRAS");
        CharSequence title = null;
        if (target != null) {
            if (!this.isSendAction(target)) {
                title = intent.getCharSequenceExtra("android.intent.extra.TITLE");
            } else {
                Log.w(TAG, "Ignoring intent's EXTRA_TITLE, deprecated in P. You may wish to set a preview title by using EXTRA_TITLE property of the wrapped EXTRA_INTENT.");
            }
        }
        int defaultTitleRes = 0;
        if (title == null) {
            defaultTitleRes = 17039652;
        }
        Parcelable[] pa = intent.getParcelableArrayExtra("android.intent.extra.INITIAL_INTENTS");
        Intent[] initialIntents = null;
        if (pa != null) {
            count = Math.min(pa.length, 2);
            initialIntents = new Intent[count];
            for (i = 0; i < count; ++i) {
                if (!(pa[i] instanceof Intent)) {
                    Log.w(TAG, "Initial intent #" + i + " not an Intent: " + pa[i]);
                    this.finish();
                    super.onCreate(null);
                    return;
                }
                Intent in = (Intent)pa[i];
                this.modifyTargetIntent(in);
                initialIntents[i] = in;
            }
        }
        this.mReferrerFillInIntent = new Intent().putExtra("android.intent.extra.REFERRER", this.getReferrer());
        this.mChosenComponentSender = (IntentSender)intent.getParcelableExtra("android.intent.extra.CHOSEN_COMPONENT_INTENT_SENDER");
        this.mRefinementIntentSender = (IntentSender)intent.getParcelableExtra("android.intent.extra.CHOOSER_REFINEMENT_INTENT_SENDER");
        this.setSafeForwardingMode(true);
        pa = intent.getParcelableArrayExtra("android.intent.extra.EXCLUDE_COMPONENTS");
        if (pa != null) {
            ComponentName[] names = new ComponentName[pa.length];
            for (i = 0; i < pa.length; ++i) {
                if (!(pa[i] instanceof ComponentName)) {
                    Log.w(TAG, "Filtered component #" + i + " not a ComponentName: " + pa[i]);
                    names = null;
                    break;
                }
                names[i] = (ComponentName)pa[i];
            }
            this.mFilteredComponentNames = names;
        }
        if ((pa = intent.getParcelableArrayExtra("android.intent.extra.CHOOSER_TARGETS")) != null) {
            count = Math.min(pa.length, 2);
            ChooserTarget[] targets = new ChooserTarget[count];
            for (int i3 = 0; i3 < count; ++i3) {
                if (!(pa[i3] instanceof ChooserTarget)) {
                    Log.w(TAG, "Chooser target #" + i3 + " not a ChooserTarget: " + pa[i3]);
                    targets = null;
                    break;
                }
                targets[i3] = (ChooserTarget)pa[i3];
            }
            this.mCallerChooserTargets = targets;
        }
        this.setRetainInOnStop(intent.getBooleanExtra(EXTRA_PRIVATE_RETAIN_IN_ON_STOP, false));
        super.onCreate(savedInstanceState, target, title, defaultTitleRes, initialIntents, null, false);
        this.mChooserShownTime = System.currentTimeMillis();
        long systemCost = this.mChooserShownTime - intentReceivedTime;
        this.getMetricsLogger().write(new LogMaker(214).setSubtype(this.isWorkProfile() ? 2 : 1).addTaggedData(1649, target.getType()).addTaggedData(1653, systemCost));
        AppPredictor appPredictor = this.getAppPredictorForDirectShareIfEnabled();
        if (appPredictor != null) {
            this.mDirectShareAppTargetCache = new HashMap<ChooserTarget, AppTarget>();
            this.mAppPredictorCallback = resultList -> {
                if (this.isFinishing() || this.isDestroyed()) {
                    return;
                }
                if (this.mChooserListAdapter == null) {
                    return;
                }
                if (resultList.isEmpty()) {
                    this.queryDirectShareTargets(this.mChooserListAdapter, true);
                    return;
                }
                List<ResolverActivity.DisplayResolveInfo> driList = this.getDisplayResolveInfos(this.mChooserListAdapter);
                ArrayList<ShortcutManager.ShareShortcutInfo> shareShortcutInfos = new ArrayList<ShortcutManager.ShareShortcutInfo>();
                for (AppTarget appTarget : resultList) {
                    if (appTarget.getShortcutInfo() == null) continue;
                    shareShortcutInfos.add(new ShortcutManager.ShareShortcutInfo(appTarget.getShortcutInfo(), new ComponentName(appTarget.getPackageName(), appTarget.getClassName())));
                }
                this.sendShareShortcutInfoList(shareShortcutInfos, driList, resultList);
            };
            appPredictor.registerPredictionUpdates(this.getMainExecutor(), this.mAppPredictorCallback);
        }
        this.mChooserRowServiceSpacing = this.getResources().getDimensionPixelSize(17105043);
        if (this.mResolverDrawerLayout != null) {
            this.mResolverDrawerLayout.addOnLayoutChangeListener(this::handleLayoutChange);
            if (this.isSendAction(target)) {
                this.mResolverDrawerLayout.setOnScrollChangeListener(this::handleScroll);
            }
            Object chooserHeader = this.mResolverDrawerLayout.findViewById(16908806);
            float defaultElevation = ((View)chooserHeader).getElevation();
            float chooserHeaderScrollElevation = this.getResources().getDimensionPixelSize(17105037);
            this.mAdapterView.setOnScrollListener(new AbsListView.OnScrollListener((View)chooserHeader, chooserHeaderScrollElevation, defaultElevation){
                final /* synthetic */ View val$chooserHeader;
                final /* synthetic */ float val$chooserHeaderScrollElevation;
                final /* synthetic */ float val$defaultElevation;
                {
                    this.val$chooserHeader = view;
                    this.val$chooserHeaderScrollElevation = f;
                    this.val$defaultElevation = f2;
                }

                @Override
                public void onScrollStateChanged(AbsListView view, int scrollState) {
                }

                @Override
                public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                    if (view.getChildCount() > 0 && (firstVisibleItem > 0 || view.getChildAt(0).getTop() < 0)) {
                        this.val$chooserHeader.setElevation(this.val$chooserHeaderScrollElevation);
                        return;
                    }
                    this.val$chooserHeader.setElevation(this.val$defaultElevation);
                }
            });
            this.mResolverDrawerLayout.setOnCollapsedChangedListener(new ResolverDrawerLayout.OnCollapsedChangedListener(){
                private boolean mWrittenOnce = false;

                @Override
                public void onCollapsedChanged(boolean isCollapsed) {
                    if (!isCollapsed && !this.mWrittenOnce) {
                        ChooserActivity.this.incrementNumSheetExpansions();
                        this.mWrittenOnce = true;
                    }
                }
            });
        }
    }

    protected boolean isWorkProfile() {
        return ((UserManager)this.getSystemService("user")).getUserInfo(UserHandle.myUserId()).isManagedProfile();
    }

    @Override
    protected PackageMonitor createPackageMonitor() {
        return new PackageMonitor(){

            @Override
            public void onSomePackagesChanged() {
                ChooserActivity.this.mAdapter.handlePackagesChanged();
                ChooserActivity.this.bindProfileView();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onCopyButtonClicked(View v) {
        Intent targetIntent = this.getTargetIntent();
        if (targetIntent == null) {
            this.finish();
            return;
        }
        String action = targetIntent.getAction();
        ClipData clipData = null;
        if ("android.intent.action.SEND".equals(action)) {
            String extraText = targetIntent.getStringExtra("android.intent.extra.TEXT");
            Uri extraStream = (Uri)targetIntent.getParcelableExtra("android.intent.extra.STREAM");
            if (extraText != null) {
                clipData = ClipData.newPlainText(null, extraText);
            } else {
                if (extraStream == null) {
                    Log.w(TAG, "No data available to copy to clipboard");
                    return;
                }
                clipData = ClipData.newUri(this.getContentResolver(), null, extraStream);
            }
        } else {
            if (!"android.intent.action.SEND_MULTIPLE".equals(action)) {
                Log.w(TAG, "Action (" + action + ") not supported for copying to clipboard");
                return;
            }
            ArrayList streams = targetIntent.getParcelableArrayListExtra("android.intent.extra.STREAM");
            clipData = ClipData.newUri(this.getContentResolver(), null, (Uri)streams.get(0));
            for (int i = 1; i < streams.size(); ++i) {
                clipData.addItem(this.getContentResolver(), new ClipData.Item((Uri)streams.get(i)));
            }
        }
        ClipboardManager clipboardManager = (ClipboardManager)this.getSystemService("clipboard");
        clipboardManager.setPrimaryClip(clipData);
        Toast.makeText(this.getApplicationContext(), 17039796, 0).show();
        this.finish();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.adjustPreviewWidth(newConfig.orientation, null);
    }

    private boolean shouldDisplayLandscape(int orientation) {
        return orientation == 2 && !this.isInMultiWindowMode();
    }

    private void adjustPreviewWidth(int orientation, View parent) {
        int width = -1;
        if (this.shouldDisplayLandscape(orientation)) {
            width = this.getResources().getDimensionPixelSize(17105041);
        }
        parent = parent == null ? this.getWindow().getDecorView() : parent;
        this.updateLayoutWidth(16908842, width, parent);
        this.updateLayoutWidth(16908845, width, parent);
        this.updateLayoutWidth(0x1020220, width, parent);
    }

    private void updateLayoutWidth(int layoutResourceId, int width, View parent) {
        Object view = parent.findViewById(layoutResourceId);
        if (view != null && ((View)view).getLayoutParams() != null) {
            ViewGroup.LayoutParams params = ((View)view).getLayoutParams();
            params.width = width;
            ((View)view).setLayoutParams(params);
        }
    }

    private ViewGroup displayContentPreview(int previewType, Intent targetIntent, LayoutInflater layoutInflater, ViewGroup convertView, ViewGroup parent) {
        if (convertView != null) {
            return convertView;
        }
        ViewGroup layout2 = null;
        switch (previewType) {
            case 3: {
                layout2 = this.displayTextContentPreview(targetIntent, layoutInflater, parent);
                break;
            }
            case 1: {
                layout2 = this.displayImageContentPreview(targetIntent, layoutInflater, parent);
                break;
            }
            case 2: {
                layout2 = this.displayFileContentPreview(targetIntent, layoutInflater, parent);
                break;
            }
            default: {
                Log.e(TAG, "Unexpected content preview type: " + previewType);
            }
        }
        if (layout2 != null) {
            this.adjustPreviewWidth(this.getResources().getConfiguration().orientation, layout2);
        }
        return layout2;
    }

    private ViewGroup displayTextContentPreview(Intent targetIntent, LayoutInflater layoutInflater, ViewGroup parent) {
        ViewGroup contentPreviewLayout = (ViewGroup)layoutInflater.inflate(17367124, parent, false);
        ((View)contentPreviewLayout.findViewById(16908847)).setOnClickListener(this::onCopyButtonClicked);
        CharSequence sharingText = targetIntent.getCharSequenceExtra("android.intent.extra.TEXT");
        if (sharingText == null) {
            ((View)contentPreviewLayout.findViewById(16908842)).setVisibility(8);
        } else {
            TextView textView = (TextView)contentPreviewLayout.findViewById(16908840);
            textView.setText(sharingText);
        }
        String previewTitle = targetIntent.getStringExtra("android.intent.extra.TITLE");
        if (TextUtils.isEmpty(previewTitle)) {
            ((View)contentPreviewLayout.findViewById(16908845)).setVisibility(8);
        } else {
            TextView previewTitleView = (TextView)contentPreviewLayout.findViewById(16908844);
            previewTitleView.setText(previewTitle);
            ClipData previewData = targetIntent.getClipData();
            Uri previewThumbnail = null;
            if (previewData != null && previewData.getItemCount() > 0) {
                ClipData.Item previewDataItem = previewData.getItemAt(0);
                previewThumbnail = previewDataItem.getUri();
            }
            ImageView previewThumbnailView = (ImageView)contentPreviewLayout.findViewById(16908843);
            if (previewThumbnail == null) {
                previewThumbnailView.setVisibility(8);
            } else {
                this.mPreviewCoord = new ContentPreviewCoordinator(contentPreviewLayout, false);
                this.mPreviewCoord.loadUriIntoView(16908843, previewThumbnail, 0);
            }
        }
        return contentPreviewLayout;
    }

    private ViewGroup displayImageContentPreview(Intent targetIntent, LayoutInflater layoutInflater, ViewGroup parent) {
        ViewGroup contentPreviewLayout = (ViewGroup)layoutInflater.inflate(17367123, parent, false);
        this.mPreviewCoord = new ContentPreviewCoordinator(contentPreviewLayout, true);
        String action = targetIntent.getAction();
        if ("android.intent.action.SEND".equals(action)) {
            Uri uri = (Uri)targetIntent.getParcelableExtra("android.intent.extra.STREAM");
            this.mPreviewCoord.loadUriIntoView(16908835, uri, 0);
        } else {
            ContentResolver resolver = this.getContentResolver();
            ArrayList uris = targetIntent.getParcelableArrayListExtra("android.intent.extra.STREAM");
            ArrayList<Uri> imageUris = new ArrayList<Uri>();
            for (Uri uri : uris) {
                if (!this.isImageType(resolver.getType(uri))) continue;
                imageUris.add(uri);
            }
            if (imageUris.size() == 0) {
                Log.i(TAG, "Attempted to display image preview area with zero available images detected in EXTRA_STREAM list");
                contentPreviewLayout.setVisibility(8);
                return contentPreviewLayout;
            }
            this.mPreviewCoord.loadUriIntoView(16908835, (Uri)imageUris.get(0), 0);
            if (imageUris.size() == 2) {
                this.mPreviewCoord.loadUriIntoView(16908836, (Uri)imageUris.get(1), 0);
            } else if (imageUris.size() > 2) {
                this.mPreviewCoord.loadUriIntoView(16908837, (Uri)imageUris.get(1), 0);
                this.mPreviewCoord.loadUriIntoView(16908838, (Uri)imageUris.get(2), imageUris.size() - 3);
            }
        }
        return contentPreviewLayout;
    }

    @VisibleForTesting
    public Cursor queryResolver(ContentResolver resolver, Uri uri) {
        return resolver.query(uri, null, null, null, null);
    }

    private FileInfo extractFileInfo(Uri uri, ContentResolver resolver) {
        int index;
        String fileName = null;
        boolean hasThumbnail = false;
        try (Cursor cursor = this.queryResolver(resolver, uri);){
            if (cursor != null && cursor.getCount() > 0) {
                int nameIndex = cursor.getColumnIndex("_display_name");
                int titleIndex = cursor.getColumnIndex("title");
                int flagsIndex = cursor.getColumnIndex("flags");
                cursor.moveToFirst();
                if (nameIndex != -1) {
                    fileName = cursor.getString(nameIndex);
                } else if (titleIndex != -1) {
                    fileName = cursor.getString(titleIndex);
                }
                if (flagsIndex != -1) {
                    hasThumbnail = (cursor.getInt(flagsIndex) & 1) != 0;
                }
            }
        }
        catch (NullPointerException | SecurityException e) {
            this.logContentPreviewWarning(uri);
        }
        if (TextUtils.isEmpty(fileName) && (index = (fileName = uri.getPath()).lastIndexOf(47)) != -1) {
            fileName = fileName.substring(index + 1);
        }
        return new FileInfo(fileName, hasThumbnail);
    }

    private void logContentPreviewWarning(Uri uri) {
        Log.w(TAG, "Could not load (" + uri.toString() + ") thumbnail/name for preview. If desired, consider using Intent#createChooser to launch the ChooserActivity, and set your Intent's clipData and flags in accordance with that method's documentation");
    }

    private ViewGroup displayFileContentPreview(Intent targetIntent, LayoutInflater layoutInflater, ViewGroup parent) {
        ViewGroup contentPreviewLayout = (ViewGroup)layoutInflater.inflate(17367122, parent, false);
        ((View)contentPreviewLayout.findViewById(16908912)).setVisibility(8);
        String action = targetIntent.getAction();
        if ("android.intent.action.SEND".equals(action)) {
            Uri uri = (Uri)targetIntent.getParcelableExtra("android.intent.extra.STREAM");
            this.loadFileUriIntoView(uri, contentPreviewLayout);
        } else {
            ArrayList uris = targetIntent.getParcelableArrayListExtra("android.intent.extra.STREAM");
            int uriCount = uris.size();
            if (uriCount == 0) {
                contentPreviewLayout.setVisibility(8);
                Log.i(TAG, "Appears to be no uris available in EXTRA_STREAM, removing preview area");
                return contentPreviewLayout;
            }
            if (uriCount == 1) {
                this.loadFileUriIntoView((Uri)uris.get(0), contentPreviewLayout);
            } else {
                FileInfo fileInfo = this.extractFileInfo((Uri)uris.get(0), this.getContentResolver());
                int remUriCount = uriCount - 1;
                String fileName = this.getResources().getQuantityString(18153490, remUriCount, fileInfo.name, remUriCount);
                TextView fileNameView = (TextView)contentPreviewLayout.findViewById(0x1020222);
                fileNameView.setText(fileName);
                Object thumbnailView = contentPreviewLayout.findViewById(0x1020221);
                ((View)thumbnailView).setVisibility(8);
                ImageView fileIconView = (ImageView)contentPreviewLayout.findViewById(16908831);
                fileIconView.setVisibility(0);
                fileIconView.setImageResource(17302409);
            }
        }
        return contentPreviewLayout;
    }

    private void loadFileUriIntoView(Uri uri, View parent) {
        FileInfo fileInfo = this.extractFileInfo(uri, this.getContentResolver());
        TextView fileNameView = (TextView)parent.findViewById(0x1020222);
        fileNameView.setText(fileInfo.name);
        if (fileInfo.hasThumbnail) {
            this.mPreviewCoord = new ContentPreviewCoordinator(parent, false);
            this.mPreviewCoord.loadUriIntoView(0x1020221, uri, 0);
        } else {
            Object thumbnailView = parent.findViewById(0x1020221);
            ((View)thumbnailView).setVisibility(8);
            ImageView fileIconView = (ImageView)parent.findViewById(16908831);
            fileIconView.setVisibility(0);
            fileIconView.setImageResource(17302105);
        }
    }

    @VisibleForTesting
    protected boolean isImageType(String mimeType) {
        return mimeType != null && mimeType.startsWith("image/");
    }

    private int findPreferredContentPreview(Uri uri, ContentResolver resolver) {
        if (uri == null) {
            return 3;
        }
        String mimeType = resolver.getType(uri);
        return this.isImageType(mimeType) ? 1 : 2;
    }

    private int findPreferredContentPreview(Intent targetIntent, ContentResolver resolver) {
        String action = targetIntent.getAction();
        if ("android.intent.action.SEND".equals(action)) {
            Uri uri = (Uri)targetIntent.getParcelableExtra("android.intent.extra.STREAM");
            return this.findPreferredContentPreview(uri, resolver);
        }
        if ("android.intent.action.SEND_MULTIPLE".equals(action)) {
            ArrayList uris = targetIntent.getParcelableArrayListExtra("android.intent.extra.STREAM");
            if (uris == null || uris.isEmpty()) {
                return 3;
            }
            for (Uri uri : uris) {
                if (this.findPreferredContentPreview(uri, resolver) != 2) continue;
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private int getNumSheetExpansions() {
        return this.getPreferences(0).getInt(PREF_NUM_SHEET_EXPANSIONS, 0);
    }

    private void incrementNumSheetExpansions() {
        this.getPreferences(0).edit().putInt(PREF_NUM_SHEET_EXPANSIONS, this.getNumSheetExpansions() + 1).apply();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        this.unbindRemainingServices();
        this.mChooserHandler.removeAllMessages();
        if (this.mPreviewCoord != null) {
            this.mPreviewCoord.cancelLoads();
        }
        if (this.mAppPredictor != null) {
            this.mAppPredictor.unregisterPredictionUpdates(this.mAppPredictorCallback);
            this.mAppPredictor.destroy();
        }
    }

    @Override
    public Intent getReplacementIntent(ActivityInfo aInfo, Intent defIntent) {
        Bundle replExtras;
        Intent result = defIntent;
        if (this.mReplacementExtras != null && (replExtras = this.mReplacementExtras.getBundle(aInfo.packageName)) != null) {
            result = new Intent(defIntent);
            result.putExtras(replExtras);
        }
        if (aInfo.name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_PARENT) || aInfo.name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            result = Intent.createChooser(result, this.getIntent().getCharSequenceExtra("android.intent.extra.TITLE"));
            result.putExtra("android.intent.extra.AUTO_LAUNCH_SINGLE_CHOICE", false);
        }
        return result;
    }

    @Override
    public void onActivityStarted(ResolverActivity.TargetInfo cti) {
        ComponentName target;
        if (this.mChosenComponentSender != null && (target = cti.getResolvedComponentName()) != null) {
            Intent fillIn = new Intent().putExtra("android.intent.extra.CHOSEN_COMPONENT", target);
            try {
                this.mChosenComponentSender.sendIntent(this, -1, fillIn, null, null);
            }
            catch (IntentSender.SendIntentException e) {
                Slog.e(TAG, "Unable to launch supplied IntentSender to report the chosen component: " + e);
            }
        }
    }

    @Override
    public void onPrepareAdapterView(AbsListView adapterView, ResolverActivity.ResolveListAdapter adapter) {
        ListView listView = adapterView instanceof ListView ? (ListView)adapterView : null;
        this.mChooserListAdapter = (ChooserListAdapter)adapter;
        if (this.mCallerChooserTargets != null && this.mCallerChooserTargets.length > 0) {
            this.mChooserListAdapter.addServiceResults(null, Lists.newArrayList(this.mCallerChooserTargets), false);
        }
        this.mChooserRowAdapter = new ChooserRowAdapter(this.mChooserListAdapter);
        if (listView != null) {
            listView.setItemsCanFocus(true);
        }
    }

    @Override
    public int getLayoutResource() {
        return 17367121;
    }

    @Override
    public boolean shouldGetActivityMetadata() {
        return true;
    }

    @Override
    public boolean shouldAutoLaunchSingleChoice(ResolverActivity.TargetInfo target) {
        if (!super.shouldAutoLaunchSingleChoice(target)) {
            return false;
        }
        return this.getIntent().getBooleanExtra("android.intent.extra.AUTO_LAUNCH_SINGLE_CHOICE", true);
    }

    @Override
    public void showTargetDetails(ResolveInfo ri) {
        if (ri == null) {
            return;
        }
        ComponentName name = ri.activityInfo.getComponentName();
        ResolverTargetActionsDialogFragment f = new ResolverTargetActionsDialogFragment(ri.loadLabel(this.getPackageManager()), name);
        f.show(this.getFragmentManager(), TARGET_DETAILS_FRAGMENT_TAG);
    }

    private void modifyTargetIntent(Intent in) {
        if (this.isSendAction(in)) {
            in.addFlags(0x8080000);
        }
    }

    @Override
    protected boolean onTargetSelected(ResolverActivity.TargetInfo target, boolean alwaysCheck) {
        if (this.mRefinementIntentSender != null) {
            Intent fillIn = new Intent();
            List<Intent> sourceIntents = target.getAllSourceIntents();
            if (!sourceIntents.isEmpty()) {
                fillIn.putExtra("android.intent.extra.INTENT", sourceIntents.get(0));
                if (sourceIntents.size() > 1) {
                    Parcelable[] alts = new Intent[sourceIntents.size() - 1];
                    int N = sourceIntents.size();
                    for (int i = 1; i < N; ++i) {
                        alts[i - 1] = sourceIntents.get(i);
                    }
                    fillIn.putExtra("android.intent.extra.ALTERNATE_INTENTS", alts);
                }
                if (this.mRefinementResultReceiver != null) {
                    this.mRefinementResultReceiver.destroy();
                }
                this.mRefinementResultReceiver = new RefinementResultReceiver(this, target, null);
                fillIn.putExtra("android.intent.extra.RESULT_RECEIVER", this.mRefinementResultReceiver);
                try {
                    this.mRefinementIntentSender.sendIntent(this, 0, fillIn, null, null);
                    return false;
                }
                catch (IntentSender.SendIntentException e) {
                    Log.e(TAG, "Refinement IntentSender failed to send", e);
                }
            }
        }
        this.updateModelAndChooserCounts(target);
        return super.onTargetSelected(target, alwaysCheck);
    }

    @Override
    public void startSelected(int which, boolean always, boolean filtered) {
        ResolverActivity.TargetInfo targetInfo = this.mChooserListAdapter.targetInfoForPosition(which, filtered);
        if (targetInfo != null && targetInfo instanceof NotSelectableTargetInfo) {
            return;
        }
        long selectionCost = System.currentTimeMillis() - this.mChooserShownTime;
        super.startSelected(which, always, filtered);
        if (this.mChooserListAdapter != null) {
            int cat = 0;
            int value = which;
            int directTargetAlsoRanked = -1;
            int numCallerProvided = 0;
            HashedStringCache.HashResult directTargetHashed = null;
            switch (this.mChooserListAdapter.getPositionTargetType(which)) {
                case 1: {
                    cat = 216;
                    ChooserTarget target = ((ChooserTargetInfo)this.mChooserListAdapter.mServiceTargets.get(value)).getChooserTarget();
                    directTargetHashed = HashedStringCache.getInstance().hashString(this, TAG, target.getComponentName().getPackageName() + target.getTitle().toString(), this.mMaxHashSaltDays);
                    directTargetAlsoRanked = this.getRankedPosition((SelectableTargetInfo)targetInfo);
                    if (this.mCallerChooserTargets == null) break;
                    numCallerProvided = this.mCallerChooserTargets.length;
                    break;
                }
                case 0: 
                case 2: {
                    cat = 215;
                    value -= this.mChooserListAdapter.getSelectableServiceTargetCount();
                    numCallerProvided = this.mChooserListAdapter.getCallerTargetCount();
                    break;
                }
                case 3: {
                    value = -1;
                    cat = 217;
                }
            }
            if (cat != 0) {
                LogMaker targetLogMaker = new LogMaker(cat).setSubtype(value);
                if (directTargetHashed != null) {
                    targetLogMaker.addTaggedData(1704, directTargetHashed.hashedString);
                    targetLogMaker.addTaggedData(1705, directTargetHashed.saltGeneration);
                    targetLogMaker.addTaggedData(1087, directTargetAlsoRanked);
                }
                targetLogMaker.addTaggedData(1086, numCallerProvided);
                this.getMetricsLogger().write(targetLogMaker);
            }
            if (this.mIsSuccessfullySelected) {
                MetricsLogger.histogram(null, "user_selection_cost_for_smart_sharing", (int)selectionCost);
                MetricsLogger.histogram(null, "app_position_for_smart_sharing", value);
            }
        }
    }

    private int getRankedPosition(SelectableTargetInfo targetInfo) {
        String targetPackageName = targetInfo.getChooserTarget().getComponentName().getPackageName();
        int maxRankedResults = Math.min(this.mChooserListAdapter.mDisplayList.size(), 12);
        for (int i = 0; i < maxRankedResults; ++i) {
            if (!((ResolverActivity.DisplayResolveInfo)this.mChooserListAdapter.mDisplayList.get((int)i)).getResolveInfo().activityInfo.packageName.equals(targetPackageName)) continue;
            return i;
        }
        return -1;
    }

    void queryTargetServices(ChooserListAdapter adapter) {
        this.mQueriedTargetServicesTimeMs = System.currentTimeMillis();
        PackageManager pm = this.getPackageManager();
        ShortcutManager sm = this.getSystemService(ShortcutManager.class);
        int targetsToQuery = 0;
        int N = adapter.getDisplayResolveInfoCount();
        for (int i = 0; i < N; ++i) {
            String serviceName;
            ResolverActivity.DisplayResolveInfo dri = adapter.getDisplayResolveInfo(i);
            if (adapter.getScore(dri) == 0.0f) continue;
            ActivityInfo ai = dri.getResolveInfo().activityInfo;
            if (sm.hasShareTargets(ai.packageName)) continue;
            Bundle md = ai.metaData;
            String string2 = serviceName = md != null ? this.convertServiceName(ai.packageName, md.getString("android.service.chooser.chooser_target_service")) : null;
            if (serviceName != null) {
                Intent serviceIntent;
                block6: {
                    ComponentName serviceComponent = new ComponentName(ai.packageName, serviceName);
                    if (this.mServicesRequested.contains(serviceComponent)) continue;
                    this.mServicesRequested.add(serviceComponent);
                    serviceIntent = new Intent("android.service.chooser.ChooserTargetService").setComponent(serviceComponent);
                    try {
                        String perm = pm.getServiceInfo((ComponentName)serviceComponent, (int)0).permission;
                        if (!"android.permission.BIND_CHOOSER_TARGET_SERVICE".equals(perm)) {
                            Log.w(TAG, "ChooserTargetService " + serviceComponent + " does not require permission " + "android.permission.BIND_CHOOSER_TARGET_SERVICE" + " - this service will not be queried for ChooserTargets. add android:permission=\"" + "android.permission.BIND_CHOOSER_TARGET_SERVICE" + "\" to the <service> tag for " + serviceComponent + " in the manifest.");
                        }
                        break block6;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Log.e(TAG, "Could not look up service " + serviceComponent + "; component name not found");
                    }
                    continue;
                }
                ChooserTargetServiceConnection conn = new ChooserTargetServiceConnection(this, dri);
                if (this.bindServiceAsUser(serviceIntent, conn, 5, Process.myUserHandle())) {
                    this.mServiceConnections.add(conn);
                    ++targetsToQuery;
                }
            }
            if (targetsToQuery >= 5) break;
        }
        this.mChooserHandler.restartServiceRequestTimer();
    }

    private IntentFilter getTargetIntentFilter() {
        try {
            Intent intent = this.getTargetIntent();
            String dataString = intent.getDataString();
            if (TextUtils.isEmpty(dataString)) {
                dataString = intent.getType();
            }
            return new IntentFilter(intent.getAction(), dataString);
        }
        catch (Exception e) {
            Log.e(TAG, "failed to get target intent filter " + e);
            return null;
        }
    }

    private List<ResolverActivity.DisplayResolveInfo> getDisplayResolveInfos(ChooserListAdapter adapter) {
        ArrayList<ResolverActivity.DisplayResolveInfo> driList = new ArrayList<ResolverActivity.DisplayResolveInfo>();
        int targetsToQuery = 0;
        int n = adapter.getDisplayResolveInfoCount();
        for (int i = 0; i < n; ++i) {
            ResolverActivity.DisplayResolveInfo dri = adapter.getDisplayResolveInfo(i);
            if (adapter.getScore(dri) == 0.0f) continue;
            driList.add(dri);
            if (++targetsToQuery >= 20) break;
        }
        return driList;
    }

    private void queryDirectShareTargets(ChooserListAdapter adapter, boolean skipAppPredictionService) {
        AppPredictor appPredictor;
        this.mQueriedSharingShortcutsTimeMs = System.currentTimeMillis();
        if (!skipAppPredictionService && (appPredictor = this.getAppPredictorForDirectShareIfEnabled()) != null) {
            appPredictor.requestPredictionUpdate();
            return;
        }
        IntentFilter filter = this.getTargetIntentFilter();
        if (filter == null) {
            return;
        }
        List<ResolverActivity.DisplayResolveInfo> driList = this.getDisplayResolveInfos(adapter);
        AsyncTask.execute(() -> {
            ShortcutManager sm = (ShortcutManager)this.getSystemService("shortcut");
            List<ShortcutManager.ShareShortcutInfo> resultList = sm.getShareTargets(filter);
            this.sendShareShortcutInfoList(resultList, driList, null);
        });
    }

    private void sendShareShortcutInfoList(List<ShortcutManager.ShareShortcutInfo> resultList, List<ResolverActivity.DisplayResolveInfo> driList, List<AppTarget> appTargets) {
        if (appTargets != null && appTargets.size() != resultList.size()) {
            throw new RuntimeException("resultList and appTargets must have the same size. resultList.size()=" + resultList.size() + " appTargets.size()=" + appTargets.size());
        }
        for (int i = resultList.size() - 1; i >= 0; --i) {
            String packageName = resultList.get(i).getTargetComponent().getPackageName();
            if (this.isPackageEnabled(packageName)) continue;
            resultList.remove(i);
            if (appTargets == null) continue;
            appTargets.remove(i);
        }
        boolean resultMessageSent = false;
        for (int i = 0; i < driList.size(); ++i) {
            ArrayList<ChooserTarget> chooserTargets = new ArrayList<ChooserTarget>();
            for (int j = 0; j < resultList.size(); ++j) {
                if (!driList.get(i).getResolvedComponentName().equals(resultList.get(j).getTargetComponent())) continue;
                ShortcutManager.ShareShortcutInfo shareShortcutInfo = resultList.get(j);
                float score = Math.max(1.0f - 0.05f * (float)j, 0.0f);
                ChooserTarget chooserTarget = this.convertToChooserTarget(shareShortcutInfo, score);
                chooserTargets.add(chooserTarget);
                if (this.mDirectShareAppTargetCache == null || appTargets == null) continue;
                this.mDirectShareAppTargetCache.put(chooserTarget, appTargets.get(j));
            }
            if (chooserTargets.isEmpty()) continue;
            Message msg = Message.obtain();
            msg.what = 4;
            msg.obj = new ServiceResultInfo(driList.get(i), chooserTargets, null);
            this.mChooserHandler.sendMessage(msg);
            resultMessageSent = true;
        }
        if (resultMessageSent) {
            this.sendShortcutManagerShareTargetResultCompleted();
        }
    }

    private void sendShortcutManagerShareTargetResultCompleted() {
        Message msg = Message.obtain();
        msg.what = 5;
        this.mChooserHandler.sendMessage(msg);
    }

    private boolean isPackageEnabled(String packageName) {
        ApplicationInfo appInfo;
        if (TextUtils.isEmpty(packageName)) {
            return false;
        }
        try {
            appInfo = this.getPackageManager().getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return appInfo != null && appInfo.enabled && (appInfo.flags & 0x40000000) == 0;
    }

    private ChooserTarget convertToChooserTarget(ShortcutManager.ShareShortcutInfo shareShortcut, float score) {
        ShortcutInfo shortcutInfo = shareShortcut.getShortcutInfo();
        Bundle extras = new Bundle();
        extras.putString("android.intent.extra.shortcut.ID", shortcutInfo.getId());
        return new ChooserTarget(shortcutInfo.getShortLabel(), null, score, shareShortcut.getTargetComponent().clone(), extras);
    }

    private String convertServiceName(String packageName, String serviceName) {
        if (TextUtils.isEmpty(serviceName)) {
            return null;
        }
        String fullName = serviceName.startsWith(".") ? packageName + serviceName : (serviceName.indexOf(46) >= 0 ? serviceName : null);
        return fullName;
    }

    void unbindRemainingServices() {
        int N = this.mServiceConnections.size();
        for (int i = 0; i < N; ++i) {
            ChooserTargetServiceConnection conn = this.mServiceConnections.get(i);
            this.unbindService(conn);
            conn.destroy();
        }
        this.mServicesRequested.clear();
        this.mServiceConnections.clear();
    }

    @Override
    public void onSetupVoiceInteraction() {
    }

    private void logDirectShareTargetReceived(int logCategory) {
        long queryTime = logCategory == 1718 ? this.mQueriedSharingShortcutsTimeMs : this.mQueriedTargetServicesTimeMs;
        int apiLatency = (int)(System.currentTimeMillis() - queryTime);
        this.getMetricsLogger().write(new LogMaker(logCategory).setSubtype(apiLatency));
    }

    void updateModelAndChooserCounts(ResolverActivity.TargetInfo info) {
        if (info != null) {
            this.sendClickToAppPredictor(info);
            ResolveInfo ri = info.getResolveInfo();
            Intent targetIntent = this.getTargetIntent();
            if (ri != null && ri.activityInfo != null && targetIntent != null && this.mAdapter != null) {
                this.mAdapter.updateModel(info.getResolvedComponentName());
                this.mAdapter.updateChooserCounts(ri.activityInfo.packageName, this.getUserId(), targetIntent.getAction());
            }
        }
        this.mIsSuccessfullySelected = true;
    }

    private void sendClickToAppPredictor(ResolverActivity.TargetInfo targetInfo) {
        AppPredictor directShareAppPredictor = this.getAppPredictorForDirectShareIfEnabled();
        if (directShareAppPredictor == null) {
            return;
        }
        if (!(targetInfo instanceof ChooserTargetInfo)) {
            return;
        }
        ChooserTarget chooserTarget = ((ChooserTargetInfo)targetInfo).getChooserTarget();
        AppTarget appTarget = null;
        if (this.mDirectShareAppTargetCache != null) {
            appTarget = this.mDirectShareAppTargetCache.get(chooserTarget);
        }
        if (appTarget != null) {
            directShareAppPredictor.notifyAppTargetEvent(new AppTargetEvent.Builder(appTarget, 1).setLaunchLocation(LAUNCH_LOCATON_DIRECT_SHARE).build());
        }
    }

    private AppPredictor getAppPredictor() {
        if (this.mAppPredictor == null && this.getPackageManager().getAppPredictionServicePackageName() != null) {
            IntentFilter filter = this.getTargetIntentFilter();
            Bundle extras = new Bundle();
            extras.putParcelable(APP_PREDICTION_INTENT_FILTER_KEY, filter);
            AppPredictionContext appPredictionContext = new AppPredictionContext.Builder(this).setUiSurface(APP_PREDICTION_SHARE_UI_SURFACE).setPredictedTargetCount(20).setExtras(extras).build();
            AppPredictionManager appPredictionManager = this.getSystemService(AppPredictionManager.class);
            this.mAppPredictor = appPredictionManager.createAppPredictionSession(appPredictionContext);
        }
        return this.mAppPredictor;
    }

    private AppPredictor getAppPredictorForDirectShareIfEnabled() {
        return !ActivityManager.isLowRamDeviceStatic() ? this.getAppPredictor() : null;
    }

    private AppPredictor getAppPredictorForShareActivitesIfEnabled() {
        return this.getAppPredictor();
    }

    void onRefinementResult(ResolverActivity.TargetInfo selectedTarget, Intent matchingIntent) {
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        if (selectedTarget == null) {
            Log.e(TAG, "Refinement result intent did not match any known targets; canceling");
        } else if (!this.checkTargetSourceIntent(selectedTarget, matchingIntent)) {
            Log.e(TAG, "onRefinementResult: Selected target " + selectedTarget + " cannot match refined source intent " + matchingIntent);
        } else {
            ResolverActivity.TargetInfo clonedTarget = selectedTarget.cloneFilledIn(matchingIntent, 0);
            if (super.onTargetSelected(clonedTarget, false)) {
                this.updateModelAndChooserCounts(clonedTarget);
                this.finish();
                return;
            }
        }
        this.onRefinementCanceled();
    }

    void onRefinementCanceled() {
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        this.finish();
    }

    boolean checkTargetSourceIntent(ResolverActivity.TargetInfo target, Intent matchingIntent) {
        List<Intent> targetIntents = target.getAllSourceIntents();
        int N = targetIntents.size();
        for (int i = 0; i < N; ++i) {
            Intent targetIntent = targetIntents.get(i);
            if (!targetIntent.filterEquals(matchingIntent)) continue;
            return true;
        }
        return false;
    }

    void filterServiceTargets(String packageName, List<ChooserTarget> targets) {
        if (targets == null) {
            return;
        }
        PackageManager pm = this.getPackageManager();
        for (int i = targets.size() - 1; i >= 0; --i) {
            boolean remove;
            ChooserTarget target = targets.get(i);
            ComponentName targetName = target.getComponentName();
            if (packageName != null && packageName.equals(targetName.getPackageName())) continue;
            try {
                ActivityInfo ai = pm.getActivityInfo(targetName, 0);
                remove = !ai.exported || ai.permission != null;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(TAG, "Target " + target + " returned by " + packageName + " component not found");
                remove = true;
            }
            if (!remove) continue;
            targets.remove(i);
        }
    }

    private void updateAlphabeticalList() {
        this.mSortedList.clear();
        this.mSortedList.addAll(this.getDisplayList());
        Collections.sort(this.mSortedList, new AzInfoComparator(this));
    }

    protected MetricsLogger getMetricsLogger() {
        if (this.mMetricsLogger == null) {
            this.mMetricsLogger = new MetricsLogger();
        }
        return this.mMetricsLogger;
    }

    @Override
    public ResolverActivity.ResolveListAdapter createAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed) {
        ChooserListAdapter adapter = new ChooserListAdapter(context, payloadIntents, initialIntents, rList, launchedFromUid, filterLastUsed, this.createListController());
        return adapter;
    }

    @Override
    @VisibleForTesting
    protected ResolverListController createListController() {
        AppPredictor appPredictor = this.getAppPredictorForShareActivitesIfEnabled();
        AbstractResolverComparator resolverComparator = appPredictor != null ? new AppPredictionServiceResolverComparator(this, this.getTargetIntent(), this.getReferrerPackageName(), appPredictor, this.getUser()) : new ResolverRankerServiceResolverComparator(this, this.getTargetIntent(), this.getReferrerPackageName(), null);
        return new ChooserListController(this, this.mPm, this.getTargetIntent(), this.getReferrerPackageName(), this.mLaunchedFromUid, resolverComparator);
    }

    @VisibleForTesting
    protected Bitmap loadThumbnail(Uri uri, Size size) {
        if (uri == null || size == null) {
            return null;
        }
        try {
            return ImageUtils.loadThumbnail(this.getContentResolver(), uri, size);
        }
        catch (IOException | NullPointerException | SecurityException ex) {
            this.logContentPreviewWarning(uri);
            return null;
        }
    }

    private void handleScroll(View view, int x, int y, int oldx, int oldy) {
        if (this.mChooserRowAdapter != null) {
            this.mChooserRowAdapter.handleScroll(view, y, oldy);
        }
    }

    private void handleLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (this.mChooserRowAdapter == null || this.mAdapterView == null) {
            return;
        }
        int availableWidth = right - left - v.getPaddingLeft() - v.getPaddingRight();
        if (this.mChooserRowAdapter.consumeLayoutRequest() || this.mChooserRowAdapter.calculateChooserTargetWidth(availableWidth) || this.mAdapterView.getAdapter() == null || availableWidth != this.mCurrAvailableWidth) {
            this.mCurrAvailableWidth = availableWidth;
            this.mAdapterView.setAdapter(this.mChooserRowAdapter);
            this.getMainThreadHandler().post(() -> {
                boolean isExpandable;
                int bottomInset;
                if (this.mResolverDrawerLayout == null || this.mChooserRowAdapter == null) {
                    return;
                }
                int offset = bottomInset = this.mSystemWindowInsets != null ? this.mSystemWindowInsets.bottom : 0;
                int rowsToShow = this.mChooserRowAdapter.getContentPreviewRowCount() + this.mChooserRowAdapter.getProfileRowCount() + this.mChooserRowAdapter.getServiceTargetRowCount() + this.mChooserRowAdapter.getCallerAndRankedTargetRowCount();
                if (rowsToShow == 0) {
                    rowsToShow = this.mChooserRowAdapter.getCount();
                }
                if (rowsToShow == 0) {
                    this.mResolverDrawerLayout.setCollapsibleHeightReserved(offset += this.getResources().getDimensionPixelSize(17105038));
                    return;
                }
                int directShareHeight = 0;
                rowsToShow = Math.min(4, rowsToShow);
                for (int i = 0; i < Math.min(rowsToShow, this.mAdapterView.getChildCount()); ++i) {
                    View child = this.mAdapterView.getChildAt(i);
                    int height = child.getHeight();
                    offset += height;
                    if (child.getTag() == null || !(child.getTag() instanceof DirectShareViewHolder)) continue;
                    directShareHeight = height;
                }
                boolean bl = isExpandable = this.getResources().getConfiguration().orientation == 1 && !this.isInMultiWindowMode();
                if (directShareHeight != 0 && this.isSendAction(this.getTargetIntent()) && isExpandable) {
                    int requiredExpansionHeight = (int)((float)directShareHeight / 0.78f);
                    int topInset = this.mSystemWindowInsets != null ? this.mSystemWindowInsets.top : 0;
                    int minHeight = bottom - top - this.mResolverDrawerLayout.getAlwaysShowHeight() - requiredExpansionHeight - topInset - bottomInset;
                    offset = Math.min(offset, minHeight);
                }
                this.mResolverDrawerLayout.setCollapsibleHeightReserved(Math.min(offset, bottom - top));
            });
        }
    }

    private boolean isSendAction(Intent targetIntent) {
        if (targetIntent == null) {
            return false;
        }
        String action = targetIntent.getAction();
        if (action == null) {
            return false;
        }
        return "android.intent.action.SEND".equals(action) || "android.intent.action.SEND_MULTIPLE".equals(action);
    }

    public static class RoundedRectImageView
    extends ImageView {
        private int mRadius = 0;
        private Path mPath = new Path();
        private Paint mOverlayPaint = new Paint(0);
        private Paint mRoundRectPaint = new Paint(0);
        private Paint mTextPaint = new Paint(1);
        private String mExtraImageCount = null;

        public RoundedRectImageView(Context context) {
            super(context);
        }

        public RoundedRectImageView(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        public RoundedRectImageView(Context context, AttributeSet attrs, int defStyleAttr) {
            this(context, attrs, defStyleAttr, 0);
        }

        public RoundedRectImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
            this.mRadius = context.getResources().getDimensionPixelSize(17105032);
            this.mOverlayPaint.setColor(-1728053248);
            this.mOverlayPaint.setStyle(Paint.Style.FILL);
            this.mRoundRectPaint.setColor(context.getResources().getColor(17170724));
            this.mRoundRectPaint.setStyle(Paint.Style.STROKE);
            this.mRoundRectPaint.setStrokeWidth(context.getResources().getDimensionPixelSize(17105039));
            this.mTextPaint.setColor(-1);
            this.mTextPaint.setTextSize(context.getResources().getDimensionPixelSize(17105040));
            this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        }

        private void updatePath(int width, int height) {
            this.mPath.reset();
            int imageWidth = width - this.getPaddingRight() - this.getPaddingLeft();
            int imageHeight = height - this.getPaddingBottom() - this.getPaddingTop();
            this.mPath.addRoundRect(this.getPaddingLeft(), this.getPaddingTop(), imageWidth, imageHeight, this.mRadius, this.mRadius, Path.Direction.CW);
        }

        public void setRadius(int radius) {
            this.mRadius = radius;
            this.updatePath(this.getWidth(), this.getHeight());
        }

        public void setExtraImageCount(int count) {
            this.mExtraImageCount = count > 0 ? "+" + count : null;
        }

        @Override
        protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
            super.onSizeChanged(width, height, oldWidth, oldHeight);
            this.updatePath(width, height);
        }

        @Override
        protected void onDraw(Canvas canvas) {
            if (this.mRadius != 0) {
                canvas.clipPath(this.mPath);
            }
            super.onDraw(canvas);
            int x = this.getPaddingLeft();
            int y = this.getPaddingRight();
            int width = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
            int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
            if (this.mExtraImageCount != null) {
                canvas.drawRect(x, y, width, height, this.mOverlayPaint);
                int xPos = canvas.getWidth() / 2;
                int yPos = (int)((float)canvas.getHeight() / 2.0f - (this.mTextPaint.descent() + this.mTextPaint.ascent()) / 2.0f);
                canvas.drawText(this.mExtraImageCount, xPos, yPos, this.mTextPaint);
            }
            canvas.drawRoundRect(x, y, width, height, this.mRadius, this.mRadius, this.mRoundRectPaint);
        }
    }

    static class RefinementResultReceiver
    extends ResultReceiver {
        private ChooserActivity mChooserActivity;
        private ResolverActivity.TargetInfo mSelectedTarget;

        public RefinementResultReceiver(ChooserActivity host, ResolverActivity.TargetInfo target, Handler handler) {
            super(handler);
            this.mChooserActivity = host;
            this.mSelectedTarget = target;
        }

        @Override
        protected void onReceiveResult(int resultCode, Bundle resultData) {
            if (this.mChooserActivity == null) {
                Log.e(ChooserActivity.TAG, "Destroyed RefinementResultReceiver received a result");
                return;
            }
            if (resultData == null) {
                Log.e(ChooserActivity.TAG, "RefinementResultReceiver received null resultData");
                return;
            }
            switch (resultCode) {
                case 0: {
                    this.mChooserActivity.onRefinementCanceled();
                    break;
                }
                case -1: {
                    Object intentParcelable = resultData.getParcelable("android.intent.extra.INTENT");
                    if (intentParcelable instanceof Intent) {
                        this.mChooserActivity.onRefinementResult(this.mSelectedTarget, (Intent)intentParcelable);
                        break;
                    }
                    Log.e(ChooserActivity.TAG, "RefinementResultReceiver received RESULT_OK but no Intent in resultData with key Intent.EXTRA_INTENT");
                    break;
                }
                default: {
                    Log.w(ChooserActivity.TAG, "Unknown result code " + resultCode + " sent to RefinementResultReceiver");
                }
            }
        }

        public void destroy() {
            this.mChooserActivity = null;
            this.mSelectedTarget = null;
        }
    }

    static class ServiceResultInfo {
        public final ResolverActivity.DisplayResolveInfo originalTarget;
        public final List<ChooserTarget> resultTargets;
        public final ChooserTargetServiceConnection connection;

        public ServiceResultInfo(ResolverActivity.DisplayResolveInfo ot, List<ChooserTarget> rt, ChooserTargetServiceConnection c) {
            this.originalTarget = ot;
            this.resultTargets = rt;
            this.connection = c;
        }
    }

    static class ChooserTargetServiceConnection
    implements ServiceConnection {
        private ResolverActivity.DisplayResolveInfo mOriginalTarget;
        private ComponentName mConnectedComponent;
        private ChooserActivity mChooserActivity;
        private final Object mLock = new Object();
        private final IChooserTargetResult mChooserTargetResult = new IChooserTargetResult.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendResult(List<ChooserTarget> targets) throws RemoteException {
                Object object = mLock;
                synchronized (object) {
                    if (mChooserActivity == null) {
                        Log.e(ChooserActivity.TAG, "destroyed ChooserTargetServiceConnection received result from " + mConnectedComponent + "; ignoring...");
                        return;
                    }
                    mChooserActivity.filterServiceTargets(((ChooserTargetServiceConnection)this).mOriginalTarget.getResolveInfo().activityInfo.packageName, targets);
                    Message msg = Message.obtain();
                    msg.what = 1;
                    msg.obj = new ServiceResultInfo(mOriginalTarget, targets, this);
                    mChooserActivity.mChooserHandler.sendMessage(msg);
                }
            }
        };

        public ChooserTargetServiceConnection(ChooserActivity chooserActivity, ResolverActivity.DisplayResolveInfo dri) {
            this.mChooserActivity = chooserActivity;
            this.mOriginalTarget = dri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mChooserActivity == null) {
                    Log.e(ChooserActivity.TAG, "destroyed ChooserTargetServiceConnection got onServiceConnected");
                    return;
                }
                IChooserTargetService icts = IChooserTargetService.Stub.asInterface(service);
                try {
                    icts.getChooserTargets(this.mOriginalTarget.getResolvedComponentName(), this.mOriginalTarget.getResolveInfo().filter, this.mChooserTargetResult);
                }
                catch (RemoteException e) {
                    Log.e(ChooserActivity.TAG, "Querying ChooserTargetService " + name + " failed.", e);
                    this.mChooserActivity.unbindService(this);
                    this.mChooserActivity.mServiceConnections.remove(this);
                    this.destroy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mChooserActivity == null) {
                    Log.e(ChooserActivity.TAG, "destroyed ChooserTargetServiceConnection got onServiceDisconnected");
                    return;
                }
                this.mChooserActivity.unbindService(this);
                this.mChooserActivity.mServiceConnections.remove(this);
                if (this.mChooserActivity.mServiceConnections.isEmpty()) {
                    this.mChooserActivity.sendVoiceChoicesIfNeeded();
                }
                this.mConnectedComponent = null;
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = this.mLock;
            synchronized (object) {
                this.mChooserActivity = null;
                this.mOriginalTarget = null;
            }
        }

        public String toString() {
            return "ChooserTargetServiceConnection{service=" + this.mConnectedComponent + ", activity=" + (this.mOriginalTarget != null ? this.mOriginalTarget.getResolveInfo().activityInfo.toString() : "<connection destroyed>") + "}";
        }
    }

    class DirectShareViewHolder
    extends RowViewHolder {
        private final ViewGroup mParent;
        private final List<ViewGroup> mRows;
        private int mCellCountPerRow;
        private boolean mHideDirectShareExpansion;
        private int mDirectShareMinHeight;
        private int mDirectShareCurrHeight;
        private int mDirectShareMaxHeight;
        private final boolean[] mCellVisibility;

        DirectShareViewHolder(ViewGroup parent, List<ViewGroup> rows, int cellCountPerRow) {
            super(rows.size() * cellCountPerRow);
            this.mHideDirectShareExpansion = false;
            this.mDirectShareMinHeight = 0;
            this.mDirectShareCurrHeight = 0;
            this.mDirectShareMaxHeight = 0;
            this.mParent = parent;
            this.mRows = rows;
            this.mCellCountPerRow = cellCountPerRow;
            this.mCellVisibility = new boolean[rows.size() * cellCountPerRow];
        }

        @Override
        public ViewGroup addView(int index, View v) {
            ViewGroup row = this.getRowByIndex(index);
            row.addView(v);
            this.mCells[index] = v;
            return row;
        }

        @Override
        public ViewGroup getViewGroup() {
            return this.mParent;
        }

        @Override
        public ViewGroup getRowByIndex(int index) {
            return this.mRows.get(index / this.mCellCountPerRow);
        }

        @Override
        public ViewGroup getRow(int rowNumber) {
            return this.mRows.get(rowNumber);
        }

        @Override
        public void measure() {
            int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
            this.getRow(0).measure(spec, spec);
            this.getRow(1).measure(spec, spec);
            this.mDirectShareMinHeight = this.getRow(0).getMeasuredHeight();
            this.mDirectShareCurrHeight = this.mDirectShareCurrHeight > 0 ? this.mDirectShareCurrHeight : this.mDirectShareMinHeight;
            this.mDirectShareMaxHeight = 2 * this.mDirectShareMinHeight;
        }

        @Override
        public int getMeasuredRowHeight() {
            return this.mDirectShareCurrHeight;
        }

        public int getMinRowHeight() {
            return this.mDirectShareMinHeight;
        }

        @Override
        public void setViewVisibility(int i, int visibility) {
            final View v = this.getView(i);
            if (visibility == 0) {
                this.mCellVisibility[i] = true;
                v.setVisibility(visibility);
                v.setAlpha(1.0f);
            } else if (visibility == 4 && this.mCellVisibility[i]) {
                this.mCellVisibility[i] = false;
                ObjectAnimator fadeAnim = ObjectAnimator.ofFloat((Object)v, "alpha", 1.0f, 0.0f);
                ((ValueAnimator)fadeAnim).setDuration(200L);
                fadeAnim.setInterpolator(new AccelerateInterpolator(1.0f));
                fadeAnim.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        v.setVisibility(4);
                    }
                });
                ((ValueAnimator)fadeAnim).start();
            }
        }

        public void handleScroll(AbsListView view, int y, int oldy, int maxTargetsPerRow) {
            boolean notExpanded;
            boolean bl = notExpanded = this.mDirectShareCurrHeight == this.mDirectShareMinHeight;
            if (notExpanded) {
                if (this.mHideDirectShareExpansion) {
                    return;
                }
                if (ChooserActivity.this.mChooserListAdapter.getSelectableServiceTargetCount() <= maxTargetsPerRow) {
                    this.mHideDirectShareExpansion = true;
                    return;
                }
            }
            int yDiff = (int)((float)(oldy - y) * 0.78f);
            int prevHeight = this.mDirectShareCurrHeight;
            int newHeight = Math.min(prevHeight + yDiff, this.mDirectShareMaxHeight);
            newHeight = Math.max(newHeight, this.mDirectShareMinHeight);
            yDiff = newHeight - prevHeight;
            if (view == null || view.getChildCount() == 0 || yDiff == 0) {
                return;
            }
            boolean foundExpansion = false;
            for (int i = 0; i < view.getChildCount(); ++i) {
                View child = view.getChildAt(i);
                if (foundExpansion) {
                    child.offsetTopAndBottom(yDiff);
                    continue;
                }
                if (child.getTag() == null || !(child.getTag() instanceof DirectShareViewHolder)) continue;
                int widthSpec = View.MeasureSpec.makeMeasureSpec(child.getWidth(), 0x40000000);
                int heightSpec = View.MeasureSpec.makeMeasureSpec(newHeight, 0x40000000);
                child.measure(widthSpec, heightSpec);
                child.getLayoutParams().height = child.getMeasuredHeight();
                child.layout(child.getLeft(), child.getTop(), child.getRight(), child.getTop() + child.getMeasuredHeight());
                foundExpansion = true;
            }
            if (foundExpansion) {
                this.mDirectShareCurrHeight = newHeight;
            }
        }
    }

    class SingleRowViewHolder
    extends RowViewHolder {
        private final ViewGroup mRow;

        SingleRowViewHolder(ViewGroup row, int cellCount) {
            super(cellCount);
            this.mRow = row;
        }

        @Override
        public ViewGroup getViewGroup() {
            return this.mRow;
        }

        @Override
        public ViewGroup getRowByIndex(int index) {
            return this.mRow;
        }

        @Override
        public ViewGroup getRow(int rowNumber) {
            if (rowNumber == 0) {
                return this.mRow;
            }
            return null;
        }

        @Override
        public ViewGroup addView(int index, View v) {
            this.mRow.addView(v);
            this.mCells[index] = v;
            return this.mRow;
        }

        @Override
        public void setViewVisibility(int i, int visibility) {
            this.getView(i).setVisibility(visibility);
        }
    }

    abstract class RowViewHolder {
        protected int mMeasuredRowHeight;
        private int[] mItemIndices;
        protected final View[] mCells;
        private final int mColumnCount;

        RowViewHolder(int cellCount) {
            this.mCells = new View[cellCount];
            this.mItemIndices = new int[cellCount];
            this.mColumnCount = cellCount;
        }

        abstract ViewGroup addView(int var1, View var2);

        abstract ViewGroup getViewGroup();

        abstract ViewGroup getRowByIndex(int var1);

        abstract ViewGroup getRow(int var1);

        abstract void setViewVisibility(int var1, int var2);

        public int getColumnCount() {
            return this.mColumnCount;
        }

        public void measure() {
            int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
            this.getViewGroup().measure(spec, spec);
            this.mMeasuredRowHeight = this.getViewGroup().getMeasuredHeight();
        }

        public int getMeasuredRowHeight() {
            return this.mMeasuredRowHeight;
        }

        public void setItemIndex(int itemIndex, int listIndex) {
            this.mItemIndices[itemIndex] = listIndex;
        }

        public int getItemIndex(int itemIndex) {
            return this.mItemIndices[itemIndex];
        }

        public View getView(int index) {
            return this.mCells[index];
        }
    }

    class ChooserRowAdapter
    extends BaseAdapter {
        private ChooserListAdapter mChooserListAdapter;
        private final LayoutInflater mLayoutInflater;
        private DirectShareViewHolder mDirectShareViewHolder;
        private int mChooserTargetWidth = 0;
        private boolean mShowAzLabelIfPoss;
        private boolean mHideContentPreview = false;
        private boolean mLayoutRequested = false;
        private static final int VIEW_TYPE_DIRECT_SHARE = 0;
        private static final int VIEW_TYPE_NORMAL = 1;
        private static final int VIEW_TYPE_CONTENT_PREVIEW = 2;
        private static final int VIEW_TYPE_PROFILE = 3;
        private static final int VIEW_TYPE_AZ_LABEL = 4;
        private static final int MAX_TARGETS_PER_ROW_PORTRAIT = 4;
        private static final int MAX_TARGETS_PER_ROW_LANDSCAPE = 8;
        private static final int NUM_EXPANSIONS_TO_HIDE_AZ_LABEL = 20;

        public ChooserRowAdapter(ChooserListAdapter wrappedAdapter) {
            this.mChooserListAdapter = wrappedAdapter;
            this.mLayoutInflater = LayoutInflater.from(ChooserActivity.this);
            this.mShowAzLabelIfPoss = ChooserActivity.this.getNumSheetExpansions() < 20;
            wrappedAdapter.registerDataSetObserver(new DataSetObserver(){

                @Override
                public void onChanged() {
                    super.onChanged();
                    ChooserRowAdapter.this.notifyDataSetChanged();
                }

                @Override
                public void onInvalidated() {
                    super.onInvalidated();
                    ChooserRowAdapter.this.notifyDataSetInvalidated();
                }
            });
        }

        public boolean calculateChooserTargetWidth(int width) {
            if (width == 0) {
                return false;
            }
            int newWidth = width / this.getMaxTargetsPerRow();
            if (newWidth != this.mChooserTargetWidth) {
                this.mChooserTargetWidth = newWidth;
                return true;
            }
            return false;
        }

        private int getMaxTargetsPerRow() {
            int maxTargets = 4;
            if (ChooserActivity.this.shouldDisplayLandscape(ChooserActivity.this.getResources().getConfiguration().orientation)) {
                maxTargets = 8;
            }
            return maxTargets;
        }

        public void hideContentPreview() {
            this.mHideContentPreview = true;
            this.mLayoutRequested = true;
            this.notifyDataSetChanged();
        }

        public boolean consumeLayoutRequest() {
            boolean oldValue = this.mLayoutRequested;
            this.mLayoutRequested = false;
            return oldValue;
        }

        @Override
        public boolean areAllItemsEnabled() {
            return false;
        }

        @Override
        public boolean isEnabled(int position) {
            int viewType = this.getItemViewType(position);
            return viewType != 2 && viewType != 4;
        }

        @Override
        public int getCount() {
            return (int)((double)(this.getContentPreviewRowCount() + this.getProfileRowCount() + this.getServiceTargetRowCount() + this.getCallerAndRankedTargetRowCount() + this.getAzLabelRowCount()) + Math.ceil((float)this.mChooserListAdapter.getAlphaTargetCount() / (float)this.getMaxTargetsPerRow()));
        }

        public int getContentPreviewRowCount() {
            if (!ChooserActivity.this.isSendAction(ChooserActivity.this.getTargetIntent())) {
                return 0;
            }
            if (this.mHideContentPreview || this.mChooserListAdapter == null || this.mChooserListAdapter.getCount() == 0) {
                return 0;
            }
            return 1;
        }

        public int getProfileRowCount() {
            return this.mChooserListAdapter.getOtherProfile() == null ? 0 : 1;
        }

        public int getCallerAndRankedTargetRowCount() {
            return (int)Math.ceil(((float)this.mChooserListAdapter.getCallerTargetCount() + (float)this.mChooserListAdapter.getRankedTargetCount()) / (float)this.getMaxTargetsPerRow());
        }

        public int getServiceTargetRowCount() {
            if (ChooserActivity.this.isSendAction(ChooserActivity.this.getTargetIntent()) && !ActivityManager.isLowRamDeviceStatic()) {
                return 1;
            }
            return 0;
        }

        public int getAzLabelRowCount() {
            return this.mShowAzLabelIfPoss && this.mChooserListAdapter.getAlphaTargetCount() > 0 ? 1 : 0;
        }

        @Override
        public Object getItem(int position) {
            return position;
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            int viewType = this.getItemViewType(position);
            if (viewType == 2) {
                return this.createContentPreviewView(convertView, parent);
            }
            if (viewType == 3) {
                return this.createProfileView(convertView, parent);
            }
            if (viewType == 4) {
                return this.createAzLabelView(parent);
            }
            RowViewHolder holder = convertView == null ? this.createViewHolder(viewType, parent) : (RowViewHolder)convertView.getTag();
            this.bindViewHolder(position, holder);
            return holder.getViewGroup();
        }

        @Override
        public int getItemViewType(int position) {
            int count;
            int countSum = count = this.getContentPreviewRowCount();
            if (count > 0 && position < countSum) {
                return 2;
            }
            count = this.getProfileRowCount();
            if (count > 0 && position < (countSum += count)) {
                return 3;
            }
            count = this.getServiceTargetRowCount();
            if (count > 0 && position < (countSum += count)) {
                return 0;
            }
            count = this.getCallerAndRankedTargetRowCount();
            if (count > 0 && position < (countSum += count)) {
                return 1;
            }
            count = this.getAzLabelRowCount();
            if (count > 0 && position < (countSum += count)) {
                return 4;
            }
            return 1;
        }

        @Override
        public int getViewTypeCount() {
            return 5;
        }

        private ViewGroup createContentPreviewView(View convertView, ViewGroup parent) {
            Intent targetIntent = ChooserActivity.this.getTargetIntent();
            int previewType = ChooserActivity.this.findPreferredContentPreview(targetIntent, ChooserActivity.this.getContentResolver());
            if (convertView == null) {
                ChooserActivity.this.getMetricsLogger().write(new LogMaker(1652).setSubtype(previewType));
            }
            return ChooserActivity.this.displayContentPreview(previewType, targetIntent, this.mLayoutInflater, (ViewGroup)convertView, parent);
        }

        private View createProfileView(View convertView, ViewGroup parent) {
            View profileRow = convertView != null ? convertView : this.mLayoutInflater.inflate(17367125, parent, false);
            profileRow.setBackground(ChooserActivity.this.getResources().getDrawable(17302106, null));
            ChooserActivity.this.mProfileView = profileRow.findViewById(16909258);
            ChooserActivity.this.mProfileView.setOnClickListener(ChooserActivity.this::onProfileClick);
            ChooserActivity.this.bindProfileView();
            return profileRow;
        }

        private View createAzLabelView(ViewGroup parent) {
            return this.mLayoutInflater.inflate(17367120, parent, false);
        }

        private RowViewHolder loadViewsIntoRow(final RowViewHolder holder) {
            int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
            int exactSpec = View.MeasureSpec.makeMeasureSpec(this.mChooserTargetWidth, 0x40000000);
            int columnCount = holder.getColumnCount();
            boolean isDirectShare = holder instanceof DirectShareViewHolder;
            for (int i = 0; i < columnCount; ++i) {
                View v = this.mChooserListAdapter.createView(holder.getRowByIndex(i));
                final int column = i;
                v.setOnClickListener(new View.OnClickListener(){

                    @Override
                    public void onClick(View v) {
                        ChooserActivity.this.startSelected(holder.getItemIndex(column), false, true);
                    }
                });
                v.setOnLongClickListener(new View.OnLongClickListener(){

                    @Override
                    public boolean onLongClick(View v) {
                        ChooserActivity.this.showTargetDetails(ChooserRowAdapter.this.mChooserListAdapter.resolveInfoForPosition(holder.getItemIndex(column), true));
                        return true;
                    }
                });
                ViewGroup row = holder.addView(i, v);
                if (isDirectShare) {
                    ResolverActivity.ViewHolder vh = (ResolverActivity.ViewHolder)v.getTag();
                    vh.text.setLines(2);
                    vh.text.setHorizontallyScrolling(false);
                    vh.text2.setVisibility(8);
                }
                v.measure(exactSpec, spec);
                this.setViewBounds(v, v.getMeasuredWidth(), v.getMeasuredHeight());
            }
            ViewGroup viewGroup = holder.getViewGroup();
            holder.measure();
            this.setViewBounds(viewGroup, -1, holder.getMeasuredRowHeight());
            if (isDirectShare) {
                DirectShareViewHolder dsvh = (DirectShareViewHolder)holder;
                this.setViewBounds(dsvh.getRow(0), -1, dsvh.getMinRowHeight());
                this.setViewBounds(dsvh.getRow(1), -1, dsvh.getMinRowHeight());
            }
            viewGroup.setTag(holder);
            return holder;
        }

        private void setViewBounds(View view, int widthPx, int heightPx) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            if (lp == null) {
                lp = new ViewGroup.LayoutParams(widthPx, heightPx);
                view.setLayoutParams(lp);
            } else {
                lp.height = heightPx;
                lp.width = widthPx;
            }
        }

        RowViewHolder createViewHolder(int viewType, ViewGroup parent) {
            if (viewType == 0) {
                ViewGroup parentGroup = (ViewGroup)this.mLayoutInflater.inflate(17367127, parent, false);
                ViewGroup row1 = (ViewGroup)this.mLayoutInflater.inflate(17367126, parentGroup, false);
                ViewGroup row2 = (ViewGroup)this.mLayoutInflater.inflate(17367126, parentGroup, false);
                parentGroup.addView(row1);
                parentGroup.addView(row2);
                this.mDirectShareViewHolder = new DirectShareViewHolder(parentGroup, Lists.newArrayList(row1, row2), this.getMaxTargetsPerRow());
                this.loadViewsIntoRow(this.mDirectShareViewHolder);
                return this.mDirectShareViewHolder;
            }
            ViewGroup row = (ViewGroup)this.mLayoutInflater.inflate(17367126, parent, false);
            SingleRowViewHolder holder = new SingleRowViewHolder(row, this.getMaxTargetsPerRow());
            this.loadViewsIntoRow(holder);
            return holder;
        }

        int getRowType(int rowPosition) {
            int positionType = this.mChooserListAdapter.getPositionTargetType(rowPosition);
            if (positionType == 0) {
                return 2;
            }
            if (this.getAzLabelRowCount() > 0 && positionType == 3) {
                return 2;
            }
            return positionType;
        }

        void bindViewHolder(int rowPosition, RowViewHolder holder) {
            TextView textView;
            int end;
            int start = this.getFirstRowPosition(rowPosition);
            int startType = this.getRowType(start);
            int lastStartType = this.getRowType(this.getFirstRowPosition(rowPosition - 1));
            ViewGroup row = holder.getViewGroup();
            if (startType != lastStartType || rowPosition == this.getContentPreviewRowCount() + this.getProfileRowCount()) {
                row.setForeground(ChooserActivity.this.getResources().getDrawable(17302106, null));
            } else {
                row.setForeground(null);
            }
            int columnCount = holder.getColumnCount();
            for (end = start + columnCount - 1; this.getRowType(end) != startType && end >= start; --end) {
            }
            if (end == start && this.mChooserListAdapter.getItem(start) instanceof EmptyTargetInfo && (textView = (TextView)row.findViewById(16908807)).getVisibility() != 0) {
                textView.setAlpha(0.0f);
                textView.setVisibility(0);
                textView.setText(17039656);
                ObjectAnimator fadeAnim = ObjectAnimator.ofFloat((Object)textView, "alpha", 0.0f, 1.0f);
                fadeAnim.setInterpolator(new DecelerateInterpolator(1.0f));
                float translationInPx = ChooserActivity.this.getResources().getDimensionPixelSize(17105042);
                textView.setTranslationY(translationInPx);
                ObjectAnimator translateAnim = ObjectAnimator.ofFloat((Object)textView, "translationY", 0.0f);
                translateAnim.setInterpolator(new DecelerateInterpolator(1.0f));
                AnimatorSet animSet = new AnimatorSet();
                animSet.setDuration(200L);
                animSet.setStartDelay(200L);
                animSet.playTogether(fadeAnim, translateAnim);
                animSet.start();
            }
            for (int i = 0; i < columnCount; ++i) {
                View v = holder.getView(i);
                if (start + i <= end) {
                    holder.setViewVisibility(i, 0);
                    holder.setItemIndex(i, start + i);
                    this.mChooserListAdapter.bindView(holder.getItemIndex(i), v);
                    continue;
                }
                holder.setViewVisibility(i, 4);
            }
        }

        int getFirstRowPosition(int row) {
            int serviceCount;
            int serviceRows;
            if ((row -= this.getContentPreviewRowCount() + this.getProfileRowCount()) < (serviceRows = (int)Math.ceil((float)(serviceCount = this.mChooserListAdapter.getServiceTargetCount()) / 8.0f))) {
                return row * this.getMaxTargetsPerRow();
            }
            int callerAndRankedCount = this.mChooserListAdapter.getCallerTargetCount() + this.mChooserListAdapter.getRankedTargetCount();
            int callerAndRankedRows = this.getCallerAndRankedTargetRowCount();
            if (row < callerAndRankedRows + serviceRows) {
                return serviceCount + (row - serviceRows) * this.getMaxTargetsPerRow();
            }
            return callerAndRankedCount + serviceCount + ((row -= this.getAzLabelRowCount()) - callerAndRankedRows - serviceRows) * this.getMaxTargetsPerRow();
        }

        public void handleScroll(View v, int y, int oldy) {
            boolean canExpandDirectShare;
            int orientation = ChooserActivity.this.getResources().getConfiguration().orientation;
            boolean bl = canExpandDirectShare = this.mChooserListAdapter.getNumShortcutResults() > this.getMaxTargetsPerRow() && orientation == 1 && !ChooserActivity.this.isInMultiWindowMode();
            if (this.mDirectShareViewHolder != null && canExpandDirectShare) {
                this.mDirectShareViewHolder.handleScroll(ChooserActivity.this.mAdapterView, y, oldy, this.getMaxTargetsPerRow());
            }
        }
    }

    static class BaseChooserTargetComparator
    implements Comparator<ChooserTarget> {
        BaseChooserTargetComparator() {
        }

        @Override
        public int compare(ChooserTarget lhs, ChooserTarget rhs) {
            return (int)Math.signum(rhs.getScore() - lhs.getScore());
        }
    }

    public class ChooserListAdapter
    extends ResolverActivity.ResolveListAdapter {
        public static final int TARGET_BAD = -1;
        public static final int TARGET_CALLER = 0;
        public static final int TARGET_SERVICE = 1;
        public static final int TARGET_STANDARD = 2;
        public static final int TARGET_STANDARD_AZ = 3;
        private static final int MAX_SUGGESTED_APP_TARGETS = 4;
        private static final int MAX_CHOOSER_TARGETS_PER_APP = 2;
        private static final int MAX_SERVICE_TARGETS = 8;
        private final int mMaxShortcutTargetsPerApp;
        private int mNumShortcutResults;
        private ChooserTargetInfo mPlaceHolderTargetInfo;
        private final List<ChooserTargetInfo> mServiceTargets;
        private final List<ResolverActivity.TargetInfo> mCallerTargets;
        private final BaseChooserTargetComparator mBaseTargetComparator;

        public ChooserListAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed, ResolverListController resolverListController) {
            super(ChooserActivity.this, context, payloadIntents, null, rList, launchedFromUid, filterLastUsed, resolverListController);
            this.mMaxShortcutTargetsPerApp = ChooserActivity.this.getResources().getInteger(17694834);
            this.mNumShortcutResults = 0;
            this.mPlaceHolderTargetInfo = new PlaceHolderTargetInfo();
            this.mServiceTargets = new ArrayList<ChooserTargetInfo>();
            this.mCallerTargets = new ArrayList<ResolverActivity.TargetInfo>();
            this.mBaseTargetComparator = new BaseChooserTargetComparator();
            this.createPlaceHolders();
            if (initialIntents != null) {
                PackageManager pm = ChooserActivity.this.getPackageManager();
                for (int i = 0; i < initialIntents.length; ++i) {
                    Intent ii = initialIntents[i];
                    if (ii == null) continue;
                    ResolveInfo ri = null;
                    ActivityInfo ai = null;
                    ComponentName cn = ii.getComponent();
                    if (cn != null) {
                        try {
                            ai = pm.getActivityInfo(ii.getComponent(), 0);
                            ri = new ResolveInfo();
                            ri.activityInfo = ai;
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (ai == null) {
                        ri = pm.resolveActivity(ii, 65536);
                        ActivityInfo activityInfo = ai = ri != null ? ri.activityInfo : null;
                    }
                    if (ai == null) {
                        Log.w(ChooserActivity.TAG, "No activity found for " + ii);
                        continue;
                    }
                    UserManager userManager = (UserManager)ChooserActivity.this.getSystemService("user");
                    if (ii instanceof LabeledIntent) {
                        LabeledIntent li = (LabeledIntent)ii;
                        ri.resolvePackageName = li.getSourcePackage();
                        ri.labelRes = li.getLabelResource();
                        ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                        ri.iconResourceId = ri.icon = li.getIconResource();
                    }
                    if (userManager.isManagedProfile()) {
                        ri.noResourceId = true;
                        ri.icon = 0;
                    }
                    ResolverActivity.ResolveInfoPresentationGetter getter = ChooserActivity.this.makePresentationGetter(ri);
                    this.mCallerTargets.add(new ResolverActivity.DisplayResolveInfo(ChooserActivity.this, ii, ri, getter.getLabel(), getter.getSubLabel(), ii));
                }
            }
        }

        @Override
        public void handlePackagesChanged() {
            this.createPlaceHolders();
            ChooserActivity.this.mServicesRequested.clear();
            this.notifyDataSetChanged();
            super.handlePackagesChanged();
        }

        @Override
        public void notifyDataSetChanged() {
            if (!ChooserActivity.this.mListViewDataChanged) {
                ChooserActivity.this.mChooserHandler.sendEmptyMessageDelayed(6, 250L);
                ChooserActivity.this.mListViewDataChanged = true;
            }
        }

        private void refreshListView() {
            if (ChooserActivity.this.mListViewDataChanged) {
                super.notifyDataSetChanged();
            }
            ChooserActivity.this.mListViewDataChanged = false;
        }

        private void createPlaceHolders() {
            this.mNumShortcutResults = 0;
            this.mServiceTargets.clear();
            for (int i = 0; i < 8; ++i) {
                this.mServiceTargets.add(this.mPlaceHolderTargetInfo);
            }
        }

        @Override
        public View onCreateView(ViewGroup parent) {
            return this.mInflater.inflate(17367258, parent, false);
        }

        @Override
        protected void onBindView(View view, ResolverActivity.TargetInfo info) {
            super.onBindView(view, info);
            ResolverActivity.ViewHolder holder = (ResolverActivity.ViewHolder)view.getTag();
            if (info instanceof PlaceHolderTargetInfo) {
                int maxWidth = ChooserActivity.this.getResources().getDimensionPixelSize(17105033);
                holder.text.setMaxWidth(maxWidth);
                holder.text.setBackground(ChooserActivity.this.getResources().getDrawable(17302104, ChooserActivity.this.getTheme()));
                holder.itemView.setBackground(null);
            } else {
                holder.text.setMaxWidth(Integer.MAX_VALUE);
                holder.text.setBackground(null);
                holder.itemView.setBackground(holder.defaultItemViewBackground);
            }
        }

        @Override
        public void onListRebuilt() {
            ChooserActivity.this.updateAlphabeticalList();
            if (ActivityManager.isLowRamDeviceStatic()) {
                return;
            }
            ChooserActivity.this.queryDirectShareTargets(this, false);
            ChooserActivity.this.queryTargetServices(this);
        }

        @Override
        public boolean shouldGetResolvedFilter() {
            return true;
        }

        @Override
        public int getCount() {
            return this.getRankedTargetCount() + this.getAlphaTargetCount() + this.getSelectableServiceTargetCount() + this.getCallerTargetCount();
        }

        @Override
        public int getUnfilteredCount() {
            int appTargets = super.getUnfilteredCount();
            if (appTargets > this.getMaxRankedTargets()) {
                appTargets += this.getMaxRankedTargets();
            }
            return appTargets + this.getSelectableServiceTargetCount() + this.getCallerTargetCount();
        }

        public int getCallerTargetCount() {
            return Math.min(this.mCallerTargets.size(), 4);
        }

        public int getSelectableServiceTargetCount() {
            int count = 0;
            for (ChooserTargetInfo info : this.mServiceTargets) {
                if (!(info instanceof SelectableTargetInfo)) continue;
                ++count;
            }
            return count;
        }

        public int getServiceTargetCount() {
            if (ChooserActivity.this.isSendAction(ChooserActivity.this.getTargetIntent()) && !ActivityManager.isLowRamDeviceStatic()) {
                return Math.min(this.mServiceTargets.size(), 8);
            }
            return 0;
        }

        int getAlphaTargetCount() {
            int standardCount = super.getCount();
            return standardCount > this.getMaxRankedTargets() ? standardCount : 0;
        }

        int getRankedTargetCount() {
            int spacesAvailable = this.getMaxRankedTargets() - this.getCallerTargetCount();
            return Math.min(spacesAvailable, super.getCount());
        }

        private int getMaxRankedTargets() {
            return ChooserActivity.this.mChooserRowAdapter == null ? 4 : ChooserActivity.this.mChooserRowAdapter.getMaxTargetsPerRow();
        }

        public int getPositionTargetType(int position) {
            int offset = 0;
            int serviceTargetCount = this.getServiceTargetCount();
            if (position < serviceTargetCount) {
                return 1;
            }
            int callerTargetCount = this.getCallerTargetCount();
            if (position - (offset += serviceTargetCount) < callerTargetCount) {
                return 0;
            }
            int rankedTargetCount = this.getRankedTargetCount();
            if (position - (offset += callerTargetCount) < rankedTargetCount) {
                return 2;
            }
            int standardTargetCount = this.getAlphaTargetCount();
            if (position - (offset += rankedTargetCount) < standardTargetCount) {
                return 3;
            }
            return -1;
        }

        @Override
        public ResolverActivity.TargetInfo getItem(int position) {
            return this.targetInfoForPosition(position, true);
        }

        @Override
        public ResolverActivity.TargetInfo targetInfoForPosition(int position, boolean filtered) {
            int serviceTargetCount;
            int offset = 0;
            int n = serviceTargetCount = filtered ? this.getServiceTargetCount() : this.getSelectableServiceTargetCount();
            if (position < serviceTargetCount) {
                return this.mServiceTargets.get(position);
            }
            int callerTargetCount = this.getCallerTargetCount();
            if (position - (offset += serviceTargetCount) < callerTargetCount) {
                return this.mCallerTargets.get(position - offset);
            }
            int rankedTargetCount = this.getRankedTargetCount();
            if (position - (offset += callerTargetCount) < rankedTargetCount) {
                return filtered ? super.getItem(position - offset) : this.getDisplayResolveInfo(position - offset);
            }
            if (position - (offset += rankedTargetCount) < this.getAlphaTargetCount() && !ChooserActivity.this.mSortedList.isEmpty()) {
                return (ResolverActivity.TargetInfo)ChooserActivity.this.mSortedList.get(position - offset);
            }
            return null;
        }

        public void addServiceResults(ResolverActivity.DisplayResolveInfo origTarget, List<ChooserTarget> targets, boolean isShortcutResult) {
            if (targets.size() == 0) {
                return;
            }
            float baseScore = this.getBaseScore(origTarget, isShortcutResult);
            Collections.sort(targets, this.mBaseTargetComparator);
            int maxTargets = isShortcutResult ? this.mMaxShortcutTargetsPerApp : 2;
            float lastScore = 0.0f;
            boolean shouldNotify = false;
            int count = Math.min(targets.size(), maxTargets);
            for (int i = 0; i < count; ++i) {
                boolean isInserted;
                ChooserTarget target = targets.get(i);
                float targetScore = target.getScore();
                targetScore *= baseScore;
                if (i > 0 && targetScore >= lastScore) {
                    targetScore = lastScore * 0.95f;
                }
                if ((isInserted = this.insertServiceTarget(new SelectableTargetInfo(origTarget, target, targetScore))) && isShortcutResult) {
                    ++this.mNumShortcutResults;
                }
                shouldNotify |= isInserted;
                lastScore = targetScore;
            }
            if (shouldNotify) {
                this.notifyDataSetChanged();
            }
        }

        private int getNumShortcutResults() {
            return this.mNumShortcutResults;
        }

        private float getBaseScore(ResolverActivity.DisplayResolveInfo target, boolean isShortcutResult) {
            if (target == null) {
                return 900.0f;
            }
            if (isShortcutResult && ChooserActivity.this.getAppPredictorForDirectShareIfEnabled() != null) {
                return 90.0f;
            }
            float score = super.getScore(target);
            if (isShortcutResult) {
                return score * 90.0f;
            }
            return score;
        }

        public void completeServiceTargetLoading() {
            this.mServiceTargets.removeIf(o -> o instanceof PlaceHolderTargetInfo);
            if (this.mServiceTargets.isEmpty()) {
                this.mServiceTargets.add(new EmptyTargetInfo());
            }
            this.notifyDataSetChanged();
        }

        private boolean insertServiceTarget(ChooserTargetInfo chooserTargetInfo) {
            if (this.mServiceTargets.size() == 1 && this.mServiceTargets.get(0) instanceof EmptyTargetInfo) {
                return false;
            }
            for (ChooserTargetInfo otherTargetInfo : this.mServiceTargets) {
                if (!chooserTargetInfo.isSimilar(otherTargetInfo)) continue;
                return false;
            }
            int currentSize = this.mServiceTargets.size();
            float newScore = chooserTargetInfo.getModifiedScore();
            for (int i = 0; i < Math.min(currentSize, 8); ++i) {
                ChooserTargetInfo serviceTarget = this.mServiceTargets.get(i);
                if (serviceTarget == null) {
                    this.mServiceTargets.set(i, chooserTargetInfo);
                    return true;
                }
                if (!(newScore > serviceTarget.getModifiedScore())) continue;
                this.mServiceTargets.add(i, chooserTargetInfo);
                return true;
            }
            if (currentSize < 8) {
                this.mServiceTargets.add(chooserTargetInfo);
                return true;
            }
            return false;
        }
    }

    final class SelectableTargetInfo
    implements ChooserTargetInfo {
        private final ResolverActivity.DisplayResolveInfo mSourceInfo;
        private final ResolveInfo mBackupResolveInfo;
        private final ChooserTarget mChooserTarget;
        private final String mDisplayLabel;
        private Drawable mBadgeIcon = null;
        private CharSequence mBadgeContentDescription;
        private Drawable mDisplayIcon;
        private final Intent mFillInIntent;
        private final int mFillInFlags;
        private final float mModifiedScore;
        private boolean mIsSuspended = false;

        SelectableTargetInfo(ResolverActivity.DisplayResolveInfo sourceInfo, ChooserTarget chooserTarget, float modifiedScore) {
            ActivityInfo ai;
            ResolveInfo ri;
            this.mSourceInfo = sourceInfo;
            this.mChooserTarget = chooserTarget;
            this.mModifiedScore = modifiedScore;
            if (sourceInfo != null && (ri = sourceInfo.getResolveInfo()) != null && (ai = ri.activityInfo) != null && ai.applicationInfo != null) {
                PackageManager pm = ChooserActivity.this.getPackageManager();
                this.mBadgeIcon = pm.getApplicationIcon(ai.applicationInfo);
                this.mBadgeContentDescription = pm.getApplicationLabel(ai.applicationInfo);
                this.mIsSuspended = (ai.applicationInfo.flags & 0x40000000) != 0;
            }
            this.mDisplayIcon = this.getChooserTargetIconDrawable(chooserTarget);
            this.mBackupResolveInfo = sourceInfo != null ? null : ChooserActivity.this.getPackageManager().resolveActivity(this.getResolvedIntent(), 0);
            this.mFillInIntent = null;
            this.mFillInFlags = 0;
            this.mDisplayLabel = this.sanitizeDisplayLabel(chooserTarget.getTitle());
        }

        private SelectableTargetInfo(SelectableTargetInfo other, Intent fillInIntent, int flags) {
            this.mSourceInfo = other.mSourceInfo;
            this.mBackupResolveInfo = other.mBackupResolveInfo;
            this.mChooserTarget = other.mChooserTarget;
            this.mBadgeIcon = other.mBadgeIcon;
            this.mBadgeContentDescription = other.mBadgeContentDescription;
            this.mDisplayIcon = other.mDisplayIcon;
            this.mFillInIntent = fillInIntent;
            this.mFillInFlags = flags;
            this.mModifiedScore = other.mModifiedScore;
            this.mDisplayLabel = this.sanitizeDisplayLabel(this.mChooserTarget.getTitle());
        }

        private String sanitizeDisplayLabel(CharSequence label) {
            SpannableStringBuilder sb = new SpannableStringBuilder(label);
            sb.clearSpans();
            return sb.toString();
        }

        @Override
        public boolean isSuspended() {
            return this.mIsSuspended;
        }

        private Drawable getChooserTargetIconDrawable(ChooserTarget target) {
            Drawable directShareIcon = null;
            Icon icon = target.getIcon();
            if (icon != null) {
                directShareIcon = icon.loadDrawable(ChooserActivity.this);
            } else {
                Bundle extras = target.getIntentExtras();
                if (extras != null && extras.containsKey("android.intent.extra.shortcut.ID")) {
                    CharSequence shortcutId = extras.getCharSequence("android.intent.extra.shortcut.ID");
                    LauncherApps launcherApps = (LauncherApps)ChooserActivity.this.getSystemService("launcherapps");
                    LauncherApps.ShortcutQuery q = new LauncherApps.ShortcutQuery();
                    q.setPackage(target.getComponentName().getPackageName());
                    q.setShortcutIds(Arrays.asList(shortcutId.toString()));
                    q.setQueryFlags(1);
                    List<ShortcutInfo> shortcuts = launcherApps.getShortcuts(q, ChooserActivity.this.getUser());
                    if (shortcuts != null && shortcuts.size() > 0) {
                        directShareIcon = launcherApps.getShortcutIconDrawable(shortcuts.get(0), 0);
                    }
                }
            }
            if (directShareIcon == null) {
                return null;
            }
            ActivityInfo info = null;
            try {
                info = ChooserActivity.this.mPm.getActivityInfo(target.getComponentName(), 0);
            }
            catch (PackageManager.NameNotFoundException error) {
                Log.e(ChooserActivity.TAG, "Could not find activity associated with ChooserTarget");
            }
            if (info == null) {
                return null;
            }
            Bitmap appIcon = ChooserActivity.this.makePresentationGetter(info).getIconBitmap(UserHandle.getUserHandleForUid(UserHandle.myUserId()));
            SimpleIconFactory sif = SimpleIconFactory.obtain(ChooserActivity.this);
            Bitmap directShareBadgedIcon = sif.createAppBadgedIconBitmap(directShareIcon, appIcon);
            sif.recycle();
            return new BitmapDrawable(ChooserActivity.this.getResources(), directShareBadgedIcon);
        }

        @Override
        public float getModifiedScore() {
            return this.mModifiedScore;
        }

        @Override
        public Intent getResolvedIntent() {
            if (this.mSourceInfo != null) {
                return this.mSourceInfo.getResolvedIntent();
            }
            Intent targetIntent = new Intent(ChooserActivity.this.getTargetIntent());
            targetIntent.setComponent(this.mChooserTarget.getComponentName());
            targetIntent.putExtras(this.mChooserTarget.getIntentExtras());
            return targetIntent;
        }

        @Override
        public ComponentName getResolvedComponentName() {
            if (this.mSourceInfo != null) {
                return this.mSourceInfo.getResolvedComponentName();
            }
            if (this.mBackupResolveInfo != null) {
                return new ComponentName(this.mBackupResolveInfo.activityInfo.packageName, this.mBackupResolveInfo.activityInfo.name);
            }
            return null;
        }

        private Intent getBaseIntentToSend() {
            Intent result = this.getResolvedIntent();
            if (result == null) {
                Log.e(ChooserActivity.TAG, "ChooserTargetInfo: no base intent available to send");
            } else {
                result = new Intent(result);
                if (this.mFillInIntent != null) {
                    result.fillIn(this.mFillInIntent, this.mFillInFlags);
                }
                result.fillIn(ChooserActivity.this.mReferrerFillInIntent, 0);
            }
            return result;
        }

        @Override
        public boolean start(Activity activity, Bundle options) {
            throw new RuntimeException("ChooserTargets should be started as caller.");
        }

        @Override
        public boolean startAsCaller(ResolverActivity activity, Bundle options, int userId) {
            Intent intent = this.getBaseIntentToSend();
            if (intent == null) {
                return false;
            }
            intent.setComponent(this.mChooserTarget.getComponentName());
            intent.putExtras(this.mChooserTarget.getIntentExtras());
            boolean ignoreTargetSecurity = this.mSourceInfo != null && this.mSourceInfo.getResolvedComponentName().getPackageName().equals(this.mChooserTarget.getComponentName().getPackageName());
            return activity.startAsCallerImpl(intent, options, ignoreTargetSecurity, userId);
        }

        @Override
        public boolean startAsUser(Activity activity, Bundle options, UserHandle user) {
            throw new RuntimeException("ChooserTargets should be started as caller.");
        }

        @Override
        public ResolveInfo getResolveInfo() {
            return this.mSourceInfo != null ? this.mSourceInfo.getResolveInfo() : this.mBackupResolveInfo;
        }

        @Override
        public CharSequence getDisplayLabel() {
            return this.mDisplayLabel;
        }

        @Override
        public CharSequence getExtendedInfo() {
            return null;
        }

        @Override
        public Drawable getDisplayIcon() {
            return this.mDisplayIcon;
        }

        @Override
        public ChooserTarget getChooserTarget() {
            return this.mChooserTarget;
        }

        @Override
        public ResolverActivity.TargetInfo cloneFilledIn(Intent fillInIntent, int flags) {
            return new SelectableTargetInfo(this, fillInIntent, flags);
        }

        @Override
        public List<Intent> getAllSourceIntents() {
            ArrayList<Intent> results = new ArrayList<Intent>();
            if (this.mSourceInfo != null) {
                results.add(this.mSourceInfo.getAllSourceIntents().get(0));
            }
            return results;
        }
    }

    final class EmptyTargetInfo
    extends NotSelectableTargetInfo {
        EmptyTargetInfo() {
        }

        @Override
        public Drawable getDisplayIcon() {
            return null;
        }
    }

    final class PlaceHolderTargetInfo
    extends NotSelectableTargetInfo {
        PlaceHolderTargetInfo() {
        }

        @Override
        public Drawable getDisplayIcon() {
            AnimatedVectorDrawable avd = (AnimatedVectorDrawable)ChooserActivity.this.getDrawable(17302103);
            avd.start();
            return avd;
        }
    }

    abstract class NotSelectableTargetInfo
    implements ChooserTargetInfo {
        NotSelectableTargetInfo() {
        }

        @Override
        public Intent getResolvedIntent() {
            return null;
        }

        @Override
        public ComponentName getResolvedComponentName() {
            return null;
        }

        @Override
        public boolean start(Activity activity, Bundle options) {
            return false;
        }

        @Override
        public boolean startAsCaller(ResolverActivity activity, Bundle options, int userId) {
            return false;
        }

        @Override
        public boolean startAsUser(Activity activity, Bundle options, UserHandle user) {
            return false;
        }

        @Override
        public ResolveInfo getResolveInfo() {
            return null;
        }

        @Override
        public CharSequence getDisplayLabel() {
            return null;
        }

        @Override
        public CharSequence getExtendedInfo() {
            return null;
        }

        @Override
        public ResolverActivity.TargetInfo cloneFilledIn(Intent fillInIntent, int flags) {
            return null;
        }

        @Override
        public List<Intent> getAllSourceIntents() {
            return null;
        }

        @Override
        public float getModifiedScore() {
            return -0.1f;
        }

        @Override
        public ChooserTarget getChooserTarget() {
            return null;
        }

        @Override
        public boolean isSuspended() {
            return false;
        }
    }

    static interface ChooserTargetInfo
    extends ResolverActivity.TargetInfo {
        public float getModifiedScore();

        public ChooserTarget getChooserTarget();

        default public boolean isSimilar(ChooserTargetInfo other) {
            if (other == null) {
                return false;
            }
            ChooserTarget ct1 = this.getChooserTarget();
            ChooserTarget ct2 = other.getChooserTarget();
            if (ct1 == null || ct2 == null) {
                return false;
            }
            return ct1.getComponentName().equals(ct2.getComponentName()) && TextUtils.equals(this.getDisplayLabel(), other.getDisplayLabel()) && TextUtils.equals(this.getExtendedInfo(), other.getExtendedInfo());
        }
    }

    public class ChooserListController
    extends ResolverListController {
        public ChooserListController(Context context, PackageManager pm, Intent targetIntent, String referrerPackageName, int launchedFromUid, AbstractResolverComparator resolverComparator) {
            super(context, pm, targetIntent, referrerPackageName, launchedFromUid, resolverComparator);
        }

        @Override
        boolean isComponentFiltered(ComponentName name) {
            if (ChooserActivity.this.mFilteredComponentNames == null) {
                return false;
            }
            for (ComponentName filteredComponentName : ChooserActivity.this.mFilteredComponentNames) {
                if (!name.equals(filteredComponentName)) continue;
                return true;
            }
            return false;
        }
    }

    class AzInfoComparator
    implements Comparator<ResolverActivity.DisplayResolveInfo> {
        Collator mCollator;

        AzInfoComparator(Context context) {
            this.mCollator = Collator.getInstance(context.getResources().getConfiguration().locale);
        }

        @Override
        public int compare(ResolverActivity.DisplayResolveInfo lhsp, ResolverActivity.DisplayResolveInfo rhsp) {
            return this.mCollator.compare(lhsp.getDisplayLabel(), rhsp.getDisplayLabel());
        }
    }

    private static class FileInfo {
        public final String name;
        public final boolean hasThumbnail;

        FileInfo(String name, boolean hasThumbnail) {
            this.name = name;
            this.hasThumbnail = hasThumbnail;
        }
    }

    private class ChooserHandler
    extends Handler {
        private static final int CHOOSER_TARGET_SERVICE_RESULT = 1;
        private static final int CHOOSER_TARGET_SERVICE_WATCHDOG_MIN_TIMEOUT = 2;
        private static final int CHOOSER_TARGET_SERVICE_WATCHDOG_MAX_TIMEOUT = 3;
        private static final int SHORTCUT_MANAGER_SHARE_TARGET_RESULT = 4;
        private static final int SHORTCUT_MANAGER_SHARE_TARGET_RESULT_COMPLETED = 5;
        private static final int LIST_VIEW_UPDATE_MESSAGE = 6;
        private static final int WATCHDOG_TIMEOUT_MAX_MILLIS = 10000;
        private static final int WATCHDOG_TIMEOUT_MIN_MILLIS = 3000;
        private boolean mMinTimeoutPassed = false;

        private ChooserHandler() {
        }

        private void removeAllMessages() {
            this.removeMessages(6);
            this.removeMessages(2);
            this.removeMessages(3);
            this.removeMessages(1);
            this.removeMessages(4);
            this.removeMessages(5);
        }

        private void restartServiceRequestTimer() {
            this.mMinTimeoutPassed = false;
            this.removeMessages(2);
            this.removeMessages(3);
            this.sendEmptyMessageDelayed(2, 3000L);
            this.sendEmptyMessageDelayed(3, 10000L);
        }

        private void maybeStopServiceRequestTimer() {
            if (this.mMinTimeoutPassed && ChooserActivity.this.mServiceConnections.isEmpty()) {
                ChooserActivity.this.logDirectShareTargetReceived(1719);
                ChooserActivity.this.sendVoiceChoicesIfNeeded();
                ChooserActivity.this.mChooserListAdapter.completeServiceTargetLoading();
            }
        }

        @Override
        public void handleMessage(Message msg) {
            if (ChooserActivity.this.mChooserListAdapter == null || ChooserActivity.this.isDestroyed()) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    ServiceResultInfo sri = (ServiceResultInfo)msg.obj;
                    if (!ChooserActivity.this.mServiceConnections.contains(sri.connection)) {
                        Log.w(ChooserActivity.TAG, "ChooserTargetServiceConnection " + sri.connection + " returned after being removed from active connections. Have you considered returning results faster?");
                        break;
                    }
                    if (sri.resultTargets != null) {
                        ChooserActivity.this.mChooserListAdapter.addServiceResults(sri.originalTarget, sri.resultTargets, false);
                    }
                    ChooserActivity.this.unbindService(sri.connection);
                    sri.connection.destroy();
                    ChooserActivity.this.mServiceConnections.remove(sri.connection);
                    this.maybeStopServiceRequestTimer();
                    break;
                }
                case 2: {
                    this.mMinTimeoutPassed = true;
                    this.maybeStopServiceRequestTimer();
                    break;
                }
                case 3: {
                    ChooserActivity.this.unbindRemainingServices();
                    this.maybeStopServiceRequestTimer();
                    break;
                }
                case 6: {
                    ChooserActivity.this.mChooserListAdapter.refreshListView();
                    break;
                }
                case 4: {
                    ServiceResultInfo resultInfo = (ServiceResultInfo)msg.obj;
                    if (resultInfo.resultTargets == null) break;
                    ChooserActivity.this.mChooserListAdapter.addServiceResults(resultInfo.originalTarget, resultInfo.resultTargets, true);
                    break;
                }
                case 5: {
                    ChooserActivity.this.logDirectShareTargetReceived(1718);
                    ChooserActivity.this.sendVoiceChoicesIfNeeded();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    private class ContentPreviewCoordinator {
        private static final int IMAGE_FADE_IN_MILLIS = 150;
        private static final int IMAGE_LOAD_TIMEOUT = 1;
        private static final int IMAGE_LOAD_INTO_VIEW = 2;
        private final int mImageLoadTimeoutMillis;
        private final View mParentView;
        private boolean mHideParentOnFail;
        private boolean mAtLeastOneLoaded;
        private final Handler mHandler;

        ContentPreviewCoordinator(View parentView, boolean hideParentOnFail) {
            this.mImageLoadTimeoutMillis = ChooserActivity.this.getResources().getInteger(0x10E0000);
            this.mAtLeastOneLoaded = false;
            this.mHandler = new Handler(){

                @Override
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            ContentPreviewCoordinator.this.maybeHideContentPreview();
                            break;
                        }
                        case 2: {
                            if (ChooserActivity.this.isFinishing()) break;
                            LoadUriTask task = (LoadUriTask)msg.obj;
                            RoundedRectImageView imageView = (RoundedRectImageView)ContentPreviewCoordinator.this.mParentView.findViewById(task.mImageResourceId);
                            if (task.mBmp == null) {
                                imageView.setVisibility(8);
                                ContentPreviewCoordinator.this.maybeHideContentPreview();
                                return;
                            }
                            ContentPreviewCoordinator.this.mAtLeastOneLoaded = true;
                            imageView.setVisibility(0);
                            imageView.setAlpha(0.0f);
                            imageView.setImageBitmap(task.mBmp);
                            ObjectAnimator fadeAnim = ObjectAnimator.ofFloat((Object)imageView, "alpha", 0.0f, 1.0f);
                            fadeAnim.setInterpolator(new DecelerateInterpolator(1.0f));
                            ((ValueAnimator)fadeAnim).setDuration(150L);
                            ((ValueAnimator)fadeAnim).start();
                            if (task.mExtraCount <= 0) break;
                            imageView.setExtraImageCount(task.mExtraCount);
                        }
                    }
                }
            };
            this.mParentView = parentView;
            this.mHideParentOnFail = hideParentOnFail;
        }

        private void loadUriIntoView(int imageResourceId, Uri uri, int extraImages) {
            this.mHandler.sendEmptyMessageDelayed(1, this.mImageLoadTimeoutMillis);
            AsyncTask.THREAD_POOL_EXECUTOR.execute(() -> {
                Bitmap bmp = ChooserActivity.this.loadThumbnail(uri, new Size(200, 200));
                Message msg = Message.obtain();
                msg.what = 2;
                msg.obj = new LoadUriTask(imageResourceId, uri, extraImages, bmp);
                this.mHandler.sendMessage(msg);
            });
        }

        private void cancelLoads() {
            this.mHandler.removeMessages(2);
            this.mHandler.removeMessages(1);
        }

        private void maybeHideContentPreview() {
            if (!this.mAtLeastOneLoaded && this.mHideParentOnFail) {
                Log.i(ChooserActivity.TAG, "Hiding image preview area. Timed out waiting for preview to load within " + this.mImageLoadTimeoutMillis + "ms.");
                this.collapseParentView();
                if (ChooserActivity.this.mChooserRowAdapter != null) {
                    ChooserActivity.this.mChooserRowAdapter.hideContentPreview();
                }
                this.mHideParentOnFail = false;
            }
        }

        private void collapseParentView() {
            View v = this.mParentView;
            int widthSpec = View.MeasureSpec.makeMeasureSpec(v.getWidth(), 0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec(0, 0x40000000);
            v.measure(widthSpec, heightSpec);
            v.getLayoutParams().height = 0;
            v.layout(v.getLeft(), v.getTop(), v.getRight(), v.getTop());
            v.invalidate();
        }

        class LoadUriTask {
            public final Uri mUri;
            public final int mImageResourceId;
            public final int mExtraCount;
            public final Bitmap mBmp;

            LoadUriTask(int imageResourceId, Uri uri, int extraCount, Bitmap bmp) {
                this.mImageResourceId = imageResourceId;
                this.mUri = uri;
                this.mExtraCount = extraCount;
                this.mBmp = bmp;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ContentPreviewType {
    }
}

