/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import com.android.internal.app.EventLogTags;

public class HarmfulAppWarningActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    private static final String TAG = HarmfulAppWarningActivity.class.getSimpleName();
    private static final String EXTRA_HARMFUL_APP_WARNING = "harmful_app_warning";
    private String mPackageName;
    private String mHarmfulAppWarning;
    private IntentSender mTarget;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        ApplicationInfo applicationInfo;
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.mPackageName = intent.getStringExtra("android.intent.extra.PACKAGE_NAME");
        this.mTarget = (IntentSender)intent.getParcelableExtra("android.intent.extra.INTENT");
        this.mHarmfulAppWarning = intent.getStringExtra(EXTRA_HARMFUL_APP_WARNING);
        if (this.mPackageName == null || this.mTarget == null || this.mHarmfulAppWarning == null) {
            Log.wtf(TAG, "Invalid intent: " + intent.toString());
            this.finish();
        }
        try {
            applicationInfo = this.getPackageManager().getApplicationInfo(this.mPackageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Could not show warning because package does not exist ", e);
            this.finish();
            return;
        }
        AlertController.AlertParams p = this.mAlertParams;
        p.mTitle = this.getString(17040082);
        p.mView = this.createView(applicationInfo);
        p.mPositiveButtonText = this.getString(17040083);
        p.mPositiveButtonListener = this;
        p.mNegativeButtonText = this.getString(17040081);
        p.mNegativeButtonListener = this;
        this.mAlert.installContent(this.mAlertParams);
    }

    private View createView(ApplicationInfo applicationInfo) {
        View view = this.getLayoutInflater().inflate(17367161, null);
        ((TextView)view.findViewById(16908731)).setText(applicationInfo.loadSafeLabel(this.getPackageManager(), 500.0f, 5));
        ((TextView)view.findViewById(16908299)).setText(this.mHarmfulAppWarning);
        return view;
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                this.getPackageManager().deletePackage(this.mPackageName, null, 0);
                EventLogTags.writeHarmfulAppWarningUninstall(this.mPackageName);
                this.finish();
                break;
            }
            case -2: {
                this.getPackageManager().setHarmfulAppWarning(this.mPackageName, null);
                IntentSender target = (IntentSender)this.getIntent().getParcelableExtra("android.intent.extra.INTENT");
                try {
                    this.startIntentSenderForResult(target, -1, null, 0, 0, 0);
                }
                catch (IntentSender.SendIntentException e) {
                    Log.e(TAG, "Error while starting intent sender", e);
                }
                EventLogTags.writeHarmfulAppWarningLaunchAnyway(this.mPackageName);
                this.finish();
            }
        }
    }

    public static Intent createHarmfulAppWarningIntent(Context context, String targetPackageName, IntentSender target, CharSequence harmfulAppWarning) {
        Intent intent = new Intent();
        intent.setClass(context, HarmfulAppWarningActivity.class);
        intent.putExtra("android.intent.extra.PACKAGE_NAME", targetPackageName);
        intent.putExtra("android.intent.extra.INTENT", target);
        intent.putExtra(EXTRA_HARMFUL_APP_WARNING, harmfulAppWarning);
        return intent;
    }
}

