/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.ActivityThread;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

public class HeavyWeightSwitcherActivity
extends Activity {
    public static final String KEY_INTENT = "intent";
    public static final String KEY_HAS_RESULT = "has_result";
    public static final String KEY_CUR_APP = "cur_app";
    public static final String KEY_CUR_TASK = "cur_task";
    public static final String KEY_NEW_APP = "new_app";
    IntentSender mStartIntent;
    boolean mHasResult;
    String mCurApp;
    int mCurTask;
    String mNewApp;
    private View.OnClickListener mSwitchOldListener = new View.OnClickListener(){

        @Override
        public void onClick(View v) {
            try {
                ActivityThread thread = ActivityThread.currentActivityThread();
                ActivityThread.ApplicationThread appThread = thread.getApplicationThread();
                ActivityTaskManager.getService().moveTaskToFront(appThread, HeavyWeightSwitcherActivity.this.getPackageName(), HeavyWeightSwitcherActivity.this.mCurTask, 0, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            HeavyWeightSwitcherActivity.this.finish();
        }
    };
    private View.OnClickListener mSwitchNewListener = new View.OnClickListener(){

        @Override
        public void onClick(View v) {
            try {
                ActivityManager.getService().finishHeavyWeightApp();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            try {
                if (HeavyWeightSwitcherActivity.this.mHasResult) {
                    HeavyWeightSwitcherActivity.this.startIntentSenderForResult(HeavyWeightSwitcherActivity.this.mStartIntent, -1, null, 0x2000000, 0x2000000, 0);
                } else {
                    HeavyWeightSwitcherActivity.this.startIntentSenderForResult(HeavyWeightSwitcherActivity.this.mStartIntent, -1, null, 0, 0, 0);
                }
            }
            catch (IntentSender.SendIntentException ex) {
                Log.w("HeavyWeightSwitcherActivity", "Failure starting", ex);
            }
            HeavyWeightSwitcherActivity.this.finish();
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.mStartIntent = (IntentSender)this.getIntent().getParcelableExtra(KEY_INTENT);
        this.mHasResult = this.getIntent().getBooleanExtra(KEY_HAS_RESULT, false);
        this.mCurApp = this.getIntent().getStringExtra(KEY_CUR_APP);
        this.mCurTask = this.getIntent().getIntExtra(KEY_CUR_TASK, 0);
        this.mNewApp = this.getIntent().getStringExtra(KEY_NEW_APP);
        this.setContentView(17367162);
        this.setIconAndText(16909190, 16909189, 0, this.mCurApp, this.mNewApp, 17040524, 0);
        this.setIconAndText(16909142, 16909140, 16909141, this.mNewApp, this.mCurApp, 17040465, 17040466);
        Object button = this.findViewById(16909420);
        ((View)button).setOnClickListener(this.mSwitchOldListener);
        button = this.findViewById(16909419);
        ((View)button).setOnClickListener(this.mSwitchNewListener);
    }

    void setText(int id2, CharSequence text) {
        ((TextView)this.findViewById(id2)).setText(text);
    }

    void setDrawable(int id2, Drawable dr) {
        if (dr != null) {
            ((ImageView)this.findViewById(id2)).setImageDrawable(dr);
        }
    }

    void setIconAndText(int iconId, int actionId, int descriptionId, String packageName, String otherPackageName, int actionStr, int descriptionStr) {
        CharSequence appName = packageName;
        Drawable appIcon = null;
        if (packageName != null) {
            try {
                ApplicationInfo info = this.getPackageManager().getApplicationInfo(packageName, 0);
                appName = info.loadLabel(this.getPackageManager());
                appIcon = info.loadIcon(this.getPackageManager());
            }
            catch (PackageManager.NameNotFoundException info) {
                // empty catch block
            }
        }
        this.setDrawable(iconId, appIcon);
        this.setText(actionId, this.getString(actionStr, appName));
        if (descriptionId != 0) {
            CharSequence otherAppName = otherPackageName;
            if (otherPackageName != null) {
                try {
                    ApplicationInfo info = this.getPackageManager().getApplicationInfo(otherPackageName, 0);
                    otherAppName = info.loadLabel(this.getPackageManager());
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            this.setText(descriptionId, this.getString(descriptionStr, otherAppName));
        }
    }
}

