/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.UnsupportedAppUsage;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.ActivityThread;
import android.app.VoiceInteractor;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Insets;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PatternMatcher;
import android.os.Process;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.Space;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ResolverListController;
import com.android.internal.app.SimpleIconFactory;
import com.android.internal.content.PackageMonitor;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.widget.ResolverDrawerLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ResolverActivity
extends Activity {
    boolean mEnableChooserDelegate = true;
    @UnsupportedAppUsage
    protected ResolveListAdapter mAdapter;
    private boolean mSafeForwardingMode;
    protected AbsListView mAdapterView;
    private Button mAlwaysButton;
    private Button mOnceButton;
    protected View mProfileView;
    private int mIconDpi;
    private int mLastSelected = -1;
    private boolean mResolvingHome = false;
    private int mProfileSwitchMessageId = -1;
    private int mLayoutId;
    private final ArrayList<Intent> mIntents = new ArrayList();
    private PickTargetOptionRequest mPickOptionRequest;
    private String mReferrerPackage;
    private CharSequence mTitle;
    private int mDefaultTitleResId;
    private boolean mUseLayoutForBrowsables;
    private boolean mSupportsAlwaysUseOption;
    protected ResolverDrawerLayout mResolverDrawerLayout;
    @UnsupportedAppUsage
    protected PackageManager mPm;
    protected int mLaunchedFromUid;
    private static final String TAG = "ResolverActivity";
    private static final boolean DEBUG = false;
    private Runnable mPostListReadyRunnable;
    private boolean mRegistered;
    private ColorMatrixColorFilter mSuspendedMatrixColorFilter;
    protected Insets mSystemWindowInsets = null;
    private Space mFooterSpacer = null;
    private boolean mRetainInOnStop;
    private static final String EXTRA_SHOW_FRAGMENT_ARGS = ":settings:show_fragment_args";
    private static final String EXTRA_FRAGMENT_ARG_KEY = ":settings:fragment_args_key";
    private static final String OPEN_LINKS_COMPONENT_KEY = "app_link_state";
    private final PackageMonitor mPackageMonitor = this.createPackageMonitor();

    public static int getLabelRes(String action) {
        return ActionTitle.forAction((String)action).labelRes;
    }

    protected PackageMonitor createPackageMonitor() {
        return new PackageMonitor(){

            @Override
            public void onSomePackagesChanged() {
                ResolverActivity.this.mAdapter.handlePackagesChanged();
                ResolverActivity.this.bindProfileView();
            }

            @Override
            public boolean onPackageChanged(String packageName, int uid, String[] components) {
                return true;
            }
        };
    }

    private Intent makeMyIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setComponent(null);
        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Intent intent = this.makeMyIntent();
        Set<String> categories = intent.getCategories();
        if ("android.intent.action.MAIN".equals(intent.getAction()) && categories != null && categories.size() == 1 && categories.contains("android.intent.category.HOME")) {
            this.mResolvingHome = true;
        }
        this.setSafeForwardingMode(true);
        this.onCreate(savedInstanceState, intent, null, 0, null, null, true);
    }

    @UnsupportedAppUsage
    protected void onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, Intent[] initialIntents, List<ResolveInfo> rList, boolean supportsAlwaysUseOption) {
        this.onCreate(savedInstanceState, intent, title, 0, initialIntents, rList, supportsAlwaysUseOption);
    }

    protected void onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, int defaultTitleRes, Intent[] initialIntents, List<ResolveInfo> rList, boolean supportsAlwaysUseOption) {
        this.setTheme(16974832);
        super.onCreate(savedInstanceState);
        this.setProfileSwitchMessageId(intent.getContentUserHint());
        try {
            this.mLaunchedFromUid = ActivityTaskManager.getService().getLaunchedFromUid(this.getActivityToken());
        }
        catch (RemoteException e) {
            this.mLaunchedFromUid = -1;
        }
        if (this.mLaunchedFromUid < 0 || UserHandle.isIsolated(this.mLaunchedFromUid)) {
            this.finish();
            return;
        }
        this.mPm = this.getPackageManager();
        this.mPackageMonitor.register(this, this.getMainLooper(), false);
        this.mRegistered = true;
        this.mReferrerPackage = this.getReferrerPackageName();
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        this.mIconDpi = am.getLauncherLargeIconDensity();
        this.mIntents.add(0, new Intent(intent));
        this.mTitle = title;
        this.mDefaultTitleResId = defaultTitleRes;
        this.mUseLayoutForBrowsables = this.getTargetIntent() == null ? false : this.isHttpSchemeAndViewAction(this.getTargetIntent());
        this.mSupportsAlwaysUseOption = supportsAlwaysUseOption;
        if (this.configureContentView(this.mIntents, initialIntents, rList)) {
            return;
        }
        ResolverDrawerLayout rdl = (ResolverDrawerLayout)this.findViewById(16908829);
        if (rdl != null) {
            rdl.setOnDismissedListener(new ResolverDrawerLayout.OnDismissedListener(){

                @Override
                public void onDismissed() {
                    ResolverActivity.this.finish();
                }
            });
            if (this.isVoiceInteraction()) {
                rdl.setCollapsed(false);
            }
            rdl.setSystemUiVisibility(768);
            rdl.setOnApplyWindowInsetsListener(this::onApplyWindowInsets);
            this.mResolverDrawerLayout = rdl;
        }
        this.mProfileView = this.findViewById(16909258);
        if (this.mProfileView != null) {
            this.mProfileView.setOnClickListener(this::onProfileClick);
            this.bindProfileView();
        }
        this.initSuspendedColorMatrix();
        if (this.isVoiceInteraction()) {
            this.onSetupVoiceInteraction();
        }
        Set<String> categories = intent.getCategories();
        MetricsLogger.action((Context)this, this.mAdapter.hasFilteredItem() ? 451 : 453, intent.getAction() + ":" + intent.getType() + ":" + (categories != null ? Arrays.toString(categories.toArray()) : ""));
    }

    protected void onProfileClick(View v) {
        DisplayResolveInfo dri = this.mAdapter.getOtherProfile();
        if (dri == null) {
            return;
        }
        this.mProfileSwitchMessageId = -1;
        this.onTargetSelected(dri, false);
        this.finish();
    }

    protected WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
        this.mSystemWindowInsets = insets.getSystemWindowInsets();
        this.mResolverDrawerLayout.setPadding(this.mSystemWindowInsets.left, this.mSystemWindowInsets.top, this.mSystemWindowInsets.right, 0);
        Object emptyView = this.findViewById(16908292);
        if (emptyView != null) {
            ((View)emptyView).setPadding(0, 0, 0, this.mSystemWindowInsets.bottom + this.getResources().getDimensionPixelSize(17105034) * 2);
        }
        if (this.mFooterSpacer == null) {
            this.mFooterSpacer = new Space(this.getApplicationContext());
        } else {
            ((ListView)this.mAdapterView).removeFooterView(this.mFooterSpacer);
        }
        this.mFooterSpacer.setLayoutParams(new AbsListView.LayoutParams(-1, this.mSystemWindowInsets.bottom));
        ((ListView)this.mAdapterView).addFooterView(this.mFooterSpacer);
        this.resetButtonBar();
        return insets.consumeSystemWindowInsets();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mAdapter.handlePackagesChanged();
        if (this.mSystemWindowInsets != null) {
            this.mResolverDrawerLayout.setPadding(this.mSystemWindowInsets.left, this.mSystemWindowInsets.top, this.mSystemWindowInsets.right, 0);
        }
    }

    private void initSuspendedColorMatrix() {
        int grayValue = 127;
        float scale = 0.5f;
        ColorMatrix tempBrightnessMatrix = new ColorMatrix();
        float[] mat = tempBrightnessMatrix.getArray();
        mat[0] = scale;
        mat[6] = scale;
        mat[12] = scale;
        mat[4] = grayValue;
        mat[9] = grayValue;
        mat[14] = grayValue;
        ColorMatrix matrix = new ColorMatrix();
        matrix.setSaturation(0.0f);
        matrix.preConcat(tempBrightnessMatrix);
        this.mSuspendedMatrixColorFilter = new ColorMatrixColorFilter(matrix);
    }

    public void onSetupVoiceInteraction() {
        this.sendVoiceChoicesIfNeeded();
    }

    public void sendVoiceChoicesIfNeeded() {
        if (!this.isVoiceInteraction()) {
            return;
        }
        VoiceInteractor.PickOptionRequest.Option[] options = new VoiceInteractor.PickOptionRequest.Option[this.mAdapter.getCount()];
        int N = options.length;
        for (int i = 0; i < N; ++i) {
            options[i] = this.optionForChooserTarget(this.mAdapter.getItem(i), i);
        }
        this.mPickOptionRequest = new PickTargetOptionRequest(new VoiceInteractor.Prompt(this.getTitle()), options, null);
        this.getVoiceInteractor().submitRequest(this.mPickOptionRequest);
    }

    VoiceInteractor.PickOptionRequest.Option optionForChooserTarget(TargetInfo target, int index) {
        return new VoiceInteractor.PickOptionRequest.Option(target.getDisplayLabel(), index);
    }

    protected final void setAdditionalTargets(Intent[] intents) {
        if (intents != null) {
            for (Intent intent : intents) {
                this.mIntents.add(intent);
            }
        }
    }

    public Intent getTargetIntent() {
        return this.mIntents.isEmpty() ? null : this.mIntents.get(0);
    }

    protected String getReferrerPackageName() {
        Uri referrer = this.getReferrer();
        if (referrer != null && "android-app".equals(referrer.getScheme())) {
            return referrer.getHost();
        }
        return null;
    }

    public int getLayoutResource() {
        return 17367261;
    }

    protected void bindProfileView() {
        if (this.mProfileView == null) {
            return;
        }
        DisplayResolveInfo dri = this.mAdapter.getOtherProfile();
        if (dri != null) {
            this.mProfileView.setVisibility(0);
            Object text = this.mProfileView.findViewById(16909258);
            if (!(text instanceof TextView)) {
                text = this.mProfileView.findViewById(16908308);
            }
            ((TextView)text).setText(dri.getDisplayLabel());
        } else {
            this.mProfileView.setVisibility(8);
        }
    }

    private void setProfileSwitchMessageId(int contentUserHint) {
        if (contentUserHint != -2 && contentUserHint != UserHandle.myUserId()) {
            UserManager userManager = (UserManager)this.getSystemService("user");
            UserInfo originUserInfo = userManager.getUserInfo(contentUserHint);
            boolean originIsManaged = originUserInfo != null ? originUserInfo.isManagedProfile() : false;
            boolean targetIsManaged = userManager.isManagedProfile();
            if (originIsManaged && !targetIsManaged) {
                this.mProfileSwitchMessageId = 17040045;
            } else if (!originIsManaged && targetIsManaged) {
                this.mProfileSwitchMessageId = 17040046;
            }
        }
    }

    public void setSafeForwardingMode(boolean safeForwarding) {
        this.mSafeForwardingMode = safeForwarding;
    }

    protected CharSequence getTitleForAction(Intent intent, int defaultTitleRes) {
        boolean named;
        ActionTitle title = this.mResolvingHome ? ActionTitle.HOME : ActionTitle.forAction(intent.getAction());
        boolean bl = named = this.mAdapter.getFilteredPosition() >= 0;
        if (title == ActionTitle.DEFAULT && defaultTitleRes != 0) {
            return this.getString(defaultTitleRes);
        }
        if (this.isHttpSchemeAndViewAction(intent)) {
            String dialogTitle = null;
            dialogTitle = named && !this.mUseLayoutForBrowsables ? this.getString(17041256, this.mAdapter.getFilteredItem().getDisplayLabel()) : (named && this.mUseLayoutForBrowsables ? this.getString(17041254, intent.getData().getHost(), this.mAdapter.getFilteredItem().getDisplayLabel()) : (this.mAdapter.areAllTargetsBrowsers() ? this.getString(17041255) : this.getString(17041253, intent.getData().getHost())));
            return dialogTitle;
        }
        return named ? this.getString(title.namedTitleRes, this.mAdapter.getFilteredItem().getDisplayLabel()) : this.getString(title.titleRes);
    }

    void dismiss() {
        if (!this.isFinishing()) {
            this.finish();
        }
    }

    ResolveInfoPresentationGetter makePresentationGetter(ResolveInfo ri) {
        return new ResolveInfoPresentationGetter((Context)this, this.mIconDpi, ri);
    }

    protected ActivityInfoPresentationGetter makePresentationGetter(ActivityInfo ai) {
        return new ActivityInfoPresentationGetter((Context)this, this.mIconDpi, ai);
    }

    Drawable loadIconForResolveInfo(ResolveInfo ri) {
        return this.makePresentationGetter(ri).getIcon(Process.myUserHandle());
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        if (!this.mRegistered) {
            this.mPackageMonitor.register(this, this.getMainLooper(), false);
            this.mRegistered = true;
        }
        this.mAdapter.handlePackagesChanged();
        this.bindProfileView();
    }

    @Override
    protected void onStop() {
        Intent intent;
        super.onStop();
        if (this.mRegistered) {
            this.mPackageMonitor.unregister();
            this.mRegistered = false;
        }
        if (!(((intent = this.getIntent()).getFlags() & 0x10000000) == 0 || this.isVoiceInteraction() || this.mResolvingHome || this.mRetainInOnStop || this.isChangingConfigurations())) {
            this.finish();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (!this.isChangingConfigurations() && this.mPickOptionRequest != null) {
            this.mPickOptionRequest.cancel();
        }
        if (this.mPostListReadyRunnable != null) {
            this.getMainThreadHandler().removeCallbacks(this.mPostListReadyRunnable);
            this.mPostListReadyRunnable = null;
        }
        if (this.mAdapter != null && this.mAdapter.mResolverListController != null) {
            this.mAdapter.mResolverListController.destroy();
        }
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.resetButtonBar();
    }

    private boolean isHttpSchemeAndViewAction(Intent intent) {
        return ("http".equals(intent.getScheme()) || "https".equals(intent.getScheme())) && "android.intent.action.VIEW".equals(intent.getAction());
    }

    private boolean hasManagedProfile() {
        UserManager userManager = (UserManager)this.getSystemService("user");
        if (userManager == null) {
            return false;
        }
        try {
            List<UserInfo> profiles = userManager.getProfiles(this.getUserId());
            for (UserInfo userInfo : profiles) {
                if (userInfo == null || !userInfo.isManagedProfile()) continue;
                return true;
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return false;
    }

    private boolean supportsManagedProfiles(ResolveInfo resolveInfo) {
        try {
            ApplicationInfo appInfo = this.getPackageManager().getApplicationInfo(resolveInfo.activityInfo.packageName, 0);
            return appInfo.targetSdkVersion >= 21;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private void setAlwaysButtonEnabled(boolean hasValidSelection, int checkedPos, boolean filtered) {
        boolean enabled = false;
        if (hasValidSelection) {
            ResolveInfo ri = this.mAdapter.resolveInfoForPosition(checkedPos, filtered);
            if (ri == null) {
                Log.e(TAG, "Invalid position supplied to setAlwaysButtonEnabled");
                return;
            }
            if (ri.targetUserId != -2) {
                Log.e(TAG, "Attempted to set selection to resolve info for another user");
                return;
            }
            enabled = true;
            if (this.mUseLayoutForBrowsables && !ri.handleAllWebDataURI) {
                this.mAlwaysButton.setText(this.getResources().getString(17039454));
            } else {
                this.mAlwaysButton.setText(this.getResources().getString(17039455));
            }
        }
        this.mAlwaysButton.setEnabled(enabled);
    }

    public void onButtonClick(View v) {
        int id2 = v.getId();
        int which = this.mAdapter.hasFilteredItem() ? this.mAdapter.getFilteredPosition() : this.mAdapterView.getCheckedItemPosition();
        boolean hasIndexBeenFiltered = !this.mAdapter.hasFilteredItem();
        ResolveInfo ri = this.mAdapter.resolveInfoForPosition(which, hasIndexBeenFiltered);
        if (this.mUseLayoutForBrowsables && !ri.handleAllWebDataURI && id2 == 16908779) {
            this.showSettingsForSelected(ri);
        } else {
            this.startSelected(which, id2 == 16908779, hasIndexBeenFiltered);
        }
    }

    private void showSettingsForSelected(ResolveInfo ri) {
        Intent intent = new Intent();
        String packageName = ri.activityInfo.packageName;
        Bundle showFragmentArgs = new Bundle();
        showFragmentArgs.putString(EXTRA_FRAGMENT_ARG_KEY, OPEN_LINKS_COMPONENT_KEY);
        showFragmentArgs.putString("package", packageName);
        intent.setAction("com.android.settings.APP_OPEN_BY_DEFAULT_SETTINGS").setData(Uri.fromParts("package", packageName, null)).addFlags(524288).putExtra(EXTRA_FRAGMENT_ARG_KEY, OPEN_LINKS_COMPONENT_KEY).putExtra(EXTRA_SHOW_FRAGMENT_ARGS, showFragmentArgs);
        this.startActivity(intent);
    }

    public void startSelected(int which, boolean always, boolean hasIndexBeenFiltered) {
        if (this.isFinishing()) {
            return;
        }
        ResolveInfo ri = this.mAdapter.resolveInfoForPosition(which, hasIndexBeenFiltered);
        if (this.mResolvingHome && this.hasManagedProfile() && !this.supportsManagedProfiles(ri)) {
            Toast.makeText((Context)this, String.format(this.getResources().getString(17039457), ri.activityInfo.loadLabel(this.getPackageManager()).toString()), 1).show();
            return;
        }
        TargetInfo target = this.mAdapter.targetInfoForPosition(which, hasIndexBeenFiltered);
        if (target == null) {
            return;
        }
        if (this.onTargetSelected(target, always)) {
            if (always && this.mSupportsAlwaysUseOption) {
                MetricsLogger.action(this, 455);
            } else if (this.mSupportsAlwaysUseOption) {
                MetricsLogger.action(this, 456);
            } else {
                MetricsLogger.action(this, 457);
            }
            MetricsLogger.action(this, this.mAdapter.hasFilteredItem() ? 452 : 454);
            this.finish();
        }
    }

    public Intent getReplacementIntent(ActivityInfo aInfo, Intent defIntent) {
        return defIntent;
    }

    protected boolean onTargetSelected(TargetInfo target, boolean alwaysCheck) {
        Intent intent;
        ResolveInfo ri = target.getResolveInfo();
        Intent intent2 = intent = target != null ? target.getResolvedIntent() : null;
        if (intent != null && (this.mSupportsAlwaysUseOption || this.mAdapter.hasFilteredItem()) && this.mAdapter.mUnfilteredResolveList != null) {
            String mimeType;
            Set<String> categories;
            IntentFilter filter = new IntentFilter();
            Intent filterIntent = intent.getSelector() != null ? intent.getSelector() : intent;
            String action = filterIntent.getAction();
            if (action != null) {
                filter.addAction(action);
            }
            if ((categories = filterIntent.getCategories()) != null) {
                for (String cat : categories) {
                    filter.addCategory(cat);
                }
            }
            filter.addCategory("android.intent.category.DEFAULT");
            int cat = ri.match & 0xFFF0000;
            Uri data = filterIntent.getData();
            if (cat == 0x600000 && (mimeType = filterIntent.resolveType(this)) != null) {
                try {
                    filter.addDataType(mimeType);
                }
                catch (IntentFilter.MalformedMimeTypeException e) {
                    Log.w(TAG, e);
                    filter = null;
                }
            }
            if (data != null && data.getScheme() != null && (cat != 0x600000 || !"file".equals(data.getScheme()) && !"content".equals(data.getScheme()))) {
                Iterator<IntentFilter.AuthorityEntry> aIt;
                filter.addDataScheme(data.getScheme());
                Iterator<PatternMatcher> pIt = ri.filter.schemeSpecificPartsIterator();
                if (pIt != null) {
                    String ssp = data.getSchemeSpecificPart();
                    while (ssp != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(ssp)) continue;
                        filter.addDataSchemeSpecificPart(p.getPath(), p.getType());
                        break;
                    }
                }
                if ((aIt = ri.filter.authoritiesIterator()) != null) {
                    while (aIt.hasNext()) {
                        IntentFilter.AuthorityEntry a = aIt.next();
                        if (a.match(data) < 0) continue;
                        int port = a.getPort();
                        filter.addDataAuthority(a.getHost(), port >= 0 ? Integer.toString(port) : null);
                        break;
                    }
                }
                if ((pIt = ri.filter.pathsIterator()) != null) {
                    String path = data.getPath();
                    while (path != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(path)) continue;
                        filter.addDataPath(p.getPath(), p.getType());
                        break;
                    }
                }
            }
            if (filter != null) {
                int N = this.mAdapter.mUnfilteredResolveList.size();
                boolean needToAddBackProfileForwardingComponent = this.mAdapter.mOtherProfile != null;
                ComponentName[] set = !needToAddBackProfileForwardingComponent ? new ComponentName[N] : new ComponentName[N + 1];
                int bestMatch = 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo r = this.mAdapter.mUnfilteredResolveList.get(i).getResolveInfoAt(0);
                    set[i] = new ComponentName(r.activityInfo.packageName, r.activityInfo.name);
                    if (r.match <= bestMatch) continue;
                    bestMatch = r.match;
                }
                if (needToAddBackProfileForwardingComponent) {
                    set[N] = this.mAdapter.mOtherProfile.getResolvedComponentName();
                    int otherProfileMatch = ((ResolveListAdapter)this.mAdapter).mOtherProfile.getResolveInfo().match;
                    if (otherProfileMatch > bestMatch) {
                        bestMatch = otherProfileMatch;
                    }
                }
                if (alwaysCheck) {
                    int userId = this.getUserId();
                    PackageManager pm = this.getPackageManager();
                    pm.addPreferredActivity(filter, bestMatch, set, intent.getComponent());
                    if (ri.handleAllWebDataURI) {
                        String packageName = pm.getDefaultBrowserPackageNameAsUser(userId);
                        if (TextUtils.isEmpty(packageName)) {
                            pm.setDefaultBrowserPackageNameAsUser(ri.activityInfo.packageName, userId);
                        }
                    } else {
                        boolean hasCategoryBrowsable;
                        ComponentName cn = intent.getComponent();
                        String packageName = cn.getPackageName();
                        String dataScheme = data != null ? data.getScheme() : null;
                        boolean isHttpOrHttps = dataScheme != null && (dataScheme.equals("http") || dataScheme.equals("https"));
                        boolean isViewAction = action != null && action.equals("android.intent.action.VIEW");
                        boolean bl = hasCategoryBrowsable = categories != null && categories.contains("android.intent.category.BROWSABLE");
                        if (isHttpOrHttps && isViewAction && hasCategoryBrowsable) {
                            pm.updateIntentVerificationStatusAsUser(packageName, 2, userId);
                        }
                    }
                } else {
                    try {
                        this.mAdapter.mResolverListController.setLastChosen(intent, filter, bestMatch);
                    }
                    catch (RemoteException re) {
                        Log.d(TAG, "Error calling setLastChosenActivity\n" + re);
                    }
                }
            }
        }
        if (target != null) {
            this.safelyStartActivity(target);
            if (target.isSuspended()) {
                return false;
            }
        }
        return true;
    }

    public void safelyStartActivity(TargetInfo cti) {
        StrictMode.disableDeathOnFileUriExposure();
        try {
            this.safelyStartActivityInternal(cti);
        }
        finally {
            StrictMode.enableDeathOnFileUriExposure();
        }
    }

    private void safelyStartActivityInternal(TargetInfo cti) {
        if (this.mProfileSwitchMessageId != -1) {
            Toast.makeText((Context)this, this.getString(this.mProfileSwitchMessageId), 1).show();
        }
        if (!this.mSafeForwardingMode) {
            if (cti.start(this, null)) {
                this.onActivityStarted(cti);
            }
            return;
        }
        try {
            if (cti.startAsCaller(this, null, -10000)) {
                this.onActivityStarted(cti);
            }
        }
        catch (RuntimeException e) {
            String launchedFromPackage;
            try {
                launchedFromPackage = ActivityTaskManager.getService().getLaunchedFromPackage(this.getActivityToken());
            }
            catch (RemoteException e2) {
                launchedFromPackage = "??";
            }
            Slog.wtf(TAG, "Unable to launch as uid " + this.mLaunchedFromUid + " package " + launchedFromPackage + ", while running in " + ActivityThread.currentProcessName(), e);
        }
    }

    boolean startAsCallerImpl(Intent intent, Bundle options, boolean ignoreTargetSecurity, int userId) {
        try {
            IBinder permissionToken = ActivityTaskManager.getService().requestStartActivityPermissionToken(this.getActivityToken());
            Intent chooserIntent = new Intent();
            ComponentName delegateActivity = ComponentName.unflattenFromString(Resources.getSystem().getString(17039687));
            chooserIntent.setClassName(delegateActivity.getPackageName(), delegateActivity.getClassName());
            chooserIntent.putExtra("android.app.extra.PERMISSION_TOKEN", permissionToken);
            chooserIntent.putExtra("android.intent.extra.INTENT", intent);
            chooserIntent.putExtra("android.app.extra.OPTIONS", options);
            chooserIntent.putExtra("android.app.extra.EXTRA_IGNORE_TARGET_SECURITY", ignoreTargetSecurity);
            chooserIntent.putExtra("android.intent.extra.USER_ID", userId);
            chooserIntent.addFlags(0x3000000);
            this.startActivity(chooserIntent);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString());
        }
        return true;
    }

    public void onActivityStarted(TargetInfo cti) {
    }

    public boolean shouldGetActivityMetadata() {
        return false;
    }

    public boolean shouldAutoLaunchSingleChoice(TargetInfo target) {
        return !target.isSuspended();
    }

    public void showTargetDetails(ResolveInfo ri) {
        Intent in = new Intent().setAction("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts("package", ri.activityInfo.packageName, null)).addFlags(524288);
        this.startActivity(in);
    }

    public ResolveListAdapter createAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed) {
        return new ResolveListAdapter(context, payloadIntents, initialIntents, rList, launchedFromUid, filterLastUsed, this.createListController());
    }

    @VisibleForTesting
    protected ResolverListController createListController() {
        return new ResolverListController(this, this.mPm, this.getTargetIntent(), this.getReferrerPackageName(), this.mLaunchedFromUid);
    }

    public boolean configureContentView(List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList) {
        TargetInfo target;
        this.mAdapter = this.createAdapter(this, payloadIntents, initialIntents, rList, this.mLaunchedFromUid, this.mSupportsAlwaysUseOption && !this.isVoiceInteraction());
        boolean rebuildCompleted = this.mAdapter.rebuildList();
        this.mLayoutId = this.useLayoutWithDefault() ? 17367262 : this.getLayoutResource();
        this.setContentView(this.mLayoutId);
        int count = this.mAdapter.getUnfilteredCount();
        if (rebuildCompleted && count == 1 && this.mAdapter.getOtherProfile() == null && this.shouldAutoLaunchSingleChoice(target = this.mAdapter.targetInfoForPosition(0, false))) {
            this.safelyStartActivity(target);
            this.mPackageMonitor.unregister();
            this.mRegistered = false;
            this.finish();
            return true;
        }
        this.mAdapterView = (AbsListView)this.findViewById(16909285);
        if (count == 0 && this.mAdapter.mPlaceholderCount == 0) {
            TextView emptyView = (TextView)this.findViewById(16908292);
            emptyView.setVisibility(0);
            this.mAdapterView.setVisibility(8);
        } else {
            this.mAdapterView.setVisibility(0);
            this.onPrepareAdapterView(this.mAdapterView, this.mAdapter);
        }
        return false;
    }

    public void onPrepareAdapterView(AbsListView adapterView, ResolveListAdapter adapter) {
        boolean useHeader = adapter.hasFilteredItem();
        ListView listView = adapterView instanceof ListView ? (ListView)adapterView : null;
        adapterView.setAdapter(this.mAdapter);
        ItemClickListener listener = new ItemClickListener();
        adapterView.setOnItemClickListener(listener);
        adapterView.setOnItemLongClickListener(listener);
        if (this.mSupportsAlwaysUseOption || this.mUseLayoutForBrowsables) {
            listView.setChoiceMode(1);
        }
        if (useHeader && listView != null && listView.getHeaderViewsCount() == 0) {
            listView.addHeaderView(LayoutInflater.from(this).inflate(17367260, (ViewGroup)listView, false));
        }
    }

    public void setHeader() {
        CharSequence title;
        TextView titleView;
        if (this.mAdapter.getCount() == 0 && this.mAdapter.mPlaceholderCount == 0 && (titleView = (TextView)this.findViewById(16908310)) != null) {
            titleView.setVisibility(8);
        }
        CharSequence charSequence = title = this.mTitle != null ? this.mTitle : this.getTitleForAction(this.getTargetIntent(), this.mDefaultTitleResId);
        if (!TextUtils.isEmpty(title)) {
            TextView titleView2 = (TextView)this.findViewById(16908310);
            if (titleView2 != null) {
                titleView2.setText(title);
            }
            this.setTitle(title);
        }
        ImageView iconView = (ImageView)this.findViewById(16908294);
        DisplayResolveInfo iconInfo = this.mAdapter.getFilteredItem();
        if (iconView != null && iconInfo != null) {
            new LoadIconTask(iconInfo, iconView).execute(new Void[0]);
        }
    }

    private void resetButtonBar() {
        if (!this.mSupportsAlwaysUseOption && !this.mUseLayoutForBrowsables) {
            return;
        }
        ViewGroup buttonLayout = (ViewGroup)this.findViewById(16908780);
        if (buttonLayout != null) {
            buttonLayout.setVisibility(0);
            int inset = this.mSystemWindowInsets != null ? this.mSystemWindowInsets.bottom : 0;
            buttonLayout.setPadding(buttonLayout.getPaddingLeft(), buttonLayout.getPaddingTop(), buttonLayout.getPaddingRight(), this.getResources().getDimensionPixelSize(17105396) + inset);
            this.mOnceButton = (Button)buttonLayout.findViewById(16908781);
            this.mAlwaysButton = (Button)buttonLayout.findViewById(16908779);
            this.resetAlwaysOrOnceButtonBar();
        } else {
            Log.e(TAG, "Layout unexpectedly does not have a button bar");
        }
    }

    private void resetAlwaysOrOnceButtonBar() {
        if (this.useLayoutWithDefault() && this.mAdapter.getFilteredPosition() != -1) {
            this.setAlwaysButtonEnabled(true, this.mAdapter.getFilteredPosition(), false);
            this.mOnceButton.setEnabled(true);
            return;
        }
        if (this.mAdapterView != null && this.mAdapterView.getCheckedItemPosition() != -1) {
            this.setAlwaysButtonEnabled(true, this.mAdapterView.getCheckedItemPosition(), true);
            this.mOnceButton.setEnabled(true);
        }
    }

    private boolean useLayoutWithDefault() {
        return this.mSupportsAlwaysUseOption && this.mAdapter.hasFilteredItem();
    }

    protected void setRetainInOnStop(boolean retainInOnStop) {
        this.mRetainInOnStop = retainInOnStop;
    }

    static boolean resolveInfoMatch(ResolveInfo lhs, ResolveInfo rhs) {
        return lhs == null ? rhs == null : (lhs.activityInfo == null ? rhs.activityInfo == null : Objects.equals(lhs.activityInfo.name, rhs.activityInfo.name) && Objects.equals(lhs.activityInfo.packageName, rhs.activityInfo.packageName));
    }

    List<DisplayResolveInfo> getDisplayList() {
        return this.mAdapter.mDisplayList;
    }

    static final boolean isSpecificUriMatch(int match) {
        return (match &= 0xFFF0000) >= 0x300000 && match <= 0x500000;
    }

    static class PickTargetOptionRequest
    extends VoiceInteractor.PickOptionRequest {
        public PickTargetOptionRequest(VoiceInteractor.Prompt prompt, VoiceInteractor.PickOptionRequest.Option[] options, Bundle extras) {
            super(prompt, options, extras);
        }

        @Override
        public void onCancel() {
            super.onCancel();
            ResolverActivity ra = (ResolverActivity)this.getActivity();
            if (ra != null) {
                ra.mPickOptionRequest = null;
                ra.finish();
            }
        }

        @Override
        public void onPickOptionResult(boolean finished, VoiceInteractor.PickOptionRequest.Option[] selections, Bundle result) {
            TargetInfo ti;
            super.onPickOptionResult(finished, selections, result);
            if (selections.length != 1) {
                return;
            }
            ResolverActivity ra = (ResolverActivity)this.getActivity();
            if (ra != null && ra.onTargetSelected(ti = ra.mAdapter.getItem(selections[0].getIndex()), false)) {
                ra.mPickOptionRequest = null;
                ra.finish();
            }
        }
    }

    class LoadIconTask
    extends AsyncTask<Void, Void, Drawable> {
        protected final DisplayResolveInfo mDisplayResolveInfo;
        private final ResolveInfo mResolveInfo;
        private final ImageView mTargetView;

        LoadIconTask(DisplayResolveInfo dri, ImageView target) {
            this.mDisplayResolveInfo = dri;
            this.mResolveInfo = dri.getResolveInfo();
            this.mTargetView = target;
        }

        protected Drawable doInBackground(Void ... params) {
            return ResolverActivity.this.loadIconForResolveInfo(this.mResolveInfo);
        }

        @Override
        protected void onPostExecute(Drawable d) {
            if (ResolverActivity.this.mAdapter.getOtherProfile() == this.mDisplayResolveInfo) {
                ResolverActivity.this.bindProfileView();
            } else {
                this.mDisplayResolveInfo.setDisplayIcon(d);
                this.mTargetView.setImageDrawable(d);
            }
        }
    }

    class ItemClickListener
    implements AdapterView.OnItemClickListener,
    AdapterView.OnItemLongClickListener {
        ItemClickListener() {
        }

        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            boolean hasValidSelection;
            ListView listView;
            ListView listView2 = listView = parent instanceof ListView ? (ListView)parent : null;
            if (listView != null) {
                position -= listView.getHeaderViewsCount();
            }
            if (position < 0) {
                return;
            }
            if (ResolverActivity.this.mAdapter.resolveInfoForPosition(position, true) == null) {
                return;
            }
            int checkedPos = ResolverActivity.this.mAdapterView.getCheckedItemPosition();
            boolean bl = hasValidSelection = checkedPos != -1;
            if (!(ResolverActivity.this.useLayoutWithDefault() || hasValidSelection && ResolverActivity.this.mLastSelected == checkedPos || ResolverActivity.this.mAlwaysButton == null)) {
                ResolverActivity.this.setAlwaysButtonEnabled(hasValidSelection, checkedPos, true);
                ResolverActivity.this.mOnceButton.setEnabled(hasValidSelection);
                if (hasValidSelection) {
                    ResolverActivity.this.mAdapterView.smoothScrollToPosition(checkedPos);
                }
                ResolverActivity.this.mLastSelected = checkedPos;
            } else {
                ResolverActivity.this.startSelected(position, false, true);
            }
        }

        @Override
        public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
            ListView listView;
            ListView listView2 = listView = parent instanceof ListView ? (ListView)parent : null;
            if (listView != null) {
                position -= listView.getHeaderViewsCount();
            }
            if (position < 0) {
                return false;
            }
            ResolveInfo ri = ResolverActivity.this.mAdapter.resolveInfoForPosition(position, true);
            ResolverActivity.this.showTargetDetails(ri);
            return true;
        }
    }

    static class ViewHolder {
        public View itemView;
        public Drawable defaultItemViewBackground;
        public TextView text;
        public TextView text2;
        public ImageView icon;

        public ViewHolder(View view) {
            this.itemView = view;
            this.defaultItemViewBackground = view.getBackground();
            this.text = (TextView)view.findViewById(16908308);
            this.text2 = (TextView)view.findViewById(16908309);
            this.icon = (ImageView)view.findViewById(16908294);
        }
    }

    @VisibleForTesting
    public static final class ResolvedComponentInfo {
        public final ComponentName name;
        private final List<Intent> mIntents = new ArrayList<Intent>();
        private final List<ResolveInfo> mResolveInfos = new ArrayList<ResolveInfo>();

        public ResolvedComponentInfo(ComponentName name, Intent intent, ResolveInfo info) {
            this.name = name;
            this.add(intent, info);
        }

        public void add(Intent intent, ResolveInfo info) {
            this.mIntents.add(intent);
            this.mResolveInfos.add(info);
        }

        public int getCount() {
            return this.mIntents.size();
        }

        public Intent getIntentAt(int index) {
            return index >= 0 ? this.mIntents.get(index) : null;
        }

        public ResolveInfo getResolveInfoAt(int index) {
            return index >= 0 ? this.mResolveInfos.get(index) : null;
        }

        public int findIntent(Intent intent) {
            int N = this.mIntents.size();
            for (int i = 0; i < N; ++i) {
                if (!intent.equals(this.mIntents.get(i))) continue;
                return i;
            }
            return -1;
        }

        public int findResolveInfo(ResolveInfo info) {
            int N = this.mResolveInfos.size();
            for (int i = 0; i < N; ++i) {
                if (!info.equals(this.mResolveInfos.get(i))) continue;
                return i;
            }
            return -1;
        }
    }

    public class ResolveListAdapter
    extends BaseAdapter {
        private final List<Intent> mIntents;
        private final Intent[] mInitialIntents;
        private final List<ResolveInfo> mBaseResolveList;
        protected ResolveInfo mLastChosen;
        private DisplayResolveInfo mOtherProfile;
        private ResolverListController mResolverListController;
        private int mPlaceholderCount;
        private boolean mAllTargetsAreBrowsers = false;
        protected final LayoutInflater mInflater;
        List<DisplayResolveInfo> mDisplayList;
        List<ResolvedComponentInfo> mUnfilteredResolveList;
        private int mLastChosenPosition = -1;
        private boolean mFilterLastUsed;

        public ResolveListAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed, ResolverListController resolverListController) {
            this.mIntents = payloadIntents;
            this.mInitialIntents = initialIntents;
            this.mBaseResolveList = rList;
            ResolverActivity.this.mLaunchedFromUid = launchedFromUid;
            this.mInflater = LayoutInflater.from(context);
            this.mDisplayList = new ArrayList<DisplayResolveInfo>();
            this.mFilterLastUsed = filterLastUsed;
            this.mResolverListController = resolverListController;
        }

        public void handlePackagesChanged() {
            this.rebuildList();
            if (this.getCount() == 0) {
                ResolverActivity.this.finish();
            }
        }

        public void setPlaceholderCount(int count) {
            this.mPlaceholderCount = count;
        }

        public int getPlaceholderCount() {
            return this.mPlaceholderCount;
        }

        public DisplayResolveInfo getFilteredItem() {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                return this.mDisplayList.get(this.mLastChosenPosition);
            }
            return null;
        }

        public DisplayResolveInfo getOtherProfile() {
            return this.mOtherProfile;
        }

        public int getFilteredPosition() {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                return this.mLastChosenPosition;
            }
            return -1;
        }

        public boolean hasFilteredItem() {
            return this.mFilterLastUsed && this.mLastChosen != null;
        }

        public float getScore(DisplayResolveInfo target) {
            return this.mResolverListController.getScore(target);
        }

        public void updateModel(ComponentName componentName) {
            this.mResolverListController.updateModel(componentName);
        }

        public void updateChooserCounts(String packageName, int userId, String action) {
            this.mResolverListController.updateChooserCounts(packageName, userId, action);
        }

        public boolean areAllTargetsBrowsers() {
            return this.mAllTargetsAreBrowsers;
        }

        protected boolean rebuildList() {
            int N;
            List<ResolvedComponentInfo> currentResolveList = null;
            this.mOtherProfile = null;
            this.mLastChosen = null;
            this.mLastChosenPosition = -1;
            this.mAllTargetsAreBrowsers = false;
            this.mDisplayList.clear();
            if (this.mBaseResolveList != null) {
                this.mUnfilteredResolveList = new ArrayList<ResolvedComponentInfo>();
                currentResolveList = this.mUnfilteredResolveList;
                this.mResolverListController.addResolveListDedupe(currentResolveList, ResolverActivity.this.getTargetIntent(), this.mBaseResolveList);
            } else {
                this.mUnfilteredResolveList = this.mResolverListController.getResolversForIntent(this.shouldGetResolvedFilter(), ResolverActivity.this.shouldGetActivityMetadata(), this.mIntents);
                currentResolveList = this.mUnfilteredResolveList;
                if (currentResolveList == null) {
                    this.processSortedList(currentResolveList);
                    return true;
                }
                ArrayList<ResolvedComponentInfo> originalList = this.mResolverListController.filterIneligibleActivities(currentResolveList, true);
                if (originalList != null) {
                    this.mUnfilteredResolveList = originalList;
                }
            }
            for (ResolvedComponentInfo info : currentResolveList) {
                if (info.getResolveInfoAt((int)0).targetUserId == -2) continue;
                this.mOtherProfile = new DisplayResolveInfo(info.getIntentAt(0), info.getResolveInfoAt(0), info.getResolveInfoAt(0).loadLabel(ResolverActivity.this.mPm), info.getResolveInfoAt(0).loadLabel(ResolverActivity.this.mPm), ResolverActivity.this.getReplacementIntent(info.getResolveInfoAt((int)0).activityInfo, info.getIntentAt(0)));
                currentResolveList.remove(info);
                break;
            }
            if (this.mOtherProfile == null) {
                try {
                    this.mLastChosen = this.mResolverListController.getLastChosen();
                }
                catch (RemoteException re) {
                    Log.d(ResolverActivity.TAG, "Error calling getLastChosenActivity\n" + re);
                }
            }
            if (currentResolveList != null && (N = currentResolveList.size()) > 0) {
                ArrayList<ResolvedComponentInfo> originalList = this.mResolverListController.filterLowPriority(currentResolveList, this.mUnfilteredResolveList == currentResolveList);
                if (originalList != null) {
                    this.mUnfilteredResolveList = originalList;
                }
                if (currentResolveList.size() > 1) {
                    int placeholderCount = currentResolveList.size();
                    if (ResolverActivity.this.useLayoutWithDefault()) {
                        --placeholderCount;
                    }
                    this.setPlaceholderCount(placeholderCount);
                    AsyncTask<List<ResolvedComponentInfo>, Void, List<ResolvedComponentInfo>> sortingTask = new AsyncTask<List<ResolvedComponentInfo>, Void, List<ResolvedComponentInfo>>(){

                        protected List<ResolvedComponentInfo> doInBackground(List<ResolvedComponentInfo> ... params) {
                            ResolveListAdapter.this.mResolverListController.sort(params[0]);
                            return params[0];
                        }

                        @Override
                        protected void onPostExecute(List<ResolvedComponentInfo> sortedComponents) {
                            ResolveListAdapter.this.processSortedList(sortedComponents);
                            ResolverActivity.this.bindProfileView();
                            ResolveListAdapter.this.notifyDataSetChanged();
                        }
                    };
                    sortingTask.execute(currentResolveList);
                    this.postListReadyRunnable();
                    return false;
                }
                this.processSortedList(currentResolveList);
                return true;
            }
            this.processSortedList(currentResolveList);
            return true;
        }

        private void processSortedList(List<ResolvedComponentInfo> sortedComponents) {
            int N;
            if (sortedComponents != null && (N = sortedComponents.size()) != 0) {
                this.mAllTargetsAreBrowsers = ResolverActivity.this.mUseLayoutForBrowsables;
                if (this.mInitialIntents != null) {
                    for (int i = 0; i < this.mInitialIntents.length; ++i) {
                        Intent ii = this.mInitialIntents[i];
                        if (ii == null) continue;
                        ActivityInfo ai = ii.resolveActivityInfo(ResolverActivity.this.getPackageManager(), 0);
                        if (ai == null) {
                            Log.w(ResolverActivity.TAG, "No activity found for " + ii);
                            continue;
                        }
                        ResolveInfo ri = new ResolveInfo();
                        ri.activityInfo = ai;
                        UserManager userManager = (UserManager)ResolverActivity.this.getSystemService("user");
                        if (ii instanceof LabeledIntent) {
                            LabeledIntent li = (LabeledIntent)ii;
                            ri.resolvePackageName = li.getSourcePackage();
                            ri.labelRes = li.getLabelResource();
                            ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                            ri.iconResourceId = ri.icon = li.getIconResource();
                        }
                        if (userManager.isManagedProfile()) {
                            ri.noResourceId = true;
                            ri.icon = 0;
                        }
                        this.mAllTargetsAreBrowsers &= ri.handleAllWebDataURI;
                        this.addResolveInfo(new DisplayResolveInfo(ii, ri, ri.loadLabel(ResolverActivity.this.getPackageManager()), null, ii));
                    }
                }
                for (ResolvedComponentInfo rci : sortedComponents) {
                    ResolveInfo ri = rci.getResolveInfoAt(0);
                    if (ri == null) continue;
                    this.mAllTargetsAreBrowsers &= ri.handleAllWebDataURI;
                    ResolveInfoPresentationGetter pg = ResolverActivity.this.makePresentationGetter(ri);
                    this.addResolveInfoWithAlternates(rci, pg.getSubLabel(), pg.getLabel());
                }
            }
            this.postListReadyRunnable();
        }

        private void postListReadyRunnable() {
            if (ResolverActivity.this.mPostListReadyRunnable == null) {
                ResolverActivity.this.mPostListReadyRunnable = new Runnable(){

                    @Override
                    public void run() {
                        ResolverActivity.this.setHeader();
                        ResolverActivity.this.resetButtonBar();
                        ResolveListAdapter.this.onListRebuilt();
                        ResolverActivity.this.mPostListReadyRunnable = null;
                    }
                };
                ResolverActivity.this.getMainThreadHandler().post(ResolverActivity.this.mPostListReadyRunnable);
            }
        }

        public void onListRebuilt() {
            TargetInfo target;
            int count = this.getUnfilteredCount();
            if (count == 1 && this.getOtherProfile() == null && ResolverActivity.this.shouldAutoLaunchSingleChoice(target = this.targetInfoForPosition(0, false))) {
                ResolverActivity.this.safelyStartActivity(target);
                ResolverActivity.this.finish();
            }
        }

        public boolean shouldGetResolvedFilter() {
            return this.mFilterLastUsed;
        }

        private void addResolveInfoWithAlternates(ResolvedComponentInfo rci, CharSequence extraInfo, CharSequence roLabel) {
            int count = rci.getCount();
            Intent intent = rci.getIntentAt(0);
            ResolveInfo add = rci.getResolveInfoAt(0);
            Intent replaceIntent = ResolverActivity.this.getReplacementIntent(add.activityInfo, intent);
            DisplayResolveInfo dri = new DisplayResolveInfo(intent, add, roLabel, extraInfo, replaceIntent);
            this.addResolveInfo(dri);
            if (replaceIntent == intent) {
                int N = count;
                for (int i = 1; i < N; ++i) {
                    Intent altIntent = rci.getIntentAt(i);
                    dri.addAlternateSourceIntent(altIntent);
                }
            }
            this.updateLastChosenPosition(add);
        }

        private void updateLastChosenPosition(ResolveInfo info) {
            if (this.mOtherProfile != null) {
                this.mLastChosenPosition = -1;
                return;
            }
            if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(info.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(info.activityInfo.name)) {
                this.mLastChosenPosition = this.mDisplayList.size() - 1;
            }
        }

        private void addResolveInfo(DisplayResolveInfo dri) {
            if (dri != null && dri.mResolveInfo != null && ((DisplayResolveInfo)dri).mResolveInfo.targetUserId == -2) {
                for (DisplayResolveInfo existingInfo : this.mDisplayList) {
                    if (!ResolverActivity.resolveInfoMatch(dri.mResolveInfo, existingInfo.mResolveInfo)) continue;
                    return;
                }
                this.mDisplayList.add(dri);
            }
        }

        public ResolveInfo resolveInfoForPosition(int position, boolean filtered) {
            TargetInfo target = this.targetInfoForPosition(position, filtered);
            if (target != null) {
                return target.getResolveInfo();
            }
            return null;
        }

        public TargetInfo targetInfoForPosition(int position, boolean filtered) {
            if (filtered) {
                return this.getItem(position);
            }
            if (this.mDisplayList.size() > position) {
                return this.mDisplayList.get(position);
            }
            return null;
        }

        @Override
        public int getCount() {
            int totalSize;
            int n = totalSize = this.mDisplayList == null || this.mDisplayList.isEmpty() ? this.mPlaceholderCount : this.mDisplayList.size();
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                --totalSize;
            }
            return totalSize;
        }

        public int getUnfilteredCount() {
            return this.mDisplayList.size();
        }

        @Override
        public TargetInfo getItem(int position) {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0 && position >= this.mLastChosenPosition) {
                ++position;
            }
            if (this.mDisplayList.size() > position) {
                return this.mDisplayList.get(position);
            }
            return null;
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        public int getDisplayResolveInfoCount() {
            return this.mDisplayList.size();
        }

        public DisplayResolveInfo getDisplayResolveInfo(int index) {
            return this.mDisplayList.get(index);
        }

        @Override
        public final View getView(int position, View convertView, ViewGroup parent) {
            View view = convertView;
            if (view == null) {
                view = this.createView(parent);
            }
            this.onBindView(view, this.getItem(position));
            return view;
        }

        public final View createView(ViewGroup parent) {
            View view = this.onCreateView(parent);
            ViewHolder holder = new ViewHolder(view);
            view.setTag(holder);
            return view;
        }

        public View onCreateView(ViewGroup parent) {
            return this.mInflater.inflate(17367259, parent, false);
        }

        public final void bindView(int position, View view) {
            this.onBindView(view, this.getItem(position));
        }

        protected void onBindView(View view, TargetInfo info) {
            CharSequence subLabel;
            ViewHolder holder = (ViewHolder)view.getTag();
            if (info == null) {
                holder.icon.setImageDrawable(ResolverActivity.this.getDrawable(17303382));
                return;
            }
            CharSequence label = info.getDisplayLabel();
            if (!TextUtils.equals(holder.text.getText(), label)) {
                holder.text.setText(info.getDisplayLabel());
            }
            if (TextUtils.equals(label, subLabel = info.getExtendedInfo())) {
                subLabel = null;
            }
            if (!TextUtils.equals(holder.text2.getText(), subLabel)) {
                holder.text2.setText(subLabel);
            }
            if (info.isSuspended()) {
                holder.icon.setColorFilter(ResolverActivity.this.mSuspendedMatrixColorFilter);
            } else {
                holder.icon.setColorFilter(null);
            }
            if (info instanceof DisplayResolveInfo && !((DisplayResolveInfo)info).hasDisplayIcon()) {
                new LoadIconTask((DisplayResolveInfo)info, holder.icon).execute(new Void[0]);
            } else {
                holder.icon.setImageDrawable(info.getDisplayIcon());
            }
        }
    }

    public static interface TargetInfo {
        public Intent getResolvedIntent();

        public ComponentName getResolvedComponentName();

        public boolean start(Activity var1, Bundle var2);

        public boolean startAsCaller(ResolverActivity var1, Bundle var2, int var3);

        public boolean startAsUser(Activity var1, Bundle var2, UserHandle var3);

        public ResolveInfo getResolveInfo();

        public CharSequence getDisplayLabel();

        public CharSequence getExtendedInfo();

        public Drawable getDisplayIcon();

        public TargetInfo cloneFilledIn(Intent var1, int var2);

        public List<Intent> getAllSourceIntents();

        public boolean isSuspended();
    }

    public final class DisplayResolveInfo
    implements TargetInfo {
        private final ResolveInfo mResolveInfo;
        private final CharSequence mDisplayLabel;
        private Drawable mDisplayIcon;
        private Drawable mBadge;
        private final CharSequence mExtendedInfo;
        private final Intent mResolvedIntent;
        private final List<Intent> mSourceIntents = new ArrayList<Intent>();
        private boolean mIsSuspended;

        public DisplayResolveInfo(Intent originalIntent, ResolveInfo pri, CharSequence pLabel, CharSequence pInfo, Intent pOrigIntent) {
            this.mSourceIntents.add(originalIntent);
            this.mResolveInfo = pri;
            this.mDisplayLabel = pLabel;
            this.mExtendedInfo = pInfo;
            Intent intent = new Intent(pOrigIntent != null ? pOrigIntent : ResolverActivity.this.getReplacementIntent(pri.activityInfo, ResolverActivity.this.getTargetIntent()));
            intent.addFlags(0x3000000);
            ActivityInfo ai = this.mResolveInfo.activityInfo;
            intent.setComponent(new ComponentName(ai.applicationInfo.packageName, ai.name));
            this.mIsSuspended = (ai.applicationInfo.flags & 0x40000000) != 0;
            this.mResolvedIntent = intent;
        }

        private DisplayResolveInfo(DisplayResolveInfo other, Intent fillInIntent, int flags) {
            this.mSourceIntents.addAll(other.getAllSourceIntents());
            this.mResolveInfo = other.mResolveInfo;
            this.mDisplayLabel = other.mDisplayLabel;
            this.mDisplayIcon = other.mDisplayIcon;
            this.mExtendedInfo = other.mExtendedInfo;
            this.mResolvedIntent = new Intent(other.mResolvedIntent);
            this.mResolvedIntent.fillIn(fillInIntent, flags);
        }

        @Override
        public ResolveInfo getResolveInfo() {
            return this.mResolveInfo;
        }

        @Override
        public CharSequence getDisplayLabel() {
            return this.mDisplayLabel;
        }

        @Override
        public Drawable getDisplayIcon() {
            return this.mDisplayIcon;
        }

        @Override
        public TargetInfo cloneFilledIn(Intent fillInIntent, int flags) {
            return new DisplayResolveInfo(this, fillInIntent, flags);
        }

        @Override
        public List<Intent> getAllSourceIntents() {
            return this.mSourceIntents;
        }

        public void addAlternateSourceIntent(Intent alt) {
            this.mSourceIntents.add(alt);
        }

        public void setDisplayIcon(Drawable icon) {
            this.mDisplayIcon = icon;
        }

        public boolean hasDisplayIcon() {
            return this.mDisplayIcon != null;
        }

        @Override
        public CharSequence getExtendedInfo() {
            return this.mExtendedInfo;
        }

        @Override
        public Intent getResolvedIntent() {
            return this.mResolvedIntent;
        }

        @Override
        public ComponentName getResolvedComponentName() {
            return new ComponentName(this.mResolveInfo.activityInfo.packageName, this.mResolveInfo.activityInfo.name);
        }

        @Override
        public boolean start(Activity activity, Bundle options) {
            activity.startActivity(this.mResolvedIntent, options);
            return true;
        }

        @Override
        public boolean startAsCaller(ResolverActivity activity, Bundle options, int userId) {
            if (ResolverActivity.this.mEnableChooserDelegate) {
                return activity.startAsCallerImpl(this.mResolvedIntent, options, false, userId);
            }
            activity.startActivityAsCaller(this.mResolvedIntent, options, null, false, userId);
            return true;
        }

        @Override
        public boolean startAsUser(Activity activity, Bundle options, UserHandle user) {
            activity.startActivityAsUser(this.mResolvedIntent, options, user);
            return false;
        }

        @Override
        public boolean isSuspended() {
            return this.mIsSuspended;
        }
    }

    @VisibleForTesting
    public static class ActivityInfoPresentationGetter
    extends TargetPresentationGetter {
        private final ActivityInfo mActivityInfo;

        public ActivityInfoPresentationGetter(Context ctx, int iconDpi, ActivityInfo activityInfo) {
            super(ctx, iconDpi, activityInfo.applicationInfo);
            this.mActivityInfo = activityInfo;
        }

        @Override
        Drawable getIconSubstituteInternal() {
            Drawable dr = null;
            try {
                if (this.mActivityInfo.icon != 0) {
                    dr = this.loadIconFromResource(this.mPm.getResourcesForApplication(this.mActivityInfo.applicationInfo), this.mActivityInfo.icon);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(ResolverActivity.TAG, "SUBSTITUTE_SHARE_TARGET_APP_NAME_AND_ICON permission granted but couldn't find resources for package", e);
            }
            return dr;
        }

        @Override
        String getAppSubLabelInternal() {
            return (String)this.mActivityInfo.loadLabel(this.mPm);
        }
    }

    @VisibleForTesting
    public static class ResolveInfoPresentationGetter
    extends ActivityInfoPresentationGetter {
        private final ResolveInfo mRi;

        public ResolveInfoPresentationGetter(Context ctx, int iconDpi, ResolveInfo ri) {
            super(ctx, iconDpi, ri.activityInfo);
            this.mRi = ri;
        }

        @Override
        Drawable getIconSubstituteInternal() {
            Drawable dr = null;
            try {
                if (this.mRi.resolvePackageName != null && this.mRi.icon != 0) {
                    dr = this.loadIconFromResource(this.mPm.getResourcesForApplication(this.mRi.resolvePackageName), this.mRi.icon);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(ResolverActivity.TAG, "SUBSTITUTE_SHARE_TARGET_APP_NAME_AND_ICON permission granted but couldn't find resources for package", e);
            }
            if (dr == null) {
                dr = super.getIconSubstituteInternal();
            }
            return dr;
        }

        @Override
        String getAppSubLabelInternal() {
            return (String)this.mRi.loadLabel(this.mPm);
        }
    }

    private static abstract class TargetPresentationGetter {
        private Context mCtx;
        private final int mIconDpi;
        private final boolean mHasSubstitutePermission;
        private final ApplicationInfo mAi;
        protected PackageManager mPm;

        abstract Drawable getIconSubstituteInternal();

        abstract String getAppSubLabelInternal();

        TargetPresentationGetter(Context ctx, int iconDpi, ApplicationInfo ai) {
            this.mCtx = ctx;
            this.mPm = ctx.getPackageManager();
            this.mAi = ai;
            this.mIconDpi = iconDpi;
            this.mHasSubstitutePermission = 0 == this.mPm.checkPermission("android.permission.SUBSTITUTE_SHARE_TARGET_APP_NAME_AND_ICON", this.mAi.packageName);
        }

        public Drawable getIcon(UserHandle userHandle) {
            return new BitmapDrawable(this.mCtx.getResources(), this.getIconBitmap(userHandle));
        }

        public Bitmap getIconBitmap(UserHandle userHandle) {
            Drawable dr = null;
            if (this.mHasSubstitutePermission) {
                dr = this.getIconSubstituteInternal();
            }
            if (dr == null) {
                try {
                    if (this.mAi.icon != 0) {
                        dr = this.loadIconFromResource(this.mPm.getResourcesForApplication(this.mAi), this.mAi.icon);
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if (dr == null) {
                dr = this.mAi.loadIcon(this.mPm);
            }
            SimpleIconFactory sif = SimpleIconFactory.obtain(this.mCtx);
            Bitmap icon = sif.createUserBadgedIconBitmap(dr, userHandle);
            sif.recycle();
            return icon;
        }

        public String getLabel() {
            String label = null;
            if (this.mHasSubstitutePermission) {
                label = this.getAppSubLabelInternal();
            }
            if (label == null) {
                label = (String)this.mAi.loadLabel(this.mPm);
            }
            return label;
        }

        public String getSubLabel() {
            if (this.mHasSubstitutePermission) {
                return null;
            }
            return this.getAppSubLabelInternal();
        }

        protected String loadLabelFromResource(Resources res, int resId) {
            return res.getString(resId);
        }

        protected Drawable loadIconFromResource(Resources res, int resId) {
            return res.getDrawableForDensity(resId, this.mIconDpi);
        }
    }

    private static enum ActionTitle {
        VIEW("android.intent.action.VIEW", 17041263, 17041265, 17041264),
        EDIT("android.intent.action.EDIT", 17041243, 17041245, 17041244),
        SEND("android.intent.action.SEND", 17041257, 17041259, 17041258),
        SENDTO("android.intent.action.SENDTO", 17041260, 17041262, 17041261),
        SEND_MULTIPLE("android.intent.action.SEND_MULTIPLE", 17041257, 17041259, 17041258),
        CAPTURE_IMAGE("android.media.action.IMAGE_CAPTURE", 17041250, 17041252, 17041251),
        DEFAULT(null, 17041240, 17041242, 17041241),
        HOME("android.intent.action.MAIN", 17041247, 17041249, 17041248);

        public static final int BROWSABLE_TITLE_RES = 17041255;
        public static final int BROWSABLE_HOST_TITLE_RES = 17041253;
        public static final int BROWSABLE_HOST_APP_TITLE_RES = 17041254;
        public static final int BROWSABLE_APP_TITLE_RES = 17041256;
        public final String action;
        public final int titleRes;
        public final int namedTitleRes;
        public final int labelRes;

        private ActionTitle(String action, int titleRes, int namedTitleRes, int labelRes) {
            this.action = action;
            this.titleRes = titleRes;
            this.namedTitleRes = namedTitleRes;
            this.labelRes = labelRes;
        }

        public static ActionTitle forAction(String action) {
            for (ActionTitle title : ActionTitle.values()) {
                if (title == HOME || action == null || !action.equals(title.action)) continue;
                return title;
            }
            return DEFAULT;
        }
    }
}

