/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.os.UserHandle;
import android.util.AttributeSet;
import android.util.Pools;
import java.nio.ByteBuffer;
import org.xmlpull.v1.XmlPullParser;

@Deprecated
public class SimpleIconFactory {
    private static final Pools.SynchronizedPool<SimpleIconFactory> sPool = new Pools.SynchronizedPool(Runtime.getRuntime().availableProcessors());
    private static final int DEFAULT_WRAPPER_BACKGROUND = -1;
    private static final float BLUR_FACTOR = 0.010416667f;
    private Context mContext;
    private Canvas mCanvas;
    private PackageManager mPm;
    private int mFillResIconDpi;
    private int mIconBitmapSize;
    private int mBadgeBitmapSize;
    private int mWrapperBackgroundColor;
    private Drawable mWrapperIcon;
    private final Rect mOldBounds = new Rect();
    private static final float SCALE_NOT_INITIALIZED = 0.0f;
    private static final float MAX_SQUARE_AREA_FACTOR = 0.6510417f;
    private static final float MAX_CIRCLE_AREA_FACTOR = 0.6597222f;
    private static final float CIRCLE_AREA_BY_RECT = 0.7853982f;
    private static final float LINEAR_SCALE_SLOPE = 0.040449437f;
    private static final int MIN_VISIBLE_ALPHA = 40;
    private float mAdaptiveIconScale;
    private final Rect mAdaptiveIconBounds;
    private final Rect mBounds;
    private final int mMaxSize;
    private final byte[] mPixels;
    private final float[] mLeftBorder;
    private final float[] mRightBorder;
    private final Bitmap mBitmap;
    private final Canvas mScaleCheckCanvas;
    private static final float KEY_SHADOW_DISTANCE = 0.020833334f;
    private static final int KEY_SHADOW_ALPHA = 61;
    private static final int AMBIENT_SHADOW_ALPHA = 30;
    private Paint mBlurPaint = new Paint(3);
    private Paint mDrawPaint = new Paint(3);
    private BlurMaskFilter mDefaultBlurMaskFilter;

    @Deprecated
    public static SimpleIconFactory obtain(Context ctx) {
        SimpleIconFactory instance = sPool.acquire();
        if (instance == null) {
            ActivityManager am = (ActivityManager)ctx.getSystemService("activity");
            int iconDpi = am == null ? 0 : am.getLauncherLargeIconDensity();
            Resources r = ctx.getResources();
            int iconSize = r.getDimensionPixelSize(17105397);
            int badgeSize = r.getDimensionPixelSize(17105395);
            instance = new SimpleIconFactory(ctx, iconDpi, iconSize, badgeSize);
            instance.setWrapperBackgroundColor(-1);
        }
        return instance;
    }

    @Deprecated
    public void recycle() {
        this.setWrapperBackgroundColor(-1);
        sPool.release(this);
    }

    @Deprecated
    private SimpleIconFactory(Context context, int fillResIconDpi, int iconBitmapSize, int badgeBitmapSize) {
        this.mContext = context.getApplicationContext();
        this.mPm = this.mContext.getPackageManager();
        this.mIconBitmapSize = iconBitmapSize;
        this.mBadgeBitmapSize = badgeBitmapSize;
        this.mFillResIconDpi = fillResIconDpi;
        this.mCanvas = new Canvas();
        this.mCanvas.setDrawFilter(new PaintFlagsDrawFilter(4, 2));
        this.mMaxSize = iconBitmapSize * 2;
        this.mBitmap = Bitmap.createBitmap(this.mMaxSize, this.mMaxSize, Bitmap.Config.ALPHA_8);
        this.mScaleCheckCanvas = new Canvas(this.mBitmap);
        this.mPixels = new byte[this.mMaxSize * this.mMaxSize];
        this.mLeftBorder = new float[this.mMaxSize];
        this.mRightBorder = new float[this.mMaxSize];
        this.mBounds = new Rect();
        this.mAdaptiveIconBounds = new Rect();
        this.mAdaptiveIconScale = 0.0f;
        this.mDefaultBlurMaskFilter = new BlurMaskFilter((float)iconBitmapSize * 0.010416667f, BlurMaskFilter.Blur.NORMAL);
    }

    @Deprecated
    void setWrapperBackgroundColor(int color2) {
        this.mWrapperBackgroundColor = Color.alpha(color2) < 255 ? -1 : color2;
    }

    @Deprecated
    Bitmap createUserBadgedIconBitmap(Drawable icon, UserHandle user) {
        FixedSizeBitmapDrawable drawable2;
        Drawable badged;
        float[] scale = new float[1];
        if (icon == null) {
            icon = SimpleIconFactory.getFullResDefaultActivityIcon(this.mFillResIconDpi);
        }
        icon = this.normalizeAndWrapToAdaptiveIcon(icon, null, scale);
        Bitmap bitmap = this.createIconBitmap(icon, scale[0]);
        if (icon instanceof AdaptiveIconDrawable) {
            this.mCanvas.setBitmap(bitmap);
            this.recreateIcon(Bitmap.createBitmap(bitmap), this.mCanvas);
            this.mCanvas.setBitmap(null);
        }
        Bitmap result = user != null ? ((badged = this.mPm.getUserBadgedIcon(drawable2 = new FixedSizeBitmapDrawable(bitmap), user)) instanceof BitmapDrawable ? ((BitmapDrawable)badged).getBitmap() : this.createIconBitmap(badged, 1.0f)) : bitmap;
        return result;
    }

    @Deprecated
    Bitmap createAppBadgedIconBitmap(Drawable icon, Bitmap renderedAppIcon) {
        if (icon == null) {
            icon = SimpleIconFactory.getFullResDefaultActivityIcon(this.mFillResIconDpi);
        }
        int w = icon.getIntrinsicWidth();
        int h = icon.getIntrinsicHeight();
        float scale = 1.0f;
        if (h > w && w > 0) {
            scale = (float)h / (float)w;
        } else if (w > h && h > 0) {
            scale = (float)w / (float)h;
        }
        Bitmap bitmap = this.createIconBitmap(icon, scale);
        bitmap = this.maskBitmapToCircle(bitmap);
        icon = new BitmapDrawable(this.mContext.getResources(), bitmap);
        scale = this.getScale(icon, null);
        bitmap = this.createIconBitmap(icon, scale);
        this.mCanvas.setBitmap(bitmap);
        this.recreateIcon(Bitmap.createBitmap(bitmap), this.mCanvas);
        if (renderedAppIcon != null) {
            renderedAppIcon = Bitmap.createScaledBitmap(renderedAppIcon, this.mBadgeBitmapSize, this.mBadgeBitmapSize, false);
            this.mCanvas.drawBitmap(renderedAppIcon, this.mIconBitmapSize - this.mBadgeBitmapSize, this.mIconBitmapSize - this.mBadgeBitmapSize, null);
        }
        this.mCanvas.setBitmap(null);
        return bitmap;
    }

    private Bitmap maskBitmapToCircle(Bitmap bitmap) {
        Bitmap output = Bitmap.createBitmap(bitmap.getWidth(), bitmap.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(-1);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle((float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f, (float)bitmap.getWidth() / 2.0f - 1.0f, paint);
        paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    private static Drawable getFullResDefaultActivityIcon(int iconDpi) {
        return Resources.getSystem().getDrawableForDensity(0x10D0000, iconDpi);
    }

    private Bitmap createIconBitmap(Drawable icon, float scale) {
        return this.createIconBitmap(icon, scale, this.mIconBitmapSize);
    }

    private Bitmap createIconBitmap(Drawable icon, float scale, int size) {
        Bitmap bitmap = Bitmap.createBitmap(size, size, Bitmap.Config.ARGB_8888);
        this.mCanvas.setBitmap(bitmap);
        this.mOldBounds.set(icon.getBounds());
        if (icon instanceof AdaptiveIconDrawable) {
            int offset = Math.max((int)Math.ceil(0.010416667f * (float)size), Math.round((float)size * (1.0f - scale) / 2.0f));
            icon.setBounds(offset, offset, size - offset, size - offset);
            icon.draw(this.mCanvas);
        } else {
            if (icon instanceof BitmapDrawable) {
                BitmapDrawable bitmapDrawable = (BitmapDrawable)icon;
                Bitmap b = bitmapDrawable.getBitmap();
                if (bitmap != null && b.getDensity() == 0) {
                    bitmapDrawable.setTargetDensity(this.mContext.getResources().getDisplayMetrics());
                }
            }
            int width = size;
            int height = size;
            int intrinsicWidth = icon.getIntrinsicWidth();
            int intrinsicHeight = icon.getIntrinsicHeight();
            if (intrinsicWidth > 0 && intrinsicHeight > 0) {
                float ratio = (float)intrinsicWidth / (float)intrinsicHeight;
                if (intrinsicWidth > intrinsicHeight) {
                    height = (int)((float)width / ratio);
                } else if (intrinsicHeight > intrinsicWidth) {
                    width = (int)((float)height * ratio);
                }
            }
            int left = (size - width) / 2;
            int top = (size - height) / 2;
            icon.setBounds(left, top, left + width, top + height);
            this.mCanvas.save();
            this.mCanvas.scale(scale, scale, size / 2, size / 2);
            icon.draw(this.mCanvas);
            this.mCanvas.restore();
        }
        icon.setBounds(this.mOldBounds);
        this.mCanvas.setBitmap(null);
        return bitmap;
    }

    private Drawable normalizeAndWrapToAdaptiveIcon(Drawable icon, RectF outIconBounds, float[] outScale) {
        float scale = 1.0f;
        if (this.mWrapperIcon == null) {
            this.mWrapperIcon = this.mContext.getDrawable(17302853).mutate();
        }
        AdaptiveIconDrawable dr = (AdaptiveIconDrawable)this.mWrapperIcon;
        dr.setBounds(0, 0, 1, 1);
        scale = this.getScale(icon, outIconBounds);
        if (!(icon instanceof AdaptiveIconDrawable)) {
            FixedScaleDrawable fsd = (FixedScaleDrawable)dr.getForeground();
            fsd.setDrawable(icon);
            fsd.setScale(scale);
            icon = dr;
            scale = this.getScale(icon, outIconBounds);
            ((ColorDrawable)dr.getBackground()).setColor(this.mWrapperBackgroundColor);
        }
        outScale[0] = scale;
        return icon;
    }

    private synchronized float getScale(Drawable d, RectF outBounds) {
        float areaScale;
        float scale;
        if (d instanceof AdaptiveIconDrawable && this.mAdaptiveIconScale != 0.0f) {
            if (outBounds != null) {
                outBounds.set(this.mAdaptiveIconBounds);
            }
            return this.mAdaptiveIconScale;
        }
        int width = d.getIntrinsicWidth();
        int height = d.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            width = width <= 0 || width > this.mMaxSize ? this.mMaxSize : width;
            height = height <= 0 || height > this.mMaxSize ? this.mMaxSize : height;
        } else if (width > this.mMaxSize || height > this.mMaxSize) {
            int max = Math.max(width, height);
            width = this.mMaxSize * width / max;
            height = this.mMaxSize * height / max;
        }
        this.mBitmap.eraseColor(0);
        d.setBounds(0, 0, width, height);
        d.draw(this.mScaleCheckCanvas);
        ByteBuffer buffer = ByteBuffer.wrap(this.mPixels);
        buffer.rewind();
        this.mBitmap.copyPixelsToBuffer(buffer);
        int topY = -1;
        int bottomY = -1;
        int leftX = this.mMaxSize + 1;
        int rightX = -1;
        int index = 0;
        int rowSizeDiff = this.mMaxSize - width;
        for (int y = 0; y < height; ++y) {
            int lastX = -1;
            int firstX = -1;
            for (int x = 0; x < width; ++x) {
                if ((this.mPixels[index] & 0xFF) > 40) {
                    if (firstX == -1) {
                        firstX = x;
                    }
                    lastX = x;
                }
                ++index;
            }
            index += rowSizeDiff;
            this.mLeftBorder[y] = firstX;
            this.mRightBorder[y] = lastX;
            if (firstX == -1) continue;
            bottomY = y;
            if (topY == -1) {
                topY = y;
            }
            leftX = Math.min(leftX, firstX);
            rightX = Math.max(rightX, lastX);
        }
        if (topY == -1 || rightX == -1) {
            return 1.0f;
        }
        SimpleIconFactory.convertToConvexArray(this.mLeftBorder, 1, topY, bottomY);
        SimpleIconFactory.convertToConvexArray(this.mRightBorder, -1, topY, bottomY);
        float area = 0.0f;
        for (int y = 0; y < height; ++y) {
            if (this.mLeftBorder[y] <= -1.0f) continue;
            area += this.mRightBorder[y] - this.mLeftBorder[y] + 1.0f;
        }
        float rectArea = (bottomY + 1 - topY) * (rightX + 1 - leftX);
        float hullByRect = area / rectArea;
        float scaleRequired = hullByRect < 0.7853982f ? 0.6597222f : 0.6510417f + 0.040449437f * (1.0f - hullByRect);
        this.mBounds.left = leftX;
        this.mBounds.right = rightX;
        this.mBounds.top = topY;
        this.mBounds.bottom = bottomY;
        if (outBounds != null) {
            outBounds.set((float)this.mBounds.left / (float)width, (float)this.mBounds.top / (float)height, 1.0f - (float)this.mBounds.right / (float)width, 1.0f - (float)this.mBounds.bottom / (float)height);
        }
        float f = scale = (areaScale = area / (float)(width * height)) > scaleRequired ? (float)Math.sqrt(scaleRequired / areaScale) : 1.0f;
        if (d instanceof AdaptiveIconDrawable && this.mAdaptiveIconScale == 0.0f) {
            this.mAdaptiveIconScale = scale;
            this.mAdaptiveIconBounds.set(this.mBounds);
        }
        return scale;
    }

    private static void convertToConvexArray(float[] xCoordinates, int direction, int topY, int bottomY) {
        int total = xCoordinates.length;
        float[] angles = new float[total - 1];
        int first = topY;
        int last = -1;
        float lastAngle = Float.MAX_VALUE;
        for (int i = topY + 1; i <= bottomY; ++i) {
            int start;
            if (xCoordinates[i] <= -1.0f) continue;
            if (lastAngle == Float.MAX_VALUE) {
                start = first;
            } else {
                float currentAngle = (xCoordinates[i] - xCoordinates[last]) / (float)(i - last);
                start = last;
                if ((currentAngle - lastAngle) * (float)direction < 0.0f) {
                    while (start > first && !(((currentAngle = (xCoordinates[i] - xCoordinates[--start]) / (float)(i - start)) - angles[start]) * (float)direction >= 0.0f)) {
                    }
                }
            }
            lastAngle = (xCoordinates[i] - xCoordinates[start]) / (float)(i - start);
            for (int j = start; j < i; ++j) {
                angles[j] = lastAngle;
                xCoordinates[j] = xCoordinates[start] + lastAngle * (float)(j - start);
            }
            last = i;
        }
    }

    private synchronized void recreateIcon(Bitmap icon, Canvas out) {
        this.recreateIcon(icon, this.mDefaultBlurMaskFilter, 30, 61, out);
    }

    private synchronized void recreateIcon(Bitmap icon, BlurMaskFilter blurMaskFilter, int ambientAlpha, int keyAlpha, Canvas out) {
        int[] offset = new int[2];
        this.mBlurPaint.setMaskFilter(blurMaskFilter);
        Bitmap shadow = icon.extractAlpha(this.mBlurPaint, offset);
        this.mDrawPaint.setAlpha(ambientAlpha);
        out.drawBitmap(shadow, offset[0], offset[1], this.mDrawPaint);
        this.mDrawPaint.setAlpha(keyAlpha);
        out.drawBitmap(shadow, offset[0], (float)offset[1] + 0.020833334f * (float)this.mIconBitmapSize, this.mDrawPaint);
        this.mDrawPaint.setAlpha(255);
        out.drawBitmap(icon, 0.0f, 0.0f, this.mDrawPaint);
    }

    private static class FixedSizeBitmapDrawable
    extends BitmapDrawable {
        FixedSizeBitmapDrawable(Bitmap bitmap) {
            super(null, bitmap);
        }

        @Override
        public int getIntrinsicHeight() {
            return this.getBitmap().getWidth();
        }

        @Override
        public int getIntrinsicWidth() {
            return this.getBitmap().getWidth();
        }
    }

    public static class FixedScaleDrawable
    extends DrawableWrapper {
        private static final float LEGACY_ICON_SCALE = 0.46669f;
        private float mScaleX = 0.46669f;
        private float mScaleY = 0.46669f;

        public FixedScaleDrawable() {
            super(new ColorDrawable());
        }

        @Override
        public void draw(Canvas canvas) {
            int saveCount = canvas.save();
            canvas.scale(this.mScaleX, this.mScaleY, this.getBounds().exactCenterX(), this.getBounds().exactCenterY());
            super.draw(canvas);
            canvas.restoreToCount(saveCount);
        }

        @Override
        public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) {
        }

        @Override
        public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) {
        }

        public void setScale(float scale) {
            float h = this.getIntrinsicHeight();
            float w = this.getIntrinsicWidth();
            this.mScaleX = scale * 0.46669f;
            this.mScaleY = scale * 0.46669f;
            if (h > w && w > 0.0f) {
                this.mScaleX *= w / h;
            } else if (w > h && h > 0.0f) {
                this.mScaleY *= h / w;
            }
        }
    }
}

