/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.SuspendDialogInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class SuspendedAppActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    private static final String TAG = SuspendedAppActivity.class.getSimpleName();
    private static final String PACKAGE_NAME = "com.android.internal.app";
    public static final String EXTRA_SUSPENDED_PACKAGE = "com.android.internal.app.extra.SUSPENDED_PACKAGE";
    public static final String EXTRA_SUSPENDING_PACKAGE = "com.android.internal.app.extra.SUSPENDING_PACKAGE";
    public static final String EXTRA_DIALOG_INFO = "com.android.internal.app.extra.DIALOG_INFO";
    private Intent mMoreDetailsIntent;
    private int mUserId;
    private PackageManager mPm;
    private Resources mSuspendingAppResources;
    private SuspendDialogInfo mSuppliedDialogInfo;

    private CharSequence getAppLabel(String packageName) {
        try {
            return this.mPm.getApplicationInfoAsUser(packageName, 0, this.mUserId).loadLabel(this.mPm);
        }
        catch (PackageManager.NameNotFoundException ne) {
            Slog.e(TAG, "Package " + packageName + " not found", ne);
            return packageName;
        }
    }

    private Intent getMoreDetailsActivity(String suspendingPackage, String suspendedPackage, int userId) {
        Intent moreDetailsIntent = new Intent("android.intent.action.SHOW_SUSPENDED_APP_DETAILS").setPackage(suspendingPackage);
        String requiredPermission = "android.permission.SEND_SHOW_SUSPENDED_APP_DETAILS";
        ResolveInfo resolvedInfo = this.mPm.resolveActivityAsUser(moreDetailsIntent, 0, userId);
        if (resolvedInfo != null && resolvedInfo.activityInfo != null && "android.permission.SEND_SHOW_SUSPENDED_APP_DETAILS".equals(resolvedInfo.activityInfo.permission)) {
            moreDetailsIntent.putExtra("android.intent.extra.PACKAGE_NAME", suspendedPackage).setFlags(0x14000000);
            return moreDetailsIntent;
        }
        return null;
    }

    private Drawable resolveIcon() {
        int iconId;
        int n = iconId = this.mSuppliedDialogInfo != null ? this.mSuppliedDialogInfo.getIconResId() : 0;
        if (iconId != 0 && this.mSuspendingAppResources != null) {
            try {
                return this.mSuspendingAppResources.getDrawable(iconId, this.getTheme());
            }
            catch (Resources.NotFoundException nfe) {
                Slog.e(TAG, "Could not resolve drawable resource id " + iconId);
            }
        }
        return null;
    }

    private String resolveTitle() {
        int titleId;
        int n = titleId = this.mSuppliedDialogInfo != null ? this.mSuppliedDialogInfo.getTitleResId() : 0;
        if (titleId != 0 && this.mSuspendingAppResources != null) {
            try {
                return this.mSuspendingAppResources.getString(titleId);
            }
            catch (Resources.NotFoundException nfe) {
                Slog.e(TAG, "Could not resolve string resource id " + titleId);
            }
        }
        return this.getString(17039516);
    }

    private String resolveDialogMessage(String suspendingPkg, String suspendedPkg) {
        CharSequence suspendedAppLabel = this.getAppLabel(suspendedPkg);
        if (this.mSuppliedDialogInfo != null) {
            int messageId = this.mSuppliedDialogInfo.getDialogMessageResId();
            String message = this.mSuppliedDialogInfo.getDialogMessage();
            if (messageId != 0 && this.mSuspendingAppResources != null) {
                try {
                    return this.mSuspendingAppResources.getString(messageId, suspendedAppLabel);
                }
                catch (Resources.NotFoundException nfe) {
                    Slog.e(TAG, "Could not resolve string resource id " + messageId);
                }
            } else if (message != null) {
                return String.format(this.getResources().getConfiguration().getLocales().get(0), message, suspendedAppLabel);
            }
        }
        return this.getString(17039514, suspendedAppLabel, this.getAppLabel(suspendingPkg));
    }

    private String resolveNeutralButtonText() {
        int buttonTextId;
        int n = buttonTextId = this.mSuppliedDialogInfo != null ? this.mSuppliedDialogInfo.getNeutralButtonTextResId() : 0;
        if (buttonTextId != 0 && this.mSuspendingAppResources != null) {
            try {
                return this.mSuspendingAppResources.getString(buttonTextId);
            }
            catch (Resources.NotFoundException nfe) {
                Slog.e(TAG, "Could not resolve string resource id " + buttonTextId);
            }
        }
        return this.getString(17039515);
    }

    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mPm = this.getPackageManager();
        this.getWindow().setType(2008);
        Intent intent = this.getIntent();
        this.mUserId = intent.getIntExtra("android.intent.extra.USER_ID", -1);
        if (this.mUserId < 0) {
            Slog.wtf(TAG, "Invalid user: " + this.mUserId);
            this.finish();
            return;
        }
        String suspendedPackage = intent.getStringExtra(EXTRA_SUSPENDED_PACKAGE);
        String suspendingPackage = intent.getStringExtra(EXTRA_SUSPENDING_PACKAGE);
        this.mSuppliedDialogInfo = (SuspendDialogInfo)intent.getParcelableExtra(EXTRA_DIALOG_INFO);
        if (this.mSuppliedDialogInfo != null) {
            try {
                this.mSuspendingAppResources = this.mPm.getResourcesForApplicationAsUser(suspendingPackage, this.mUserId);
            }
            catch (PackageManager.NameNotFoundException ne) {
                Slog.e(TAG, "Could not find resources for " + suspendingPackage, ne);
            }
        }
        AlertController.AlertParams ap = this.mAlertParams;
        ap.mIcon = this.resolveIcon();
        ap.mTitle = this.resolveTitle();
        ap.mMessage = this.resolveDialogMessage(suspendingPackage, suspendedPackage);
        ap.mPositiveButtonText = this.getString(17039370);
        this.mMoreDetailsIntent = this.getMoreDetailsActivity(suspendingPackage, suspendedPackage, this.mUserId);
        if (this.mMoreDetailsIntent != null) {
            ap.mNeutralButtonText = this.resolveNeutralButtonText();
        }
        ap.mPositiveButtonListener = ap.mNeutralButtonListener = this;
        this.setupAlert();
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -3: {
                this.startActivityAsUser(this.mMoreDetailsIntent, UserHandle.of(this.mUserId));
                Slog.i(TAG, "Started more details activity");
            }
        }
        this.finish();
    }

    public static Intent createSuspendedAppInterceptIntent(String suspendedPackage, String suspendingPackage, SuspendDialogInfo dialogInfo, int userId) {
        return new Intent().setClassName("android", SuspendedAppActivity.class.getName()).putExtra(EXTRA_SUSPENDED_PACKAGE, suspendedPackage).putExtra(EXTRA_DIALOG_INFO, dialogInfo).putExtra(EXTRA_SUSPENDING_PACKAGE, suspendingPackage).putExtra("android.intent.extra.USER_ID", userId).setFlags(0x10800000);
    }
}

