/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.Parcel;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.app.procstats.DumpUtils;
import com.android.internal.app.procstats.DurationsTable;
import com.android.internal.app.procstats.ProcessState;
import com.android.internal.app.procstats.ProcessStats;
import com.android.internal.app.procstats.SparseMappingTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Objects;

public final class AssociationState {
    private static final String TAG = "ProcessStats";
    private static final boolean DEBUG = false;
    private final ProcessStats mProcessStats;
    private final ProcessStats.PackageState mPackageState;
    private final String mProcessName;
    private final String mName;
    private final ArrayMap<SourceKey, SourceState> mSources = new ArrayMap();
    private final SourceKey mTmpSourceKey = new SourceKey(0, null, null);
    private ProcessState mProc;
    private int mNumActive;

    public AssociationState(ProcessStats processStats, ProcessStats.PackageState packageState, String name, String processName, ProcessState proc) {
        this.mProcessStats = processStats;
        this.mPackageState = packageState;
        this.mName = name;
        this.mProcessName = processName;
        this.mProc = proc;
    }

    public int getUid() {
        return this.mPackageState.mUid;
    }

    public String getPackage() {
        return this.mPackageState.mPackageName;
    }

    public String getProcessName() {
        return this.mProcessName;
    }

    public String getName() {
        return this.mName;
    }

    public ProcessState getProcess() {
        return this.mProc;
    }

    public void setProcess(ProcessState proc) {
        this.mProc = proc;
    }

    public SourceState startSource(int uid, String processName, String packageName) {
        this.mTmpSourceKey.mUid = uid;
        this.mTmpSourceKey.mProcess = processName;
        this.mTmpSourceKey.mPackage = packageName;
        SourceState src = this.mSources.get(this.mTmpSourceKey);
        if (src == null) {
            SourceKey key = new SourceKey(uid, processName, packageName);
            src = new SourceState(key);
            this.mSources.put(key, src);
        }
        ++src.mNesting;
        if (src.mNesting == 1) {
            ++src.mCount;
            src.mStartUptime = SystemClock.uptimeMillis();
            ++this.mNumActive;
        }
        return src;
    }

    public void add(AssociationState other) {
        for (int isrc = other.mSources.size() - 1; isrc >= 0; --isrc) {
            SourceKey key = other.mSources.keyAt(isrc);
            SourceState otherSrc = other.mSources.valueAt(isrc);
            SourceState mySrc = this.mSources.get(key);
            if (mySrc == null) {
                mySrc = new SourceState(key);
                this.mSources.put(key, mySrc);
            }
            mySrc.mCount += otherSrc.mCount;
            mySrc.mDuration += otherSrc.mDuration;
            mySrc.mActiveCount += otherSrc.mActiveCount;
            if (otherSrc.mActiveDuration == 0L && otherSrc.mDurations == null) continue;
            if (mySrc.mDurations != null) {
                if (otherSrc.mDurations != null) {
                    mySrc.mDurations.addDurations(otherSrc.mDurations);
                    continue;
                }
                mySrc.mDurations.addDuration(otherSrc.mActiveProcState, otherSrc.mActiveDuration);
                continue;
            }
            if (otherSrc.mDurations != null) {
                mySrc.makeDurations();
                mySrc.mDurations.addDurations(otherSrc.mDurations);
                if (mySrc.mActiveDuration == 0L) continue;
                mySrc.mDurations.addDuration(mySrc.mActiveProcState, mySrc.mActiveDuration);
                mySrc.mActiveDuration = 0L;
                mySrc.mActiveProcState = -1;
                continue;
            }
            if (mySrc.mActiveDuration != 0L) {
                if (mySrc.mActiveProcState == otherSrc.mActiveProcState) {
                    mySrc.mDuration += otherSrc.mDuration;
                    continue;
                }
                mySrc.makeDurations();
                mySrc.mDurations.addDuration(mySrc.mActiveProcState, mySrc.mActiveDuration);
                mySrc.mDurations.addDuration(otherSrc.mActiveProcState, otherSrc.mActiveDuration);
                mySrc.mActiveDuration = 0L;
                mySrc.mActiveProcState = -1;
                continue;
            }
            mySrc.mActiveProcState = otherSrc.mActiveProcState;
            mySrc.mActiveDuration = otherSrc.mActiveDuration;
        }
    }

    public boolean isInUse() {
        return this.mNumActive > 0;
    }

    public void resetSafely(long now) {
        if (!this.isInUse()) {
            this.mSources.clear();
        } else {
            for (int isrc = this.mSources.size() - 1; isrc >= 0; --isrc) {
                SourceState src = this.mSources.valueAt(isrc);
                if (src.mNesting > 0) {
                    src.mCount = 1;
                    src.mStartUptime = now;
                    src.mDuration = 0L;
                    if (src.mActiveStartUptime > 0L) {
                        src.mActiveCount = 1;
                        src.mActiveStartUptime = now;
                    } else {
                        src.mActiveCount = 0;
                    }
                    src.mActiveDuration = 0L;
                    src.mDurations = null;
                    continue;
                }
                this.mSources.removeAt(isrc);
            }
        }
    }

    public void writeToParcel(ProcessStats stats, Parcel out, long nowUptime) {
        int NSRC = this.mSources.size();
        out.writeInt(NSRC);
        for (int isrc = 0; isrc < NSRC; ++isrc) {
            SourceKey key = this.mSources.keyAt(isrc);
            SourceState src = this.mSources.valueAt(isrc);
            out.writeInt(key.mUid);
            stats.writeCommonString(out, key.mProcess);
            stats.writeCommonString(out, key.mPackage);
            out.writeInt(src.mCount);
            out.writeLong(src.mDuration);
            out.writeInt(src.mActiveCount);
            if (src.mDurations != null) {
                out.writeInt(1);
                src.mDurations.writeToParcel(out);
                continue;
            }
            out.writeInt(0);
            out.writeInt(src.mActiveProcState);
            out.writeLong(src.mActiveDuration);
        }
    }

    public String readFromParcel(ProcessStats stats, Parcel in, int parcelVersion) {
        int NSRC = in.readInt();
        if (NSRC < 0 || NSRC > 100000) {
            return "Association with bad src count: " + NSRC;
        }
        for (int isrc = 0; isrc < NSRC; ++isrc) {
            int uid = in.readInt();
            String procName = stats.readCommonString(in, parcelVersion);
            String pkgName = stats.readCommonString(in, parcelVersion);
            SourceKey key = new SourceKey(uid, procName, pkgName);
            SourceState src = new SourceState(key);
            src.mCount = in.readInt();
            src.mDuration = in.readLong();
            src.mActiveCount = in.readInt();
            if (in.readInt() != 0) {
                src.makeDurations();
                if (!src.mDurations.readFromParcel(in)) {
                    return "Duration table corrupt: " + key + " <- " + src;
                }
            } else {
                src.mActiveProcState = in.readInt();
                src.mActiveDuration = in.readLong();
            }
            this.mSources.put(key, src);
        }
        return null;
    }

    public void commitStateTime(long nowUptime) {
        if (this.isInUse()) {
            for (int isrc = this.mSources.size() - 1; isrc >= 0; --isrc) {
                SourceState src = this.mSources.valueAt(isrc);
                if (src.mNesting > 0) {
                    src.mDuration += nowUptime - src.mStartUptime;
                    src.mStartUptime = nowUptime;
                }
                if (src.mActiveStartUptime <= 0L) continue;
                long duration = src.mActiveDuration + nowUptime - src.mActiveStartUptime;
                if (src.mDurations != null) {
                    src.mDurations.addDuration(src.mActiveProcState, duration);
                } else {
                    src.mActiveDuration = duration;
                }
                src.mActiveStartUptime = nowUptime;
            }
        }
    }

    public boolean hasProcessOrPackage(String procName) {
        int NSRC = this.mSources.size();
        for (int isrc = 0; isrc < NSRC; ++isrc) {
            SourceKey key = this.mSources.keyAt(isrc);
            if (!procName.equals(key.mProcess) && !procName.equals(key.mPackage)) continue;
            return true;
        }
        return false;
    }

    public void dumpStats(PrintWriter pw, String prefix, String prefixInner, String headerPrefix, long now, long totalTime, String reqPackage, boolean dumpDetails, boolean dumpAll) {
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mNumActive=");
            pw.println(this.mNumActive);
        }
        int NSRC = this.mSources.size();
        for (int isrc = 0; isrc < NSRC; ++isrc) {
            SourceKey key = this.mSources.keyAt(isrc);
            SourceState src = this.mSources.valueAt(isrc);
            if (reqPackage != null && !reqPackage.equals(key.mProcess) && !reqPackage.equals(key.mPackage)) continue;
            pw.print(prefixInner);
            pw.print("<- ");
            pw.print(key.mProcess);
            pw.print("/");
            UserHandle.formatUid(pw, key.mUid);
            if (key.mPackage != null) {
                pw.print(" (");
                pw.print(key.mPackage);
                pw.print(")");
            }
            pw.println(":");
            pw.print(prefixInner);
            pw.print("   Total count ");
            pw.print(src.mCount);
            long duration = src.mDuration;
            if (src.mNesting > 0) {
                duration += now - src.mStartUptime;
            }
            if (dumpAll) {
                pw.print(": Duration ");
                TimeUtils.formatDuration(duration, pw);
                pw.print(" / ");
            } else {
                pw.print(": time ");
            }
            DumpUtils.printPercent(pw, (double)duration / (double)totalTime);
            if (src.mNesting > 0) {
                pw.print(" (running");
                if (src.mProcState != -1) {
                    pw.print(" / ");
                    pw.print(DumpUtils.STATE_NAMES[src.mProcState]);
                    pw.print(" #");
                    pw.print(src.mProcStateSeq);
                }
                pw.print(")");
            }
            pw.println();
            if (src.mActiveCount > 0 || src.mDurations != null || src.mActiveDuration != 0L || src.mActiveStartUptime != 0L) {
                pw.print(prefixInner);
                pw.print("   Active count ");
                pw.print(src.mActiveCount);
                if (dumpDetails) {
                    if (dumpAll) {
                        pw.print(src.mDurations != null ? " (multi-field)" : " (inline)");
                    }
                    pw.println(":");
                    this.dumpTime(pw, prefixInner, src, totalTime, now, dumpDetails, dumpAll);
                } else {
                    pw.print(": ");
                    this.dumpActiveDurationSummary(pw, src, totalTime, now, dumpAll);
                    pw.println();
                }
            }
            if (!dumpAll) continue;
            if (src.mInTrackingList) {
                pw.print(prefixInner);
                pw.print("   mInTrackingList=");
                pw.println(src.mInTrackingList);
            }
            if (src.mProcState == -1) continue;
            pw.print(prefixInner);
            pw.print("   mProcState=");
            pw.print(DumpUtils.STATE_NAMES[src.mProcState]);
            pw.print(" mProcStateSeq=");
            pw.println(src.mProcStateSeq);
        }
    }

    void dumpActiveDurationSummary(PrintWriter pw, SourceState src, long totalTime, long now, boolean dumpAll) {
        boolean isRunning;
        long duration = this.dumpTime(null, null, src, totalTime, now, false, false);
        boolean bl = isRunning = duration < 0L;
        if (isRunning) {
            duration = -duration;
        }
        if (dumpAll) {
            pw.print("Duration ");
            TimeUtils.formatDuration(duration, pw);
            pw.print(" / ");
        } else {
            pw.print("time ");
        }
        DumpUtils.printPercent(pw, (double)duration / (double)totalTime);
        if (src.mActiveStartUptime > 0L) {
            pw.print(" (running)");
        }
        pw.println();
    }

    long dumpTime(PrintWriter pw, String prefix, SourceState src, long overallTime, long now, boolean dumpDetails, boolean dumpAll) {
        long totalTime = 0L;
        boolean isRunning = false;
        for (int iprocstate = 0; iprocstate < 14; ++iprocstate) {
            String running;
            long time;
            if (src.mDurations != null) {
                time = src.mDurations.getValueForId((byte)iprocstate);
            } else {
                long l = time = src.mActiveProcState == iprocstate ? src.mDuration : 0L;
            }
            if (src.mActiveStartUptime != 0L && src.mActiveProcState == iprocstate) {
                running = " (running)";
                isRunning = true;
                time += now - src.mActiveStartUptime;
            } else {
                running = null;
            }
            if (time == 0L) continue;
            if (pw != null) {
                pw.print(prefix);
                pw.print("  ");
                pw.print(DumpUtils.STATE_LABELS[iprocstate]);
                pw.print(": ");
                if (dumpAll) {
                    pw.print("Duration ");
                    TimeUtils.formatDuration(time, pw);
                    pw.print(" / ");
                } else {
                    pw.print("time ");
                }
                DumpUtils.printPercent(pw, (double)time / (double)overallTime);
                if (running != null) {
                    pw.print(running);
                }
                pw.println();
            }
            totalTime += time;
        }
        if (totalTime != 0L && pw != null) {
            pw.print(prefix);
            pw.print("  ");
            pw.print(DumpUtils.STATE_LABEL_TOTAL);
            pw.print(": ");
            if (dumpAll) {
                pw.print("Duration ");
                TimeUtils.formatDuration(totalTime, pw);
                pw.print(" / ");
            } else {
                pw.print("time ");
            }
            DumpUtils.printPercent(pw, (double)totalTime / (double)overallTime);
            pw.println();
        }
        return isRunning ? -totalTime : totalTime;
    }

    public void dumpTimesCheckin(PrintWriter pw, String pkgName, int uid, long vers, String associationName, long now) {
        int NSRC = this.mSources.size();
        for (int isrc = 0; isrc < NSRC; ++isrc) {
            long timeNow;
            SourceKey key = this.mSources.keyAt(isrc);
            SourceState src = this.mSources.valueAt(isrc);
            pw.print("pkgasc");
            pw.print(",");
            pw.print(pkgName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print(vers);
            pw.print(",");
            pw.print(associationName);
            pw.print(",");
            pw.print(key.mProcess);
            pw.print(",");
            pw.print(key.mUid);
            pw.print(",");
            pw.print(src.mCount);
            long duration = src.mDuration;
            if (src.mNesting > 0) {
                duration += now - src.mStartUptime;
            }
            pw.print(",");
            pw.print(duration);
            pw.print(",");
            pw.print(src.mActiveCount);
            long l = timeNow = src.mActiveStartUptime != 0L ? now - src.mActiveStartUptime : 0L;
            if (src.mDurations != null) {
                int N = src.mDurations.getKeyCount();
                for (int i = 0; i < N; ++i) {
                    int dkey = src.mDurations.getKeyAt(i);
                    duration = src.mDurations.getValue(dkey);
                    if (dkey == src.mActiveProcState) {
                        duration += timeNow;
                    }
                    byte procState = SparseMappingTable.getIdFromKey(dkey);
                    pw.print(",");
                    DumpUtils.printArrayEntry(pw, DumpUtils.STATE_TAGS, procState, 1);
                    pw.print(':');
                    pw.print(duration);
                }
            } else {
                duration = src.mActiveDuration + timeNow;
                if (duration != 0L) {
                    pw.print(",");
                    DumpUtils.printArrayEntry(pw, DumpUtils.STATE_TAGS, src.mActiveProcState, 1);
                    pw.print(':');
                    pw.print(duration);
                }
            }
            pw.println();
        }
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId, long now) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.mName);
        int NSRC = this.mSources.size();
        for (int isrc = 0; isrc < NSRC; ++isrc) {
            long timeNow;
            SourceKey key = this.mSources.keyAt(isrc);
            SourceState src = this.mSources.valueAt(isrc);
            long sourceToken = proto.start(0x20B00000002L);
            proto.write(1138166333442L, key.mProcess);
            proto.write(1138166333447L, key.mPackage);
            proto.write(0x10500000001L, key.mUid);
            proto.write(1120986464259L, src.mCount);
            long duration = src.mDuration;
            if (src.mNesting > 0) {
                duration += now - src.mStartUptime;
            }
            proto.write(1112396529668L, duration);
            if (src.mActiveCount != 0) {
                proto.write(0x10500000005L, src.mActiveCount);
            }
            long l = timeNow = src.mActiveStartUptime != 0L ? now - src.mActiveStartUptime : 0L;
            if (src.mDurations != null) {
                int N = src.mDurations.getKeyCount();
                for (int i = 0; i < N; ++i) {
                    int dkey = src.mDurations.getKeyAt(i);
                    duration = src.mDurations.getValue(dkey);
                    if (dkey == src.mActiveProcState) {
                        duration += timeNow;
                    }
                    byte procState = SparseMappingTable.getIdFromKey(dkey);
                    long stateToken = proto.start(2246267895814L);
                    DumpUtils.printProto(proto, 0x10E00000001L, DumpUtils.STATE_PROTO_ENUMS, procState, 1);
                    proto.write(1112396529666L, duration);
                    proto.end(stateToken);
                }
            } else {
                duration = src.mActiveDuration + timeNow;
                if (duration != 0L) {
                    long stateToken = proto.start(2246267895814L);
                    DumpUtils.printProto(proto, 0x10E00000001L, DumpUtils.STATE_PROTO_ENUMS, src.mActiveProcState, 1);
                    proto.write(1112396529666L, duration);
                    proto.end(stateToken);
                }
            }
            proto.end(sourceToken);
        }
        proto.end(token);
    }

    public String toString() {
        return "AssociationState{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.mName + " pkg=" + this.mPackageState.mPackageName + " proc=" + Integer.toHexString(System.identityHashCode(this.mProc)) + "}";
    }

    private static final class SourceKey {
        int mUid;
        String mProcess;
        String mPackage;

        SourceKey(int uid, String process, String pkg) {
            this.mUid = uid;
            this.mProcess = process;
            this.mPackage = pkg;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SourceKey)) {
                return false;
            }
            SourceKey s = (SourceKey)o;
            return s.mUid == this.mUid && Objects.equals(s.mProcess, this.mProcess) && Objects.equals(s.mPackage, this.mPackage);
        }

        public int hashCode() {
            return Integer.hashCode(this.mUid) ^ (this.mProcess == null ? 0 : this.mProcess.hashCode()) ^ (this.mPackage == null ? 0 : this.mPackage.hashCode() * 33);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append("SourceKey{");
            UserHandle.formatUid(sb, this.mUid);
            sb.append(' ');
            sb.append(this.mProcess);
            sb.append(' ');
            sb.append(this.mPackage);
            sb.append('}');
            return sb.toString();
        }
    }

    public final class SourceState {
        final SourceKey mKey;
        int mProcStateSeq = -1;
        int mProcState = -1;
        boolean mInTrackingList;
        int mNesting;
        int mCount;
        long mStartUptime;
        long mDuration;
        long mTrackingUptime;
        int mActiveCount;
        int mActiveProcState = -1;
        long mActiveStartUptime;
        long mActiveDuration;
        DurationsTable mDurations;

        SourceState(SourceKey key) {
            this.mKey = key;
        }

        public AssociationState getAssociationState() {
            return AssociationState.this;
        }

        public String getProcessName() {
            return this.mKey.mProcess;
        }

        public int getUid() {
            return this.mKey.mUid;
        }

        public void trackProcState(int procState, int seq, long now) {
            procState = ProcessState.PROCESS_STATE_TO_STATE[procState];
            if (seq != this.mProcStateSeq) {
                this.mProcStateSeq = seq;
                this.mProcState = procState;
            } else if (procState < this.mProcState) {
                this.mProcState = procState;
            }
            if (procState < 9 && !this.mInTrackingList) {
                this.mInTrackingList = true;
                this.mTrackingUptime = now;
                ((AssociationState)AssociationState.this).mProcessStats.mTrackingAssociations.add(this);
            }
        }

        public void stop() {
            --this.mNesting;
            if (this.mNesting == 0) {
                this.mDuration += SystemClock.uptimeMillis() - this.mStartUptime;
                AssociationState.this.mNumActive--;
                this.stopTracking(SystemClock.uptimeMillis());
            }
        }

        void startActive(long now) {
            if (this.mInTrackingList) {
                if (this.mActiveStartUptime == 0L) {
                    this.mActiveStartUptime = now;
                    ++this.mActiveCount;
                }
                if (this.mActiveProcState != this.mProcState) {
                    if (this.mActiveProcState != -1) {
                        long duration = this.mActiveDuration + now - this.mActiveStartUptime;
                        if (duration != 0L) {
                            if (this.mDurations == null) {
                                this.makeDurations();
                            }
                            this.mDurations.addDuration(this.mActiveProcState, duration);
                            this.mActiveDuration = 0L;
                        }
                        this.mActiveStartUptime = now;
                    }
                    this.mActiveProcState = this.mProcState;
                }
            } else {
                Slog.wtf(AssociationState.TAG, "startActive while not tracking: " + this);
            }
        }

        void stopActive(long now) {
            if (this.mActiveStartUptime != 0L) {
                if (!this.mInTrackingList) {
                    Slog.wtf(AssociationState.TAG, "stopActive while not tracking: " + this);
                }
                long duration = this.mActiveDuration + now - this.mActiveStartUptime;
                if (this.mDurations != null) {
                    this.mDurations.addDuration(this.mActiveProcState, duration);
                } else {
                    this.mActiveDuration = duration;
                }
                this.mActiveStartUptime = 0L;
            }
        }

        void makeDurations() {
            this.mDurations = new DurationsTable(((AssociationState)AssociationState.this).mProcessStats.mTableData);
        }

        void stopTracking(long now) {
            this.stopActive(now);
            if (this.mInTrackingList) {
                this.mInTrackingList = false;
                this.mProcState = -1;
                ArrayList<SourceState> list = ((AssociationState)AssociationState.this).mProcessStats.mTrackingAssociations;
                for (int i = list.size() - 1; i >= 0; --i) {
                    if (list.get(i) != this) continue;
                    list.remove(i);
                    return;
                }
                Slog.wtf(AssociationState.TAG, "Stop tracking didn't find in tracking list: " + this);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append("SourceState{").append(Integer.toHexString(System.identityHashCode(this))).append(" ").append(this.mKey.mProcess).append("/").append(this.mKey.mUid);
            if (this.mProcState != -1) {
                sb.append(" ").append(DumpUtils.STATE_NAMES[this.mProcState]).append(" #").append(this.mProcStateSeq);
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

