/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.UserHandle;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.app.procstats.ProcessState;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class DumpUtils {
    public static final String[] STATE_NAMES = new String[14];
    public static final String[] STATE_LABELS;
    public static final String STATE_LABEL_TOTAL;
    public static final String STATE_LABEL_CACHED;
    public static final String[] STATE_NAMES_CSV;
    static final String[] STATE_TAGS;
    static final int[] STATE_PROTO_ENUMS;
    public static final String[] ADJ_SCREEN_NAMES_CSV;
    public static final String[] ADJ_MEM_NAMES_CSV;
    static final String[] ADJ_SCREEN_TAGS;
    static final int[] ADJ_SCREEN_PROTO_ENUMS;
    static final String[] ADJ_MEM_TAGS;
    static final int[] ADJ_MEM_PROTO_ENUMS;
    static final String CSV_SEP = "\t";

    private DumpUtils() {
    }

    public static void printScreenLabel(PrintWriter pw, int offset) {
        switch (offset) {
            case -1: {
                pw.print("     ");
                break;
            }
            case 0: {
                pw.print("SOff/");
                break;
            }
            case 4: {
                pw.print(" SOn/");
                break;
            }
            default: {
                pw.print("????/");
            }
        }
    }

    public static void printScreenLabelCsv(PrintWriter pw, int offset) {
        switch (offset) {
            case -1: {
                break;
            }
            case 0: {
                pw.print(ADJ_SCREEN_NAMES_CSV[0]);
                break;
            }
            case 4: {
                pw.print(ADJ_SCREEN_NAMES_CSV[1]);
                break;
            }
            default: {
                pw.print("???");
            }
        }
    }

    public static void printMemLabel(PrintWriter pw, int offset, char sep) {
        switch (offset) {
            case -1: {
                pw.print("    ");
                if (sep == '\u0000') break;
                pw.print(' ');
                break;
            }
            case 0: {
                pw.print("Norm");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 1: {
                pw.print(" Mod");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 2: {
                pw.print(" Low");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 3: {
                pw.print("Crit");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            default: {
                pw.print("????");
                if (sep == '\u0000') break;
                pw.print(sep);
            }
        }
    }

    public static void printMemLabelCsv(PrintWriter pw, int offset) {
        if (offset >= 0) {
            if (offset <= 3) {
                pw.print(ADJ_MEM_NAMES_CSV[offset]);
            } else {
                pw.print("???");
            }
        }
    }

    public static void printPercent(PrintWriter pw, double fraction2) {
        if ((fraction2 *= 100.0) < 1.0) {
            pw.print(String.format("%.2f", fraction2));
        } else if (fraction2 < 10.0) {
            pw.print(String.format("%.1f", fraction2));
        } else {
            pw.print(String.format("%.0f", fraction2));
        }
        pw.print("%");
    }

    public static void printProcStateTag(PrintWriter pw, int state) {
        state = DumpUtils.printArrayEntry(pw, ADJ_SCREEN_TAGS, state, 56);
        state = DumpUtils.printArrayEntry(pw, ADJ_MEM_TAGS, state, 14);
        DumpUtils.printArrayEntry(pw, STATE_TAGS, state, 1);
    }

    public static void printProcStateTagProto(ProtoOutputStream proto, long screenId, long memId, long stateId, int state) {
        state = DumpUtils.printProto(proto, screenId, ADJ_SCREEN_PROTO_ENUMS, state, 56);
        state = DumpUtils.printProto(proto, memId, ADJ_MEM_PROTO_ENUMS, state, 14);
        DumpUtils.printProto(proto, stateId, STATE_PROTO_ENUMS, state, 1);
    }

    public static void printAdjTag(PrintWriter pw, int state) {
        state = DumpUtils.printArrayEntry(pw, ADJ_SCREEN_TAGS, state, 4);
        DumpUtils.printArrayEntry(pw, ADJ_MEM_TAGS, state, 1);
    }

    public static void printProcStateAdjTagProto(ProtoOutputStream proto, long screenId, long memId, int state) {
        state = DumpUtils.printProto(proto, screenId, ADJ_SCREEN_PROTO_ENUMS, state, 56);
        DumpUtils.printProto(proto, memId, ADJ_MEM_PROTO_ENUMS, state, 14);
    }

    public static void printProcStateDurationProto(ProtoOutputStream proto, long fieldId, int procState, long duration) {
        long stateToken = proto.start(fieldId);
        DumpUtils.printProto(proto, 1159641169923L, STATE_PROTO_ENUMS, procState, 1);
        proto.write(1112396529668L, duration);
        proto.end(stateToken);
    }

    public static void printProcStateTagAndValue(PrintWriter pw, int state, long value) {
        pw.print(',');
        DumpUtils.printProcStateTag(pw, state);
        pw.print(':');
        pw.print(value);
    }

    public static void printAdjTagAndValue(PrintWriter pw, int state, long value) {
        pw.print(',');
        DumpUtils.printAdjTag(pw, state);
        pw.print(':');
        pw.print(value);
    }

    public static long dumpSingleTime(PrintWriter pw, String prefix, long[] durations, int curState, long curStartTime, long now) {
        long totalTime = 0L;
        int printedScreen = -1;
        for (int iscreen = 0; iscreen < 8; iscreen += 4) {
            int printedMem = -1;
            for (int imem = 0; imem < 4; ++imem) {
                int state = imem + iscreen;
                long time = durations[state];
                String running = "";
                if (curState == state) {
                    time += now - curStartTime;
                    if (pw != null) {
                        running = " (running)";
                    }
                }
                if (time == 0L) continue;
                if (pw != null) {
                    pw.print(prefix);
                    DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                    printedScreen = iscreen;
                    DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '\u0000');
                    printedMem = imem;
                    pw.print(": ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println(running);
                }
                totalTime += time;
            }
        }
        if (totalTime != 0L && pw != null) {
            pw.print(prefix);
            pw.print("    TOTAL: ");
            TimeUtils.formatDuration(totalTime, pw);
            pw.println();
        }
        return totalTime;
    }

    public static void dumpAdjTimesCheckin(PrintWriter pw, String sep, long[] durations, int curState, long curStartTime, long now) {
        for (int iscreen = 0; iscreen < 8; iscreen += 4) {
            for (int imem = 0; imem < 4; ++imem) {
                int state = imem + iscreen;
                long time = durations[state];
                if (curState == state) {
                    time += now - curStartTime;
                }
                if (time == 0L) continue;
                DumpUtils.printAdjTagAndValue(pw, state, time);
            }
        }
    }

    private static void dumpStateHeadersCsv(PrintWriter pw, String sep, int[] screenStates, int[] memStates, int[] procStates) {
        int NS = screenStates != null ? screenStates.length : 1;
        int NM = memStates != null ? memStates.length : 1;
        int NP = procStates != null ? procStates.length : 1;
        for (int is = 0; is < NS; ++is) {
            for (int im = 0; im < NM; ++im) {
                for (int ip = 0; ip < NP; ++ip) {
                    pw.print(sep);
                    boolean printed = false;
                    if (screenStates != null && screenStates.length > 1) {
                        DumpUtils.printScreenLabelCsv(pw, screenStates[is]);
                        printed = true;
                    }
                    if (memStates != null && memStates.length > 1) {
                        if (printed) {
                            pw.print("-");
                        }
                        DumpUtils.printMemLabelCsv(pw, memStates[im]);
                        printed = true;
                    }
                    if (procStates == null || procStates.length <= 1) continue;
                    if (printed) {
                        pw.print("-");
                    }
                    pw.print(STATE_NAMES_CSV[procStates[ip]]);
                }
            }
        }
    }

    public static void dumpProcessSummaryLocked(PrintWriter pw, String prefix, String header, ArrayList<ProcessState> procs, int[] screenStates, int[] memStates, int[] procStates, long now, long totalTime) {
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessState proc = procs.get(i);
            proc.dumpSummary(pw, prefix, header, screenStates, memStates, procStates, now, totalTime);
        }
    }

    public static void dumpProcessListCsv(PrintWriter pw, ArrayList<ProcessState> procs, boolean sepScreenStates, int[] screenStates, boolean sepMemStates, int[] memStates, boolean sepProcStates, int[] procStates, long now) {
        pw.print("process");
        pw.print(CSV_SEP);
        pw.print("uid");
        pw.print(CSV_SEP);
        pw.print("vers");
        DumpUtils.dumpStateHeadersCsv(pw, CSV_SEP, (int[])(sepScreenStates ? screenStates : null), (int[])(sepMemStates ? memStates : null), (int[])(sepProcStates ? procStates : null));
        pw.println();
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessState proc = procs.get(i);
            pw.print(proc.getName());
            pw.print(CSV_SEP);
            UserHandle.formatUid(pw, proc.getUid());
            pw.print(CSV_SEP);
            pw.print(proc.getVersion());
            proc.dumpCsv(pw, sepScreenStates, screenStates, sepMemStates, memStates, sepProcStates, procStates, now);
            pw.println();
        }
    }

    public static int printArrayEntry(PrintWriter pw, String[] array2, int value, int mod) {
        int index = value / mod;
        if (index >= 0 && index < array2.length) {
            pw.print(array2[index]);
        } else {
            pw.print('?');
        }
        return value - index * mod;
    }

    public static int printProto(ProtoOutputStream proto, long fieldId, int[] enums, int value, int mod) {
        int index = value / mod;
        if (index >= 0 && index < enums.length) {
            proto.write(fieldId, enums[index]);
        }
        return value - index * mod;
    }

    public static String collapseString(String pkgName, String itemName) {
        if (itemName.startsWith(pkgName)) {
            int PKGLEN;
            int ITEMLEN = itemName.length();
            if (ITEMLEN == (PKGLEN = pkgName.length())) {
                return "";
            }
            if (ITEMLEN >= PKGLEN && itemName.charAt(PKGLEN) == '.') {
                return itemName.substring(PKGLEN);
            }
        }
        return itemName;
    }

    static {
        DumpUtils.STATE_NAMES[0] = "Persist";
        DumpUtils.STATE_NAMES[1] = "Top";
        DumpUtils.STATE_NAMES[2] = "ImpFg";
        DumpUtils.STATE_NAMES[3] = "ImpBg";
        DumpUtils.STATE_NAMES[4] = "Backup";
        DumpUtils.STATE_NAMES[5] = "Service";
        DumpUtils.STATE_NAMES[6] = "ServRst";
        DumpUtils.STATE_NAMES[7] = "Receivr";
        DumpUtils.STATE_NAMES[8] = "HeavyWt";
        DumpUtils.STATE_NAMES[9] = "Home";
        DumpUtils.STATE_NAMES[10] = "LastAct";
        DumpUtils.STATE_NAMES[11] = "CchAct";
        DumpUtils.STATE_NAMES[12] = "CchCAct";
        DumpUtils.STATE_NAMES[13] = "CchEmty";
        STATE_LABELS = new String[14];
        DumpUtils.STATE_LABELS[0] = "Persistent";
        DumpUtils.STATE_LABELS[1] = "       Top";
        DumpUtils.STATE_LABELS[2] = "    Imp Fg";
        DumpUtils.STATE_LABELS[3] = "    Imp Bg";
        DumpUtils.STATE_LABELS[4] = "    Backup";
        DumpUtils.STATE_LABELS[5] = "   Service";
        DumpUtils.STATE_LABELS[6] = "Service Rs";
        DumpUtils.STATE_LABELS[7] = "  Receiver";
        DumpUtils.STATE_LABELS[8] = " Heavy Wgt";
        DumpUtils.STATE_LABELS[9] = "    (Home)";
        DumpUtils.STATE_LABELS[10] = "(Last Act)";
        DumpUtils.STATE_LABELS[11] = " (Cch Act)";
        DumpUtils.STATE_LABELS[12] = "(Cch CAct)";
        DumpUtils.STATE_LABELS[13] = "(Cch Emty)";
        STATE_LABEL_CACHED = "  (Cached)";
        STATE_LABEL_TOTAL = "     TOTAL";
        STATE_NAMES_CSV = new String[14];
        DumpUtils.STATE_NAMES_CSV[0] = "pers";
        DumpUtils.STATE_NAMES_CSV[1] = "top";
        DumpUtils.STATE_NAMES_CSV[2] = "impfg";
        DumpUtils.STATE_NAMES_CSV[3] = "impbg";
        DumpUtils.STATE_NAMES_CSV[4] = "backup";
        DumpUtils.STATE_NAMES_CSV[5] = "service";
        DumpUtils.STATE_NAMES_CSV[6] = "service-rs";
        DumpUtils.STATE_NAMES_CSV[7] = "receiver";
        DumpUtils.STATE_NAMES_CSV[8] = "heavy";
        DumpUtils.STATE_NAMES_CSV[9] = "home";
        DumpUtils.STATE_NAMES_CSV[10] = "lastact";
        DumpUtils.STATE_NAMES_CSV[11] = "cch-activity";
        DumpUtils.STATE_NAMES_CSV[12] = "cch-aclient";
        DumpUtils.STATE_NAMES_CSV[13] = "cch-empty";
        STATE_TAGS = new String[14];
        DumpUtils.STATE_TAGS[0] = "p";
        DumpUtils.STATE_TAGS[1] = "t";
        DumpUtils.STATE_TAGS[2] = "f";
        DumpUtils.STATE_TAGS[3] = "b";
        DumpUtils.STATE_TAGS[4] = "u";
        DumpUtils.STATE_TAGS[5] = "s";
        DumpUtils.STATE_TAGS[6] = "x";
        DumpUtils.STATE_TAGS[7] = "r";
        DumpUtils.STATE_TAGS[8] = "w";
        DumpUtils.STATE_TAGS[9] = "h";
        DumpUtils.STATE_TAGS[10] = "l";
        DumpUtils.STATE_TAGS[11] = "a";
        DumpUtils.STATE_TAGS[12] = "c";
        DumpUtils.STATE_TAGS[13] = "e";
        STATE_PROTO_ENUMS = new int[14];
        DumpUtils.STATE_PROTO_ENUMS[0] = 1;
        DumpUtils.STATE_PROTO_ENUMS[1] = 2;
        DumpUtils.STATE_PROTO_ENUMS[2] = 3;
        DumpUtils.STATE_PROTO_ENUMS[3] = 4;
        DumpUtils.STATE_PROTO_ENUMS[4] = 5;
        DumpUtils.STATE_PROTO_ENUMS[5] = 6;
        DumpUtils.STATE_PROTO_ENUMS[6] = 7;
        DumpUtils.STATE_PROTO_ENUMS[7] = 8;
        DumpUtils.STATE_PROTO_ENUMS[8] = 9;
        DumpUtils.STATE_PROTO_ENUMS[9] = 10;
        DumpUtils.STATE_PROTO_ENUMS[10] = 11;
        DumpUtils.STATE_PROTO_ENUMS[11] = 12;
        DumpUtils.STATE_PROTO_ENUMS[12] = 13;
        DumpUtils.STATE_PROTO_ENUMS[13] = 14;
        ADJ_SCREEN_NAMES_CSV = new String[]{"off", "on"};
        ADJ_MEM_NAMES_CSV = new String[]{"norm", "mod", "low", "crit"};
        ADJ_SCREEN_TAGS = new String[]{"0", "1"};
        ADJ_SCREEN_PROTO_ENUMS = new int[]{1, 2};
        ADJ_MEM_TAGS = new String[]{"n", "m", "l", "c"};
        ADJ_MEM_PROTO_ENUMS = new int[]{1, 2, 3, 4};
    }
}

