/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.Parcel;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.DebugUtils;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Slog;
import android.util.SparseLongArray;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import android.util.proto.ProtoUtils;
import com.android.internal.app.procstats.DumpUtils;
import com.android.internal.app.procstats.DurationsTable;
import com.android.internal.app.procstats.ProcessStats;
import com.android.internal.app.procstats.PssTable;
import com.android.internal.app.procstats.SparseMappingTable;
import java.io.PrintWriter;
import java.util.Comparator;

public final class ProcessState {
    private static final String TAG = "ProcessStats";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_PARCEL = false;
    static final int[] PROCESS_STATE_TO_STATE = new int[]{0, 0, 1, 2, 2, 2, 2, 2, 3, 3, 4, 5, 7, 1, 8, 9, 10, 11, 12, 11, 13};
    public static final Comparator<ProcessState> COMPARATOR = new Comparator<ProcessState>(){

        @Override
        public int compare(ProcessState lhs, ProcessState rhs) {
            if (lhs.mTmpTotalTime < rhs.mTmpTotalTime) {
                return -1;
            }
            if (lhs.mTmpTotalTime > rhs.mTmpTotalTime) {
                return 1;
            }
            return 0;
        }
    };
    public int tmpNumInUse;
    public ProcessState tmpFoundSubProc;
    private final ProcessStats mStats;
    private final String mName;
    private final String mPackage;
    private final int mUid;
    private final long mVersion;
    private final DurationsTable mDurations;
    private final PssTable mPssTable;
    private final long[] mTotalRunningPss = new long[10];
    private ProcessState mCommonProcess;
    private int mCurCombinedState = -1;
    private long mStartTime;
    private int mLastPssState = -1;
    private long mLastPssTime;
    private long mTotalRunningStartTime;
    private long mTotalRunningDuration;
    private boolean mActive;
    private int mNumActiveServices;
    private int mNumStartedServices;
    private int mNumExcessiveCpu;
    private int mNumCachedKill;
    private long mMinCachedKillPss;
    private long mAvgCachedKillPss;
    private long mMaxCachedKillPss;
    private boolean mMultiPackage;
    private boolean mDead;
    private long mTmpTotalTime;

    public ProcessState(ProcessStats processStats, String pkg, int uid, long vers, String name) {
        this.mStats = processStats;
        this.mName = name;
        this.mCommonProcess = this;
        this.mPackage = pkg;
        this.mUid = uid;
        this.mVersion = vers;
        this.mDurations = new DurationsTable(processStats.mTableData);
        this.mPssTable = new PssTable(processStats.mTableData);
    }

    public ProcessState(ProcessState commonProcess, String pkg, int uid, long vers, String name, long now) {
        this.mStats = commonProcess.mStats;
        this.mName = name;
        this.mCommonProcess = commonProcess;
        this.mPackage = pkg;
        this.mUid = uid;
        this.mVersion = vers;
        this.mCurCombinedState = commonProcess.mCurCombinedState;
        this.mStartTime = now;
        if (this.mCurCombinedState != -1) {
            this.mTotalRunningStartTime = now;
        }
        this.mDurations = new DurationsTable(commonProcess.mStats.mTableData);
        this.mPssTable = new PssTable(commonProcess.mStats.mTableData);
    }

    public ProcessState clone(long now) {
        ProcessState pnew = new ProcessState(this, this.mPackage, this.mUid, this.mVersion, this.mName, now);
        pnew.mDurations.addDurations(this.mDurations);
        pnew.mPssTable.copyFrom(this.mPssTable, 10);
        System.arraycopy(this.mTotalRunningPss, 0, pnew.mTotalRunningPss, 0, 10);
        pnew.mTotalRunningDuration = this.getTotalRunningDuration(now);
        pnew.mNumExcessiveCpu = this.mNumExcessiveCpu;
        pnew.mNumCachedKill = this.mNumCachedKill;
        pnew.mMinCachedKillPss = this.mMinCachedKillPss;
        pnew.mAvgCachedKillPss = this.mAvgCachedKillPss;
        pnew.mMaxCachedKillPss = this.mMaxCachedKillPss;
        pnew.mActive = this.mActive;
        pnew.mNumActiveServices = this.mNumActiveServices;
        pnew.mNumStartedServices = this.mNumStartedServices;
        return pnew;
    }

    public String getName() {
        return this.mName;
    }

    public ProcessState getCommonProcess() {
        return this.mCommonProcess;
    }

    public void makeStandalone() {
        this.mCommonProcess = this;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public int getUid() {
        return this.mUid;
    }

    public long getVersion() {
        return this.mVersion;
    }

    public boolean isMultiPackage() {
        return this.mMultiPackage;
    }

    public void setMultiPackage(boolean val) {
        this.mMultiPackage = val;
    }

    public int getDurationsBucketCount() {
        return this.mDurations.getKeyCount();
    }

    public void add(ProcessState other) {
        this.mDurations.addDurations(other.mDurations);
        this.mPssTable.mergeStats(other.mPssTable);
        this.mNumExcessiveCpu += other.mNumExcessiveCpu;
        if (other.mNumCachedKill > 0) {
            this.addCachedKill(other.mNumCachedKill, other.mMinCachedKillPss, other.mAvgCachedKillPss, other.mMaxCachedKillPss);
        }
    }

    public void resetSafely(long now) {
        this.mDurations.resetTable();
        this.mPssTable.resetTable();
        this.mStartTime = now;
        this.mLastPssState = -1;
        this.mLastPssTime = 0L;
        this.mNumExcessiveCpu = 0;
        this.mNumCachedKill = 0;
        this.mMaxCachedKillPss = 0L;
        this.mAvgCachedKillPss = 0L;
        this.mMinCachedKillPss = 0L;
    }

    public void makeDead() {
        this.mDead = true;
    }

    private void ensureNotDead() {
        if (!this.mDead) {
            return;
        }
        Slog.w(TAG, "ProcessState dead: name=" + this.mName + " pkg=" + this.mPackage + " uid=" + this.mUid + " common.name=" + this.mCommonProcess.mName);
    }

    public void writeToParcel(Parcel out, long now) {
        out.writeInt(this.mMultiPackage ? 1 : 0);
        this.mDurations.writeToParcel(out);
        this.mPssTable.writeToParcel(out);
        for (int i = 0; i < 10; ++i) {
            out.writeLong(this.mTotalRunningPss[i]);
        }
        out.writeLong(this.getTotalRunningDuration(now));
        out.writeInt(0);
        out.writeInt(this.mNumExcessiveCpu);
        out.writeInt(this.mNumCachedKill);
        if (this.mNumCachedKill > 0) {
            out.writeLong(this.mMinCachedKillPss);
            out.writeLong(this.mAvgCachedKillPss);
            out.writeLong(this.mMaxCachedKillPss);
        }
    }

    public boolean readFromParcel(Parcel in, boolean fully) {
        boolean multiPackage;
        boolean bl = multiPackage = in.readInt() != 0;
        if (fully) {
            this.mMultiPackage = multiPackage;
        }
        if (!this.mDurations.readFromParcel(in)) {
            return false;
        }
        if (!this.mPssTable.readFromParcel(in)) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            this.mTotalRunningPss[i] = in.readLong();
        }
        this.mTotalRunningDuration = in.readLong();
        in.readInt();
        this.mNumExcessiveCpu = in.readInt();
        this.mNumCachedKill = in.readInt();
        if (this.mNumCachedKill > 0) {
            this.mMinCachedKillPss = in.readLong();
            this.mAvgCachedKillPss = in.readLong();
            this.mMaxCachedKillPss = in.readLong();
        } else {
            this.mMaxCachedKillPss = 0L;
            this.mAvgCachedKillPss = 0L;
            this.mMinCachedKillPss = 0L;
        }
        return true;
    }

    public void makeActive() {
        this.ensureNotDead();
        this.mActive = true;
    }

    public void makeInactive() {
        this.mActive = false;
    }

    public boolean isInUse() {
        return this.mActive || this.mNumActiveServices > 0 || this.mNumStartedServices > 0 || this.mCurCombinedState != -1;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public boolean hasAnyData() {
        return this.mDurations.getKeyCount() != 0 || this.mCurCombinedState != -1 || this.mPssTable.getKeyCount() != 0 || this.mTotalRunningPss[0] != 0L;
    }

    public void setState(int state, int memFactor, long now, ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList) {
        state = state < 0 ? (this.mNumStartedServices > 0 ? 6 + memFactor * 14 : -1) : PROCESS_STATE_TO_STATE[state] + memFactor * 14;
        this.mCommonProcess.setCombinedState(state, now);
        if (!this.mCommonProcess.mMultiPackage) {
            return;
        }
        if (pkgList != null) {
            for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
                this.pullFixedProc(pkgList, ip).setCombinedState(state, now);
            }
        }
    }

    public void setCombinedState(int state, long now) {
        this.ensureNotDead();
        if (!this.mDead && this.mCurCombinedState != state) {
            this.commitStateTime(now);
            if (state == -1) {
                this.mTotalRunningDuration += now - this.mTotalRunningStartTime;
                this.mTotalRunningStartTime = 0L;
            } else if (this.mCurCombinedState == -1) {
                this.mTotalRunningDuration = 0L;
                this.mTotalRunningStartTime = now;
                for (int i = 9; i >= 0; --i) {
                    this.mTotalRunningPss[i] = 0L;
                }
            }
            this.mCurCombinedState = state;
        }
    }

    public int getCombinedState() {
        return this.mCurCombinedState;
    }

    public void commitStateTime(long now) {
        if (this.mCurCombinedState != -1) {
            long dur = now - this.mStartTime;
            if (dur > 0L) {
                this.mDurations.addDuration(this.mCurCombinedState, dur);
            }
            this.mTotalRunningDuration += now - this.mTotalRunningStartTime;
            this.mTotalRunningStartTime = now;
        }
        this.mStartTime = now;
    }

    public void incActiveServices(String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.incActiveServices(serviceName);
        }
        ++this.mNumActiveServices;
    }

    public void decActiveServices(String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.decActiveServices(serviceName);
        }
        --this.mNumActiveServices;
        if (this.mNumActiveServices < 0) {
            Slog.wtfStack(TAG, "Proc active services underrun: pkg=" + this.mPackage + " uid=" + this.mUid + " proc=" + this.mName + " service=" + serviceName);
            this.mNumActiveServices = 0;
        }
    }

    public void incStartedServices(int memFactor, long now, String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.incStartedServices(memFactor, now, serviceName);
        }
        ++this.mNumStartedServices;
        if (this.mNumStartedServices == 1 && this.mCurCombinedState == -1) {
            this.setCombinedState(6 + memFactor * 14, now);
        }
    }

    public void decStartedServices(int memFactor, long now, String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.decStartedServices(memFactor, now, serviceName);
        }
        --this.mNumStartedServices;
        if (this.mNumStartedServices == 0 && this.mCurCombinedState % 14 == 6) {
            this.setCombinedState(-1, now);
        } else if (this.mNumStartedServices < 0) {
            Slog.wtfStack(TAG, "Proc started services underrun: pkg=" + this.mPackage + " uid=" + this.mUid + " name=" + this.mName);
            this.mNumStartedServices = 0;
        }
    }

    public void addPss(long pss, long uss, long rss, boolean always, int type, long duration, ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList) {
        this.ensureNotDead();
        switch (type) {
            case 0: {
                ++this.mStats.mInternalSinglePssCount;
                this.mStats.mInternalSinglePssTime += duration;
                break;
            }
            case 1: {
                ++this.mStats.mInternalAllMemPssCount;
                this.mStats.mInternalAllMemPssTime += duration;
                break;
            }
            case 2: {
                ++this.mStats.mInternalAllPollPssCount;
                this.mStats.mInternalAllPollPssTime += duration;
                break;
            }
            case 3: {
                ++this.mStats.mExternalPssCount;
                this.mStats.mExternalPssTime += duration;
                break;
            }
            case 4: {
                ++this.mStats.mExternalSlowPssCount;
                this.mStats.mExternalSlowPssTime += duration;
            }
        }
        if (!always && this.mLastPssState == this.mCurCombinedState && SystemClock.uptimeMillis() < this.mLastPssTime + 30000L) {
            return;
        }
        this.mLastPssState = this.mCurCombinedState;
        this.mLastPssTime = SystemClock.uptimeMillis();
        if (this.mCurCombinedState != -1) {
            this.mCommonProcess.mPssTable.mergeStats(this.mCurCombinedState, 1, pss, pss, pss, uss, uss, uss, rss, rss, rss);
            PssTable.mergeStats(this.mCommonProcess.mTotalRunningPss, 0, 1, pss, pss, pss, uss, uss, uss, rss, rss, rss);
            if (!this.mCommonProcess.mMultiPackage) {
                return;
            }
            if (pkgList != null) {
                for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
                    ProcessState fixedProc = this.pullFixedProc(pkgList, ip);
                    fixedProc.mPssTable.mergeStats(this.mCurCombinedState, 1, pss, pss, pss, uss, uss, uss, rss, rss, rss);
                    PssTable.mergeStats(fixedProc.mTotalRunningPss, 0, 1, pss, pss, pss, uss, uss, uss, rss, rss, rss);
                }
            }
        }
    }

    public void reportExcessiveCpu(ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList) {
        this.ensureNotDead();
        ++this.mCommonProcess.mNumExcessiveCpu;
        if (!this.mCommonProcess.mMultiPackage) {
            return;
        }
        for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
            ++this.pullFixedProc(pkgList, (int)ip).mNumExcessiveCpu;
        }
    }

    private void addCachedKill(int num, long minPss, long avgPss, long maxPss) {
        if (this.mNumCachedKill <= 0) {
            this.mNumCachedKill = num;
            this.mMinCachedKillPss = minPss;
            this.mAvgCachedKillPss = avgPss;
            this.mMaxCachedKillPss = maxPss;
        } else {
            if (minPss < this.mMinCachedKillPss) {
                this.mMinCachedKillPss = minPss;
            }
            if (maxPss > this.mMaxCachedKillPss) {
                this.mMaxCachedKillPss = maxPss;
            }
            this.mAvgCachedKillPss = (long)(((double)this.mAvgCachedKillPss * (double)this.mNumCachedKill + (double)avgPss) / (double)(this.mNumCachedKill + num));
            this.mNumCachedKill += num;
        }
    }

    public void reportCachedKill(ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList, long pss) {
        this.ensureNotDead();
        this.mCommonProcess.addCachedKill(1, pss, pss, pss);
        if (!this.mCommonProcess.mMultiPackage) {
            return;
        }
        for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
            this.pullFixedProc(pkgList, ip).addCachedKill(1, pss, pss, pss);
        }
    }

    public ProcessState pullFixedProc(String pkgName) {
        if (this.mMultiPackage) {
            LongSparseArray<ProcessStats.PackageState> vpkg = this.mStats.mPackages.get(pkgName, this.mUid);
            if (vpkg == null) {
                throw new IllegalStateException("Didn't find package " + pkgName + " / " + this.mUid);
            }
            ProcessStats.PackageState pkg = vpkg.get(this.mVersion);
            if (pkg == null) {
                throw new IllegalStateException("Didn't find package " + pkgName + " / " + this.mUid + " vers " + this.mVersion);
            }
            ProcessState proc = pkg.mProcesses.get(this.mName);
            if (proc == null) {
                throw new IllegalStateException("Didn't create per-package process " + this.mName + " in pkg " + pkgName + " / " + this.mUid + " vers " + this.mVersion);
            }
            return proc;
        }
        return this;
    }

    private ProcessState pullFixedProc(ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList, int index) {
        ProcessStats.ProcessStateHolder holder = pkgList.valueAt(index);
        ProcessState proc = holder.state;
        if (this.mDead && proc.mCommonProcess != proc) {
            Log.wtf(TAG, "Pulling dead proc: name=" + this.mName + " pkg=" + this.mPackage + " uid=" + this.mUid + " common.name=" + this.mCommonProcess.mName);
            proc = this.mStats.getProcessStateLocked(proc.mPackage, proc.mUid, proc.mVersion, proc.mName);
        }
        if (proc.mMultiPackage) {
            LongSparseArray<ProcessStats.PackageState> vpkg = this.mStats.mPackages.get(pkgList.keyAt(index), proc.mUid);
            if (vpkg == null) {
                throw new IllegalStateException("No existing package " + pkgList.keyAt(index) + "/" + proc.mUid + " for multi-proc " + proc.mName);
            }
            ProcessStats.PackageState expkg = vpkg.get(proc.mVersion);
            if (expkg == null) {
                throw new IllegalStateException("No existing package " + pkgList.keyAt(index) + "/" + proc.mUid + " for multi-proc " + proc.mName + " version " + proc.mVersion);
            }
            String savedName = proc.mName;
            proc = expkg.mProcesses.get(proc.mName);
            if (proc == null) {
                throw new IllegalStateException("Didn't create per-package process " + savedName + " in pkg " + expkg.mPackageName + "/" + expkg.mUid);
            }
            holder.state = proc;
        }
        return proc;
    }

    public long getTotalRunningDuration(long now) {
        return this.mTotalRunningDuration + (this.mTotalRunningStartTime != 0L ? now - this.mTotalRunningStartTime : 0L);
    }

    public long getDuration(int state, long now) {
        long time = this.mDurations.getValueForId((byte)state);
        if (this.mCurCombinedState == state) {
            time += now - this.mStartTime;
        }
        return time;
    }

    public long getPssSampleCount(int state) {
        return this.mPssTable.getValueForId((byte)state, 0);
    }

    public long getPssMinimum(int state) {
        return this.mPssTable.getValueForId((byte)state, 1);
    }

    public long getPssAverage(int state) {
        return this.mPssTable.getValueForId((byte)state, 2);
    }

    public long getPssMaximum(int state) {
        return this.mPssTable.getValueForId((byte)state, 3);
    }

    public long getPssUssMinimum(int state) {
        return this.mPssTable.getValueForId((byte)state, 4);
    }

    public long getPssUssAverage(int state) {
        return this.mPssTable.getValueForId((byte)state, 5);
    }

    public long getPssUssMaximum(int state) {
        return this.mPssTable.getValueForId((byte)state, 6);
    }

    public long getPssRssMinimum(int state) {
        return this.mPssTable.getValueForId((byte)state, 7);
    }

    public long getPssRssAverage(int state) {
        return this.mPssTable.getValueForId((byte)state, 8);
    }

    public long getPssRssMaximum(int state) {
        return this.mPssTable.getValueForId((byte)state, 9);
    }

    public void aggregatePss(ProcessStats.TotalMemoryUseCollection data, long now) {
        PssAggr fgPss = new PssAggr();
        PssAggr bgPss = new PssAggr();
        PssAggr cachedPss = new PssAggr();
        boolean havePss = false;
        for (int i = 0; i < this.mDurations.getKeyCount(); ++i) {
            int key = this.mDurations.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            int procState = type % 14;
            long samples = this.getPssSampleCount(type);
            if (samples <= 0L) continue;
            long avg = this.getPssAverage(type);
            havePss = true;
            if (procState <= 2) {
                fgPss.add(avg, samples);
                continue;
            }
            if (procState <= 7) {
                bgPss.add(avg, samples);
                continue;
            }
            cachedPss.add(avg, samples);
        }
        if (!havePss) {
            return;
        }
        boolean fgHasBg = false;
        boolean fgHasCached = false;
        boolean bgHasCached = false;
        if (fgPss.samples < 3L && bgPss.samples > 0L) {
            fgHasBg = true;
            fgPss.add(bgPss.pss, bgPss.samples);
        }
        if (fgPss.samples < 3L && cachedPss.samples > 0L) {
            fgHasCached = true;
            fgPss.add(cachedPss.pss, cachedPss.samples);
        }
        if (bgPss.samples < 3L && cachedPss.samples > 0L) {
            bgHasCached = true;
            bgPss.add(cachedPss.pss, cachedPss.samples);
        }
        if (bgPss.samples < 3L && !fgHasBg && fgPss.samples > 0L) {
            bgPss.add(fgPss.pss, fgPss.samples);
        }
        if (cachedPss.samples < 3L && !bgHasCached && bgPss.samples > 0L) {
            cachedPss.add(bgPss.pss, bgPss.samples);
        }
        if (cachedPss.samples < 3L && !fgHasCached && fgPss.samples > 0L) {
            cachedPss.add(fgPss.pss, fgPss.samples);
        }
        for (int i = 0; i < this.mDurations.getKeyCount(); ++i) {
            long avg;
            int procState;
            int key = this.mDurations.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            long time = this.mDurations.getValue(key);
            if (this.mCurCombinedState == type) {
                time += now - this.mStartTime;
            }
            int n = procState = type % 14;
            data.processStateTime[n] = data.processStateTime[n] + time;
            long samples = this.getPssSampleCount(type);
            if (samples > 0L) {
                avg = this.getPssAverage(type);
            } else if (procState <= 2) {
                samples = fgPss.samples;
                avg = fgPss.pss;
            } else if (procState <= 7) {
                samples = bgPss.samples;
                avg = bgPss.pss;
            } else {
                samples = cachedPss.samples;
                avg = cachedPss.pss;
            }
            double newAvg = ((double)data.processStatePss[procState] * (double)data.processStateSamples[procState] + (double)avg * (double)samples) / (double)((long)data.processStateSamples[procState] + samples);
            data.processStatePss[procState] = (long)newAvg;
            int n2 = procState;
            data.processStateSamples[n2] = (int)((long)data.processStateSamples[n2] + samples);
            int n3 = procState;
            data.processStateWeight[n3] = data.processStateWeight[n3] + (double)avg * (double)time;
        }
    }

    public long computeProcessTimeLocked(int[] screenStates, int[] memStates, int[] procStates, long now) {
        long totalTime = 0L;
        for (int is = 0; is < screenStates.length; ++is) {
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int bucket = (screenStates[is] + memStates[im]) * 14 + procStates[ip];
                    totalTime += this.getDuration(bucket, now);
                }
            }
        }
        this.mTmpTotalTime = totalTime;
        return totalTime;
    }

    public void dumpSummary(PrintWriter pw, String prefix, String header, int[] screenStates, int[] memStates, int[] procStates, long now, long totalTime) {
        pw.print(prefix);
        pw.print("* ");
        if (header != null) {
            pw.print(header);
        }
        pw.print(this.mName);
        pw.print(" / ");
        UserHandle.formatUid(pw, this.mUid);
        pw.print(" / v");
        pw.print(this.mVersion);
        pw.println(":");
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABEL_TOTAL, screenStates, memStates, procStates, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABELS[0], screenStates, memStates, new int[]{0}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABELS[1], screenStates, memStates, new int[]{1}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABELS[2], screenStates, memStates, new int[]{2}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABELS[3], screenStates, memStates, new int[]{3}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABELS[4], screenStates, memStates, new int[]{4}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABELS[5], screenStates, memStates, new int[]{5}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABELS[6], screenStates, memStates, new int[]{6}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABELS[7], screenStates, memStates, new int[]{7}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABELS[8], screenStates, memStates, new int[]{8}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABELS[9], screenStates, memStates, new int[]{9}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABELS[10], screenStates, memStates, new int[]{10}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, DumpUtils.STATE_LABEL_CACHED, screenStates, memStates, new int[]{11, 12, 13}, now, totalTime, true);
    }

    public void dumpProcessState(PrintWriter pw, String prefix, int[] screenStates, int[] memStates, int[] procStates, long now) {
        long totalTime = 0L;
        int printedScreen = -1;
        for (int is = 0; is < screenStates.length; ++is) {
            int printedMem = -1;
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int iscreen = screenStates[is];
                    int imem = memStates[im];
                    int bucket = (iscreen + imem) * 14 + procStates[ip];
                    long time = this.mDurations.getValueForId((byte)bucket);
                    String running = "";
                    if (this.mCurCombinedState == bucket) {
                        running = " (running)";
                        time += now - this.mStartTime;
                    }
                    if (time == 0L) continue;
                    pw.print(prefix);
                    if (screenStates.length > 1) {
                        DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                        printedScreen = iscreen;
                    }
                    if (memStates.length > 1) {
                        DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '/');
                        printedMem = imem;
                    }
                    pw.print(DumpUtils.STATE_LABELS[procStates[ip]]);
                    pw.print(": ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println(running);
                    totalTime += time;
                }
            }
        }
        if (totalTime != 0L) {
            pw.print(prefix);
            if (screenStates.length > 1) {
                DumpUtils.printScreenLabel(pw, -1);
            }
            if (memStates.length > 1) {
                DumpUtils.printMemLabel(pw, -1, '/');
            }
            pw.print(DumpUtils.STATE_LABEL_TOTAL);
            pw.print(": ");
            TimeUtils.formatDuration(totalTime, pw);
            pw.println();
        }
    }

    public void dumpPss(PrintWriter pw, String prefix, int[] screenStates, int[] memStates, int[] procStates, long now) {
        boolean printedHeader = false;
        int printedScreen = -1;
        for (int is = 0; is < screenStates.length; ++is) {
            int printedMem = -1;
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int iscreen = screenStates[is];
                    int imem = memStates[im];
                    int bucket = (iscreen + imem) * 14 + procStates[ip];
                    int key = this.mPssTable.getKey((byte)bucket);
                    if (key == -1) continue;
                    long[] table = this.mPssTable.getArrayForKey(key);
                    int tableOffset = SparseMappingTable.getIndexFromKey(key);
                    if (!printedHeader) {
                        pw.print(prefix);
                        pw.print("PSS/USS (");
                        pw.print(this.mPssTable.getKeyCount());
                        pw.println(" entries):");
                        printedHeader = true;
                    }
                    pw.print(prefix);
                    pw.print("  ");
                    if (screenStates.length > 1) {
                        DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                        printedScreen = iscreen;
                    }
                    if (memStates.length > 1) {
                        DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '/');
                        printedMem = imem;
                    }
                    pw.print(DumpUtils.STATE_LABELS[procStates[ip]]);
                    pw.print(": ");
                    ProcessState.dumpPssSamples(pw, table, tableOffset);
                    pw.println();
                }
            }
        }
        long totalRunningDuration = this.getTotalRunningDuration(now);
        if (totalRunningDuration != 0L) {
            pw.print(prefix);
            pw.print("Cur time ");
            TimeUtils.formatDuration(totalRunningDuration, pw);
            if (this.mTotalRunningStartTime != 0L) {
                pw.print(" (running)");
            }
            if (this.mTotalRunningPss[0] != 0L) {
                pw.print(": ");
                ProcessState.dumpPssSamples(pw, this.mTotalRunningPss, 0);
            }
            pw.println();
        }
        if (this.mNumExcessiveCpu != 0) {
            pw.print(prefix);
            pw.print("Killed for excessive CPU use: ");
            pw.print(this.mNumExcessiveCpu);
            pw.println(" times");
        }
        if (this.mNumCachedKill != 0) {
            pw.print(prefix);
            pw.print("Killed from cached state: ");
            pw.print(this.mNumCachedKill);
            pw.print(" times from pss ");
            DebugUtils.printSizeValue(pw, this.mMinCachedKillPss * 1024L);
            pw.print("-");
            DebugUtils.printSizeValue(pw, this.mAvgCachedKillPss * 1024L);
            pw.print("-");
            DebugUtils.printSizeValue(pw, this.mMaxCachedKillPss * 1024L);
            pw.println();
        }
    }

    public static void dumpPssSamples(PrintWriter pw, long[] table, int offset) {
        DebugUtils.printSizeValue(pw, table[offset + 1] * 1024L);
        pw.print("-");
        DebugUtils.printSizeValue(pw, table[offset + 2] * 1024L);
        pw.print("-");
        DebugUtils.printSizeValue(pw, table[offset + 3] * 1024L);
        pw.print("/");
        DebugUtils.printSizeValue(pw, table[offset + 4] * 1024L);
        pw.print("-");
        DebugUtils.printSizeValue(pw, table[offset + 5] * 1024L);
        pw.print("-");
        DebugUtils.printSizeValue(pw, table[offset + 6] * 1024L);
        pw.print("/");
        DebugUtils.printSizeValue(pw, table[offset + 7] * 1024L);
        pw.print("-");
        DebugUtils.printSizeValue(pw, table[offset + 8] * 1024L);
        pw.print("-");
        DebugUtils.printSizeValue(pw, table[offset + 9] * 1024L);
        pw.print(" over ");
        pw.print(table[offset + 0]);
    }

    private void dumpProcessSummaryDetails(PrintWriter pw, String prefix, String label, int[] screenStates, int[] memStates, int[] procStates, long now, long totalTime, boolean full) {
        ProcessStats.ProcessDataCollection totals = new ProcessStats.ProcessDataCollection(screenStates, memStates, procStates);
        this.computeProcessData(totals, now);
        double percentage = (double)totals.totalTime / (double)totalTime * 100.0;
        if (percentage >= 0.005 || totals.numPss != 0L) {
            if (prefix != null) {
                pw.print(prefix);
            }
            if (label != null) {
                pw.print("  ");
                pw.print(label);
                pw.print(": ");
            }
            totals.print(pw, totalTime, full);
            if (prefix != null) {
                pw.println();
            }
        }
    }

    public void dumpInternalLocked(PrintWriter pw, String prefix, boolean dumpAll) {
        if (dumpAll) {
            pw.print(prefix);
            pw.print("myID=");
            pw.print(Integer.toHexString(System.identityHashCode(this)));
            pw.print(" mCommonProcess=");
            pw.print(Integer.toHexString(System.identityHashCode(this.mCommonProcess)));
            pw.print(" mPackage=");
            pw.println(this.mPackage);
            if (this.mMultiPackage) {
                pw.print(prefix);
                pw.print("mMultiPackage=");
                pw.println(this.mMultiPackage);
            }
            if (this != this.mCommonProcess) {
                pw.print(prefix);
                pw.print("Common Proc: ");
                pw.print(this.mCommonProcess.mName);
                pw.print("/");
                pw.print(this.mCommonProcess.mUid);
                pw.print(" pkg=");
                pw.println(this.mCommonProcess.mPackage);
            }
        }
        if (this.mActive) {
            pw.print(prefix);
            pw.print("mActive=");
            pw.println(this.mActive);
        }
        if (this.mDead) {
            pw.print(prefix);
            pw.print("mDead=");
            pw.println(this.mDead);
        }
        if (this.mNumActiveServices != 0 || this.mNumStartedServices != 0) {
            pw.print(prefix);
            pw.print("mNumActiveServices=");
            pw.print(this.mNumActiveServices);
            pw.print(" mNumStartedServices=");
            pw.println(this.mNumStartedServices);
        }
    }

    public void computeProcessData(ProcessStats.ProcessDataCollection data, long now) {
        data.totalTime = 0L;
        data.maxRss = 0L;
        data.avgRss = 0L;
        data.minRss = 0L;
        data.maxUss = 0L;
        data.avgUss = 0L;
        data.minUss = 0L;
        data.maxPss = 0L;
        data.avgPss = 0L;
        data.minPss = 0L;
        data.numPss = 0L;
        for (int is = 0; is < data.screenStates.length; ++is) {
            for (int im = 0; im < data.memStates.length; ++im) {
                for (int ip = 0; ip < data.procStates.length; ++ip) {
                    int bucket = (data.screenStates[is] + data.memStates[im]) * 14 + data.procStates[ip];
                    data.totalTime += this.getDuration(bucket, now);
                    long samples = this.getPssSampleCount(bucket);
                    if (samples <= 0L) continue;
                    long minPss = this.getPssMinimum(bucket);
                    long avgPss = this.getPssAverage(bucket);
                    long maxPss = this.getPssMaximum(bucket);
                    long minUss = this.getPssUssMinimum(bucket);
                    long avgUss = this.getPssUssAverage(bucket);
                    long maxUss = this.getPssUssMaximum(bucket);
                    long minRss = this.getPssRssMinimum(bucket);
                    long avgRss = this.getPssRssAverage(bucket);
                    long maxRss = this.getPssRssMaximum(bucket);
                    if (data.numPss == 0L) {
                        data.minPss = minPss;
                        data.avgPss = avgPss;
                        data.maxPss = maxPss;
                        data.minUss = minUss;
                        data.avgUss = avgUss;
                        data.maxUss = maxUss;
                        data.minRss = minRss;
                        data.avgRss = avgRss;
                        data.maxRss = maxRss;
                    } else {
                        if (minPss < data.minPss) {
                            data.minPss = minPss;
                        }
                        data.avgPss = (long)(((double)data.avgPss * (double)data.numPss + (double)avgPss * (double)samples) / (double)(data.numPss + samples));
                        if (maxPss > data.maxPss) {
                            data.maxPss = maxPss;
                        }
                        if (minUss < data.minUss) {
                            data.minUss = minUss;
                        }
                        data.avgUss = (long)(((double)data.avgUss * (double)data.numPss + (double)avgUss * (double)samples) / (double)(data.numPss + samples));
                        if (maxUss > data.maxUss) {
                            data.maxUss = maxUss;
                        }
                        if (minRss < data.minRss) {
                            data.minRss = minRss;
                        }
                        data.avgRss = (long)(((double)data.avgRss * (double)data.numPss + (double)avgRss * (double)samples) / (double)(data.numPss + samples));
                        if (maxRss > data.maxRss) {
                            data.maxRss = maxRss;
                        }
                    }
                    data.numPss += samples;
                }
            }
        }
    }

    public void dumpCsv(PrintWriter pw, boolean sepScreenStates, int[] screenStates, boolean sepMemStates, int[] memStates, boolean sepProcStates, int[] procStates, long now) {
        int NSS = sepScreenStates ? screenStates.length : 1;
        int NMS = sepMemStates ? memStates.length : 1;
        int NPS = sepProcStates ? procStates.length : 1;
        for (int iss = 0; iss < NSS; ++iss) {
            for (int ims = 0; ims < NMS; ++ims) {
                for (int ips = 0; ips < NPS; ++ips) {
                    int vsscreen = sepScreenStates ? screenStates[iss] : 0;
                    int vsmem = sepMemStates ? memStates[ims] : 0;
                    int vsproc = sepProcStates ? procStates[ips] : 0;
                    int NSA = sepScreenStates ? 1 : screenStates.length;
                    int NMA = sepMemStates ? 1 : memStates.length;
                    int NPA = sepProcStates ? 1 : procStates.length;
                    long totalTime = 0L;
                    for (int isa = 0; isa < NSA; ++isa) {
                        for (int ima = 0; ima < NMA; ++ima) {
                            for (int ipa = 0; ipa < NPA; ++ipa) {
                                int vascreen = sepScreenStates ? 0 : screenStates[isa];
                                int vamem = sepMemStates ? 0 : memStates[ima];
                                int vaproc = sepProcStates ? 0 : procStates[ipa];
                                int bucket = (vsscreen + vascreen + vsmem + vamem) * 14 + vsproc + vaproc;
                                totalTime += this.getDuration(bucket, now);
                            }
                        }
                    }
                    pw.print("\t");
                    pw.print(totalTime);
                }
            }
        }
    }

    public void dumpPackageProcCheckin(PrintWriter pw, String pkgName, int uid, long vers, String itemName, long now) {
        pw.print("pkgproc,");
        pw.print(pkgName);
        pw.print(",");
        pw.print(uid);
        pw.print(",");
        pw.print(vers);
        pw.print(",");
        pw.print(DumpUtils.collapseString(pkgName, itemName));
        this.dumpAllStateCheckin(pw, now);
        pw.println();
        if (this.mPssTable.getKeyCount() > 0) {
            pw.print("pkgpss,");
            pw.print(pkgName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print(vers);
            pw.print(",");
            pw.print(DumpUtils.collapseString(pkgName, itemName));
            this.dumpAllPssCheckin(pw);
            pw.println();
        }
        if (this.mTotalRunningPss[0] != 0L) {
            pw.print("pkgrun,");
            pw.print(pkgName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print(vers);
            pw.print(",");
            pw.print(DumpUtils.collapseString(pkgName, itemName));
            pw.print(",");
            pw.print(this.getTotalRunningDuration(now));
            pw.print(",");
            ProcessState.dumpPssSamplesCheckin(pw, this.mTotalRunningPss, 0);
            pw.println();
        }
        if (this.mNumExcessiveCpu > 0 || this.mNumCachedKill > 0) {
            pw.print("pkgkills,");
            pw.print(pkgName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print(vers);
            pw.print(",");
            pw.print(DumpUtils.collapseString(pkgName, itemName));
            pw.print(",");
            pw.print("0");
            pw.print(",");
            pw.print(this.mNumExcessiveCpu);
            pw.print(",");
            pw.print(this.mNumCachedKill);
            pw.print(",");
            pw.print(this.mMinCachedKillPss);
            pw.print(":");
            pw.print(this.mAvgCachedKillPss);
            pw.print(":");
            pw.print(this.mMaxCachedKillPss);
            pw.println();
        }
    }

    public void dumpProcCheckin(PrintWriter pw, String procName, int uid, long now) {
        if (this.mDurations.getKeyCount() > 0) {
            pw.print("proc,");
            pw.print(procName);
            pw.print(",");
            pw.print(uid);
            this.dumpAllStateCheckin(pw, now);
            pw.println();
        }
        if (this.mPssTable.getKeyCount() > 0) {
            pw.print("pss,");
            pw.print(procName);
            pw.print(",");
            pw.print(uid);
            this.dumpAllPssCheckin(pw);
            pw.println();
        }
        if (this.mTotalRunningPss[0] != 0L) {
            pw.print("procrun,");
            pw.print(procName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print(this.getTotalRunningDuration(now));
            pw.print(",");
            ProcessState.dumpPssSamplesCheckin(pw, this.mTotalRunningPss, 0);
            pw.println();
        }
        if (this.mNumExcessiveCpu > 0 || this.mNumCachedKill > 0) {
            pw.print("kills,");
            pw.print(procName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print("0");
            pw.print(",");
            pw.print(this.mNumExcessiveCpu);
            pw.print(",");
            pw.print(this.mNumCachedKill);
            pw.print(",");
            pw.print(this.mMinCachedKillPss);
            pw.print(":");
            pw.print(this.mAvgCachedKillPss);
            pw.print(":");
            pw.print(this.mMaxCachedKillPss);
            pw.println();
        }
    }

    public void dumpAllStateCheckin(PrintWriter pw, long now) {
        boolean didCurState = false;
        for (int i = 0; i < this.mDurations.getKeyCount(); ++i) {
            int key = this.mDurations.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            long time = this.mDurations.getValue(key);
            if (this.mCurCombinedState == type) {
                didCurState = true;
                time += now - this.mStartTime;
            }
            DumpUtils.printProcStateTagAndValue(pw, type, time);
        }
        if (!didCurState && this.mCurCombinedState != -1) {
            DumpUtils.printProcStateTagAndValue(pw, this.mCurCombinedState, now - this.mStartTime);
        }
    }

    public void dumpAllPssCheckin(PrintWriter pw) {
        int N = this.mPssTable.getKeyCount();
        for (int i = 0; i < N; ++i) {
            int key = this.mPssTable.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            pw.print(',');
            DumpUtils.printProcStateTag(pw, type);
            pw.print(':');
            ProcessState.dumpPssSamplesCheckin(pw, this.mPssTable.getArrayForKey(key), SparseMappingTable.getIndexFromKey(key));
        }
    }

    public static void dumpPssSamplesCheckin(PrintWriter pw, long[] table, int offset) {
        pw.print(table[offset + 0]);
        pw.print(':');
        pw.print(table[offset + 1]);
        pw.print(':');
        pw.print(table[offset + 2]);
        pw.print(':');
        pw.print(table[offset + 3]);
        pw.print(':');
        pw.print(table[offset + 4]);
        pw.print(':');
        pw.print(table[offset + 5]);
        pw.print(':');
        pw.print(table[offset + 6]);
        pw.print(':');
        pw.print(table[offset + 7]);
        pw.print(':');
        pw.print(table[offset + 8]);
        pw.print(':');
        pw.print(table[offset + 9]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ProcessState{").append(Integer.toHexString(System.identityHashCode(this))).append(" ").append(this.mName).append("/").append(this.mUid).append(" pkg=").append(this.mPackage);
        if (this.mMultiPackage) {
            sb.append(" (multi)");
        }
        if (this.mCommonProcess != this) {
            sb.append(" (sub)");
        }
        sb.append("}");
        return sb.toString();
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId, String procName, int uid, long now) {
        byte type;
        int key;
        int i;
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, procName);
        proto.write(1120986464258L, uid);
        if (this.mNumExcessiveCpu > 0 || this.mNumCachedKill > 0) {
            long killToken = proto.start(1146756268035L);
            proto.write(0x10500000001L, this.mNumExcessiveCpu);
            proto.write(1120986464258L, this.mNumCachedKill);
            ProtoUtils.toAggStatsProto(proto, 1146756268035L, this.mMinCachedKillPss, this.mAvgCachedKillPss, this.mMaxCachedKillPss);
            proto.end(killToken);
        }
        SparseLongArray durationByState = new SparseLongArray();
        boolean didCurState = false;
        for (i = 0; i < this.mDurations.getKeyCount(); ++i) {
            key = this.mDurations.getKeyAt(i);
            type = SparseMappingTable.getIdFromKey(key);
            long time = this.mDurations.getValue(key);
            if (this.mCurCombinedState == type) {
                didCurState = true;
                time += now - this.mStartTime;
            }
            durationByState.put(type, time);
        }
        if (!didCurState && this.mCurCombinedState != -1) {
            durationByState.put(this.mCurCombinedState, now - this.mStartTime);
        }
        for (i = 0; i < this.mPssTable.getKeyCount(); ++i) {
            key = this.mPssTable.getKeyAt(i);
            type = SparseMappingTable.getIdFromKey(key);
            if (durationByState.indexOfKey(type) < 0) continue;
            long stateToken = proto.start(2246267895813L);
            DumpUtils.printProcStateTagProto(proto, 0x10E00000001L, 1159641169922L, 1159641169923L, type);
            long duration = durationByState.get(type);
            durationByState.delete(type);
            proto.write(1112396529668L, duration);
            this.mPssTable.writeStatsToProtoForKey(proto, key);
            proto.end(stateToken);
        }
        for (i = 0; i < durationByState.size(); ++i) {
            long stateToken = proto.start(2246267895813L);
            DumpUtils.printProcStateTagProto(proto, 0x10E00000001L, 1159641169922L, 1159641169923L, durationByState.keyAt(i));
            proto.write(1112396529668L, durationByState.valueAt(i));
            proto.end(stateToken);
        }
        long totalRunningDuration = this.getTotalRunningDuration(now);
        if (totalRunningDuration > 0L) {
            long stateToken = proto.start(1146756268038L);
            proto.write(1112396529668L, totalRunningDuration);
            if (this.mTotalRunningPss[0] != 0L) {
                PssTable.writeStatsToProto(proto, this.mTotalRunningPss, 0);
            }
            proto.end(stateToken);
        }
        proto.end(token);
    }

    static class PssAggr {
        long pss = 0L;
        long samples = 0L;

        PssAggr() {
        }

        void add(long newPss, long newSamples) {
            this.pss = (long)((double)this.pss * (double)this.samples + (double)newPss * (double)newSamples) / (this.samples + newSamples);
            this.samples += newSamples;
        }
    }
}

