/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.Parcel;
import android.os.SystemClock;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.app.procstats.DumpUtils;
import com.android.internal.app.procstats.DurationsTable;
import com.android.internal.app.procstats.ProcessState;
import com.android.internal.app.procstats.ProcessStats;
import com.android.internal.app.procstats.SparseMappingTable;
import java.io.PrintWriter;

public final class ServiceState {
    private static final String TAG = "ProcessStats";
    private static final boolean DEBUG = false;
    public static final int SERVICE_RUN = 0;
    public static final int SERVICE_STARTED = 1;
    public static final int SERVICE_BOUND = 2;
    public static final int SERVICE_EXEC = 3;
    public static final int SERVICE_FOREGROUND = 4;
    public static final int SERVICE_COUNT = 5;
    private final String mPackage;
    private final String mProcessName;
    private final String mName;
    private final DurationsTable mDurations;
    private ProcessState mProc;
    private Object mOwner;
    private int mRunCount;
    private int mRunState = -1;
    private long mRunStartTime;
    private boolean mStarted;
    private boolean mRestarting;
    private int mStartedCount;
    private int mStartedState = -1;
    private long mStartedStartTime;
    private int mBoundCount;
    private int mBoundState = -1;
    private long mBoundStartTime;
    private int mExecCount;
    private int mExecState = -1;
    private long mExecStartTime;
    private int mForegroundCount;
    private int mForegroundState = -1;
    private long mForegroundStartTime;

    public ServiceState(ProcessStats processStats, String pkg, String name, String processName, ProcessState proc) {
        this.mPackage = pkg;
        this.mName = name;
        this.mProcessName = processName;
        this.mProc = proc;
        this.mDurations = new DurationsTable(processStats.mTableData);
    }

    public String getPackage() {
        return this.mPackage;
    }

    public String getProcessName() {
        return this.mProcessName;
    }

    public String getName() {
        return this.mName;
    }

    public ProcessState getProcess() {
        return this.mProc;
    }

    public void setProcess(ProcessState proc) {
        this.mProc = proc;
    }

    public void setMemFactor(int memFactor, long now) {
        if (this.isRestarting()) {
            this.setRestarting(true, memFactor, now);
        } else if (this.isInUse()) {
            if (this.mStartedState != -1) {
                this.setStarted(true, memFactor, now);
            }
            if (this.mBoundState != -1) {
                this.setBound(true, memFactor, now);
            }
            if (this.mExecState != -1) {
                this.setExecuting(true, memFactor, now);
            }
            if (this.mForegroundState != -1) {
                this.setForeground(true, memFactor, now);
            }
        }
    }

    public void applyNewOwner(Object newOwner) {
        if (this.mOwner != newOwner) {
            if (this.mOwner == null) {
                this.mOwner = newOwner;
                this.mProc.incActiveServices(this.mName);
            } else {
                this.mOwner = newOwner;
                if (this.mStarted || this.mBoundState != -1 || this.mExecState != -1 || this.mForegroundState != -1) {
                    long now = SystemClock.uptimeMillis();
                    if (this.mStarted) {
                        this.setStarted(false, 0, now);
                    }
                    if (this.mBoundState != -1) {
                        this.setBound(false, 0, now);
                    }
                    if (this.mExecState != -1) {
                        this.setExecuting(false, 0, now);
                    }
                    if (this.mForegroundState != -1) {
                        this.setForeground(false, 0, now);
                    }
                }
            }
        }
    }

    public void clearCurrentOwner(Object owner, boolean silently) {
        if (this.mOwner == owner) {
            this.mProc.decActiveServices(this.mName);
            if (this.mStarted || this.mBoundState != -1 || this.mExecState != -1 || this.mForegroundState != -1) {
                long now = SystemClock.uptimeMillis();
                if (this.mStarted) {
                    if (!silently) {
                        Slog.wtfStack(TAG, "Service owner " + owner + " cleared while started: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                    }
                    this.setStarted(false, 0, now);
                }
                if (this.mBoundState != -1) {
                    if (!silently) {
                        Slog.wtfStack(TAG, "Service owner " + owner + " cleared while bound: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                    }
                    this.setBound(false, 0, now);
                }
                if (this.mExecState != -1) {
                    if (!silently) {
                        Slog.wtfStack(TAG, "Service owner " + owner + " cleared while exec: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                    }
                    this.setExecuting(false, 0, now);
                }
                if (this.mForegroundState != -1) {
                    if (!silently) {
                        Slog.wtfStack(TAG, "Service owner " + owner + " cleared while foreground: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                    }
                    this.setForeground(false, 0, now);
                }
            }
            this.mOwner = null;
        }
    }

    public boolean isInUse() {
        return this.mOwner != null || this.mRestarting;
    }

    public boolean isRestarting() {
        return this.mRestarting;
    }

    public void add(ServiceState other) {
        this.mDurations.addDurations(other.mDurations);
        this.mRunCount += other.mRunCount;
        this.mStartedCount += other.mStartedCount;
        this.mBoundCount += other.mBoundCount;
        this.mExecCount += other.mExecCount;
        this.mForegroundCount += other.mForegroundCount;
    }

    public void resetSafely(long now) {
        this.mDurations.resetTable();
        this.mRunCount = this.mRunState != -1 ? 1 : 0;
        this.mStartedCount = this.mStartedState != -1 ? 1 : 0;
        this.mBoundCount = this.mBoundState != -1 ? 1 : 0;
        this.mExecCount = this.mExecState != -1 ? 1 : 0;
        this.mForegroundCount = this.mForegroundState != -1 ? 1 : 0;
        this.mExecStartTime = this.mForegroundStartTime = now;
        this.mBoundStartTime = this.mForegroundStartTime;
        this.mStartedStartTime = this.mForegroundStartTime;
        this.mRunStartTime = this.mForegroundStartTime;
    }

    public void writeToParcel(Parcel out, long now) {
        this.mDurations.writeToParcel(out);
        out.writeInt(this.mRunCount);
        out.writeInt(this.mStartedCount);
        out.writeInt(this.mBoundCount);
        out.writeInt(this.mExecCount);
        out.writeInt(this.mForegroundCount);
    }

    public boolean readFromParcel(Parcel in) {
        if (!this.mDurations.readFromParcel(in)) {
            return false;
        }
        this.mRunCount = in.readInt();
        this.mStartedCount = in.readInt();
        this.mBoundCount = in.readInt();
        this.mExecCount = in.readInt();
        this.mForegroundCount = in.readInt();
        return true;
    }

    public void commitStateTime(long now) {
        if (this.mRunState != -1) {
            this.mDurations.addDuration(0 + this.mRunState * 5, now - this.mRunStartTime);
            this.mRunStartTime = now;
        }
        if (this.mStartedState != -1) {
            this.mDurations.addDuration(1 + this.mStartedState * 5, now - this.mStartedStartTime);
            this.mStartedStartTime = now;
        }
        if (this.mBoundState != -1) {
            this.mDurations.addDuration(2 + this.mBoundState * 5, now - this.mBoundStartTime);
            this.mBoundStartTime = now;
        }
        if (this.mExecState != -1) {
            this.mDurations.addDuration(3 + this.mExecState * 5, now - this.mExecStartTime);
            this.mExecStartTime = now;
        }
        if (this.mForegroundState != -1) {
            this.mDurations.addDuration(4 + this.mForegroundState * 5, now - this.mForegroundStartTime);
            this.mForegroundStartTime = now;
        }
    }

    private void updateRunning(int memFactor, long now) {
        int state;
        int n = state = this.mStartedState != -1 || this.mBoundState != -1 || this.mExecState != -1 || this.mForegroundState != -1 ? memFactor : -1;
        if (this.mRunState != state) {
            if (this.mRunState != -1) {
                this.mDurations.addDuration(0 + this.mRunState * 5, now - this.mRunStartTime);
            } else if (state != -1) {
                ++this.mRunCount;
            }
            this.mRunState = state;
            this.mRunStartTime = now;
        }
    }

    public void setStarted(boolean started, int memFactor, long now) {
        if (this.mOwner == null) {
            Slog.wtf(TAG, "Starting service " + this + " without owner");
        }
        this.mStarted = started;
        this.updateStartedState(memFactor, now);
    }

    public void setRestarting(boolean restarting, int memFactor, long now) {
        this.mRestarting = restarting;
        this.updateStartedState(memFactor, now);
    }

    public void updateStartedState(int memFactor, long now) {
        int state;
        boolean wasStarted = this.mStartedState != -1;
        boolean started = this.mStarted || this.mRestarting;
        int n = state = started ? memFactor : -1;
        if (this.mStartedState != state) {
            if (this.mStartedState != -1) {
                this.mDurations.addDuration(1 + this.mStartedState * 5, now - this.mStartedStartTime);
            } else if (started) {
                ++this.mStartedCount;
            }
            this.mStartedState = state;
            this.mStartedStartTime = now;
            this.mProc = this.mProc.pullFixedProc(this.mPackage);
            if (wasStarted != started) {
                if (started) {
                    this.mProc.incStartedServices(memFactor, now, this.mName);
                } else {
                    this.mProc.decStartedServices(memFactor, now, this.mName);
                }
            }
            this.updateRunning(memFactor, now);
        }
    }

    public void setBound(boolean bound, int memFactor, long now) {
        int state;
        if (this.mOwner == null) {
            Slog.wtf(TAG, "Binding service " + this + " without owner");
        }
        int n = state = bound ? memFactor : -1;
        if (this.mBoundState != state) {
            if (this.mBoundState != -1) {
                this.mDurations.addDuration(2 + this.mBoundState * 5, now - this.mBoundStartTime);
            } else if (bound) {
                ++this.mBoundCount;
            }
            this.mBoundState = state;
            this.mBoundStartTime = now;
            this.updateRunning(memFactor, now);
        }
    }

    public void setExecuting(boolean executing, int memFactor, long now) {
        int state;
        if (this.mOwner == null) {
            Slog.wtf(TAG, "Executing service " + this + " without owner");
        }
        int n = state = executing ? memFactor : -1;
        if (this.mExecState != state) {
            if (this.mExecState != -1) {
                this.mDurations.addDuration(3 + this.mExecState * 5, now - this.mExecStartTime);
            } else if (executing) {
                ++this.mExecCount;
            }
            this.mExecState = state;
            this.mExecStartTime = now;
            this.updateRunning(memFactor, now);
        }
    }

    public void setForeground(boolean foreground, int memFactor, long now) {
        int state;
        if (this.mOwner == null) {
            Slog.wtf(TAG, "Foregrounding service " + this + " without owner");
        }
        int n = state = foreground ? memFactor : -1;
        if (this.mForegroundState != state) {
            if (this.mForegroundState != -1) {
                this.mDurations.addDuration(4 + this.mForegroundState * 5, now - this.mForegroundStartTime);
            } else if (foreground) {
                ++this.mForegroundCount;
            }
            this.mForegroundState = state;
            this.mForegroundStartTime = now;
            this.updateRunning(memFactor, now);
        }
    }

    public long getDuration(int opType, int curState, long startTime, int memFactor, long now) {
        int state = opType + memFactor * 5;
        long time = this.mDurations.getValueForId((byte)state);
        if (curState == memFactor) {
            time += now - startTime;
        }
        return time;
    }

    public void dumpStats(PrintWriter pw, String prefix, String prefixInner, String headerPrefix, long now, long totalTime, boolean dumpSummary, boolean dumpAll) {
        this.dumpStats(pw, prefix, prefixInner, headerPrefix, "Running", this.mRunCount, 0, this.mRunState, this.mRunStartTime, now, totalTime, !dumpSummary || dumpAll);
        this.dumpStats(pw, prefix, prefixInner, headerPrefix, "Started", this.mStartedCount, 1, this.mStartedState, this.mStartedStartTime, now, totalTime, !dumpSummary || dumpAll);
        this.dumpStats(pw, prefix, prefixInner, headerPrefix, "Foreground", this.mForegroundCount, 4, this.mForegroundState, this.mForegroundStartTime, now, totalTime, !dumpSummary || dumpAll);
        this.dumpStats(pw, prefix, prefixInner, headerPrefix, "Bound", this.mBoundCount, 2, this.mBoundState, this.mBoundStartTime, now, totalTime, !dumpSummary || dumpAll);
        this.dumpStats(pw, prefix, prefixInner, headerPrefix, "Executing", this.mExecCount, 3, this.mExecState, this.mExecStartTime, now, totalTime, !dumpSummary || dumpAll);
        if (dumpAll) {
            if (this.mOwner != null) {
                pw.print("        mOwner=");
                pw.println(this.mOwner);
            }
            if (this.mStarted || this.mRestarting) {
                pw.print("        mStarted=");
                pw.print(this.mStarted);
                pw.print(" mRestarting=");
                pw.println(this.mRestarting);
            }
        }
    }

    private void dumpStats(PrintWriter pw, String prefix, String prefixInner, String headerPrefix, String header, int count, int serviceType, int state, long startTime, long now, long totalTime, boolean dumpAll) {
        if (count != 0) {
            if (dumpAll) {
                pw.print(prefix);
                pw.print(header);
                pw.print(" op count ");
                pw.print(count);
                pw.println(":");
                this.dumpTime(pw, prefixInner, serviceType, state, startTime, now);
            } else {
                boolean isRunning;
                long myTime = this.dumpTimeInternal(null, null, serviceType, state, startTime, now, true);
                pw.print(prefix);
                pw.print(headerPrefix);
                pw.print(header);
                pw.print(" count ");
                pw.print(count);
                pw.print(" / time ");
                boolean bl = isRunning = myTime < 0L;
                if (isRunning) {
                    myTime = -myTime;
                }
                DumpUtils.printPercent(pw, (double)myTime / (double)totalTime);
                if (isRunning) {
                    pw.print(" (running)");
                }
                pw.println();
            }
        }
    }

    public long dumpTime(PrintWriter pw, String prefix, int serviceType, int curState, long curStartTime, long now) {
        return this.dumpTimeInternal(pw, prefix, serviceType, curState, curStartTime, now, false);
    }

    long dumpTimeInternal(PrintWriter pw, String prefix, int serviceType, int curState, long curStartTime, long now, boolean negativeIfRunning) {
        long totalTime = 0L;
        int printedScreen = -1;
        boolean isRunning = false;
        for (int iscreen = 0; iscreen < 8; iscreen += 4) {
            int printedMem = -1;
            for (int imem = 0; imem < 4; ++imem) {
                int state = imem + iscreen;
                long time = this.getDuration(serviceType, curState, curStartTime, state, now);
                String running = "";
                if (curState == state && pw != null) {
                    running = " (running)";
                    isRunning = true;
                }
                if (time == 0L) continue;
                if (pw != null) {
                    pw.print(prefix);
                    DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                    printedScreen = iscreen;
                    DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '\u0000');
                    printedMem = imem;
                    pw.print(": ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println(running);
                }
                totalTime += time;
            }
        }
        if (totalTime != 0L && pw != null) {
            pw.print(prefix);
            pw.print("    TOTAL: ");
            TimeUtils.formatDuration(totalTime, pw);
            pw.println();
        }
        return isRunning && negativeIfRunning ? -totalTime : totalTime;
    }

    public void dumpTimesCheckin(PrintWriter pw, String pkgName, int uid, long vers, String serviceName, long now) {
        this.dumpTimeCheckin(pw, "pkgsvc-run", pkgName, uid, vers, serviceName, 0, this.mRunCount, this.mRunState, this.mRunStartTime, now);
        this.dumpTimeCheckin(pw, "pkgsvc-start", pkgName, uid, vers, serviceName, 1, this.mStartedCount, this.mStartedState, this.mStartedStartTime, now);
        this.dumpTimeCheckin(pw, "pkgsvc-fg", pkgName, uid, vers, serviceName, 4, this.mForegroundCount, this.mForegroundState, this.mForegroundStartTime, now);
        this.dumpTimeCheckin(pw, "pkgsvc-bound", pkgName, uid, vers, serviceName, 2, this.mBoundCount, this.mBoundState, this.mBoundStartTime, now);
        this.dumpTimeCheckin(pw, "pkgsvc-exec", pkgName, uid, vers, serviceName, 3, this.mExecCount, this.mExecState, this.mExecStartTime, now);
    }

    private void dumpTimeCheckin(PrintWriter pw, String label, String packageName, int uid, long vers, String serviceName, int serviceType, int opCount, int curState, long curStartTime, long now) {
        if (opCount <= 0) {
            return;
        }
        pw.print(label);
        pw.print(",");
        pw.print(packageName);
        pw.print(",");
        pw.print(uid);
        pw.print(",");
        pw.print(vers);
        pw.print(",");
        pw.print(serviceName);
        pw.print(",");
        pw.print(opCount);
        boolean didCurState = false;
        int N = this.mDurations.getKeyCount();
        for (int i = 0; i < N; ++i) {
            int key = this.mDurations.getKeyAt(i);
            long time = this.mDurations.getValue(key);
            int type = SparseMappingTable.getIdFromKey(key);
            int memFactor = type / 5;
            if ((type %= 5) != serviceType) continue;
            if (curState == memFactor) {
                didCurState = true;
                time += now - curStartTime;
            }
            DumpUtils.printAdjTagAndValue(pw, memFactor, time);
        }
        if (!didCurState && curState != -1) {
            DumpUtils.printAdjTagAndValue(pw, curState, now - curStartTime);
        }
        pw.println();
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId, long now) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.mName);
        this.writeTypeToProto(proto, 0x20B00000002L, 1, 0, this.mRunCount, this.mRunState, this.mRunStartTime, now);
        this.writeTypeToProto(proto, 0x20B00000002L, 2, 1, this.mStartedCount, this.mStartedState, this.mStartedStartTime, now);
        this.writeTypeToProto(proto, 0x20B00000002L, 3, 4, this.mForegroundCount, this.mForegroundState, this.mForegroundStartTime, now);
        this.writeTypeToProto(proto, 0x20B00000002L, 4, 2, this.mBoundCount, this.mBoundState, this.mBoundStartTime, now);
        this.writeTypeToProto(proto, 0x20B00000002L, 5, 3, this.mExecCount, this.mExecState, this.mExecStartTime, now);
        proto.end(token);
    }

    public void writeTypeToProto(ProtoOutputStream proto, long fieldId, int opType, int serviceType, int opCount, int curState, long curStartTime, long now) {
        if (opCount <= 0) {
            return;
        }
        long token = proto.start(fieldId);
        proto.write(0x10E00000001L, opType);
        proto.write(1120986464258L, opCount);
        boolean didCurState = false;
        int N = this.mDurations.getKeyCount();
        for (int i = 0; i < N; ++i) {
            int key = this.mDurations.getKeyAt(i);
            long time = this.mDurations.getValue(key);
            int type = SparseMappingTable.getIdFromKey(key);
            int memFactor = type / 5;
            if ((type %= 5) != serviceType) continue;
            if (curState == memFactor) {
                didCurState = true;
                time += now - curStartTime;
            }
            long stateToken = proto.start(2246267895811L);
            DumpUtils.printProcStateAdjTagProto(proto, 0x10E00000001L, 1159641169922L, type);
            proto.write(0x10300000003L, time);
            proto.end(stateToken);
        }
        if (!didCurState && curState != -1) {
            long stateToken = proto.start(2246267895811L);
            DumpUtils.printProcStateAdjTagProto(proto, 0x10E00000001L, 1159641169922L, curState);
            proto.write(0x10300000003L, now - curStartTime);
            proto.end(stateToken);
        }
        proto.end(token);
    }

    public String toString() {
        return "ServiceState{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.mName + " pkg=" + this.mPackage + " proc=" + Integer.toHexString(System.identityHashCode(this.mProc)) + "}";
    }
}

