/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.colorextraction.drawable;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.graphics.ColorUtils;

public class ScrimDrawable
extends Drawable {
    private static final String TAG = "ScrimDrawable";
    private static final long COLOR_ANIMATION_DURATION = 2000L;
    private final Paint mPaint = new Paint();
    private int mAlpha = 255;
    private int mMainColor;
    private ValueAnimator mColorAnimation;
    private int mMainColorTo;

    public ScrimDrawable() {
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void setColor(int mainColor, boolean animated) {
        if (mainColor == this.mMainColorTo) {
            return;
        }
        if (this.mColorAnimation != null && this.mColorAnimation.isRunning()) {
            this.mColorAnimation.cancel();
        }
        this.mMainColorTo = mainColor;
        if (animated) {
            int mainFrom = this.mMainColor;
            ValueAnimator anim2 = ValueAnimator.ofFloat(0.0f, 1.0f);
            anim2.setDuration(2000L);
            anim2.addUpdateListener(animation -> {
                float ratio = ((Float)animation.getAnimatedValue()).floatValue();
                this.mMainColor = ColorUtils.blendARGB(mainFrom, mainColor, ratio);
                this.invalidateSelf();
            });
            anim2.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animation, boolean isReverse) {
                    if (ScrimDrawable.this.mColorAnimation == animation) {
                        ScrimDrawable.this.mColorAnimation = null;
                    }
                }
            });
            anim2.setInterpolator(new DecelerateInterpolator());
            anim2.start();
            this.mColorAnimation = anim2;
        } else {
            this.mMainColor = mainColor;
            this.invalidateSelf();
        }
    }

    @Override
    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    @Override
    public int getAlpha() {
        return this.mAlpha;
    }

    @Override
    public void setXfermode(Xfermode mode) {
        this.mPaint.setXfermode(mode);
        this.invalidateSelf();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    @Override
    public ColorFilter getColorFilter() {
        return this.mPaint.getColorFilter();
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    public void draw(Canvas canvas) {
        this.mPaint.setColor(this.mMainColor);
        this.mPaint.setAlpha(this.mAlpha);
        canvas.drawRect(this.getBounds(), this.mPaint);
    }

    @VisibleForTesting
    public int getMainColor() {
        return this.mMainColor;
    }
}

