/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.ContentResolver;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.provider.DocumentsProvider;
import android.provider.MediaStore;
import android.provider.MetadataReader;
import android.system.Int64Ref;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import libcore.io.IoUtils;

public abstract class FileSystemProvider
extends DocumentsProvider {
    private static final String TAG = "FileSystemProvider";
    private static final boolean LOG_INOTIFY = false;
    protected static final String SUPPORTED_QUERY_ARGS = FileSystemProvider.joinNewline("android:query-arg-display-name", "android:query-arg-file-size-over", "android:query-arg-last-modified-after", "android:query-arg-mime-types");
    private String[] mDefaultProjection;
    @GuardedBy(value={"mObservers"})
    private final ArrayMap<File, DirectoryObserver> mObservers = new ArrayMap();
    private Handler mHandler;

    private static String joinNewline(String ... args) {
        return TextUtils.join((CharSequence)"\n", args);
    }

    protected abstract File getFileForDocId(String var1, boolean var2) throws FileNotFoundException;

    protected abstract String getDocIdForFile(File var1) throws FileNotFoundException;

    protected abstract Uri buildNotificationUri(String var1);

    protected void onDocIdChanged(String docId) {
    }

    @Override
    public boolean onCreate() {
        throw new UnsupportedOperationException("Subclass should override this and call onCreate(defaultDocumentProjection)");
    }

    protected void onCreate(String[] defaultProjection) {
        this.mHandler = new Handler();
        this.mDefaultProjection = defaultProjection;
    }

    @Override
    public boolean isChildDocument(String parentDocId, String docId) {
        try {
            File parent = this.getFileForDocId(parentDocId).getCanonicalFile();
            File doc = this.getFileForDocId(docId).getCanonicalFile();
            return FileUtils.contains(parent, doc);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to determine if " + docId + " is child of " + parentDocId + ": " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getDocumentMetadata(String documentId) throws FileNotFoundException {
        Bundle bundle;
        File file = this.getFileForDocId(documentId);
        if (!file.exists()) {
            throw new FileNotFoundException("Can't find the file for documentId: " + documentId);
        }
        String mimeType = this.getDocumentType(documentId);
        if ("vnd.android.document/directory".equals(mimeType)) {
            final Int64Ref treeCount = new Int64Ref(0L);
            final Int64Ref treeSize = new Int64Ref(0L);
            try {
                Path path = FileSystems.getDefault().getPath(file.getAbsolutePath(), new String[0]);
                Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        ++treeCount.value;
                        treeSize.value += attrs.size();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                Log.e(TAG, "An error occurred retrieving the metadata", e);
                return null;
            }
            Bundle res = new Bundle();
            res.putLong("android:metadataTreeCount", treeCount.value);
            res.putLong("android:metadataTreeSize", treeSize.value);
            return res;
        }
        if (!file.isFile()) {
            Log.w(TAG, "Can't stream non-regular file. Returning empty metadata.");
            return null;
        }
        if (!file.canRead()) {
            Log.w(TAG, "Can't stream non-readable file. Returning empty metadata.");
            return null;
        }
        if (!MetadataReader.isSupportedMimeType(mimeType)) {
            Log.w(TAG, "Unsupported type " + mimeType + ". Returning empty metadata.");
            return null;
        }
        FileInputStream stream = null;
        try {
            Bundle metadata = new Bundle();
            stream = new FileInputStream(file.getAbsolutePath());
            MetadataReader.getMetadata(metadata, stream, mimeType, null);
            bundle = metadata;
        }
        catch (IOException e) {
            Bundle bundle2;
            try {
                Log.e(TAG, "An error occurred retrieving the metadata", e);
                bundle2 = null;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(stream);
                throw throwable;
            }
            IoUtils.closeQuietly(stream);
            return bundle2;
        }
        IoUtils.closeQuietly(stream);
        return bundle;
    }

    protected final List<String> findDocumentPath(File parent, File doc) throws FileNotFoundException {
        if (!doc.exists()) {
            throw new FileNotFoundException(doc + " is not found.");
        }
        if (!FileUtils.contains(parent, doc)) {
            throw new FileNotFoundException(doc + " is not found under " + parent);
        }
        LinkedList<String> path = new LinkedList<String>();
        while (doc != null && FileUtils.contains(parent, doc)) {
            path.addFirst(this.getDocIdForFile(doc));
            doc = doc.getParentFile();
        }
        return path;
    }

    @Override
    public String createDocument(String docId, String mimeType, String displayName) throws FileNotFoundException {
        String childId;
        displayName = FileUtils.buildValidFatFilename(displayName);
        File parent = this.getFileForDocId(docId);
        if (!parent.isDirectory()) {
            throw new IllegalArgumentException("Parent document isn't a directory");
        }
        File file = FileUtils.buildUniqueFile(parent, mimeType, displayName);
        if ("vnd.android.document/directory".equals(mimeType)) {
            if (!file.mkdir()) {
                throw new IllegalStateException("Failed to mkdir " + file);
            }
            childId = this.getDocIdForFile(file);
            this.onDocIdChanged(childId);
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new IllegalStateException("Failed to touch " + file);
                }
                childId = this.getDocIdForFile(file);
                this.onDocIdChanged(childId);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to touch " + file + ": " + e);
            }
        }
        MediaStore.scanFile(this.getContext(), file);
        return childId;
    }

    @Override
    public String renameDocument(String docId, String displayName) throws FileNotFoundException {
        displayName = FileUtils.buildValidFatFilename(displayName);
        File before = this.getFileForDocId(docId);
        File beforeVisibleFile = this.getFileForDocId(docId, true);
        File after = FileUtils.buildUniqueFile(before.getParentFile(), displayName);
        if (!before.renameTo(after)) {
            throw new IllegalStateException("Failed to rename to " + after);
        }
        String afterDocId = this.getDocIdForFile(after);
        this.onDocIdChanged(docId);
        this.onDocIdChanged(afterDocId);
        File afterVisibleFile = this.getFileForDocId(afterDocId, true);
        this.moveInMediaStore(beforeVisibleFile, afterVisibleFile);
        if (!TextUtils.equals(docId, afterDocId)) {
            return afterDocId;
        }
        return null;
    }

    @Override
    public String moveDocument(String sourceDocumentId, String sourceParentDocumentId, String targetParentDocumentId) throws FileNotFoundException {
        File before = this.getFileForDocId(sourceDocumentId);
        File after = new File(this.getFileForDocId(targetParentDocumentId), before.getName());
        File visibleFileBefore = this.getFileForDocId(sourceDocumentId, true);
        if (after.exists()) {
            throw new IllegalStateException("Already exists " + after);
        }
        if (!before.renameTo(after)) {
            throw new IllegalStateException("Failed to move to " + after);
        }
        String docId = this.getDocIdForFile(after);
        this.onDocIdChanged(sourceDocumentId);
        this.onDocIdChanged(docId);
        this.moveInMediaStore(visibleFileBefore, this.getFileForDocId(docId, true));
        return docId;
    }

    private void moveInMediaStore(File oldVisibleFile, File newVisibleFile) {
        if (oldVisibleFile != null) {
            MediaStore.scanFile(this.getContext(), oldVisibleFile);
        }
        if (newVisibleFile != null) {
            MediaStore.scanFile(this.getContext(), newVisibleFile);
        }
    }

    @Override
    public void deleteDocument(String docId) throws FileNotFoundException {
        File file = this.getFileForDocId(docId);
        File visibleFile = this.getFileForDocId(docId, true);
        boolean isDirectory = file.isDirectory();
        if (isDirectory) {
            FileUtils.deleteContents(file);
        }
        if (!file.delete()) {
            throw new IllegalStateException("Failed to delete " + file);
        }
        this.onDocIdChanged(docId);
        this.removeFromMediaStore(visibleFile, isDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMediaStore(File visibleFile, boolean isFolder) throws FileNotFoundException {
        if (visibleFile != null) {
            long token = Binder.clearCallingIdentity();
            try {
                String path;
                ContentResolver resolver = this.getContext().getContentResolver();
                Uri externalUri = MediaStore.Files.getContentUri("external");
                if (isFolder) {
                    path = visibleFile.getAbsolutePath() + "/";
                    resolver.delete(externalUri, "_data LIKE ?1 AND lower(substr(_data,1,?2))=lower(?3)", new String[]{path + "%", Integer.toString(path.length()), path});
                }
                path = visibleFile.getAbsolutePath();
                resolver.delete(externalUri, "_data LIKE ?1 AND lower(_data)=lower(?2)", new String[]{path, path});
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    @Override
    public Cursor queryDocument(String documentId, String[] projection) throws FileNotFoundException {
        MatrixCursor result = new MatrixCursor(this.resolveProjection(projection));
        this.includeFile(result, documentId, null);
        return result;
    }

    @Override
    public Cursor queryChildDocuments(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {
        File parent = this.getFileForDocId(parentDocumentId);
        DirectoryCursor result = new DirectoryCursor(this.resolveProjection(projection), parentDocumentId, parent);
        if (parent.isDirectory()) {
            for (File file : FileUtils.listFilesOrEmpty(parent)) {
                this.includeFile(result, null, file);
            }
        } else {
            Log.w(TAG, "parentDocumentId '" + parentDocumentId + "' is not Directory");
        }
        return result;
    }

    protected final Cursor querySearchDocuments(File folder, String[] projection, Set<String> exclusion, Bundle queryArgs) throws FileNotFoundException {
        MatrixCursor result = new MatrixCursor(this.resolveProjection(projection));
        LinkedList<File> pending = new LinkedList<File>();
        pending.add(folder);
        while (!pending.isEmpty() && result.getCount() < 24) {
            File file = (File)pending.removeFirst();
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    pending.add(child);
                }
            }
            if (exclusion.contains(file.getAbsolutePath()) || !this.matchSearchQueryArguments(file, queryArgs)) continue;
            this.includeFile(result, null, file);
        }
        String[] handledQueryArgs = DocumentsContract.getHandledQueryArguments(queryArgs);
        if (handledQueryArgs.length > 0) {
            Bundle extras = new Bundle();
            extras.putStringArray("android.content.extra.HONORED_ARGS", handledQueryArgs);
            result.setExtras(extras);
        }
        return result;
    }

    @Override
    public String getDocumentType(String documentId) throws FileNotFoundException {
        return this.getDocumentType(documentId, this.getFileForDocId(documentId));
    }

    private String getDocumentType(String documentId, File file) throws FileNotFoundException {
        if (file.isDirectory()) {
            return "vnd.android.document/directory";
        }
        int lastDot = documentId.lastIndexOf(46);
        if (lastDot >= 0) {
            String extension = documentId.substring(lastDot + 1).toLowerCase();
            String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
            if (mime != null) {
                return mime;
            }
        }
        return "application/octet-stream";
    }

    @Override
    public ParcelFileDescriptor openDocument(String documentId, String mode, CancellationSignal signal) throws FileNotFoundException {
        File file = this.getFileForDocId(documentId);
        File visibleFile = this.getFileForDocId(documentId, true);
        int pfdMode = ParcelFileDescriptor.parseMode(mode);
        if (pfdMode == 0x10000000 || visibleFile == null) {
            return ParcelFileDescriptor.open(file, pfdMode);
        }
        try {
            return ParcelFileDescriptor.open(file, pfdMode, this.mHandler, e -> {
                this.onDocIdChanged(documentId);
                this.scanFile(visibleFile);
            });
        }
        catch (IOException e2) {
            throw new FileNotFoundException("Failed to open for writing: " + e2);
        }
    }

    private boolean matchSearchQueryArguments(File file, Bundle queryArgs) {
        String fileMimeType;
        if (file == null) {
            return false;
        }
        String fileName = file.getName();
        if (file.isDirectory()) {
            fileMimeType = "vnd.android.document/directory";
        } else {
            int dotPos = fileName.lastIndexOf(46);
            if (dotPos < 0) {
                return false;
            }
            String extension = fileName.substring(dotPos + 1);
            fileMimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return DocumentsContract.matchSearchQueryArguments(queryArgs, fileName, fileMimeType, file.lastModified(), file.length());
    }

    private void scanFile(File visibleFile) {
        Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        intent.setData(Uri.fromFile(visibleFile));
        this.getContext().sendBroadcast(intent);
    }

    @Override
    public AssetFileDescriptor openDocumentThumbnail(String documentId, Point sizeHint, CancellationSignal signal) throws FileNotFoundException {
        File file = this.getFileForDocId(documentId);
        return DocumentsContract.openImageThumbnail(file);
    }

    protected MatrixCursor.RowBuilder includeFile(MatrixCursor result, String docId, File file) throws FileNotFoundException {
        int sizeIndex;
        long lastModified;
        int lastModifiedIndex;
        int displayNameIndex;
        String[] columns = result.getColumnNames();
        MatrixCursor.RowBuilder row = result.newRow();
        if (docId == null) {
            docId = this.getDocIdForFile(file);
        } else {
            file = this.getFileForDocId(docId);
        }
        String mimeType = this.getDocumentType(docId, file);
        row.add("document_id", (Object)docId);
        row.add("mime_type", (Object)mimeType);
        int flagIndex = ArrayUtils.indexOf(columns, "flags");
        if (flagIndex != -1) {
            int flags = 0;
            if (file.canWrite()) {
                if (mimeType.equals("vnd.android.document/directory")) {
                    flags |= 8;
                    flags |= 4;
                    flags |= 0x40;
                    flags |= 0x100;
                } else {
                    flags |= 2;
                    flags |= 4;
                    flags |= 0x40;
                    flags |= 0x100;
                }
            }
            if (mimeType.startsWith("image/")) {
                flags |= 1;
            }
            if (this.typeSupportsMetadata(mimeType)) {
                flags |= 0x4000;
            }
            row.add(flagIndex, (Object)flags);
        }
        if ((displayNameIndex = ArrayUtils.indexOf(columns, "_display_name")) != -1) {
            row.add(displayNameIndex, (Object)file.getName());
        }
        if ((lastModifiedIndex = ArrayUtils.indexOf(columns, "last_modified")) != -1 && (lastModified = file.lastModified()) > 31536000000L) {
            row.add(lastModifiedIndex, (Object)lastModified);
        }
        if ((sizeIndex = ArrayUtils.indexOf(columns, "_size")) != -1) {
            row.add(sizeIndex, (Object)file.length());
        }
        return row;
    }

    protected boolean typeSupportsMetadata(String mimeType) {
        return MetadataReader.isSupportedMimeType(mimeType) || "vnd.android.document/directory".equals(mimeType);
    }

    protected final File getFileForDocId(String docId) throws FileNotFoundException {
        return this.getFileForDocId(docId, false);
    }

    private String[] resolveProjection(String[] projection) {
        return projection == null ? this.mDefaultProjection : projection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startObserving(File file, Uri notifyUri, DirectoryCursor cursor) {
        ArrayMap<File, DirectoryObserver> arrayMap = this.mObservers;
        synchronized (arrayMap) {
            DirectoryObserver observer = this.mObservers.get(file);
            if (observer == null) {
                observer = new DirectoryObserver(file, this.getContext().getContentResolver(), notifyUri);
                observer.startWatching();
                this.mObservers.put(file, observer);
            }
            observer.mCursors.add(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopObserving(File file, DirectoryCursor cursor) {
        ArrayMap<File, DirectoryObserver> arrayMap = this.mObservers;
        synchronized (arrayMap) {
            DirectoryObserver observer = this.mObservers.get(file);
            if (observer == null) {
                return;
            }
            observer.mCursors.remove(cursor);
            if (observer.mCursors.size() == 0) {
                this.mObservers.remove(file);
                observer.stopWatching();
            }
        }
    }

    private class DirectoryCursor
    extends MatrixCursor {
        private final File mFile;

        public DirectoryCursor(String[] columnNames, String docId, File file) {
            super(columnNames);
            Uri notifyUri = FileSystemProvider.this.buildNotificationUri(docId);
            boolean registerSelfObserver = false;
            this.setNotificationUris(FileSystemProvider.this.getContext().getContentResolver(), Arrays.asList(notifyUri), FileSystemProvider.this.getContext().getContentResolver().getUserId(), registerSelfObserver);
            this.mFile = file;
            FileSystemProvider.this.startObserving(this.mFile, notifyUri, this);
        }

        public void notifyChanged() {
            this.onChange(false);
        }

        @Override
        public void close() {
            super.close();
            FileSystemProvider.this.stopObserving(this.mFile, this);
        }
    }

    private static class DirectoryObserver
    extends FileObserver {
        private static final int NOTIFY_EVENTS = 4044;
        private final File mFile;
        private final ContentResolver mResolver;
        private final Uri mNotifyUri;
        private final CopyOnWriteArrayList<DirectoryCursor> mCursors;

        DirectoryObserver(File file, ContentResolver resolver, Uri notifyUri) {
            super(file.getAbsolutePath(), 4044);
            this.mFile = file;
            this.mResolver = resolver;
            this.mNotifyUri = notifyUri;
            this.mCursors = new CopyOnWriteArrayList();
        }

        @Override
        public void onEvent(int event, String path) {
            if ((event & 0xFCC) != 0) {
                for (DirectoryCursor cursor : this.mCursors) {
                    cursor.notifyChanged();
                }
                this.mResolver.notifyChange(this.mNotifyUri, null, false);
            }
        }

        public String toString() {
            String filePath = this.mFile.getAbsolutePath();
            return "DirectoryObserver{file=" + filePath + ", ref=" + this.mCursors.size() + "}";
        }
    }
}

