/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.globalactions;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.android.internal.globalactions.Action;
import java.util.List;
import java.util.function.BooleanSupplier;

public class ActionsAdapter
extends BaseAdapter {
    private final Context mContext;
    private final List<Action> mItems;
    private final BooleanSupplier mDeviceProvisioned;
    private final BooleanSupplier mKeyguardShowing;

    public ActionsAdapter(Context context, List<Action> items, BooleanSupplier deviceProvisioned, BooleanSupplier keyguardShowing) {
        this.mContext = context;
        this.mItems = items;
        this.mDeviceProvisioned = deviceProvisioned;
        this.mKeyguardShowing = keyguardShowing;
    }

    @Override
    public int getCount() {
        boolean keyguardShowing = this.mKeyguardShowing.getAsBoolean();
        boolean deviceProvisioned = this.mDeviceProvisioned.getAsBoolean();
        int count = 0;
        for (int i = 0; i < this.mItems.size(); ++i) {
            Action action = this.mItems.get(i);
            if (keyguardShowing && !action.showDuringKeyguard() || !deviceProvisioned && !action.showBeforeProvisioning()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEnabled(int position) {
        return this.getItem(position).isEnabled();
    }

    @Override
    public boolean areAllItemsEnabled() {
        return false;
    }

    @Override
    public Action getItem(int position) {
        boolean keyguardShowing = this.mKeyguardShowing.getAsBoolean();
        boolean deviceProvisioned = this.mDeviceProvisioned.getAsBoolean();
        int filteredPos = 0;
        for (int i = 0; i < this.mItems.size(); ++i) {
            Action action = this.mItems.get(i);
            if (keyguardShowing && !action.showDuringKeyguard() || !deviceProvisioned && !action.showBeforeProvisioning()) continue;
            if (filteredPos == position) {
                return action;
            }
            ++filteredPos;
        }
        throw new IllegalArgumentException("position " + position + " out of range of showable actions, filtered count=" + this.getCount() + ", keyguardshowing=" + keyguardShowing + ", provisioned=" + deviceProvisioned);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        Action action = this.getItem(position);
        return action.create(this.mContext, convertView, parent, LayoutInflater.from(this.mContext));
    }
}

