/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.globalactions;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.accessibility.AccessibilityEvent;
import android.widget.ListView;
import com.android.internal.app.AlertController;
import com.android.internal.globalactions.ActionsAdapter;

public final class ActionsDialog
extends Dialog
implements DialogInterface {
    private final Context mContext = this.getContext();
    private final AlertController mAlert = AlertController.create(this.mContext, this, this.getWindow());
    private final ActionsAdapter mAdapter;

    public ActionsDialog(Context context, AlertController.AlertParams params) {
        super(context, ActionsDialog.getDialogTheme(context));
        this.mAdapter = (ActionsAdapter)params.mAdapter;
        params.apply(this.mAlert);
    }

    private static int getDialogTheme(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(16843529, outValue, true);
        return outValue.resourceId;
    }

    @Override
    protected void onStart() {
        super.setCanceledOnTouchOutside(true);
        super.onStart();
    }

    public ListView getListView() {
        return this.mAlert.getListView();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAlert.installContent();
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (event.getEventType() == 32) {
            for (int i = 0; i < this.mAdapter.getCount(); ++i) {
                CharSequence label = this.mAdapter.getItem(i).getLabelForAccessibility(this.getContext());
                if (label == null) continue;
                event.getText().add(label);
            }
        }
        return super.dispatchPopulateAccessibilityEvent(event);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mAlert.onKeyDown(keyCode, event)) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mAlert.onKeyUp(keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }
}

