/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.infra;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public abstract class AbstractRemoteService<S extends AbstractRemoteService<S, I>, I extends IInterface>
implements IBinder.DeathRecipient {
    private static final int MSG_BIND = 1;
    private static final int MSG_UNBIND = 2;
    public static final long PERMANENT_BOUND_TIMEOUT_MS = 0L;
    protected static final int LAST_PRIVATE_MSG = 2;
    public final boolean mVerbose;
    protected final String mTag = this.getClass().getSimpleName();
    protected final Handler mHandler;
    protected final ComponentName mComponentName;
    private final Context mContext;
    private final Intent mIntent;
    private final VultureCallback<S> mVultureCallback;
    private final int mUserId;
    private final ServiceConnection mServiceConnection = new RemoteServiceConnection();
    private final int mBindingFlags;
    protected I mService;
    private boolean mBinding;
    private boolean mDestroyed;
    private boolean mServiceDied;
    private boolean mCompleted;
    private long mNextUnbind;
    private final ArrayList<BasePendingRequest<S, I>> mUnfinishedRequests = new ArrayList();

    AbstractRemoteService(Context context, String serviceInterface, ComponentName componentName, int userId, VultureCallback<S> callback, Handler handler, int bindingFlags, boolean verbose) {
        this.mContext = context;
        this.mVultureCallback = callback;
        this.mVerbose = verbose;
        this.mComponentName = componentName;
        this.mIntent = new Intent(serviceInterface).setComponent(this.mComponentName);
        this.mUserId = userId;
        this.mHandler = new Handler(handler.getLooper());
        this.mBindingFlags = bindingFlags;
    }

    public final void destroy() {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(AbstractRemoteService::handleDestroy, this));
    }

    public final boolean isDestroyed() {
        return this.mDestroyed;
    }

    public final ComponentName getComponentName() {
        return this.mComponentName;
    }

    private void handleOnConnectedStateChangedInternal(boolean connected) {
        this.handleOnConnectedStateChanged(connected);
        if (connected) {
            this.handlePendingRequests();
        }
    }

    abstract void handlePendingRequests();

    protected void handleOnConnectedStateChanged(boolean state) {
    }

    protected abstract I getServiceInterface(IBinder var1);

    protected abstract long getTimeoutIdleBindMillis();

    protected long getRemoteRequestMillis() {
        throw new UnsupportedOperationException("not implemented by " + this.getClass());
    }

    public final I getServiceInterface() {
        return this.mService;
    }

    private void handleDestroy() {
        if (this.checkIfDestroyed()) {
            return;
        }
        this.handleOnDestroy();
        this.handleEnsureUnbound();
        this.mDestroyed = true;
    }

    protected abstract void handleOnDestroy();

    @Override
    public void binderDied() {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(AbstractRemoteService::handleBinderDied, this));
    }

    private void handleBinderDied() {
        if (this.checkIfDestroyed()) {
            return;
        }
        if (this.mService != null) {
            this.mService.asBinder().unlinkToDeath(this, 0);
        }
        this.mService = null;
        this.mServiceDied = true;
        this.cancelScheduledUnbind();
        AbstractRemoteService castService = this;
        this.mVultureCallback.onServiceDied(castService);
        this.handleBindFailure();
    }

    public void dump(String prefix, PrintWriter pw) {
        String tab = "  ";
        pw.append(prefix).append("service:").println();
        pw.append(prefix).append(tab).append("userId=").append(String.valueOf(this.mUserId)).println();
        pw.append(prefix).append(tab).append("componentName=").append(this.mComponentName.flattenToString()).println();
        pw.append(prefix).append(tab).append("destroyed=").append(String.valueOf(this.mDestroyed)).println();
        pw.append(prefix).append(tab).append("numUnfinishedRequests=").append(String.valueOf(this.mUnfinishedRequests.size())).println();
        boolean bound = this.handleIsBound();
        pw.append(prefix).append(tab).append("bound=").append(String.valueOf(bound));
        long idleTimeout = this.getTimeoutIdleBindMillis();
        if (bound) {
            if (idleTimeout > 0L) {
                pw.append(" (unbind in : ");
                TimeUtils.formatDuration(this.mNextUnbind - SystemClock.elapsedRealtime(), pw);
                pw.append(")");
            } else {
                pw.append(" (permanently bound)");
            }
        }
        pw.println();
        pw.append(prefix).append("mBindingFlags=").println(this.mBindingFlags);
        pw.append(prefix).append("idleTimeout=").append(Long.toString(idleTimeout / 1000L)).append("s\n");
        pw.append(prefix).append("requestTimeout=");
        try {
            pw.append(Long.toString(this.getRemoteRequestMillis() / 1000L)).append("s\n");
        }
        catch (UnsupportedOperationException e) {
            pw.append("not supported\n");
        }
        pw.println();
    }

    protected void scheduleRequest(BasePendingRequest<S, I> pendingRequest) {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(AbstractRemoteService::handlePendingRequest, this, pendingRequest));
    }

    void finishRequest(BasePendingRequest<S, I> finshedRequest) {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(AbstractRemoteService::handleFinishRequest, this, finshedRequest));
    }

    private void handleFinishRequest(BasePendingRequest<S, I> finshedRequest) {
        this.mUnfinishedRequests.remove(finshedRequest);
        if (this.mUnfinishedRequests.isEmpty()) {
            this.scheduleUnbind();
        }
    }

    protected void scheduleAsyncRequest(AsyncRequest<I> request) {
        MyAsyncPendingRequest<AbstractRemoteService, I> asyncRequest = new MyAsyncPendingRequest<AbstractRemoteService, I>(this, request);
        this.mHandler.sendMessage(PooledLambda.obtainMessage(AbstractRemoteService::handlePendingRequest, this, asyncRequest));
    }

    private void cancelScheduledUnbind() {
        this.mHandler.removeMessages(2);
    }

    protected void scheduleBind() {
        if (this.mHandler.hasMessages(1)) {
            if (this.mVerbose) {
                Slog.v(this.mTag, "scheduleBind(): already scheduled");
            }
            return;
        }
        this.mHandler.sendMessage(PooledLambda.obtainMessage(AbstractRemoteService::handleEnsureBound, this).setWhat(1));
    }

    protected void scheduleUnbind() {
        this.scheduleUnbind(true);
    }

    private void scheduleUnbind(boolean delay) {
        long unbindDelay = this.getTimeoutIdleBindMillis();
        if (unbindDelay <= 0L) {
            if (this.mVerbose) {
                Slog.v(this.mTag, "not scheduling unbind when value is " + unbindDelay);
            }
            return;
        }
        if (!delay) {
            unbindDelay = 0L;
        }
        this.cancelScheduledUnbind();
        this.mNextUnbind = SystemClock.elapsedRealtime() + unbindDelay;
        if (this.mVerbose) {
            Slog.v(this.mTag, "unbinding in " + unbindDelay + "ms: " + this.mNextUnbind);
        }
        this.mHandler.sendMessageDelayed(PooledLambda.obtainMessage(AbstractRemoteService::handleUnbind, this).setWhat(2), unbindDelay);
    }

    private void handleUnbind() {
        if (this.checkIfDestroyed()) {
            return;
        }
        this.handleEnsureUnbound();
    }

    protected final void handlePendingRequest(BasePendingRequest<S, I> pendingRequest) {
        if (this.checkIfDestroyed() || this.mCompleted) {
            return;
        }
        if (!this.handleIsBound()) {
            if (this.mVerbose) {
                Slog.v(this.mTag, "handlePendingRequest(): queuing " + pendingRequest);
            }
            this.handlePendingRequestWhileUnBound(pendingRequest);
            this.handleEnsureBound();
        } else {
            if (this.mVerbose) {
                Slog.v(this.mTag, "handlePendingRequest(): " + pendingRequest);
            }
            this.mUnfinishedRequests.add(pendingRequest);
            this.cancelScheduledUnbind();
            pendingRequest.run();
            if (pendingRequest.isFinal()) {
                this.mCompleted = true;
            }
        }
    }

    abstract void handlePendingRequestWhileUnBound(BasePendingRequest<S, I> var1);

    abstract void handleBindFailure();

    private boolean handleIsBound() {
        return this.mService != null;
    }

    private void handleEnsureBound() {
        if (this.handleIsBound() || this.mBinding) {
            return;
        }
        if (this.mVerbose) {
            Slog.v(this.mTag, "ensureBound()");
        }
        this.mBinding = true;
        int flags = 0x4000001 | this.mBindingFlags;
        boolean willBind = this.mContext.bindServiceAsUser(this.mIntent, this.mServiceConnection, flags, this.mHandler, new UserHandle(this.mUserId));
        if (!willBind) {
            Slog.w(this.mTag, "could not bind to " + this.mIntent + " using flags " + flags);
            this.mBinding = false;
            if (!this.mServiceDied) {
                this.handleBinderDied();
            }
        }
    }

    private void handleEnsureUnbound() {
        if (!this.handleIsBound() && !this.mBinding) {
            return;
        }
        if (this.mVerbose) {
            Slog.v(this.mTag, "ensureUnbound()");
        }
        this.mBinding = false;
        if (this.handleIsBound()) {
            this.handleOnConnectedStateChangedInternal(false);
            if (this.mService != null) {
                this.mService.asBinder().unlinkToDeath(this, 0);
                this.mService = null;
            }
        }
        this.mNextUnbind = 0L;
        this.mContext.unbindService(this.mServiceConnection);
    }

    private boolean checkIfDestroyed() {
        if (this.mDestroyed && this.mVerbose) {
            Slog.v(this.mTag, "Not handling operation as service for " + this.mComponentName + " is already destroyed");
        }
        return this.mDestroyed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.mComponentName + " " + System.identityHashCode(this) + (this.mService != null ? " (bound)" : " (unbound)") + (this.mDestroyed ? " (destroyed)" : "") + "]";
    }

    private static final class MyAsyncPendingRequest<S extends AbstractRemoteService<S, I>, I extends IInterface>
    extends BasePendingRequest<S, I> {
        private static final String TAG = MyAsyncPendingRequest.class.getSimpleName();
        private final AsyncRequest<I> mRequest;

        protected MyAsyncPendingRequest(S service, AsyncRequest<I> request) {
            super(service);
            this.mRequest = request;
        }

        @Override
        public void run() {
            Object remoteService = this.getService();
            if (remoteService == null) {
                return;
            }
            try {
                this.mRequest.run(((AbstractRemoteService)remoteService).mService);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "exception handling async request (" + this + "): " + e);
            }
            finally {
                this.finish();
            }
        }
    }

    public static interface AsyncRequest<I extends IInterface> {
        public void run(I var1) throws RemoteException;
    }

    public static abstract class PendingRequest<S extends AbstractRemoteService<S, I>, I extends IInterface>
    extends BasePendingRequest<S, I> {
        private final Runnable mTimeoutTrigger;
        private final Handler mServiceHandler;

        protected PendingRequest(S service) {
            super(service);
            this.mServiceHandler = ((AbstractRemoteService)service).mHandler;
            this.mTimeoutTrigger = () -> {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mCancelled) {
                        return;
                    }
                    this.mCompleted = true;
                }
                AbstractRemoteService remoteService = (AbstractRemoteService)this.mWeakService.get();
                if (remoteService != null) {
                    Slog.w(this.mTag, "timed out after " + service.getRemoteRequestMillis() + " ms");
                    remoteService.finishRequest(this);
                    this.onTimeout(remoteService);
                } else {
                    Slog.w(this.mTag, "timed out (no service)");
                }
            };
            this.mServiceHandler.postAtTime(this.mTimeoutTrigger, SystemClock.uptimeMillis() + ((AbstractRemoteService)service).getRemoteRequestMillis());
        }

        @Override
        final void onFinished() {
            this.mServiceHandler.removeCallbacks(this.mTimeoutTrigger);
        }

        @Override
        final void onCancel() {
            this.mServiceHandler.removeCallbacks(this.mTimeoutTrigger);
        }

        protected abstract void onTimeout(S var1);
    }

    public static abstract class BasePendingRequest<S extends AbstractRemoteService<S, I>, I extends IInterface>
    implements Runnable {
        protected final String mTag = this.getClass().getSimpleName();
        protected final Object mLock = new Object();
        final WeakReference<S> mWeakService;
        @GuardedBy(value={"mLock"})
        boolean mCancelled;
        @GuardedBy(value={"mLock"})
        boolean mCompleted;

        BasePendingRequest(S service) {
            this.mWeakService = new WeakReference<S>(service);
        }

        protected final S getService() {
            return (S)((AbstractRemoteService)this.mWeakService.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean finish() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCompleted || this.mCancelled) {
                    return false;
                }
                this.mCompleted = true;
            }
            AbstractRemoteService service = (AbstractRemoteService)this.mWeakService.get();
            if (service != null) {
                service.finishRequest(this);
            }
            this.onFinished();
            return true;
        }

        void onFinished() {
        }

        protected void onFailed() {
        }

        @GuardedBy(value={"mLock"})
        protected final boolean isCancelledLocked() {
            return this.mCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCancelled || this.mCompleted) {
                    return false;
                }
                this.mCancelled = true;
            }
            this.onCancel();
            return true;
        }

        void onCancel() {
        }

        protected boolean isFinal() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isRequestCompleted() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mCompleted;
            }
        }
    }

    private class RemoteServiceConnection
    implements ServiceConnection {
        private RemoteServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            if (AbstractRemoteService.this.mVerbose) {
                Slog.v(AbstractRemoteService.this.mTag, "onServiceConnected()");
            }
            if (AbstractRemoteService.this.mDestroyed || !AbstractRemoteService.this.mBinding) {
                Slog.wtf(AbstractRemoteService.this.mTag, "onServiceConnected() was dispatched after unbindService.");
                return;
            }
            AbstractRemoteService.this.mBinding = false;
            try {
                service.linkToDeath(AbstractRemoteService.this, 0);
            }
            catch (RemoteException re) {
                AbstractRemoteService.this.handleBinderDied();
                return;
            }
            AbstractRemoteService.this.mService = AbstractRemoteService.this.getServiceInterface(service);
            AbstractRemoteService.this.handleOnConnectedStateChangedInternal(true);
            AbstractRemoteService.this.mServiceDied = false;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            if (AbstractRemoteService.this.mVerbose) {
                Slog.v(AbstractRemoteService.this.mTag, "onServiceDisconnected()");
            }
            AbstractRemoteService.this.mBinding = true;
            AbstractRemoteService.this.mService = null;
        }

        @Override
        public void onBindingDied(ComponentName name) {
            if (AbstractRemoteService.this.mVerbose) {
                Slog.v(AbstractRemoteService.this.mTag, "onBindingDied()");
            }
            AbstractRemoteService.this.scheduleUnbind(false);
        }
    }

    public static interface VultureCallback<T> {
        public void onServiceDied(T var1);
    }
}

