/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.infra;

import android.content.ComponentName;
import android.content.Context;
import android.os.Handler;
import android.os.IInterface;
import android.util.Slog;
import com.android.internal.infra.AbstractRemoteService;
import java.io.PrintWriter;

public abstract class AbstractSinglePendingRequestRemoteService<S extends AbstractSinglePendingRequestRemoteService<S, I>, I extends IInterface>
extends AbstractRemoteService<S, I> {
    protected AbstractRemoteService.BasePendingRequest<S, I> mPendingRequest;

    public AbstractSinglePendingRequestRemoteService(Context context, String serviceInterface, ComponentName componentName, int userId, AbstractRemoteService.VultureCallback<S> callback, Handler handler, int bindingFlags, boolean verbose) {
        super(context, serviceInterface, componentName, userId, callback, handler, bindingFlags, verbose);
    }

    @Override
    void handlePendingRequests() {
        if (this.mPendingRequest != null) {
            AbstractRemoteService.BasePendingRequest<S, I> pendingRequest = this.mPendingRequest;
            this.mPendingRequest = null;
            this.handlePendingRequest(pendingRequest);
        }
    }

    @Override
    protected void handleOnDestroy() {
        this.handleCancelPendingRequest();
    }

    protected AbstractRemoteService.BasePendingRequest<S, I> handleCancelPendingRequest() {
        AbstractRemoteService.BasePendingRequest<S, I> pendingRequest = this.mPendingRequest;
        if (pendingRequest != null) {
            pendingRequest.cancel();
            this.mPendingRequest = null;
        }
        return pendingRequest;
    }

    @Override
    void handleBindFailure() {
        if (this.mPendingRequest != null) {
            if (this.mVerbose) {
                Slog.v(this.mTag, "Sending failure to " + this.mPendingRequest);
            }
            this.mPendingRequest.onFailed();
            this.mPendingRequest = null;
        }
    }

    @Override
    public void dump(String prefix, PrintWriter pw) {
        super.dump(prefix, pw);
        pw.append(prefix).append("hasPendingRequest=").append(String.valueOf(this.mPendingRequest != null)).println();
    }

    @Override
    void handlePendingRequestWhileUnBound(AbstractRemoteService.BasePendingRequest<S, I> pendingRequest) {
        if (this.mPendingRequest != null) {
            if (this.mVerbose) {
                Slog.v(this.mTag, "handlePendingRequestWhileUnBound(): cancelling " + this.mPendingRequest + " to handle " + pendingRequest);
            }
            this.mPendingRequest.cancel();
        }
        this.mPendingRequest = pendingRequest;
    }
}

