/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.infra;

import android.content.ComponentName;
import android.util.ArraySet;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.infra.WhitelistHelper;
import java.io.PrintWriter;
import java.util.List;

public class GlobalWhitelistState {
    protected final Object mGlobalWhitelistStateLock = new Object();
    @GuardedBy(value={"mGlobalWhitelistStateLock"})
    protected SparseArray<WhitelistHelper> mWhitelisterHelpers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhitelist(int userId, List<String> packageNames, List<ComponentName> components) {
        Object object = this.mGlobalWhitelistStateLock;
        synchronized (object) {
            WhitelistHelper helper;
            if (this.mWhitelisterHelpers == null) {
                this.mWhitelisterHelpers = new SparseArray(1);
            }
            if ((helper = this.mWhitelisterHelpers.get(userId)) == null) {
                helper = new WhitelistHelper();
                this.mWhitelisterHelpers.put(userId, helper);
            }
            helper.setWhitelist(packageNames, components);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWhitelisted(int userId, String packageName) {
        Object object = this.mGlobalWhitelistStateLock;
        synchronized (object) {
            if (this.mWhitelisterHelpers == null) {
                return false;
            }
            WhitelistHelper helper = this.mWhitelisterHelpers.get(userId);
            boolean bl = helper == null ? false : helper.isWhitelisted(packageName);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWhitelisted(int userId, ComponentName componentName) {
        Object object = this.mGlobalWhitelistStateLock;
        synchronized (object) {
            if (this.mWhitelisterHelpers == null) {
                return false;
            }
            WhitelistHelper helper = this.mWhitelisterHelpers.get(userId);
            boolean bl = helper == null ? false : helper.isWhitelisted(componentName);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArraySet<ComponentName> getWhitelistedComponents(int userId, String packageName) {
        Object object = this.mGlobalWhitelistStateLock;
        synchronized (object) {
            if (this.mWhitelisterHelpers == null) {
                return null;
            }
            WhitelistHelper helper = this.mWhitelisterHelpers.get(userId);
            ArraySet<ComponentName> arraySet = helper == null ? null : helper.getWhitelistedComponents(packageName);
            return arraySet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetWhitelist(int userId) {
        Object object = this.mGlobalWhitelistStateLock;
        synchronized (object) {
            if (this.mWhitelisterHelpers == null) {
                return;
            }
            this.mWhitelisterHelpers.remove(userId);
            if (this.mWhitelisterHelpers.size() == 0) {
                this.mWhitelisterHelpers = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("State: ");
        Object object = this.mGlobalWhitelistStateLock;
        synchronized (object) {
            if (this.mWhitelisterHelpers == null) {
                pw.println("empty");
                return;
            }
            pw.print(this.mWhitelisterHelpers.size());
            pw.println(" services");
            String prefix2 = prefix + "  ";
            for (int i = 0; i < this.mWhitelisterHelpers.size(); ++i) {
                int userId = this.mWhitelisterHelpers.keyAt(i);
                WhitelistHelper helper = this.mWhitelisterHelpers.valueAt(i);
                helper.dump(prefix2, "Whitelist for userId " + userId, pw);
            }
        }
    }
}

