/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.infra;

import android.content.ComponentName;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.io.PrintWriter;
import java.util.List;

public final class WhitelistHelper {
    private static final String TAG = "WhitelistHelper";
    private ArrayMap<String, ArraySet<ComponentName>> mWhitelistedPackages;

    public void setWhitelist(ArraySet<String> packageNames, ArraySet<ComponentName> components) {
        int i;
        this.mWhitelistedPackages = null;
        if (packageNames == null && components == null) {
            return;
        }
        if (packageNames != null && packageNames.isEmpty() || components != null && components.isEmpty()) {
            throw new IllegalArgumentException("Packages or Components cannot be empty.");
        }
        this.mWhitelistedPackages = new ArrayMap();
        if (packageNames != null) {
            for (i = 0; i < packageNames.size(); ++i) {
                this.mWhitelistedPackages.put(packageNames.valueAt(i), null);
            }
        }
        if (components != null) {
            for (i = 0; i < components.size(); ++i) {
                ComponentName component = components.valueAt(i);
                if (component == null) {
                    Log.w(TAG, "setWhitelist(): component is null");
                    continue;
                }
                String packageName = component.getPackageName();
                ArraySet<ComponentName> set = this.mWhitelistedPackages.get(packageName);
                if (set == null) {
                    set = new ArraySet();
                    this.mWhitelistedPackages.put(packageName, set);
                }
                set.add(component);
            }
        }
    }

    public void setWhitelist(List<String> packageNames, List<ComponentName> components) {
        ArraySet<String> packageNamesSet = packageNames == null ? null : new ArraySet<String>(packageNames);
        ArraySet<ComponentName> componentsSet = components == null ? null : new ArraySet<ComponentName>(components);
        this.setWhitelist(packageNamesSet, componentsSet);
    }

    public boolean isWhitelisted(String packageName) {
        Preconditions.checkNotNull(packageName);
        if (this.mWhitelistedPackages == null) {
            return false;
        }
        return this.mWhitelistedPackages.containsKey(packageName) && this.mWhitelistedPackages.get(packageName) == null;
    }

    public boolean isWhitelisted(ComponentName componentName) {
        Preconditions.checkNotNull(componentName);
        String packageName = componentName.getPackageName();
        ArraySet<ComponentName> whitelistedComponents = this.getWhitelistedComponents(packageName);
        if (whitelistedComponents != null) {
            return whitelistedComponents.contains(componentName);
        }
        return this.isWhitelisted(packageName);
    }

    public ArraySet<ComponentName> getWhitelistedComponents(String packageName) {
        Preconditions.checkNotNull(packageName);
        return this.mWhitelistedPackages == null ? null : this.mWhitelistedPackages.get(packageName);
    }

    public String toString() {
        return "WhitelistHelper[" + this.mWhitelistedPackages + ']';
    }

    public void dump(String prefix, String message, PrintWriter pw) {
        if (this.mWhitelistedPackages == null || this.mWhitelistedPackages.size() == 0) {
            pw.print(prefix);
            pw.print(message);
            pw.println(": (no whitelisted packages)");
            return;
        }
        String prefix2 = prefix + "  ";
        int size = this.mWhitelistedPackages.size();
        pw.print(prefix);
        pw.print(message);
        pw.print(": ");
        pw.print(size);
        pw.println(" packages");
        for (int i = 0; i < this.mWhitelistedPackages.size(); ++i) {
            String packageName = this.mWhitelistedPackages.keyAt(i);
            ArraySet<ComponentName> components = this.mWhitelistedPackages.valueAt(i);
            pw.print(prefix2);
            pw.print(i);
            pw.print(".");
            pw.print(packageName);
            pw.print(": ");
            if (components == null) {
                pw.println("(whole package)");
                continue;
            }
            pw.print("[");
            pw.print(components.valueAt(0));
            for (int j = 1; j < components.size(); ++j) {
                pw.print(", ");
                pw.print(components.valueAt(j));
            }
            pw.println("]");
        }
    }
}

