/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.os.IBinder;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.InputMethodPrivilegedOperations;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public final class InputMethodPrivilegedOperationsRegistry {
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static WeakHashMap<IBinder, WeakReference<InputMethodPrivilegedOperations>> sRegistry;
    private static InputMethodPrivilegedOperations sNop;

    private InputMethodPrivilegedOperationsRegistry() {
    }

    private static InputMethodPrivilegedOperations getNopOps() {
        if (sNop == null) {
            sNop = new InputMethodPrivilegedOperations();
        }
        return sNop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(IBinder token, InputMethodPrivilegedOperations ops) {
        Object object = sLock;
        synchronized (object) {
            WeakReference<InputMethodPrivilegedOperations> previousOps;
            if (sRegistry == null) {
                sRegistry = new WeakHashMap();
            }
            if ((previousOps = sRegistry.put(token, new WeakReference<InputMethodPrivilegedOperations>(ops))) != null) {
                throw new IllegalStateException(previousOps.get() + " is already registered for  this token=" + token + " newOps=" + ops);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputMethodPrivilegedOperations get(IBinder token) {
        Object object = sLock;
        synchronized (object) {
            if (sRegistry == null) {
                return InputMethodPrivilegedOperationsRegistry.getNopOps();
            }
            WeakReference<InputMethodPrivilegedOperations> wrapperRef = sRegistry.get(token);
            if (wrapperRef == null) {
                return InputMethodPrivilegedOperationsRegistry.getNopOps();
            }
            InputMethodPrivilegedOperations wrapper = (InputMethodPrivilegedOperations)wrapperRef.get();
            if (wrapper == null) {
                return InputMethodPrivilegedOperationsRegistry.getNopOps();
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(IBinder token) {
        Object object = sLock;
        synchronized (object) {
            if (sRegistry == null) {
                return;
            }
            sRegistry.remove(token);
            if (sRegistry.isEmpty()) {
                sRegistry = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegistered(IBinder token) {
        Object object = sLock;
        synchronized (object) {
            if (sRegistry == null) {
                return false;
            }
            return sRegistry.containsKey(token);
        }
    }
}

