/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.logging;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.metrics.LogMaker;
import android.os.Build;
import android.util.StatsLog;
import com.android.internal.logging.EventLogTags;

public class MetricsLogger {
    private static MetricsLogger sMetricsLogger;
    public static final int VIEW_UNKNOWN = 0;
    public static final int LOGTAG = 524292;

    private static MetricsLogger getLogger() {
        if (sMetricsLogger == null) {
            sMetricsLogger = new MetricsLogger();
        }
        return sMetricsLogger;
    }

    protected void saveLog(LogMaker log) {
        EventLogTags.writeSysuiMultiAction(log.serialize());
        StatsLog.write(83, 0, log.getEntries());
    }

    @UnsupportedAppUsage
    public void write(LogMaker content) {
        if (content.getType() == 0) {
            content.setType(4);
        }
        this.saveLog(content);
    }

    public void count(String name, int value) {
        this.saveLog(new LogMaker(803).setCounterName(name).setCounterValue(value));
    }

    public void histogram(String name, int bucket) {
        this.saveLog(new LogMaker(804).setCounterName(name).setCounterBucket(bucket).setCounterValue(1));
    }

    public void visible(int category) throws IllegalArgumentException {
        if (Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        this.saveLog(new LogMaker(category).setType(1));
    }

    public void hidden(int category) throws IllegalArgumentException {
        if (Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        this.saveLog(new LogMaker(category).setType(2));
    }

    public void visibility(int category, boolean visible) throws IllegalArgumentException {
        if (visible) {
            this.visible(category);
        } else {
            this.hidden(category);
        }
    }

    public void visibility(int category, int vis) throws IllegalArgumentException {
        this.visibility(category, vis == 0);
    }

    public void action(int category) {
        this.saveLog(new LogMaker(category).setType(4));
    }

    public void action(int category, int value) {
        this.saveLog(new LogMaker(category).setType(4).setSubtype(value));
    }

    public void action(int category, boolean value) {
        this.saveLog(new LogMaker(category).setType(4).setSubtype(value ? 1 : 0));
    }

    public void action(int category, String pkg) {
        if (Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        this.saveLog(new LogMaker(category).setType(4).setPackageName(pkg));
    }

    @Deprecated
    public static void visible(Context context, int category) throws IllegalArgumentException {
        MetricsLogger.getLogger().visible(category);
    }

    @Deprecated
    public static void hidden(Context context, int category) throws IllegalArgumentException {
        MetricsLogger.getLogger().hidden(category);
    }

    @Deprecated
    public static void visibility(Context context, int category, boolean visibile) throws IllegalArgumentException {
        MetricsLogger.getLogger().visibility(category, visibile);
    }

    @Deprecated
    public static void visibility(Context context, int category, int vis) throws IllegalArgumentException {
        MetricsLogger.visibility(context, category, vis == 0);
    }

    @Deprecated
    public static void action(Context context, int category) {
        MetricsLogger.getLogger().action(category);
    }

    @Deprecated
    public static void action(Context context, int category, int value) {
        MetricsLogger.getLogger().action(category, value);
    }

    @Deprecated
    public static void action(Context context, int category, boolean value) {
        MetricsLogger.getLogger().action(category, value);
    }

    @Deprecated
    public static void action(LogMaker content) {
        MetricsLogger.getLogger().write(content);
    }

    @Deprecated
    public static void action(Context context, int category, String pkg) {
        MetricsLogger.getLogger().action(category, pkg);
    }

    @Deprecated
    public static void count(Context context, String name, int value) {
        MetricsLogger.getLogger().count(name, value);
    }

    @Deprecated
    public static void histogram(Context context, String name, int bucket) {
        MetricsLogger.getLogger().histogram(name, bucket);
    }
}

