/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.midi;

import java.util.SortedMap;
import java.util.TreeMap;

public class EventScheduler {
    private static final long NANOS_PER_MILLI = 1000000L;
    private final Object mLock = new Object();
    private volatile SortedMap<Long, FastEventQueue> mEventBuffer = new TreeMap<Long, FastEventQueue>();
    private FastEventQueue mEventPool = null;
    private int mMaxPoolSize = 200;
    private boolean mClosed;

    public SchedulableEvent removeEventfromPool() {
        SchedulableEvent event = null;
        if (this.mEventPool != null && this.mEventPool.size() > 1) {
            event = this.mEventPool.remove();
        }
        return event;
    }

    public void addEventToPool(SchedulableEvent event) {
        if (this.mEventPool == null) {
            this.mEventPool = new FastEventQueue(event);
        } else if (this.mEventPool.size() < this.mMaxPoolSize) {
            this.mEventPool.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SchedulableEvent event) {
        Object object = this.mLock;
        synchronized (object) {
            FastEventQueue list = (FastEventQueue)this.mEventBuffer.get(event.getTimestamp());
            if (list == null) {
                long lowestTime = this.mEventBuffer.isEmpty() ? Long.MAX_VALUE : this.mEventBuffer.firstKey();
                list = new FastEventQueue(event);
                this.mEventBuffer.put(event.getTimestamp(), list);
                if (event.getTimestamp() < lowestTime) {
                    this.mLock.notify();
                }
            } else {
                list.add(event);
            }
        }
    }

    private SchedulableEvent removeNextEventLocked(long lowestTime) {
        FastEventQueue list = (FastEventQueue)this.mEventBuffer.get(lowestTime);
        if (list.size() == 1) {
            this.mEventBuffer.remove(lowestTime);
        }
        SchedulableEvent event = list.remove();
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulableEvent getNextEvent(long time) {
        SchedulableEvent event = null;
        Object object = this.mLock;
        synchronized (object) {
            long lowestTime;
            if (!this.mEventBuffer.isEmpty() && (lowestTime = this.mEventBuffer.firstKey().longValue()) <= time) {
                event = this.removeNextEventLocked(lowestTime);
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulableEvent waitNextEvent() throws InterruptedException {
        SchedulableEvent event = null;
        Object object = this.mLock;
        synchronized (object) {
            while (!this.mClosed) {
                long millisToWait = Integer.MAX_VALUE;
                if (!this.mEventBuffer.isEmpty()) {
                    long now = System.nanoTime();
                    long lowestTime = this.mEventBuffer.firstKey();
                    if (lowestTime <= now) {
                        event = this.removeNextEventLocked(lowestTime);
                        break;
                    }
                    long nanosToWait = lowestTime - now;
                    millisToWait = 1L + nanosToWait / 1000000L;
                    if (millisToWait > Integer.MAX_VALUE) {
                        millisToWait = Integer.MAX_VALUE;
                    }
                }
                this.mLock.wait((int)millisToWait);
            }
        }
        return event;
    }

    protected void flush() {
        this.mEventBuffer = new TreeMap<Long, FastEventQueue>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.mClosed = true;
            this.mLock.notify();
        }
    }

    public static class SchedulableEvent {
        private long mTimestamp;
        private volatile SchedulableEvent mNext = null;

        public SchedulableEvent(long timestamp) {
            this.mTimestamp = timestamp;
        }

        public long getTimestamp() {
            return this.mTimestamp;
        }

        public void setTimestamp(long timestamp) {
            this.mTimestamp = timestamp;
        }
    }

    private class FastEventQueue {
        volatile SchedulableEvent mFirst;
        volatile SchedulableEvent mLast;
        volatile long mEventsAdded;
        volatile long mEventsRemoved;

        FastEventQueue(SchedulableEvent event) {
            this.mLast = this.mFirst = event;
            this.mEventsAdded = 1L;
            this.mEventsRemoved = 0L;
        }

        int size() {
            return (int)(this.mEventsAdded - this.mEventsRemoved);
        }

        public SchedulableEvent remove() {
            ++this.mEventsRemoved;
            SchedulableEvent event = this.mFirst;
            this.mFirst = event.mNext;
            event.mNext = null;
            return event;
        }

        public void add(SchedulableEvent event) {
            event.mNext = null;
            this.mLast.mNext = event;
            this.mLast = event;
            ++this.mEventsAdded;
        }
    }
}

