/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.midi;

import android.media.midi.MidiReceiver;
import com.android.internal.midi.EventScheduler;
import java.io.IOException;

public class MidiEventScheduler
extends EventScheduler {
    private static final String TAG = "MidiEventScheduler";
    private static final int POOL_EVENT_SIZE = 16;
    private MidiReceiver mReceiver = new SchedulingReceiver();

    private MidiEvent createScheduledEvent(byte[] msg, int offset, int count, long timestamp) {
        MidiEvent event;
        if (count > 16) {
            event = new MidiEvent(msg, offset, count, timestamp);
        } else {
            event = (MidiEvent)this.removeEventfromPool();
            if (event == null) {
                event = new MidiEvent(16);
            }
            System.arraycopy(msg, offset, event.data, 0, count);
            event.count = count;
            event.setTimestamp(timestamp);
        }
        return event;
    }

    @Override
    public void addEventToPool(EventScheduler.SchedulableEvent event) {
        if (event instanceof MidiEvent) {
            MidiEvent midiEvent = (MidiEvent)event;
            if (midiEvent.data.length == 16) {
                super.addEventToPool(event);
            }
        }
    }

    public MidiReceiver getReceiver() {
        return this.mReceiver;
    }

    public static class MidiEvent
    extends EventScheduler.SchedulableEvent {
        public int count = 0;
        public byte[] data;

        private MidiEvent(int count) {
            super(0L);
            this.data = new byte[count];
        }

        private MidiEvent(byte[] msg, int offset, int count, long timestamp) {
            super(timestamp);
            this.data = new byte[count];
            System.arraycopy(msg, offset, this.data, 0, count);
            this.count = count;
        }

        public String toString() {
            String text = "Event: ";
            for (int i = 0; i < this.count; ++i) {
                text = text + this.data[i] + ", ";
            }
            return text;
        }
    }

    private class SchedulingReceiver
    extends MidiReceiver {
        private SchedulingReceiver() {
        }

        @Override
        public void onSend(byte[] msg, int offset, int count, long timestamp) throws IOException {
            MidiEvent event = MidiEventScheduler.this.createScheduledEvent(msg, offset, count, timestamp);
            if (event != null) {
                MidiEventScheduler.this.add(event);
            }
        }

        @Override
        public void onFlush() {
            MidiEventScheduler.this.flush();
        }
    }
}

