/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.notification;

import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.media.AudioAttributes;
import android.os.RemoteException;
import android.provider.Settings;
import java.util.ArrayList;
import java.util.Arrays;

public class SystemNotificationChannels {
    public static String VIRTUAL_KEYBOARD = "VIRTUAL_KEYBOARD";
    public static String PHYSICAL_KEYBOARD = "PHYSICAL_KEYBOARD";
    public static String SECURITY = "SECURITY";
    public static String CAR_MODE = "CAR_MODE";
    public static String ACCOUNT = "ACCOUNT";
    public static String DEVELOPER = "DEVELOPER";
    public static String UPDATES = "UPDATES";
    public static String NETWORK_STATUS = "NETWORK_STATUS";
    public static String NETWORK_ALERTS = "NETWORK_ALERTS";
    public static String NETWORK_AVAILABLE = "NETWORK_AVAILABLE";
    public static String VPN = "VPN";
    @Deprecated
    public static String DEVICE_ADMIN_DEPRECATED = "DEVICE_ADMIN";
    public static String DEVICE_ADMIN = "DEVICE_ADMIN_ALERTS";
    public static String ALERTS = "ALERTS";
    public static String RETAIL_MODE = "RETAIL_MODE";
    public static String USB = "USB";
    public static String FOREGROUND_SERVICE = "FOREGROUND_SERVICE";
    public static String HEAVY_WEIGHT_APP = "HEAVY_WEIGHT_APP";
    public static String SYSTEM_CHANGES = "SYSTEM_CHANGES";
    public static String DO_NOT_DISTURB = "DO_NOT_DISTURB";

    public static void createAll(Context context) {
        NotificationManager nm = context.getSystemService(NotificationManager.class);
        ArrayList<NotificationChannel> channelsList = new ArrayList<NotificationChannel>();
        NotificationChannel keyboard = new NotificationChannel(VIRTUAL_KEYBOARD, context.getString(17040505), 2);
        keyboard.setBlockableSystem(true);
        channelsList.add(keyboard);
        NotificationChannel physicalKeyboardChannel = new NotificationChannel(PHYSICAL_KEYBOARD, context.getString(17040497), 3);
        physicalKeyboardChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        physicalKeyboardChannel.setBlockableSystem(true);
        channelsList.add(physicalKeyboardChannel);
        NotificationChannel security = new NotificationChannel(SECURITY, context.getString(17040499), 2);
        channelsList.add(security);
        NotificationChannel car = new NotificationChannel(CAR_MODE, context.getString(17040485), 2);
        car.setBlockableSystem(true);
        channelsList.add(car);
        channelsList.add(SystemNotificationChannels.newAccountChannel(context));
        NotificationChannel developer = new NotificationChannel(DEVELOPER, context.getString(17040486), 2);
        developer.setBlockableSystem(true);
        channelsList.add(developer);
        NotificationChannel updates = new NotificationChannel(UPDATES, context.getString(17040503), 2);
        channelsList.add(updates);
        NotificationChannel network = new NotificationChannel(NETWORK_STATUS, context.getString(17040496), 2);
        channelsList.add(network);
        NotificationChannel networkAlertsChannel = new NotificationChannel(NETWORK_ALERTS, context.getString(17040494), 4);
        networkAlertsChannel.setBlockableSystem(true);
        channelsList.add(networkAlertsChannel);
        NotificationChannel networkAvailable = new NotificationChannel(NETWORK_AVAILABLE, context.getString(17040495), 2);
        networkAvailable.setBlockableSystem(true);
        channelsList.add(networkAvailable);
        NotificationChannel vpn = new NotificationChannel(VPN, context.getString(17040507), 2);
        channelsList.add(vpn);
        NotificationChannel deviceAdmin = new NotificationChannel(DEVICE_ADMIN, context.getString(17040487), 4);
        channelsList.add(deviceAdmin);
        NotificationChannel alertsChannel = new NotificationChannel(ALERTS, context.getString(17040483), 3);
        channelsList.add(alertsChannel);
        NotificationChannel retail = new NotificationChannel(RETAIL_MODE, context.getString(17040498), 2);
        channelsList.add(retail);
        NotificationChannel usb = new NotificationChannel(USB, context.getString(17040504), 1);
        channelsList.add(usb);
        NotificationChannel foregroundChannel = new NotificationChannel(FOREGROUND_SERVICE, context.getString(17040490), 2);
        foregroundChannel.setBlockableSystem(true);
        channelsList.add(foregroundChannel);
        NotificationChannel heavyWeightChannel = new NotificationChannel(HEAVY_WEIGHT_APP, context.getString(17040491), 3);
        heavyWeightChannel.setShowBadge(false);
        heavyWeightChannel.setSound(null, new AudioAttributes.Builder().setContentType(4).setUsage(10).build());
        channelsList.add(heavyWeightChannel);
        NotificationChannel systemChanges = new NotificationChannel(SYSTEM_CHANGES, context.getString(17040502), 2);
        channelsList.add(systemChanges);
        NotificationChannel dndChanges = new NotificationChannel(DO_NOT_DISTURB, context.getString(17040488), 2);
        channelsList.add(dndChanges);
        nm.createNotificationChannels(channelsList);
    }

    public static void removeDeprecated(Context context) {
        NotificationManager nm = context.getSystemService(NotificationManager.class);
        nm.deleteNotificationChannel(DEVICE_ADMIN_DEPRECATED);
    }

    public static void createAccountChannelForPackage(String pkg, int uid, Context context) {
        INotificationManager iNotificationManager = NotificationManager.getService();
        try {
            iNotificationManager.createNotificationChannelsForPackage(pkg, uid, new ParceledListSlice<NotificationChannel>(Arrays.asList(SystemNotificationChannels.newAccountChannel(context))));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static NotificationChannel newAccountChannel(Context context) {
        return new NotificationChannel(ACCOUNT, context.getString(17040482), 2);
    }

    private SystemNotificationChannels() {
    }
}

