/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.LoadedApk;
import android.app.ZygotePreload;
import android.content.ComponentName;
import android.content.pm.ApplicationInfo;
import android.net.LocalSocket;
import android.util.Log;
import com.android.internal.os.ChildZygoteInit;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteConnection;
import com.android.internal.os.ZygoteServer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;

class AppZygoteInit {
    public static final String TAG = "AppZygoteInit";
    private static ZygoteServer sServer;

    AppZygoteInit() {
    }

    public static void main(String[] argv) {
        AppZygoteServer server = new AppZygoteServer();
        ChildZygoteInit.runZygoteServer(server, argv);
    }

    private static class AppZygoteConnection
    extends ZygoteConnection {
        AppZygoteConnection(LocalSocket socket, String abiList) throws IOException {
            super(socket, abiList);
        }

        @Override
        protected void preload() {
        }

        @Override
        protected boolean isPreloadComplete() {
            return true;
        }

        @Override
        protected boolean canPreloadApp() {
            return true;
        }

        @Override
        protected void handlePreloadApp(ApplicationInfo appInfo) {
            ClassLoader loader;
            block7: {
                Log.i(AppZygoteInit.TAG, "Beginning application preload for " + appInfo.packageName);
                LoadedApk loadedApk = new LoadedApk(null, appInfo, null, null, false, true, false);
                loader = loadedApk.getClassLoader();
                Zygote.allowAppFilesAcrossFork(appInfo);
                if (appInfo.zygotePreloadName != null) {
                    try {
                        ComponentName preloadName = ComponentName.createRelative(appInfo.packageName, appInfo.zygotePreloadName);
                        Class<?> cl = Class.forName(preloadName.getClassName(), true, loader);
                        if (!ZygotePreload.class.isAssignableFrom(cl)) {
                            Log.e(AppZygoteInit.TAG, preloadName.getClassName() + " does not implement " + ZygotePreload.class.getName());
                            break block7;
                        }
                        Constructor<?> ctor = cl.getConstructor(new Class[0]);
                        ZygotePreload preloadObject = (ZygotePreload)ctor.newInstance(new Object[0]);
                        preloadObject.doPreload(appInfo);
                    }
                    catch (ReflectiveOperationException e) {
                        Log.e(AppZygoteInit.TAG, "AppZygote application preload failed for " + appInfo.zygotePreloadName, e);
                    }
                } else {
                    Log.i(AppZygoteInit.TAG, "No zygotePreloadName attribute specified.");
                }
            }
            try {
                DataOutputStream socketOut = this.getSocketOutputStream();
                socketOut.writeInt(loader != null ? 1 : 0);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error writing to command socket", e);
            }
            Log.i(AppZygoteInit.TAG, "Application preload done");
        }
    }

    private static class AppZygoteServer
    extends ZygoteServer {
        private AppZygoteServer() {
        }

        @Override
        protected ZygoteConnection createNewConnection(LocalSocket socket, String abiList) throws IOException {
            return new AppZygoteConnection(socket, abiList);
        }
    }
}

