/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.UnsupportedAppUsage;
import android.os.ShellCommand;
import java.io.PrintStream;

public abstract class BaseCommand {
    @UnsupportedAppUsage
    protected final ShellCommand mArgs = new ShellCommand(){

        @Override
        public int onCommand(String cmd) {
            return 0;
        }

        @Override
        public void onHelp() {
        }
    };
    public static final String FATAL_ERROR_CODE = "Error type 1";
    public static final String NO_SYSTEM_ERROR_CODE = "Error type 2";
    public static final String NO_CLASS_ERROR_CODE = "Error type 3";
    private String[] mRawArgs;

    public void run(String[] args) {
        if (args.length < 1) {
            this.onShowUsage(System.out);
            return;
        }
        this.mRawArgs = args;
        this.mArgs.init(null, null, null, null, args, null, 0);
        try {
            this.onRun();
        }
        catch (IllegalArgumentException e) {
            this.onShowUsage(System.err);
            System.err.println();
            System.err.println("Error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void showUsage() {
        this.onShowUsage(System.err);
    }

    public void showError(String message) {
        this.onShowUsage(System.err);
        System.err.println();
        System.err.println(message);
    }

    public abstract void onRun() throws Exception;

    public abstract void onShowUsage(PrintStream var1);

    public String nextOption() {
        return this.mArgs.getNextOption();
    }

    public String nextArg() {
        return this.mArgs.getNextArg();
    }

    public String peekNextArg() {
        return this.mArgs.peekNextArg();
    }

    public String nextArgRequired() {
        return this.mArgs.getNextArgRequired();
    }

    public String[] getRawArgs() {
        return this.mRawArgs;
    }
}

