/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Binder;
import android.os.Process;
import android.os.SystemClock;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.AppIdToPackageMap;
import com.android.internal.os.BinderInternal;
import com.android.internal.os.CachedDeviceState;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.ToDoubleFunction;

public class BinderCallsStats
implements BinderInternal.Observer {
    public static final boolean ENABLED_DEFAULT = true;
    public static final boolean DETAILED_TRACKING_DEFAULT = true;
    public static final int PERIODIC_SAMPLING_INTERVAL_DEFAULT = 1000;
    public static final boolean DEFAULT_TRACK_SCREEN_INTERACTIVE = false;
    public static final boolean DEFAULT_TRACK_DIRECT_CALLING_UID = true;
    public static final int MAX_BINDER_CALL_STATS_COUNT_DEFAULT = 1500;
    private static final String DEBUG_ENTRY_PREFIX = "__DEBUG_";
    private static final String TAG = "BinderCallsStats";
    private static final int CALL_SESSIONS_POOL_SIZE = 100;
    private static final int MAX_EXCEPTION_COUNT_SIZE = 50;
    private static final String EXCEPTION_COUNT_OVERFLOW_NAME = "overflow";
    private static final Class<? extends Binder> OVERFLOW_BINDER = OverflowBinder.class;
    private static final boolean OVERFLOW_SCREEN_INTERACTIVE = false;
    private static final int OVERFLOW_DIRECT_CALLING_UID = -1;
    private static final int OVERFLOW_TRANSACTION_CODE = -1;
    private boolean mDetailedTracking = true;
    private int mPeriodicSamplingInterval = 1000;
    private int mMaxBinderCallStatsCount = 1500;
    @GuardedBy(value={"mLock"})
    private final SparseArray<UidEntry> mUidEntries = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<String, Integer> mExceptionCounts = new ArrayMap();
    private final Queue<BinderInternal.CallSession> mCallSessionsPool = new ConcurrentLinkedQueue<BinderInternal.CallSession>();
    private final Object mLock = new Object();
    private final Random mRandom;
    private long mStartCurrentTime = System.currentTimeMillis();
    private long mStartElapsedTime = SystemClock.elapsedRealtime();
    private long mCallStatsCount = 0L;
    private boolean mAddDebugEntries = false;
    private boolean mTrackDirectCallingUid = true;
    private boolean mTrackScreenInteractive = false;
    private CachedDeviceState.Readonly mDeviceState;
    private CachedDeviceState.TimeInStateStopwatch mBatteryStopwatch;

    public BinderCallsStats(Injector injector) {
        this.mRandom = injector.getRandomGenerator();
    }

    public void setDeviceState(CachedDeviceState.Readonly deviceState) {
        if (this.mBatteryStopwatch != null) {
            this.mBatteryStopwatch.close();
        }
        this.mDeviceState = deviceState;
        this.mBatteryStopwatch = deviceState.createTimeOnBatteryStopwatch();
    }

    @Override
    public BinderInternal.CallSession callStarted(Binder binder, int code, int workSourceUid) {
        if (this.mDeviceState == null || this.mDeviceState.isCharging()) {
            return null;
        }
        BinderInternal.CallSession s = this.obtainCallSession();
        s.binderClass = binder.getClass();
        s.transactionCode = code;
        s.exceptionThrown = false;
        s.cpuTimeStarted = -1L;
        s.timeStarted = -1L;
        if (this.shouldRecordDetailedData()) {
            s.cpuTimeStarted = this.getThreadTimeMicro();
            s.timeStarted = this.getElapsedRealtimeMicro();
        }
        return s;
    }

    private BinderInternal.CallSession obtainCallSession() {
        BinderInternal.CallSession s = this.mCallSessionsPool.poll();
        return s == null ? new BinderInternal.CallSession() : s;
    }

    @Override
    public void callEnded(BinderInternal.CallSession s, int parcelRequestSize, int parcelReplySize, int workSourceUid) {
        if (s == null) {
            return;
        }
        this.processCallEnded(s, parcelRequestSize, parcelReplySize, workSourceUid);
        if (this.mCallSessionsPool.size() < 100) {
            this.mCallSessionsPool.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCallEnded(BinderInternal.CallSession s, int parcelRequestSize, int parcelReplySize, int workSourceUid) {
        long latencyDuration;
        long duration;
        boolean recordCall;
        boolean bl = recordCall = s.cpuTimeStarted >= 0L;
        if (recordCall) {
            duration = this.getThreadTimeMicro() - s.cpuTimeStarted;
            latencyDuration = this.getElapsedRealtimeMicro() - s.timeStarted;
        } else {
            duration = 0L;
            latencyDuration = 0L;
        }
        boolean screenInteractive = this.mTrackScreenInteractive ? this.mDeviceState.isScreenInteractive() : false;
        int callingUid = this.mTrackDirectCallingUid ? this.getCallingUid() : -1;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDeviceState == null || this.mDeviceState.isCharging()) {
                return;
            }
            UidEntry uidEntry = this.getUidEntry(workSourceUid);
            ++uidEntry.callCount;
            if (recordCall) {
                boolean isNewCallStat;
                uidEntry.cpuTimeMicros += duration;
                ++uidEntry.recordedCallCount;
                CallStat callStat = uidEntry.getOrCreate(callingUid, s.binderClass, s.transactionCode, screenInteractive, this.mCallStatsCount >= (long)this.mMaxBinderCallStatsCount);
                boolean bl2 = isNewCallStat = callStat.callCount == 0L;
                if (isNewCallStat) {
                    ++this.mCallStatsCount;
                }
                ++callStat.callCount;
                ++callStat.recordedCallCount;
                callStat.cpuTimeMicros += duration;
                callStat.maxCpuTimeMicros = Math.max(callStat.maxCpuTimeMicros, duration);
                callStat.latencyMicros += latencyDuration;
                callStat.maxLatencyMicros = Math.max(callStat.maxLatencyMicros, latencyDuration);
                if (this.mDetailedTracking) {
                    callStat.exceptionCount = callStat.exceptionCount + (s.exceptionThrown ? 1L : 0L);
                    callStat.maxRequestSizeBytes = Math.max(callStat.maxRequestSizeBytes, (long)parcelRequestSize);
                    callStat.maxReplySizeBytes = Math.max(callStat.maxReplySizeBytes, (long)parcelReplySize);
                }
            } else {
                CallStat callStat = uidEntry.get(callingUid, s.binderClass, s.transactionCode, screenInteractive);
                if (callStat != null) {
                    ++callStat.callCount;
                }
            }
        }
    }

    private UidEntry getUidEntry(int uid) {
        UidEntry uidEntry = this.mUidEntries.get(uid);
        if (uidEntry == null) {
            uidEntry = new UidEntry(uid);
            this.mUidEntries.put(uid, uidEntry);
        }
        return uidEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callThrewException(BinderInternal.CallSession s, Exception exception) {
        if (s == null) {
            return;
        }
        s.exceptionThrown = true;
        try {
            String className = exception.getClass().getName();
            Object object = this.mLock;
            synchronized (object) {
                Integer count;
                if (this.mExceptionCounts.size() >= 50) {
                    className = EXCEPTION_COUNT_OVERFLOW_NAME;
                }
                this.mExceptionCounts.put(className, (count = this.mExceptionCounts.get(className)) == null ? 1 : count + 1);
            }
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unexpected exception while updating mExceptionCounts");
        }
    }

    private Method getDefaultTransactionNameMethod(Class<? extends Binder> binder) {
        try {
            return binder.getMethod("getDefaultTransactionName", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private String resolveTransactionCode(Method getDefaultTransactionName, int transactionCode) {
        if (getDefaultTransactionName == null) {
            return null;
        }
        try {
            return (String)getDefaultTransactionName.invoke(null, transactionCode);
        }
        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ExportedCallStat> getExportedCallStats() {
        if (!this.mDetailedTracking) {
            return new ArrayList<ExportedCallStat>();
        }
        ArrayList<ExportedCallStat> resultCallStats = new ArrayList<ExportedCallStat>();
        Object object = this.mLock;
        synchronized (object) {
            int uidEntriesSize = this.mUidEntries.size();
            for (int entryIdx = 0; entryIdx < uidEntriesSize; ++entryIdx) {
                UidEntry entry = this.mUidEntries.valueAt(entryIdx);
                for (CallStat stat : entry.getCallStatsList()) {
                    ExportedCallStat exported = new ExportedCallStat();
                    exported.workSourceUid = entry.workSourceUid;
                    exported.callingUid = stat.callingUid;
                    exported.className = stat.binderClass.getName();
                    exported.binderClass = stat.binderClass;
                    exported.transactionCode = stat.transactionCode;
                    exported.screenInteractive = stat.screenInteractive;
                    exported.cpuTimeMicros = stat.cpuTimeMicros;
                    exported.maxCpuTimeMicros = stat.maxCpuTimeMicros;
                    exported.latencyMicros = stat.latencyMicros;
                    exported.maxLatencyMicros = stat.maxLatencyMicros;
                    exported.recordedCallCount = stat.recordedCallCount;
                    exported.callCount = stat.callCount;
                    exported.maxRequestSizeBytes = stat.maxRequestSizeBytes;
                    exported.maxReplySizeBytes = stat.maxReplySizeBytes;
                    exported.exceptionCount = stat.exceptionCount;
                    resultCallStats.add(exported);
                }
            }
        }
        Object previous = null;
        Method getDefaultTransactionName = null;
        String previousMethodName = null;
        resultCallStats.sort(BinderCallsStats::compareByBinderClassAndCode);
        for (ExportedCallStat exported : resultCallStats) {
            String resolvedCode;
            boolean isCodeDifferent;
            boolean isClassDifferent;
            boolean bl = isClassDifferent = previous == null || !previous.className.equals(exported.className);
            if (isClassDifferent) {
                getDefaultTransactionName = this.getDefaultTransactionNameMethod(exported.binderClass);
            }
            boolean bl2 = isCodeDifferent = previous == null || previous.transactionCode != exported.transactionCode;
            String methodName = isClassDifferent || isCodeDifferent ? ((resolvedCode = this.resolveTransactionCode(getDefaultTransactionName, exported.transactionCode)) == null ? String.valueOf(exported.transactionCode) : resolvedCode) : previousMethodName;
            previousMethodName = methodName;
            exported.methodName = methodName;
        }
        if (this.mAddDebugEntries && this.mBatteryStopwatch != null) {
            resultCallStats.add(this.createDebugEntry("start_time_millis", this.mStartElapsedTime));
            resultCallStats.add(this.createDebugEntry("end_time_millis", SystemClock.elapsedRealtime()));
            resultCallStats.add(this.createDebugEntry("battery_time_millis", this.mBatteryStopwatch.getMillis()));
            resultCallStats.add(this.createDebugEntry("sampling_interval", this.mPeriodicSamplingInterval));
        }
        return resultCallStats;
    }

    private ExportedCallStat createDebugEntry(String variableName, long value) {
        int uid = Process.myUid();
        ExportedCallStat callStat = new ExportedCallStat();
        callStat.className = "";
        callStat.workSourceUid = uid;
        callStat.callingUid = uid;
        callStat.recordedCallCount = 1L;
        callStat.callCount = 1L;
        callStat.methodName = DEBUG_ENTRY_PREFIX + variableName;
        callStat.latencyMicros = value;
        return callStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayMap<String, Integer> getExportedExceptionStats() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayMap<String, Integer>(this.mExceptionCounts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, AppIdToPackageMap packageMap, boolean verbose) {
        Object object = this.mLock;
        synchronized (object) {
            this.dumpLocked(pw, packageMap, verbose);
        }
    }

    private void dumpLocked(PrintWriter pw, AppIdToPackageMap packageMap, boolean verbose) {
        long totalCallsCount = 0L;
        long totalRecordedCallsCount = 0L;
        long totalCpuTime = 0L;
        pw.print("Start time: ");
        pw.println(DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", this.mStartCurrentTime));
        pw.print("On battery time (ms): ");
        pw.println(this.mBatteryStopwatch != null ? this.mBatteryStopwatch.getMillis() : 0L);
        pw.println("Sampling interval period: " + this.mPeriodicSamplingInterval);
        ArrayList<UidEntry> entries = new ArrayList<UidEntry>();
        int uidEntriesSize = this.mUidEntries.size();
        for (int i = 0; i < uidEntriesSize; ++i) {
            UidEntry e3 = this.mUidEntries.valueAt(i);
            entries.add(e3);
            totalCpuTime += e3.cpuTimeMicros;
            totalRecordedCallsCount += e3.recordedCallCount;
            totalCallsCount += e3.callCount;
        }
        entries.sort(Comparator.comparingDouble(value -> value.cpuTimeMicros).reversed());
        String datasetSizeDesc = verbose ? "" : "(top 90% by cpu time) ";
        StringBuilder sb = new StringBuilder();
        pw.println("Per-UID raw data " + datasetSizeDesc + "(package/uid, worksource, call_desc, screen_interactive, cpu_time_micros, max_cpu_time_micros, latency_time_micros, max_latency_time_micros, exception_count, max_request_size_bytes, max_reply_size_bytes, recorded_call_count, call_count):");
        ArrayList<ExportedCallStat> exportedCallStats = this.getExportedCallStats();
        exportedCallStats.sort(BinderCallsStats::compareByCpuDesc);
        for (ExportedCallStat exportedCallStat : exportedCallStats) {
            if (exportedCallStat.methodName.startsWith(DEBUG_ENTRY_PREFIX)) continue;
            sb.setLength(0);
            sb.append("    ").append(packageMap.mapUid(exportedCallStat.callingUid)).append(',').append(packageMap.mapUid(exportedCallStat.workSourceUid)).append(',').append(exportedCallStat.className).append('#').append(exportedCallStat.methodName).append(',').append(exportedCallStat.screenInteractive).append(',').append(exportedCallStat.cpuTimeMicros).append(',').append(exportedCallStat.maxCpuTimeMicros).append(',').append(exportedCallStat.latencyMicros).append(',').append(exportedCallStat.maxLatencyMicros).append(',').append(this.mDetailedTracking ? exportedCallStat.exceptionCount : 95L).append(',').append(this.mDetailedTracking ? exportedCallStat.maxRequestSizeBytes : 95L).append(',').append(this.mDetailedTracking ? exportedCallStat.maxReplySizeBytes : 95L).append(',').append(exportedCallStat.recordedCallCount).append(',').append(exportedCallStat.callCount);
            pw.println(sb);
        }
        pw.println();
        pw.println("Per-UID Summary " + datasetSizeDesc + "(cpu_time, % of total cpu_time, recorded_call_count, call_count, package/uid):");
        ArrayList<UidEntry> summaryEntries = verbose ? entries : BinderCallsStats.getHighestValues(entries, value -> value.cpuTimeMicros, 0.9);
        for (UidEntry entry : summaryEntries) {
            String uidStr = packageMap.mapUid(entry.workSourceUid);
            pw.println(String.format("  %10d %3.0f%% %8d %8d %s", entry.cpuTimeMicros, 100.0 * (double)entry.cpuTimeMicros / (double)totalCpuTime, entry.recordedCallCount, entry.callCount, uidStr));
        }
        pw.println();
        pw.println(String.format("  Summary: total_cpu_time=%d, calls_count=%d, avg_call_cpu_time=%.0f", totalCpuTime, totalCallsCount, (double)totalCpuTime / (double)totalRecordedCallsCount));
        pw.println();
        pw.println("Exceptions thrown (exception_count, class_name):");
        ArrayList arrayList = new ArrayList();
        this.mExceptionCounts.entrySet().iterator().forEachRemaining(e -> exceptionEntries.add(Pair.create((String)e.getKey(), (Integer)e.getValue())));
        arrayList.sort((e1, e2) -> Integer.compare((Integer)e2.second, (Integer)e1.second));
        for (Pair entry : arrayList) {
            pw.println(String.format("  %6d %s", entry.second, entry.first));
        }
        if (this.mPeriodicSamplingInterval != 1) {
            pw.println("");
            pw.println("/!\\ Displayed data is sampled. See sampling interval at the top.");
        }
    }

    protected long getThreadTimeMicro() {
        return SystemClock.currentThreadTimeMicro();
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    protected long getElapsedRealtimeMicro() {
        return SystemClock.elapsedRealtimeNanos() / 1000L;
    }

    protected boolean shouldRecordDetailedData() {
        return this.mRandom.nextInt() % this.mPeriodicSamplingInterval == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetailedTracking(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            if (enabled != this.mDetailedTracking) {
                this.mDetailedTracking = enabled;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackScreenInteractive(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            if (enabled != this.mTrackScreenInteractive) {
                this.mTrackScreenInteractive = enabled;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackDirectCallerUid(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            if (enabled != this.mTrackDirectCallingUid) {
                this.mTrackDirectCallingUid = enabled;
                this.reset();
            }
        }
    }

    public void setAddDebugEntries(boolean addDebugEntries) {
        this.mAddDebugEntries = addDebugEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBinderCallStats(int maxKeys) {
        if (maxKeys <= 0) {
            Slog.w(TAG, "Ignored invalid max value (value must be positive): " + maxKeys);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (maxKeys != this.mMaxBinderCallStatsCount) {
                this.mMaxBinderCallStatsCount = maxKeys;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSamplingInterval(int samplingInterval) {
        if (samplingInterval <= 0) {
            Slog.w(TAG, "Ignored invalid sampling interval (value must be positive): " + samplingInterval);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (samplingInterval != this.mPeriodicSamplingInterval) {
                this.mPeriodicSamplingInterval = samplingInterval;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallStatsCount = 0L;
            this.mUidEntries.clear();
            this.mExceptionCounts.clear();
            this.mStartCurrentTime = System.currentTimeMillis();
            this.mStartElapsedTime = SystemClock.elapsedRealtime();
            if (this.mBatteryStopwatch != null) {
                this.mBatteryStopwatch.reset();
            }
        }
    }

    @VisibleForTesting
    public SparseArray<UidEntry> getUidEntries() {
        return this.mUidEntries;
    }

    @VisibleForTesting
    public ArrayMap<String, Integer> getExceptionCounts() {
        return this.mExceptionCounts;
    }

    @VisibleForTesting
    public static <T> List<T> getHighestValues(List<T> list, ToDoubleFunction<T> toDouble, double percentile) {
        ArrayList<T> sortedList = new ArrayList<T>(list);
        sortedList.sort(Comparator.comparingDouble(toDouble).reversed());
        double total = 0.0;
        for (T item : list) {
            total += toDouble.applyAsDouble(item);
        }
        ArrayList result = new ArrayList();
        double runningSum = 0.0;
        for (Object item : sortedList) {
            if (runningSum > percentile * total) break;
            result.add(item);
            runningSum += toDouble.applyAsDouble(item);
        }
        return result;
    }

    private static int compareByCpuDesc(ExportedCallStat a, ExportedCallStat b) {
        return Long.compare(b.cpuTimeMicros, a.cpuTimeMicros);
    }

    private static int compareByBinderClassAndCode(ExportedCallStat a, ExportedCallStat b) {
        int result = a.className.compareTo(b.className);
        return result != 0 ? result : Integer.compare(a.transactionCode, b.transactionCode);
    }

    @VisibleForTesting
    public static class UidEntry {
        public int workSourceUid;
        public long recordedCallCount;
        public long callCount;
        public long cpuTimeMicros;
        private Map<CallStatKey, CallStat> mCallStats = new ArrayMap<CallStatKey, CallStat>();
        private CallStatKey mTempKey = new CallStatKey();

        UidEntry(int uid) {
            this.workSourceUid = uid;
        }

        CallStat get(int callingUid, Class<? extends Binder> binderClass, int transactionCode, boolean screenInteractive) {
            this.mTempKey.callingUid = callingUid;
            this.mTempKey.binderClass = binderClass;
            this.mTempKey.transactionCode = transactionCode;
            this.mTempKey.screenInteractive = screenInteractive;
            return this.mCallStats.get(this.mTempKey);
        }

        CallStat getOrCreate(int callingUid, Class<? extends Binder> binderClass, int transactionCode, boolean screenInteractive, boolean maxCallStatsReached) {
            CallStat mapCallStat = this.get(callingUid, binderClass, transactionCode, screenInteractive);
            if (mapCallStat == null) {
                if (maxCallStatsReached) {
                    mapCallStat = this.get(-1, OVERFLOW_BINDER, -1, false);
                    if (mapCallStat != null) {
                        return mapCallStat;
                    }
                    callingUid = -1;
                    binderClass = OVERFLOW_BINDER;
                    transactionCode = -1;
                    screenInteractive = false;
                }
                mapCallStat = new CallStat(callingUid, binderClass, transactionCode, screenInteractive);
                CallStatKey key = new CallStatKey();
                key.callingUid = callingUid;
                key.binderClass = binderClass;
                key.transactionCode = transactionCode;
                key.screenInteractive = screenInteractive;
                this.mCallStats.put(key, mapCallStat);
            }
            return mapCallStat;
        }

        public Collection<CallStat> getCallStatsList() {
            return this.mCallStats.values();
        }

        public String toString() {
            return "UidEntry{cpuTimeMicros=" + this.cpuTimeMicros + ", callCount=" + this.callCount + ", mCallStats=" + this.mCallStats + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            UidEntry uidEntry = (UidEntry)o;
            return this.workSourceUid == uidEntry.workSourceUid;
        }

        public int hashCode() {
            return this.workSourceUid;
        }
    }

    public static class CallStatKey {
        public int callingUid;
        public Class<? extends Binder> binderClass;
        public int transactionCode;
        private boolean screenInteractive;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            CallStatKey key = (CallStatKey)o;
            return this.callingUid == key.callingUid && this.transactionCode == key.transactionCode && this.screenInteractive == key.screenInteractive && this.binderClass.equals(key.binderClass);
        }

        public int hashCode() {
            int result = this.binderClass.hashCode();
            result = 31 * result + this.transactionCode;
            result = 31 * result + this.callingUid;
            result = 31 * result + (this.screenInteractive ? 1231 : 1237);
            return result;
        }
    }

    @VisibleForTesting
    public static class CallStat {
        public final int callingUid;
        public final Class<? extends Binder> binderClass;
        public final int transactionCode;
        public final boolean screenInteractive;
        public long recordedCallCount;
        public long callCount;
        public long cpuTimeMicros;
        public long maxCpuTimeMicros;
        public long latencyMicros;
        public long maxLatencyMicros;
        public long maxRequestSizeBytes;
        public long maxReplySizeBytes;
        public long exceptionCount;

        CallStat(int callingUid, Class<? extends Binder> binderClass, int transactionCode, boolean screenInteractive) {
            this.callingUid = callingUid;
            this.binderClass = binderClass;
            this.transactionCode = transactionCode;
            this.screenInteractive = screenInteractive;
        }
    }

    public static class ExportedCallStat {
        public int callingUid;
        public int workSourceUid;
        public String className;
        public String methodName;
        public boolean screenInteractive;
        public long cpuTimeMicros;
        public long maxCpuTimeMicros;
        public long latencyMicros;
        public long maxLatencyMicros;
        public long callCount;
        public long recordedCallCount;
        public long maxRequestSizeBytes;
        public long maxReplySizeBytes;
        public long exceptionCount;
        Class<? extends Binder> binderClass;
        int transactionCode;
    }

    public static class Injector {
        public Random getRandomGenerator() {
            return new Random();
        }
    }

    private static class OverflowBinder
    extends Binder {
        private OverflowBinder() {
        }
    }
}

