/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;

public class BinderDeathDispatcher<T extends IInterface> {
    private static final String TAG = "BinderDeathDispatcher";
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<IBinder, RecipientsInfo> mTargets = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int linkToDeath(T target, IBinder.DeathRecipient recipient) {
        IBinder ib = target.asBinder();
        Object object = this.mLock;
        synchronized (object) {
            RecipientsInfo info = this.mTargets.get(ib);
            if (info == null) {
                info = new RecipientsInfo(ib);
                try {
                    ib.linkToDeath(info, 0);
                }
                catch (RemoteException e) {
                    return -1;
                }
                this.mTargets.put(ib, info);
            }
            info.mRecipients.add(recipient);
            return info.mRecipients.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkToDeath(T target, IBinder.DeathRecipient recipient) {
        IBinder ib = target.asBinder();
        Object object = this.mLock;
        synchronized (object) {
            RecipientsInfo info = this.mTargets.get(ib);
            if (info == null) {
                return;
            }
            if (info.mRecipients.remove(recipient) && info.mRecipients.size() == 0) {
                info.mTarget.unlinkToDeath(info, 0);
                this.mTargets.remove(info.mTarget);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String indent) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print(indent);
            pw.print("# of watched binders: ");
            pw.println(this.mTargets.size());
            pw.print(indent);
            pw.print("# of death recipients: ");
            int n = 0;
            for (RecipientsInfo info : this.mTargets.values()) {
                n += info.mRecipients.size();
            }
            pw.println(n);
        }
    }

    @VisibleForTesting
    public ArrayMap<IBinder, RecipientsInfo> getTargetsForTest() {
        return this.mTargets;
    }

    @VisibleForTesting
    class RecipientsInfo
    implements IBinder.DeathRecipient {
        final IBinder mTarget;
        @GuardedBy(value={"mLock"})
        ArraySet<IBinder.DeathRecipient> mRecipients = new ArraySet();

        private RecipientsInfo(IBinder target) {
            this.mTarget = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            ArraySet<IBinder.DeathRecipient> copy;
            Object object = BinderDeathDispatcher.this.mLock;
            synchronized (object) {
                copy = this.mRecipients;
                this.mRecipients = null;
                BinderDeathDispatcher.this.mTargets.remove(this.mTarget);
            }
            if (copy == null) {
                return;
            }
            int size = copy.size();
            for (int i = 0; i < size; ++i) {
                copy.valueAt(i).binderDied();
            }
        }
    }
}

