/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteServer;

public class ChildZygoteInit {
    private static final String TAG = "ChildZygoteInit";

    static String parseSocketNameFromArgs(String[] argv) {
        for (String arg : argv) {
            if (!arg.startsWith("--zygote-socket=")) continue;
            return arg.substring("--zygote-socket=".length());
        }
        return null;
    }

    static String parseAbiListFromArgs(String[] argv) {
        for (String arg : argv) {
            if (!arg.startsWith("--abi-list=")) continue;
            return arg.substring("--abi-list=".length());
        }
        return null;
    }

    static int parseIntFromArg(String[] argv, String desiredArg) {
        int value = -1;
        for (String arg : argv) {
            if (!arg.startsWith(desiredArg)) continue;
            String valueStr = arg.substring(arg.indexOf(61) + 1);
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid int argument: " + valueStr, e);
            }
        }
        return value;
    }

    static void runZygoteServer(ZygoteServer server, String[] args) {
        Runnable caller;
        String socketName = ChildZygoteInit.parseSocketNameFromArgs(args);
        if (socketName == null) {
            throw new NullPointerException("No socketName specified");
        }
        String abiList = ChildZygoteInit.parseAbiListFromArgs(args);
        if (abiList == null) {
            throw new NullPointerException("No abiList specified");
        }
        try {
            Os.prctl(OsConstants.PR_SET_NO_NEW_PRIVS, 1L, 0L, 0L, 0L);
        }
        catch (ErrnoException ex) {
            throw new RuntimeException("Failed to set PR_SET_NO_NEW_PRIVS", ex);
        }
        int uidGidMin = ChildZygoteInit.parseIntFromArg(args, "--uid-range-start=");
        int uidGidMax = ChildZygoteInit.parseIntFromArg(args, "--uid-range-end=");
        if (uidGidMin == -1 || uidGidMax == -1) {
            throw new RuntimeException("Couldn't parse UID range start/end");
        }
        if (uidGidMin > uidGidMax) {
            throw new RuntimeException("Passed in UID range is invalid, min > max.");
        }
        if (uidGidMin < 90000) {
            throw new RuntimeException("Passed in UID range does not map to isolated processes.");
        }
        Zygote.nativeInstallSeccompUidGidFilter(uidGidMin, uidGidMax);
        try {
            server.registerServerSocketAtAbstractName(socketName);
            Zygote.nativeAllowFileAcrossFork("ABSTRACT/" + socketName);
            caller = server.runSelectLoop(abiList);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Fatal exception:", e);
            throw e;
        }
        finally {
            server.closeServerSocket();
        }
        if (caller != null) {
            caller.run();
        }
    }
}

