/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.KernelCpuThreadReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KernelCpuThreadReaderDiff {
    private static final String TAG = "KernelCpuThreadReaderDiff";
    private static final int OTHER_THREADS_ID = -1;
    private static final String OTHER_THREADS_NAME = "__OTHER_THREADS";
    private final KernelCpuThreadReader mReader;
    private Map<ThreadKey, int[]> mPreviousCpuUsage;
    private int mMinimumTotalCpuUsageMillis;

    @VisibleForTesting
    public KernelCpuThreadReaderDiff(KernelCpuThreadReader reader, int minimumTotalCpuUsageMillis) {
        this.mReader = reader;
        this.mMinimumTotalCpuUsageMillis = minimumTotalCpuUsageMillis;
        this.mPreviousCpuUsage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<KernelCpuThreadReader.ProcessCpuUsage> getProcessCpuUsageDiffed() {
        Map<ThreadKey, int[]> newCpuUsage = null;
        try {
            ArrayList<KernelCpuThreadReader.ProcessCpuUsage> processCpuUsages = this.mReader.getProcessCpuUsage();
            newCpuUsage = KernelCpuThreadReaderDiff.createCpuUsageMap(processCpuUsages);
            if (this.mPreviousCpuUsage == null) {
                ArrayList<KernelCpuThreadReader.ProcessCpuUsage> arrayList = null;
                return arrayList;
            }
            for (int i = 0; i < processCpuUsages.size(); ++i) {
                KernelCpuThreadReader.ProcessCpuUsage processCpuUsage = processCpuUsages.get(i);
                KernelCpuThreadReaderDiff.changeToDiffs(this.mPreviousCpuUsage, processCpuUsage);
                this.applyThresholding(processCpuUsage);
            }
            ArrayList<KernelCpuThreadReader.ProcessCpuUsage> arrayList = processCpuUsages;
            return arrayList;
        }
        finally {
            this.mPreviousCpuUsage = newCpuUsage;
        }
    }

    public int[] getCpuFrequenciesKhz() {
        return this.mReader.getCpuFrequenciesKhz();
    }

    void setMinimumTotalCpuUsageMillis(int minimumTotalCpuUsageMillis) {
        if (minimumTotalCpuUsageMillis < 0) {
            Slog.w(TAG, "Negative minimumTotalCpuUsageMillis: " + minimumTotalCpuUsageMillis);
            return;
        }
        this.mMinimumTotalCpuUsageMillis = minimumTotalCpuUsageMillis;
    }

    private static Map<ThreadKey, int[]> createCpuUsageMap(List<KernelCpuThreadReader.ProcessCpuUsage> processCpuUsages) {
        ArrayMap<ThreadKey, int[]> cpuUsageMap = new ArrayMap<ThreadKey, int[]>();
        for (int i = 0; i < processCpuUsages.size(); ++i) {
            KernelCpuThreadReader.ProcessCpuUsage processCpuUsage = processCpuUsages.get(i);
            for (int j = 0; j < processCpuUsage.threadCpuUsages.size(); ++j) {
                KernelCpuThreadReader.ThreadCpuUsage threadCpuUsage = processCpuUsage.threadCpuUsages.get(j);
                cpuUsageMap.put(new ThreadKey(processCpuUsage.processId, threadCpuUsage.threadId, processCpuUsage.processName, threadCpuUsage.threadName), threadCpuUsage.usageTimesMillis);
            }
        }
        return cpuUsageMap;
    }

    private static void changeToDiffs(Map<ThreadKey, int[]> previousCpuUsage, KernelCpuThreadReader.ProcessCpuUsage processCpuUsage) {
        for (int i = 0; i < processCpuUsage.threadCpuUsages.size(); ++i) {
            KernelCpuThreadReader.ThreadCpuUsage threadCpuUsage = processCpuUsage.threadCpuUsages.get(i);
            ThreadKey key = new ThreadKey(processCpuUsage.processId, threadCpuUsage.threadId, processCpuUsage.processName, threadCpuUsage.threadName);
            int[] previous = previousCpuUsage.get(key);
            if (previous == null) {
                previous = new int[threadCpuUsage.usageTimesMillis.length];
            }
            threadCpuUsage.usageTimesMillis = KernelCpuThreadReaderDiff.cpuTimeDiff(threadCpuUsage.usageTimesMillis, previous);
        }
    }

    private void applyThresholding(KernelCpuThreadReader.ProcessCpuUsage processCpuUsage) {
        int[] filteredThreadsCpuUsage = null;
        ArrayList<KernelCpuThreadReader.ThreadCpuUsage> thresholded = new ArrayList<KernelCpuThreadReader.ThreadCpuUsage>();
        for (int i = 0; i < processCpuUsage.threadCpuUsages.size(); ++i) {
            KernelCpuThreadReader.ThreadCpuUsage threadCpuUsage = processCpuUsage.threadCpuUsages.get(i);
            if (this.mMinimumTotalCpuUsageMillis > KernelCpuThreadReaderDiff.totalCpuUsage(threadCpuUsage.usageTimesMillis)) {
                if (filteredThreadsCpuUsage == null) {
                    filteredThreadsCpuUsage = new int[threadCpuUsage.usageTimesMillis.length];
                }
                KernelCpuThreadReaderDiff.addToCpuUsage(filteredThreadsCpuUsage, threadCpuUsage.usageTimesMillis);
                continue;
            }
            thresholded.add(threadCpuUsage);
        }
        if (filteredThreadsCpuUsage != null) {
            thresholded.add(new KernelCpuThreadReader.ThreadCpuUsage(-1, OTHER_THREADS_NAME, filteredThreadsCpuUsage));
        }
        processCpuUsage.threadCpuUsages = thresholded;
    }

    private static int totalCpuUsage(int[] cpuUsage) {
        int total = 0;
        for (int i = 0; i < cpuUsage.length; ++i) {
            total += cpuUsage[i];
        }
        return total;
    }

    private static void addToCpuUsage(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
    }

    private static int[] cpuTimeDiff(int[] a, int[] b) {
        int[] difference = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            difference[i] = a[i] - b[i];
        }
        return difference;
    }

    private static class ThreadKey {
        private final int mProcessId;
        private final int mThreadId;
        private final int mProcessNameHash;
        private final int mThreadNameHash;

        ThreadKey(int processId, int threadId, String processName, String threadName) {
            this.mProcessId = processId;
            this.mThreadId = threadId;
            this.mProcessNameHash = Objects.hash(processName);
            this.mThreadNameHash = Objects.hash(threadName);
        }

        public int hashCode() {
            return Objects.hash(this.mProcessId, this.mThreadId, this.mProcessNameHash, this.mThreadNameHash);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ThreadKey)) {
                return false;
            }
            ThreadKey other = (ThreadKey)obj;
            return this.mProcessId == other.mProcessId && this.mThreadId == other.mThreadId && this.mProcessNameHash == other.mProcessNameHash && this.mThreadNameHash == other.mThreadNameHash;
        }
    }
}

