/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.provider.Settings;
import android.util.KeyValueListParser;
import android.util.Range;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.KernelCpuThreadReader;
import com.android.internal.os.KernelCpuThreadReaderDiff;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KernelCpuThreadReaderSettingsObserver
extends ContentObserver {
    private static final String TAG = "KernelCpuThreadReaderSettingsObserver";
    private static final String NUM_BUCKETS_SETTINGS_KEY = "num_buckets";
    private static final int NUM_BUCKETS_DEFAULT = 8;
    private static final String COLLECTED_UIDS_SETTINGS_KEY = "collected_uids";
    private static final String COLLECTED_UIDS_DEFAULT = "0-0;1000-1000";
    private static final String MINIMUM_TOTAL_CPU_USAGE_MILLIS_SETTINGS_KEY = "minimum_total_cpu_usage_millis";
    private static final int MINIMUM_TOTAL_CPU_USAGE_MILLIS_DEFAULT = 10000;
    private final Context mContext;
    private final KernelCpuThreadReader mKernelCpuThreadReader;
    private final KernelCpuThreadReaderDiff mKernelCpuThreadReaderDiff;

    public static KernelCpuThreadReaderDiff getSettingsModifiedReader(Context context) {
        KernelCpuThreadReaderSettingsObserver settingsObserver = new KernelCpuThreadReaderSettingsObserver(context);
        Uri settingsUri = Settings.Global.getUriFor("kernel_cpu_thread_reader");
        context.getContentResolver().registerContentObserver(settingsUri, false, settingsObserver, 0);
        return settingsObserver.mKernelCpuThreadReaderDiff;
    }

    private KernelCpuThreadReaderSettingsObserver(Context context) {
        super(BackgroundThread.getHandler());
        this.mContext = context;
        this.mKernelCpuThreadReader = KernelCpuThreadReader.create(8, UidPredicate.fromString(COLLECTED_UIDS_DEFAULT));
        this.mKernelCpuThreadReaderDiff = new KernelCpuThreadReaderDiff(this.mKernelCpuThreadReader, 10000);
    }

    @Override
    public void onChange(boolean selfChange, Uri uri, int userId) {
        this.updateReader();
    }

    private void updateReader() {
        UidPredicate uidPredicate;
        if (this.mKernelCpuThreadReader == null) {
            return;
        }
        KeyValueListParser parser = new KeyValueListParser(',');
        try {
            parser.setString(Settings.Global.getString(this.mContext.getContentResolver(), "kernel_cpu_thread_reader"));
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "Bad settings", e);
            return;
        }
        try {
            uidPredicate = UidPredicate.fromString(parser.getString(COLLECTED_UIDS_SETTINGS_KEY, COLLECTED_UIDS_DEFAULT));
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "Failed to get UID predicate", e);
            return;
        }
        this.mKernelCpuThreadReader.setNumBuckets(parser.getInt(NUM_BUCKETS_SETTINGS_KEY, 8));
        this.mKernelCpuThreadReader.setUidPredicate(uidPredicate);
        this.mKernelCpuThreadReaderDiff.setMinimumTotalCpuUsageMillis(parser.getInt(MINIMUM_TOTAL_CPU_USAGE_MILLIS_SETTINGS_KEY, 10000));
    }

    @VisibleForTesting
    public static class UidPredicate
    implements Predicate<Integer> {
        private static final Pattern UID_RANGE_PATTERN = Pattern.compile("([0-9]+)-([0-9]+)");
        private static final String UID_SPECIFIER_DELIMITER = ";";
        private final List<Range<Integer>> mAcceptedUidRanges;

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public static UidPredicate fromString(String predicateString) throws NumberFormatException {
            ArrayList<Range<Integer>> acceptedUidRanges = new ArrayList<Range<Integer>>();
            for (String uidSpecifier : predicateString.split(UID_SPECIFIER_DELIMITER)) {
                Matcher uidRangeMatcher = UID_RANGE_PATTERN.matcher(uidSpecifier);
                if (!uidRangeMatcher.matches()) {
                    throw new NumberFormatException("Failed to recognize as number range: " + uidSpecifier);
                }
                acceptedUidRanges.add(Range.create(Integer.parseInt(uidRangeMatcher.group(1)), Integer.parseInt(uidRangeMatcher.group(2))));
            }
            return new UidPredicate(acceptedUidRanges);
        }

        private UidPredicate(List<Range<Integer>> acceptedUidRanges) {
            this.mAcceptedUidRanges = acceptedUidRanges;
        }

        @Override
        public boolean test(Integer uid) {
            for (int i = 0; i < this.mAcceptedUidRanges.size(); ++i) {
                if (!this.mAcceptedUidRanges.get(i).contains(uid)) continue;
                return true;
            }
            return false;
        }
    }
}

