/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.CachedDeviceState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;

public class LooperStats
implements Looper.Observer {
    public static final String DEBUG_ENTRY_PREFIX = "__DEBUG_";
    private static final int SESSION_POOL_SIZE = 50;
    private static final boolean DISABLED_SCREEN_STATE_TRACKING_VALUE = false;
    @GuardedBy(value={"mLock"})
    private final SparseArray<Entry> mEntries = new SparseArray(512);
    private final Object mLock = new Object();
    private final Entry mOverflowEntry = new Entry("OVERFLOW");
    private final Entry mHashCollisionEntry = new Entry("HASH_COLLISION");
    private final ConcurrentLinkedQueue<DispatchSession> mSessionPool = new ConcurrentLinkedQueue();
    private final int mEntriesSizeCap;
    private int mSamplingInterval;
    private CachedDeviceState.Readonly mDeviceState;
    private CachedDeviceState.TimeInStateStopwatch mBatteryStopwatch;
    private long mStartCurrentTime = System.currentTimeMillis();
    private long mStartElapsedTime = SystemClock.elapsedRealtime();
    private boolean mAddDebugEntries = false;
    private boolean mTrackScreenInteractive = false;

    public LooperStats(int samplingInterval, int entriesSizeCap) {
        this.mSamplingInterval = samplingInterval;
        this.mEntriesSizeCap = entriesSizeCap;
    }

    public void setDeviceState(CachedDeviceState.Readonly deviceState) {
        if (this.mBatteryStopwatch != null) {
            this.mBatteryStopwatch.close();
        }
        this.mDeviceState = deviceState;
        this.mBatteryStopwatch = deviceState.createTimeOnBatteryStopwatch();
    }

    public void setAddDebugEntries(boolean addDebugEntries) {
        this.mAddDebugEntries = addDebugEntries;
    }

    @Override
    public Object messageDispatchStarting() {
        if (this.deviceStateAllowsCollection() && this.shouldCollectDetailedData()) {
            DispatchSession session = this.mSessionPool.poll();
            session = session == null ? new DispatchSession() : session;
            session.startTimeMicro = this.getElapsedRealtimeMicro();
            session.cpuStartMicro = this.getThreadTimeMicro();
            session.systemUptimeMillis = this.getSystemUptimeMillis();
            return session;
        }
        return DispatchSession.NOT_SAMPLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageDispatched(Object token, Message msg) {
        if (!this.deviceStateAllowsCollection()) {
            return;
        }
        DispatchSession session = (DispatchSession)token;
        Entry entry = this.findEntry(msg, session != DispatchSession.NOT_SAMPLED);
        if (entry != null) {
            Entry entry2 = entry;
            synchronized (entry2) {
                ++entry.messageCount;
                if (session != DispatchSession.NOT_SAMPLED) {
                    ++entry.recordedMessageCount;
                    long latency = this.getElapsedRealtimeMicro() - session.startTimeMicro;
                    long cpuUsage = this.getThreadTimeMicro() - session.cpuStartMicro;
                    entry.totalLatencyMicro += latency;
                    entry.maxLatencyMicro = Math.max(entry.maxLatencyMicro, latency);
                    entry.cpuUsageMicro += cpuUsage;
                    entry.maxCpuUsageMicro = Math.max(entry.maxCpuUsageMicro, cpuUsage);
                    if (msg.getWhen() > 0L) {
                        long delay = Math.max(0L, session.systemUptimeMillis - msg.getWhen());
                        entry.delayMillis += delay;
                        entry.maxDelayMillis = Math.max(entry.maxDelayMillis, delay);
                        ++entry.recordedDelayMessageCount;
                    }
                }
            }
        }
        this.recycleSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchingThrewException(Object token, Message msg, Exception exception) {
        if (!this.deviceStateAllowsCollection()) {
            return;
        }
        DispatchSession session = (DispatchSession)token;
        Entry entry = this.findEntry(msg, session != DispatchSession.NOT_SAMPLED);
        if (entry != null) {
            Entry entry2 = entry;
            synchronized (entry2) {
                ++entry.exceptionCount;
            }
        }
        this.recycleSession(session);
    }

    private boolean deviceStateAllowsCollection() {
        return this.mDeviceState != null && !this.mDeviceState.isCharging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExportedEntry> getEntries() {
        ArrayList<ExportedEntry> exportedEntries;
        Object object = this.mLock;
        synchronized (object) {
            int size = this.mEntries.size();
            exportedEntries = new ArrayList<ExportedEntry>(size);
            for (int i = 0; i < size; ++i) {
                Entry entry;
                Entry entry2 = entry = this.mEntries.valueAt(i);
                synchronized (entry2) {
                    exportedEntries.add(new ExportedEntry(entry));
                    continue;
                }
            }
        }
        this.maybeAddSpecialEntry(exportedEntries, this.mOverflowEntry);
        this.maybeAddSpecialEntry(exportedEntries, this.mHashCollisionEntry);
        if (this.mAddDebugEntries && this.mBatteryStopwatch != null) {
            exportedEntries.add(this.createDebugEntry("start_time_millis", this.mStartElapsedTime));
            exportedEntries.add(this.createDebugEntry("end_time_millis", SystemClock.elapsedRealtime()));
            exportedEntries.add(this.createDebugEntry("battery_time_millis", this.mBatteryStopwatch.getMillis()));
            exportedEntries.add(this.createDebugEntry("sampling_interval", this.mSamplingInterval));
        }
        return exportedEntries;
    }

    private ExportedEntry createDebugEntry(String variableName, long value) {
        Entry entry = new Entry(DEBUG_ENTRY_PREFIX + variableName);
        entry.messageCount = 1L;
        entry.recordedMessageCount = 1L;
        entry.totalLatencyMicro = value;
        return new ExportedEntry(entry);
    }

    public long getStartTimeMillis() {
        return this.mStartCurrentTime;
    }

    public long getStartElapsedTimeMillis() {
        return this.mStartElapsedTime;
    }

    public long getBatteryTimeMillis() {
        return this.mBatteryStopwatch != null ? this.mBatteryStopwatch.getMillis() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddSpecialEntry(List<ExportedEntry> exportedEntries, Entry specialEntry) {
        Entry entry = specialEntry;
        synchronized (entry) {
            if (specialEntry.messageCount > 0L || specialEntry.exceptionCount > 0L) {
                exportedEntries.add(new ExportedEntry(specialEntry));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mLock;
        synchronized (object) {
            this.mEntries.clear();
        }
        object = this.mHashCollisionEntry;
        synchronized (object) {
            this.mHashCollisionEntry.reset();
        }
        object = this.mOverflowEntry;
        synchronized (object) {
            this.mOverflowEntry.reset();
        }
        this.mStartCurrentTime = System.currentTimeMillis();
        this.mStartElapsedTime = SystemClock.elapsedRealtime();
        if (this.mBatteryStopwatch != null) {
            this.mBatteryStopwatch.reset();
        }
    }

    public void setSamplingInterval(int samplingInterval) {
        this.mSamplingInterval = samplingInterval;
    }

    public void setTrackScreenInteractive(boolean enabled) {
        this.mTrackScreenInteractive = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry findEntry(Message msg, boolean allowCreateNew) {
        Entry entry;
        boolean isInteractive = this.mTrackScreenInteractive ? this.mDeviceState.isScreenInteractive() : false;
        int id2 = Entry.idFor(msg, isInteractive);
        Object object = this.mLock;
        synchronized (object) {
            entry = this.mEntries.get(id2);
            if (entry == null) {
                if (!allowCreateNew) {
                    return null;
                }
                if (this.mEntries.size() >= this.mEntriesSizeCap) {
                    return this.mOverflowEntry;
                }
                entry = new Entry(msg, isInteractive);
                this.mEntries.put(id2, entry);
            }
        }
        if (entry.workSourceUid != msg.workSourceUid || entry.handler.getClass() != msg.getTarget().getClass() || entry.handler.getLooper().getThread() != msg.getTarget().getLooper().getThread() || entry.isInteractive != isInteractive) {
            return this.mHashCollisionEntry;
        }
        return entry;
    }

    private void recycleSession(DispatchSession session) {
        if (session != DispatchSession.NOT_SAMPLED && this.mSessionPool.size() < 50) {
            this.mSessionPool.add(session);
        }
    }

    protected long getThreadTimeMicro() {
        return SystemClock.currentThreadTimeMicro();
    }

    protected long getElapsedRealtimeMicro() {
        return SystemClock.elapsedRealtimeNanos() / 1000L;
    }

    protected long getSystemUptimeMillis() {
        return SystemClock.uptimeMillis();
    }

    protected boolean shouldCollectDetailedData() {
        return ThreadLocalRandom.current().nextInt() % this.mSamplingInterval == 0;
    }

    public static class ExportedEntry {
        public final int workSourceUid;
        public final String handlerClassName;
        public final String threadName;
        public final String messageName;
        public final boolean isInteractive;
        public final long messageCount;
        public final long recordedMessageCount;
        public final long exceptionCount;
        public final long totalLatencyMicros;
        public final long maxLatencyMicros;
        public final long cpuUsageMicros;
        public final long maxCpuUsageMicros;
        public final long maxDelayMillis;
        public final long delayMillis;
        public final long recordedDelayMessageCount;

        ExportedEntry(Entry entry) {
            this.workSourceUid = entry.workSourceUid;
            if (entry.handler != null) {
                this.handlerClassName = entry.handler.getClass().getName();
                this.threadName = entry.handler.getLooper().getThread().getName();
            } else {
                this.handlerClassName = "";
                this.threadName = "";
            }
            this.isInteractive = entry.isInteractive;
            this.messageName = entry.messageName;
            this.messageCount = entry.messageCount;
            this.recordedMessageCount = entry.recordedMessageCount;
            this.exceptionCount = entry.exceptionCount;
            this.totalLatencyMicros = entry.totalLatencyMicro;
            this.maxLatencyMicros = entry.maxLatencyMicro;
            this.cpuUsageMicros = entry.cpuUsageMicro;
            this.maxCpuUsageMicros = entry.maxCpuUsageMicro;
            this.delayMillis = entry.delayMillis;
            this.maxDelayMillis = entry.maxDelayMillis;
            this.recordedDelayMessageCount = entry.recordedDelayMessageCount;
        }
    }

    private static class Entry {
        public final int workSourceUid;
        public final Handler handler;
        public final String messageName;
        public final boolean isInteractive;
        public long messageCount;
        public long recordedMessageCount;
        public long exceptionCount;
        public long totalLatencyMicro;
        public long maxLatencyMicro;
        public long cpuUsageMicro;
        public long maxCpuUsageMicro;
        public long recordedDelayMessageCount;
        public long delayMillis;
        public long maxDelayMillis;

        Entry(Message msg, boolean isInteractive) {
            this.workSourceUid = msg.workSourceUid;
            this.handler = msg.getTarget();
            this.messageName = this.handler.getMessageName(msg);
            this.isInteractive = isInteractive;
        }

        Entry(String specialEntryName) {
            this.workSourceUid = -1;
            this.messageName = specialEntryName;
            this.handler = null;
            this.isInteractive = false;
        }

        void reset() {
            this.messageCount = 0L;
            this.recordedMessageCount = 0L;
            this.exceptionCount = 0L;
            this.totalLatencyMicro = 0L;
            this.maxLatencyMicro = 0L;
            this.cpuUsageMicro = 0L;
            this.maxCpuUsageMicro = 0L;
            this.delayMillis = 0L;
            this.maxDelayMillis = 0L;
            this.recordedDelayMessageCount = 0L;
        }

        static int idFor(Message msg, boolean isInteractive) {
            int result = 7;
            result = 31 * result + msg.workSourceUid;
            result = 31 * result + msg.getTarget().getLooper().getThread().hashCode();
            result = 31 * result + msg.getTarget().getClass().hashCode();
            result = 31 * result + (isInteractive ? 1231 : 1237);
            if (msg.getCallback() != null) {
                return 31 * result + msg.getCallback().getClass().hashCode();
            }
            return 31 * result + msg.what;
        }
    }

    private static class DispatchSession {
        static final DispatchSession NOT_SAMPLED = new DispatchSession();
        public long startTimeMicro;
        public long cpuStartMicro;
        public long systemUptimeMillis;

        private DispatchSession() {
        }
    }
}

