/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Process;
import com.android.internal.util.ArrayUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ProcTimeInStateReader {
    private static final String TAG = "ProcTimeInStateReader";
    private static final List<Integer> TIME_IN_STATE_LINE_FREQUENCY_FORMAT = Arrays.asList(8224, 10);
    private static final List<Integer> TIME_IN_STATE_LINE_TIME_FORMAT = Arrays.asList(32, 8202);
    private static final List<Integer> TIME_IN_STATE_HEADER_LINE_FORMAT = Collections.singletonList(10);
    private int[] mTimeInStateTimeFormat;
    private long[] mFrequenciesKhz;

    public ProcTimeInStateReader(Path initialTimeInStateFile) throws IOException {
        this.initializeTimeInStateFormat(initialTimeInStateFile);
    }

    public long[] getUsageTimesMillis(Path timeInStatePath) {
        long[] readLongs = new long[this.mFrequenciesKhz.length];
        boolean readSuccess = Process.readProcFile(timeInStatePath.toString(), this.mTimeInStateTimeFormat, null, readLongs, null);
        if (!readSuccess) {
            return null;
        }
        int i = 0;
        while (i < readLongs.length) {
            int n = i++;
            readLongs[n] = readLongs[n] * 10L;
        }
        return readLongs;
    }

    public long[] getFrequenciesKhz() {
        return this.mFrequenciesKhz;
    }

    private void initializeTimeInStateFormat(Path timeInStatePath) throws IOException {
        byte[] timeInStateBytes = Files.readAllBytes(timeInStatePath);
        ArrayList<Integer> timeInStateFrequencyFormat = new ArrayList<Integer>();
        ArrayList<Integer> timeInStateTimeFormat = new ArrayList<Integer>();
        int numFrequencies = 0;
        for (int i = 0; i < timeInStateBytes.length; ++i) {
            if (!Character.isDigit(timeInStateBytes[i])) {
                timeInStateFrequencyFormat.addAll(TIME_IN_STATE_HEADER_LINE_FORMAT);
                timeInStateTimeFormat.addAll(TIME_IN_STATE_HEADER_LINE_FORMAT);
            } else {
                timeInStateFrequencyFormat.addAll(TIME_IN_STATE_LINE_FREQUENCY_FORMAT);
                timeInStateTimeFormat.addAll(TIME_IN_STATE_LINE_TIME_FORMAT);
                ++numFrequencies;
            }
            while (i < timeInStateBytes.length && timeInStateBytes[i] != 10) {
                ++i;
            }
        }
        if (numFrequencies == 0) {
            throw new IOException("Empty time_in_state file");
        }
        long[] readLongs = new long[numFrequencies];
        boolean readSuccess = Process.parseProcLine(timeInStateBytes, 0, timeInStateBytes.length, ArrayUtils.convertToIntArray(timeInStateFrequencyFormat), null, readLongs, null);
        if (!readSuccess) {
            throw new IOException("Failed to parse time_in_state file");
        }
        this.mTimeInStateTimeFormat = ArrayUtils.convertToIntArray(timeInStateTimeFormat);
        this.mFrequenciesKhz = readLongs;
    }
}

