/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.UnsupportedAppUsage;
import android.os.Process;
import android.os.StrictMode;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Slog;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.ProcStatsUtil;
import com.android.internal.util.FastPrintWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class ProcessCpuTracker {
    private static final String TAG = "ProcessCpuTracker";
    private static final boolean DEBUG = false;
    private static final boolean localLOGV = false;
    private static final int[] PROCESS_STATS_FORMAT = new int[]{32, 544, 32, 32, 32, 32, 32, 32, 32, 8224, 32, 8224, 32, 8224, 8224};
    static final int PROCESS_STAT_MINOR_FAULTS = 0;
    static final int PROCESS_STAT_MAJOR_FAULTS = 1;
    static final int PROCESS_STAT_UTIME = 2;
    static final int PROCESS_STAT_STIME = 3;
    private final long[] mProcessStatsData = new long[4];
    private final long[] mSinglePidStatsData = new long[4];
    private static final int[] PROCESS_FULL_STATS_FORMAT = new int[]{32, 4640, 32, 32, 32, 32, 32, 32, 32, 8224, 32, 8224, 32, 8224, 8224, 32, 32, 32, 32, 32, 32, 32, 8224};
    static final int PROCESS_FULL_STAT_MINOR_FAULTS = 1;
    static final int PROCESS_FULL_STAT_MAJOR_FAULTS = 2;
    static final int PROCESS_FULL_STAT_UTIME = 3;
    static final int PROCESS_FULL_STAT_STIME = 4;
    static final int PROCESS_FULL_STAT_VSIZE = 5;
    private final String[] mProcessFullStatsStringData = new String[6];
    private final long[] mProcessFullStatsData = new long[6];
    private static final int[] SYSTEM_CPU_FORMAT = new int[]{288, 8224, 8224, 8224, 8224, 8224, 8224, 8224};
    private final long[] mSystemCpuData = new long[7];
    private static final int[] LOAD_AVERAGE_FORMAT = new int[]{16416, 16416, 16416};
    private final float[] mLoadAverageData = new float[3];
    private final boolean mIncludeThreads;
    private final long mJiffyMillis;
    private float mLoad1 = 0.0f;
    private float mLoad5 = 0.0f;
    private float mLoad15 = 0.0f;
    private long mCurrentSampleTime;
    private long mLastSampleTime;
    private long mCurrentSampleRealTime;
    private long mLastSampleRealTime;
    private long mCurrentSampleWallTime;
    private long mLastSampleWallTime;
    private long mBaseUserTime;
    private long mBaseSystemTime;
    private long mBaseIoWaitTime;
    private long mBaseIrqTime;
    private long mBaseSoftIrqTime;
    private long mBaseIdleTime;
    private int mRelUserTime;
    private int mRelSystemTime;
    private int mRelIoWaitTime;
    private int mRelIrqTime;
    private int mRelSoftIrqTime;
    private int mRelIdleTime;
    private boolean mRelStatsAreGood;
    private int[] mCurPids;
    private int[] mCurThreadPids;
    private final ArrayList<Stats> mProcStats = new ArrayList();
    private final ArrayList<Stats> mWorkingProcs = new ArrayList();
    private boolean mWorkingProcsSorted;
    private boolean mFirst = true;
    private static final Comparator<Stats> sLoadComparator = new Comparator<Stats>(){

        @Override
        public final int compare(Stats sta, Stats stb) {
            int ta = sta.rel_utime + sta.rel_stime;
            int tb = stb.rel_utime + stb.rel_stime;
            if (ta != tb) {
                return ta > tb ? -1 : 1;
            }
            if (sta.added != stb.added) {
                return sta.added ? -1 : 1;
            }
            if (sta.removed != stb.removed) {
                return sta.added ? -1 : 1;
            }
            return 0;
        }
    };

    @UnsupportedAppUsage
    public ProcessCpuTracker(boolean includeThreads) {
        this.mIncludeThreads = includeThreads;
        long jiffyHz = Os.sysconf(OsConstants._SC_CLK_TCK);
        this.mJiffyMillis = 1000L / jiffyHz;
    }

    public void onLoadChanged(float load1, float load5, float load15) {
    }

    public int onMeasureProcessName(String name) {
        return 0;
    }

    public void init() {
        this.mFirst = true;
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void update() {
        long nowUptime = SystemClock.uptimeMillis();
        long nowRealtime = SystemClock.elapsedRealtime();
        long nowWallTime = System.currentTimeMillis();
        long[] sysCpu = this.mSystemCpuData;
        if (Process.readProcFile("/proc/stat", SYSTEM_CPU_FORMAT, null, sysCpu, null)) {
            long usertime = (sysCpu[0] + sysCpu[1]) * this.mJiffyMillis;
            long systemtime = sysCpu[2] * this.mJiffyMillis;
            long idletime = sysCpu[3] * this.mJiffyMillis;
            long iowaittime = sysCpu[4] * this.mJiffyMillis;
            long irqtime = sysCpu[5] * this.mJiffyMillis;
            long softirqtime = sysCpu[6] * this.mJiffyMillis;
            this.mRelUserTime = (int)(usertime - this.mBaseUserTime);
            this.mRelSystemTime = (int)(systemtime - this.mBaseSystemTime);
            this.mRelIoWaitTime = (int)(iowaittime - this.mBaseIoWaitTime);
            this.mRelIrqTime = (int)(irqtime - this.mBaseIrqTime);
            this.mRelSoftIrqTime = (int)(softirqtime - this.mBaseSoftIrqTime);
            this.mRelIdleTime = (int)(idletime - this.mBaseIdleTime);
            this.mRelStatsAreGood = true;
            this.mBaseUserTime = usertime;
            this.mBaseSystemTime = systemtime;
            this.mBaseIoWaitTime = iowaittime;
            this.mBaseIrqTime = irqtime;
            this.mBaseSoftIrqTime = softirqtime;
            this.mBaseIdleTime = idletime;
        }
        this.mLastSampleTime = this.mCurrentSampleTime;
        this.mCurrentSampleTime = nowUptime;
        this.mLastSampleRealTime = this.mCurrentSampleRealTime;
        this.mCurrentSampleRealTime = nowRealtime;
        this.mLastSampleWallTime = this.mCurrentSampleWallTime;
        this.mCurrentSampleWallTime = nowWallTime;
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        try {
            this.mCurPids = this.collectStats("/proc", -1, this.mFirst, this.mCurPids, this.mProcStats);
        }
        finally {
            StrictMode.setThreadPolicy(savedPolicy);
        }
        float[] loadAverages = this.mLoadAverageData;
        if (Process.readProcFile("/proc/loadavg", LOAD_AVERAGE_FORMAT, null, null, loadAverages)) {
            float load1 = loadAverages[0];
            float load5 = loadAverages[1];
            float load15 = loadAverages[2];
            if (load1 != this.mLoad1 || load5 != this.mLoad5 || load15 != this.mLoad15) {
                this.mLoad1 = load1;
                this.mLoad5 = load5;
                this.mLoad15 = load15;
                this.onLoadChanged(load1, load5, load15);
            }
        }
        this.mWorkingProcsSorted = false;
        this.mFirst = false;
    }

    private int[] collectStats(String statsFile, int parentPid, boolean first, int[] curPids, ArrayList<Stats> allProcs) {
        int[] pids = Process.getPids(statsFile, curPids);
        int NP = pids == null ? 0 : pids.length;
        int NS = allProcs.size();
        int curStatsIndex = 0;
        for (int i = 0; i < NP; ++i) {
            Stats st;
            int pid = pids[i];
            if (pid < 0) {
                NP = pid;
                break;
            }
            Stats stats = st = curStatsIndex < NS ? allProcs.get(curStatsIndex) : null;
            if (st != null && st.pid == pid) {
                st.added = false;
                st.working = false;
                ++curStatsIndex;
                if (!st.interesting) continue;
                long uptime = SystemClock.uptimeMillis();
                long[] procStats = this.mProcessStatsData;
                if (!Process.readProcFile(st.statFile.toString(), PROCESS_STATS_FORMAT, null, procStats, null)) continue;
                long minfaults = procStats[0];
                long majfaults = procStats[1];
                long utime = procStats[2] * this.mJiffyMillis;
                long stime = procStats[3] * this.mJiffyMillis;
                if (utime == st.base_utime && stime == st.base_stime) {
                    st.rel_utime = 0;
                    st.rel_stime = 0;
                    st.rel_minfaults = 0;
                    st.rel_majfaults = 0;
                    if (!st.active) continue;
                    st.active = false;
                    continue;
                }
                if (!st.active) {
                    st.active = true;
                }
                if (parentPid < 0) {
                    this.getName(st, st.cmdlineFile);
                    if (st.threadStats != null) {
                        this.mCurThreadPids = this.collectStats(st.threadsDir, pid, false, this.mCurThreadPids, st.threadStats);
                    }
                }
                st.rel_uptime = uptime - st.base_uptime;
                st.base_uptime = uptime;
                st.rel_utime = (int)(utime - st.base_utime);
                st.rel_stime = (int)(stime - st.base_stime);
                st.base_utime = utime;
                st.base_stime = stime;
                st.rel_minfaults = (int)(minfaults - st.base_minfaults);
                st.rel_majfaults = (int)(majfaults - st.base_majfaults);
                st.base_minfaults = minfaults;
                st.base_majfaults = majfaults;
                st.working = true;
                continue;
            }
            if (st == null || st.pid > pid) {
                st = new Stats(pid, parentPid, this.mIncludeThreads);
                allProcs.add(curStatsIndex, st);
                ++curStatsIndex;
                ++NS;
                String[] procStatsString = this.mProcessFullStatsStringData;
                long[] procStats = this.mProcessFullStatsData;
                st.base_uptime = SystemClock.uptimeMillis();
                String path = st.statFile.toString();
                if (Process.readProcFile(path, PROCESS_FULL_STATS_FORMAT, procStatsString, procStats, null)) {
                    st.vsize = procStats[5];
                    st.interesting = true;
                    st.baseName = procStatsString[0];
                    st.base_minfaults = procStats[1];
                    st.base_majfaults = procStats[2];
                    st.base_utime = procStats[3] * this.mJiffyMillis;
                    st.base_stime = procStats[4] * this.mJiffyMillis;
                } else {
                    Slog.w(TAG, "Skipping unknown process pid " + pid);
                    st.baseName = "<unknown>";
                    st.base_stime = 0L;
                    st.base_utime = 0L;
                    st.base_majfaults = 0L;
                    st.base_minfaults = 0L;
                }
                if (parentPid < 0) {
                    this.getName(st, st.cmdlineFile);
                    if (st.threadStats != null) {
                        this.mCurThreadPids = this.collectStats(st.threadsDir, pid, true, this.mCurThreadPids, st.threadStats);
                    }
                } else if (st.interesting) {
                    st.name = st.baseName;
                    st.nameWidth = this.onMeasureProcessName(st.name);
                }
                st.rel_utime = 0;
                st.rel_stime = 0;
                st.rel_minfaults = 0;
                st.rel_majfaults = 0;
                st.added = true;
                if (first || !st.interesting) continue;
                st.working = true;
                continue;
            }
            st.rel_utime = 0;
            st.rel_stime = 0;
            st.rel_minfaults = 0;
            st.rel_majfaults = 0;
            st.removed = true;
            st.working = true;
            allProcs.remove(curStatsIndex);
            --NS;
            --i;
        }
        while (curStatsIndex < NS) {
            Stats st = allProcs.get(curStatsIndex);
            st.rel_utime = 0;
            st.rel_stime = 0;
            st.rel_minfaults = 0;
            st.rel_majfaults = 0;
            st.removed = true;
            st.working = true;
            allProcs.remove(curStatsIndex);
            --NS;
        }
        return pids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCpuTimeForPid(int pid) {
        long[] lArray = this.mSinglePidStatsData;
        synchronized (this.mSinglePidStatsData) {
            String statFile = "/proc/" + pid + "/stat";
            long[] statsData = this.mSinglePidStatsData;
            if (Process.readProcFile(statFile, PROCESS_STATS_FORMAT, null, statsData, null)) {
                long time = statsData[2] + statsData[3];
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return time * this.mJiffyMillis;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return 0L;
        }
    }

    public final int getLastUserTime() {
        return this.mRelUserTime;
    }

    public final int getLastSystemTime() {
        return this.mRelSystemTime;
    }

    public final int getLastIoWaitTime() {
        return this.mRelIoWaitTime;
    }

    public final int getLastIrqTime() {
        return this.mRelIrqTime;
    }

    public final int getLastSoftIrqTime() {
        return this.mRelSoftIrqTime;
    }

    public final int getLastIdleTime() {
        return this.mRelIdleTime;
    }

    public final boolean hasGoodLastStats() {
        return this.mRelStatsAreGood;
    }

    public final float getTotalCpuPercent() {
        int denom = this.mRelUserTime + this.mRelSystemTime + this.mRelIrqTime + this.mRelIdleTime;
        if (denom <= 0) {
            return 0.0f;
        }
        return (float)(this.mRelUserTime + this.mRelSystemTime + this.mRelIrqTime) * 100.0f / (float)denom;
    }

    final void buildWorkingProcs() {
        if (!this.mWorkingProcsSorted) {
            this.mWorkingProcs.clear();
            int N = this.mProcStats.size();
            for (int i = 0; i < N; ++i) {
                Stats stats = this.mProcStats.get(i);
                if (!stats.working) continue;
                this.mWorkingProcs.add(stats);
                if (stats.threadStats == null || stats.threadStats.size() <= 1) continue;
                stats.workingThreads.clear();
                int M = stats.threadStats.size();
                for (int j = 0; j < M; ++j) {
                    Stats tstats = stats.threadStats.get(j);
                    if (!tstats.working) continue;
                    stats.workingThreads.add(tstats);
                }
                Collections.sort(stats.workingThreads, sLoadComparator);
            }
            Collections.sort(this.mWorkingProcs, sLoadComparator);
            this.mWorkingProcsSorted = true;
        }
    }

    public final int countStats() {
        return this.mProcStats.size();
    }

    public final Stats getStats(int index) {
        return this.mProcStats.get(index);
    }

    public final List<Stats> getStats(FilterStats filter) {
        ArrayList<Stats> statses = new ArrayList<Stats>(this.mProcStats.size());
        int N = this.mProcStats.size();
        for (int p = 0; p < N; ++p) {
            Stats stats = this.mProcStats.get(p);
            if (!filter.needed(stats)) continue;
            statses.add(stats);
        }
        return statses;
    }

    @UnsupportedAppUsage
    public final int countWorkingStats() {
        this.buildWorkingProcs();
        return this.mWorkingProcs.size();
    }

    @UnsupportedAppUsage
    public final Stats getWorkingStats(int index) {
        return this.mWorkingProcs.get(index);
    }

    public final String printCurrentLoad() {
        StringWriter sw = new StringWriter();
        FastPrintWriter pw = new FastPrintWriter(sw, false, 128);
        ((PrintWriter)pw).print("Load: ");
        pw.print(this.mLoad1);
        ((PrintWriter)pw).print(" / ");
        pw.print(this.mLoad5);
        ((PrintWriter)pw).print(" / ");
        pw.println(this.mLoad15);
        ((PrintWriter)pw).flush();
        return sw.toString();
    }

    public final String printCurrentState(long now) {
        long percAwake;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.buildWorkingProcs();
        StringWriter sw = new StringWriter();
        FastPrintWriter pw = new FastPrintWriter(sw, false, 1024);
        ((PrintWriter)pw).print("CPU usage from ");
        if (now > this.mLastSampleTime) {
            ((PrintWriter)pw).print(now - this.mLastSampleTime);
            ((PrintWriter)pw).print("ms to ");
            ((PrintWriter)pw).print(now - this.mCurrentSampleTime);
            ((PrintWriter)pw).print("ms ago");
        } else {
            ((PrintWriter)pw).print(this.mLastSampleTime - now);
            ((PrintWriter)pw).print("ms to ");
            ((PrintWriter)pw).print(this.mCurrentSampleTime - now);
            ((PrintWriter)pw).print("ms later");
        }
        ((PrintWriter)pw).print(" (");
        ((PrintWriter)pw).print(sdf.format(new Date(this.mLastSampleWallTime)));
        ((PrintWriter)pw).print(" to ");
        ((PrintWriter)pw).print(sdf.format(new Date(this.mCurrentSampleWallTime)));
        ((PrintWriter)pw).print(")");
        long sampleTime = this.mCurrentSampleTime - this.mLastSampleTime;
        long sampleRealTime = this.mCurrentSampleRealTime - this.mLastSampleRealTime;
        long l = percAwake = sampleRealTime > 0L ? sampleTime * 100L / sampleRealTime : 0L;
        if (percAwake != 100L) {
            ((PrintWriter)pw).print(" with ");
            ((PrintWriter)pw).print(percAwake);
            ((PrintWriter)pw).print("% awake");
        }
        pw.println(":");
        int totalTime = this.mRelUserTime + this.mRelSystemTime + this.mRelIoWaitTime + this.mRelIrqTime + this.mRelSoftIrqTime + this.mRelIdleTime;
        int N = this.mWorkingProcs.size();
        for (int i = 0; i < N; ++i) {
            Stats st = this.mWorkingProcs.get(i);
            this.printProcessCPU(pw, st.added ? " +" : (st.removed ? " -" : "  "), st.pid, st.name, (int)st.rel_uptime, st.rel_utime, st.rel_stime, 0, 0, 0, st.rel_minfaults, st.rel_majfaults);
            if (st.removed || st.workingThreads == null) continue;
            int M = st.workingThreads.size();
            for (int j = 0; j < M; ++j) {
                Stats tst = st.workingThreads.get(j);
                this.printProcessCPU(pw, tst.added ? "   +" : (tst.removed ? "   -" : "    "), tst.pid, tst.name, (int)st.rel_uptime, tst.rel_utime, tst.rel_stime, 0, 0, 0, 0, 0);
            }
        }
        this.printProcessCPU(pw, "", -1, "TOTAL", totalTime, this.mRelUserTime, this.mRelSystemTime, this.mRelIoWaitTime, this.mRelIrqTime, this.mRelSoftIrqTime, 0, 0);
        ((PrintWriter)pw).flush();
        return sw.toString();
    }

    private void printRatio(PrintWriter pw, long numerator, long denominator) {
        long remainder;
        long thousands = numerator * 1000L / denominator;
        long hundreds = thousands / 10L;
        pw.print(hundreds);
        if (hundreds < 10L && (remainder = thousands - hundreds * 10L) != 0L) {
            pw.print('.');
            pw.print(remainder);
        }
    }

    private void printProcessCPU(PrintWriter pw, String prefix, int pid, String label, int totalTime, int user, int system, int iowait, int irq, int softIrq, int minFaults, int majFaults) {
        pw.print(prefix);
        if (totalTime == 0) {
            totalTime = 1;
        }
        this.printRatio(pw, user + system + iowait + irq + softIrq, totalTime);
        pw.print("% ");
        if (pid >= 0) {
            pw.print(pid);
            pw.print("/");
        }
        pw.print(label);
        pw.print(": ");
        this.printRatio(pw, user, totalTime);
        pw.print("% user + ");
        this.printRatio(pw, system, totalTime);
        pw.print("% kernel");
        if (iowait > 0) {
            pw.print(" + ");
            this.printRatio(pw, iowait, totalTime);
            pw.print("% iowait");
        }
        if (irq > 0) {
            pw.print(" + ");
            this.printRatio(pw, irq, totalTime);
            pw.print("% irq");
        }
        if (softIrq > 0) {
            pw.print(" + ");
            this.printRatio(pw, softIrq, totalTime);
            pw.print("% softirq");
        }
        if (minFaults > 0 || majFaults > 0) {
            pw.print(" / faults:");
            if (minFaults > 0) {
                pw.print(" ");
                pw.print(minFaults);
                pw.print(" minor");
            }
            if (majFaults > 0) {
                pw.print(" ");
                pw.print(majFaults);
                pw.print(" major");
            }
        }
        pw.println();
    }

    private void getName(Stats st, String cmdlineFile) {
        String newName = st.name;
        if (st.name == null || st.name.equals("app_process") || st.name.equals("<pre-initialized>")) {
            int i;
            String cmdName = ProcStatsUtil.readTerminatedProcFile(cmdlineFile, (byte)0);
            if (cmdName != null && cmdName.length() > 1 && (i = (newName = cmdName).lastIndexOf("/")) > 0 && i < newName.length() - 1) {
                newName = newName.substring(i + 1);
            }
            if (newName == null) {
                newName = st.baseName;
            }
        }
        if (st.name == null || !newName.equals(st.name)) {
            st.name = newName;
            st.nameWidth = this.onMeasureProcessName(st.name);
        }
    }

    public static class Stats {
        public final int pid;
        public final int uid;
        final String statFile;
        final String cmdlineFile;
        final String threadsDir;
        final ArrayList<Stats> threadStats;
        final ArrayList<Stats> workingThreads;
        public BatteryStatsImpl.Uid.Proc batteryStats;
        public boolean interesting;
        public String baseName;
        @UnsupportedAppUsage
        public String name;
        public int nameWidth;
        public long vsize;
        public long base_uptime;
        @UnsupportedAppUsage
        public long rel_uptime;
        public long base_utime;
        public long base_stime;
        @UnsupportedAppUsage
        public int rel_utime;
        @UnsupportedAppUsage
        public int rel_stime;
        public long base_minfaults;
        public long base_majfaults;
        public int rel_minfaults;
        public int rel_majfaults;
        public boolean active;
        public boolean working;
        public boolean added;
        public boolean removed;

        Stats(int _pid, int parentPid, boolean includeThreads) {
            this.pid = _pid;
            if (parentPid < 0) {
                File procDir = new File("/proc", Integer.toString(this.pid));
                this.uid = Stats.getUid(procDir.toString());
                this.statFile = new File(procDir, "stat").toString();
                this.cmdlineFile = new File(procDir, "cmdline").toString();
                this.threadsDir = new File(procDir, "task").toString();
                if (includeThreads) {
                    this.threadStats = new ArrayList();
                    this.workingThreads = new ArrayList();
                } else {
                    this.threadStats = null;
                    this.workingThreads = null;
                }
            } else {
                File procDir = new File("/proc", Integer.toString(parentPid));
                File taskDir = new File(new File(procDir, "task"), Integer.toString(this.pid));
                this.uid = Stats.getUid(taskDir.toString());
                this.statFile = new File(taskDir, "stat").toString();
                this.cmdlineFile = null;
                this.threadsDir = null;
                this.threadStats = null;
                this.workingThreads = null;
            }
        }

        private static int getUid(String path) {
            try {
                return Os.stat((String)path).st_uid;
            }
            catch (ErrnoException e) {
                Slog.w(ProcessCpuTracker.TAG, "Failed to stat(" + path + "): " + e);
                return -1;
            }
        }
    }

    public static interface FilterStats {
        public boolean needed(Stats var1);
    }
}

