/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.util.ArrayMap;
import android.util.Slog;
import java.util.Map;

public final class RailStats {
    private static final String TAG = "RailStats";
    private static final String WIFI_SUBSYSTEM = "wifi";
    private static final String CELLULAR_SUBSYSTEM = "cellular";
    private Map<Long, RailInfoData> mRailInfoData = new ArrayMap<Long, RailInfoData>();
    private long mCellularTotalEnergyUseduWs = 0L;
    private long mWifiTotalEnergyUseduWs = 0L;
    private boolean mRailStatsAvailability = true;

    public void updateRailData(long index, String railName, String subSystemName, long timestampSinceBootMs, long energyUsedSinceBootuWs) {
        if (!subSystemName.equals(WIFI_SUBSYSTEM) && !subSystemName.equals(CELLULAR_SUBSYSTEM)) {
            return;
        }
        RailInfoData node = this.mRailInfoData.get(index);
        if (node == null) {
            this.mRailInfoData.put(index, new RailInfoData(index, railName, subSystemName, timestampSinceBootMs, energyUsedSinceBootuWs));
            if (subSystemName.equals(WIFI_SUBSYSTEM)) {
                this.mWifiTotalEnergyUseduWs += energyUsedSinceBootuWs;
                return;
            }
            if (subSystemName.equals(CELLULAR_SUBSYSTEM)) {
                this.mCellularTotalEnergyUseduWs += energyUsedSinceBootuWs;
            }
            return;
        }
        long timeSinceLastLogMs = timestampSinceBootMs - node.timestampSinceBootMs;
        long energyUsedSinceLastLoguWs = energyUsedSinceBootuWs - node.energyUsedSinceBootuWs;
        if (timeSinceLastLogMs < 0L || energyUsedSinceLastLoguWs < 0L) {
            energyUsedSinceLastLoguWs = node.energyUsedSinceBootuWs;
        }
        node.timestampSinceBootMs = timestampSinceBootMs;
        node.energyUsedSinceBootuWs = energyUsedSinceBootuWs;
        if (subSystemName.equals(WIFI_SUBSYSTEM)) {
            this.mWifiTotalEnergyUseduWs += energyUsedSinceLastLoguWs;
            return;
        }
        if (subSystemName.equals(CELLULAR_SUBSYSTEM)) {
            this.mCellularTotalEnergyUseduWs += energyUsedSinceLastLoguWs;
        }
    }

    public void resetCellularTotalEnergyUsed() {
        this.mCellularTotalEnergyUseduWs = 0L;
    }

    public void resetWifiTotalEnergyUsed() {
        this.mWifiTotalEnergyUseduWs = 0L;
    }

    public long getCellularTotalEnergyUseduWs() {
        return this.mCellularTotalEnergyUseduWs;
    }

    public long getWifiTotalEnergyUseduWs() {
        return this.mWifiTotalEnergyUseduWs;
    }

    public void reset() {
        this.mCellularTotalEnergyUseduWs = 0L;
        this.mWifiTotalEnergyUseduWs = 0L;
    }

    public RailStats getRailStats() {
        return this;
    }

    public void setRailStatsAvailability(boolean railStatsAvailability) {
        this.mRailStatsAvailability = railStatsAvailability;
    }

    public boolean isRailStatsAvailable() {
        return this.mRailStatsAvailability;
    }

    public static class RailInfoData {
        private static final String TAG = "RailInfoData";
        public long index;
        public String railName;
        public String subSystemName;
        public long timestampSinceBootMs;
        public long energyUsedSinceBootuWs;

        private RailInfoData(long index, String railName, String subSystemName, long timestampSinceBootMs, long energyUsedSinceBoot) {
            this.index = index;
            this.railName = railName;
            this.subSystemName = subSystemName;
            this.timestampSinceBootMs = timestampSinceBootMs;
            this.energyUsedSinceBootuWs = energyUsedSinceBoot;
        }

        public void printData() {
            Slog.d(TAG, "Index = " + this.index);
            Slog.d(TAG, "RailName = " + this.railName);
            Slog.d(TAG, "SubSystemName = " + this.subSystemName);
            Slog.d(TAG, "TimestampSinceBootMs = " + this.timestampSinceBootMs);
            Slog.d(TAG, "EnergyUsedSinceBootuWs = " + this.energyUsedSinceBootuWs);
        }
    }
}

