/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class StoragedUidIoStatsReader {
    private static final String TAG = StoragedUidIoStatsReader.class.getSimpleName();
    private static String sUidIoFile = "/proc/uid_io/stats";

    public StoragedUidIoStatsReader() {
    }

    @VisibleForTesting
    public StoragedUidIoStatsReader(String file) {
        sUidIoFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAbsolute(Callback callback) {
        block22: {
            int oldMask = StrictMode.allowThreadDiskReadsMask();
            File file = new File(sUidIoFile);
            try {
                BufferedReader reader = Files.newBufferedReader(file.toPath());
                Throwable throwable = null;
                block16: while (true) {
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            String[] fields = TextUtils.split(line, " ");
                            if (fields.length != 11) {
                                Slog.e(TAG, "Malformed entry in " + sUidIoFile + ": " + line);
                                continue;
                            }
                            try {
                                String uidStr = fields[0];
                                int uid = Integer.parseInt(fields[0], 10);
                                long fgCharsRead = Long.parseLong(fields[1], 10);
                                long fgCharsWrite = Long.parseLong(fields[2], 10);
                                long fgBytesRead = Long.parseLong(fields[3], 10);
                                long fgBytesWrite = Long.parseLong(fields[4], 10);
                                long bgCharsRead = Long.parseLong(fields[5], 10);
                                long bgCharsWrite = Long.parseLong(fields[6], 10);
                                long bgBytesRead = Long.parseLong(fields[7], 10);
                                long bgBytesWrite = Long.parseLong(fields[8], 10);
                                long fgFsync = Long.parseLong(fields[9], 10);
                                long bgFsync = Long.parseLong(fields[10], 10);
                                callback.onUidStorageStats(uid, fgCharsRead, fgCharsWrite, fgBytesRead, fgBytesWrite, bgCharsRead, bgCharsWrite, bgBytesRead, bgBytesWrite, fgFsync, bgFsync);
                                continue block16;
                            }
                            catch (NumberFormatException e) {
                                Slog.e(TAG, "Could not parse entry in " + sUidIoFile + ": " + e.getMessage());
                            }
                        }
                        break block22;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                Slog.e(TAG, "Failed to read " + sUidIoFile + ": " + e.getMessage());
            }
            finally {
                StrictMode.setThreadPolicyMask(oldMask);
            }
        }
    }

    public static interface Callback {
        public void onUidStorageStats(int var1, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20);
    }
}

