/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.view.DisplayInfo;
import com.android.internal.policy.DockedDividerUtils;
import java.util.ArrayList;

public class DividerSnapAlgorithm {
    private static final int MIN_FLING_VELOCITY_DP_PER_SECOND = 400;
    private static final int MIN_DISMISS_VELOCITY_DP_PER_SECOND = 600;
    private static final int SNAP_MODE_16_9 = 0;
    private static final int SNAP_FIXED_RATIO = 1;
    private static final int SNAP_ONLY_1_1 = 2;
    private static final int SNAP_MODE_MINIMIZED = 3;
    private final float mMinFlingVelocityPxPerSecond;
    private final float mMinDismissVelocityPxPerSecond;
    private final int mDisplayWidth;
    private final int mDisplayHeight;
    private final int mDividerSize;
    private final ArrayList<SnapTarget> mTargets = new ArrayList();
    private final Rect mInsets = new Rect();
    private final int mSnapMode;
    private final int mMinimalSizeResizableTask;
    private final int mTaskHeightInMinimizedMode;
    private final float mFixedRatio;
    private boolean mIsHorizontalDivision;
    private final SnapTarget mFirstSplitTarget;
    private final SnapTarget mLastSplitTarget;
    private final SnapTarget mDismissStartTarget;
    private final SnapTarget mDismissEndTarget;
    private final SnapTarget mMiddleTarget;

    public static DividerSnapAlgorithm create(Context ctx, Rect insets) {
        DisplayInfo displayInfo = new DisplayInfo();
        ctx.getSystemService(DisplayManager.class).getDisplay(0).getDisplayInfo(displayInfo);
        int dividerWindowWidth = ctx.getResources().getDimensionPixelSize(17105142);
        int dividerInsets = ctx.getResources().getDimensionPixelSize(17105141);
        return new DividerSnapAlgorithm(ctx.getResources(), displayInfo.logicalWidth, displayInfo.logicalHeight, dividerWindowWidth - 2 * dividerInsets, ctx.getApplicationContext().getResources().getConfiguration().orientation == 1, insets);
    }

    public DividerSnapAlgorithm(Resources res, int displayWidth, int displayHeight, int dividerSize, boolean isHorizontalDivision, Rect insets) {
        this(res, displayWidth, displayHeight, dividerSize, isHorizontalDivision, insets, -1, false);
    }

    public DividerSnapAlgorithm(Resources res, int displayWidth, int displayHeight, int dividerSize, boolean isHorizontalDivision, Rect insets, int dockSide) {
        this(res, displayWidth, displayHeight, dividerSize, isHorizontalDivision, insets, dockSide, false);
    }

    public DividerSnapAlgorithm(Resources res, int displayWidth, int displayHeight, int dividerSize, boolean isHorizontalDivision, Rect insets, int dockSide, boolean isMinimizedMode) {
        this.mMinFlingVelocityPxPerSecond = 400.0f * res.getDisplayMetrics().density;
        this.mMinDismissVelocityPxPerSecond = 600.0f * res.getDisplayMetrics().density;
        this.mDividerSize = dividerSize;
        this.mDisplayWidth = displayWidth;
        this.mDisplayHeight = displayHeight;
        this.mIsHorizontalDivision = isHorizontalDivision;
        this.mInsets.set(insets);
        this.mSnapMode = isMinimizedMode ? 3 : res.getInteger(17694795);
        this.mFixedRatio = res.getFraction(18022407, 1, 1);
        this.mMinimalSizeResizableTask = res.getDimensionPixelSize(17105123);
        this.mTaskHeightInMinimizedMode = res.getDimensionPixelSize(17105432);
        this.calculateTargets(isHorizontalDivision, dockSide);
        this.mFirstSplitTarget = this.mTargets.get(1);
        this.mLastSplitTarget = this.mTargets.get(this.mTargets.size() - 2);
        this.mDismissStartTarget = this.mTargets.get(0);
        this.mDismissEndTarget = this.mTargets.get(this.mTargets.size() - 1);
        this.mMiddleTarget = this.mTargets.get(this.mTargets.size() / 2);
        this.mMiddleTarget.isMiddleTarget = true;
    }

    public boolean isSplitScreenFeasible() {
        int statusBarSize = this.mInsets.top;
        int navBarSize = this.mIsHorizontalDivision ? this.mInsets.bottom : this.mInsets.right;
        int size = this.mIsHorizontalDivision ? this.mDisplayHeight : this.mDisplayWidth;
        int availableSpace = size - navBarSize - statusBarSize - this.mDividerSize;
        return availableSpace / 2 >= this.mMinimalSizeResizableTask;
    }

    public SnapTarget calculateSnapTarget(int position, float velocity) {
        return this.calculateSnapTarget(position, velocity, true);
    }

    public SnapTarget calculateSnapTarget(int position, float velocity, boolean hardDismiss) {
        if (position < this.mFirstSplitTarget.position && velocity < -this.mMinDismissVelocityPxPerSecond) {
            return this.mDismissStartTarget;
        }
        if (position > this.mLastSplitTarget.position && velocity > this.mMinDismissVelocityPxPerSecond) {
            return this.mDismissEndTarget;
        }
        if (Math.abs(velocity) < this.mMinFlingVelocityPxPerSecond) {
            return this.snap(position, hardDismiss);
        }
        if (velocity < 0.0f) {
            return this.mFirstSplitTarget;
        }
        return this.mLastSplitTarget;
    }

    public SnapTarget calculateNonDismissingSnapTarget(int position) {
        SnapTarget target = this.snap(position, false);
        if (target == this.mDismissStartTarget) {
            return this.mFirstSplitTarget;
        }
        if (target == this.mDismissEndTarget) {
            return this.mLastSplitTarget;
        }
        return target;
    }

    public float calculateDismissingFraction(int position) {
        if (position < this.mFirstSplitTarget.position) {
            return 1.0f - (float)(position - this.getStartInset()) / (float)(this.mFirstSplitTarget.position - this.getStartInset());
        }
        if (position > this.mLastSplitTarget.position) {
            return (float)(position - this.mLastSplitTarget.position) / (float)(this.mDismissEndTarget.position - this.mLastSplitTarget.position - this.mDividerSize);
        }
        return 0.0f;
    }

    public SnapTarget getClosestDismissTarget(int position) {
        if (position < this.mFirstSplitTarget.position) {
            return this.mDismissStartTarget;
        }
        if (position > this.mLastSplitTarget.position) {
            return this.mDismissEndTarget;
        }
        if (position - this.mDismissStartTarget.position < this.mDismissEndTarget.position - position) {
            return this.mDismissStartTarget;
        }
        return this.mDismissEndTarget;
    }

    public SnapTarget getFirstSplitTarget() {
        return this.mFirstSplitTarget;
    }

    public SnapTarget getLastSplitTarget() {
        return this.mLastSplitTarget;
    }

    public SnapTarget getDismissStartTarget() {
        return this.mDismissStartTarget;
    }

    public SnapTarget getDismissEndTarget() {
        return this.mDismissEndTarget;
    }

    private int getStartInset() {
        if (this.mIsHorizontalDivision) {
            return this.mInsets.top;
        }
        return this.mInsets.left;
    }

    private int getEndInset() {
        if (this.mIsHorizontalDivision) {
            return this.mInsets.bottom;
        }
        return this.mInsets.right;
    }

    private SnapTarget snap(int position, boolean hardDismiss) {
        int minIndex = -1;
        float minDistance = Float.MAX_VALUE;
        int size = this.mTargets.size();
        for (int i = 0; i < size; ++i) {
            SnapTarget target = this.mTargets.get(i);
            float distance = Math.abs(position - target.position);
            if (hardDismiss) {
                distance /= target.distanceMultiplier;
            }
            if (!(distance < minDistance)) continue;
            minIndex = i;
            minDistance = distance;
        }
        return this.mTargets.get(minIndex);
    }

    private void calculateTargets(boolean isHorizontalDivision, int dockedSide) {
        this.mTargets.clear();
        int dividerMax = isHorizontalDivision ? this.mDisplayHeight : this.mDisplayWidth;
        int navBarSize = isHorizontalDivision ? this.mInsets.bottom : this.mInsets.right;
        int startPos = -this.mDividerSize;
        if (dockedSide == 3) {
            startPos += this.mInsets.left;
        }
        this.mTargets.add(new SnapTarget(startPos, startPos, 1, 0.35f));
        switch (this.mSnapMode) {
            case 0: {
                this.addRatio16_9Targets(isHorizontalDivision, dividerMax);
                break;
            }
            case 1: {
                this.addFixedDivisionTargets(isHorizontalDivision, dividerMax);
                break;
            }
            case 2: {
                this.addMiddleTarget(isHorizontalDivision);
                break;
            }
            case 3: {
                this.addMinimizedTarget(isHorizontalDivision, dockedSide);
            }
        }
        this.mTargets.add(new SnapTarget(dividerMax - navBarSize, dividerMax, 2, 0.35f));
    }

    private void addNonDismissingTargets(boolean isHorizontalDivision, int topPosition, int bottomPosition, int dividerMax) {
        this.maybeAddTarget(topPosition, topPosition - this.mInsets.top);
        this.addMiddleTarget(isHorizontalDivision);
        this.maybeAddTarget(bottomPosition, dividerMax - this.mInsets.bottom - (bottomPosition + this.mDividerSize));
    }

    private void addFixedDivisionTargets(boolean isHorizontalDivision, int dividerMax) {
        int start = isHorizontalDivision ? this.mInsets.top : this.mInsets.left;
        int end = isHorizontalDivision ? this.mDisplayHeight - this.mInsets.bottom : this.mDisplayWidth - this.mInsets.right;
        int size = (int)(this.mFixedRatio * (float)(end - start)) - this.mDividerSize / 2;
        int topPosition = start + size;
        int bottomPosition = end - size - this.mDividerSize;
        this.addNonDismissingTargets(isHorizontalDivision, topPosition, bottomPosition, dividerMax);
    }

    private void addRatio16_9Targets(boolean isHorizontalDivision, int dividerMax) {
        int start = isHorizontalDivision ? this.mInsets.top : this.mInsets.left;
        int end = isHorizontalDivision ? this.mDisplayHeight - this.mInsets.bottom : this.mDisplayWidth - this.mInsets.right;
        int startOther = isHorizontalDivision ? this.mInsets.left : this.mInsets.top;
        int endOther = isHorizontalDivision ? this.mDisplayWidth - this.mInsets.right : this.mDisplayHeight - this.mInsets.bottom;
        float size = 0.5625f * (float)(endOther - startOther);
        int sizeInt = (int)Math.floor(size);
        int topPosition = start + sizeInt;
        int bottomPosition = end - sizeInt - this.mDividerSize;
        this.addNonDismissingTargets(isHorizontalDivision, topPosition, bottomPosition, dividerMax);
    }

    private void maybeAddTarget(int position, int smallerSize) {
        if (smallerSize >= this.mMinimalSizeResizableTask) {
            this.mTargets.add(new SnapTarget(position, position, 0));
        }
    }

    private void addMiddleTarget(boolean isHorizontalDivision) {
        int position = DockedDividerUtils.calculateMiddlePosition(isHorizontalDivision, this.mInsets, this.mDisplayWidth, this.mDisplayHeight, this.mDividerSize);
        this.mTargets.add(new SnapTarget(position, position, 0));
    }

    private void addMinimizedTarget(boolean isHorizontalDivision, int dockedSide) {
        int position = this.mTaskHeightInMinimizedMode + this.mInsets.top;
        if (!isHorizontalDivision) {
            if (dockedSide == 1) {
                position += this.mInsets.left;
            } else if (dockedSide == 3) {
                position = this.mDisplayWidth - position - this.mInsets.right - this.mDividerSize;
            }
        }
        this.mTargets.add(new SnapTarget(position, position, 0));
    }

    public SnapTarget getMiddleTarget() {
        return this.mMiddleTarget;
    }

    public SnapTarget getNextTarget(SnapTarget snapTarget) {
        int index = this.mTargets.indexOf(snapTarget);
        if (index != -1 && index < this.mTargets.size() - 1) {
            return this.mTargets.get(index + 1);
        }
        return snapTarget;
    }

    public SnapTarget getPreviousTarget(SnapTarget snapTarget) {
        int index = this.mTargets.indexOf(snapTarget);
        if (index != -1 && index > 0) {
            return this.mTargets.get(index - 1);
        }
        return snapTarget;
    }

    public boolean showMiddleSplitTargetForAccessibility() {
        return this.mTargets.size() - 2 > 1;
    }

    public boolean isFirstSplitTargetAvailable() {
        return this.mFirstSplitTarget != this.mMiddleTarget;
    }

    public boolean isLastSplitTargetAvailable() {
        return this.mLastSplitTarget != this.mMiddleTarget;
    }

    public SnapTarget cycleNonDismissTarget(SnapTarget snapTarget, int increment) {
        int index = this.mTargets.indexOf(snapTarget);
        if (index != -1) {
            SnapTarget newTarget = this.mTargets.get((index + this.mTargets.size() + increment) % this.mTargets.size());
            if (newTarget == this.mDismissStartTarget) {
                return this.mLastSplitTarget;
            }
            if (newTarget == this.mDismissEndTarget) {
                return this.mFirstSplitTarget;
            }
            return newTarget;
        }
        return snapTarget;
    }

    public static class SnapTarget {
        public static final int FLAG_NONE = 0;
        public static final int FLAG_DISMISS_START = 1;
        public static final int FLAG_DISMISS_END = 2;
        public final int position;
        public final int taskPosition;
        public final int flag;
        public boolean isMiddleTarget;
        private final float distanceMultiplier;

        public SnapTarget(int position, int taskPosition, int flag) {
            this(position, taskPosition, flag, 1.0f);
        }

        public SnapTarget(int position, int taskPosition, int flag, float distanceMultiplier) {
            this.position = position;
            this.taskPosition = taskPosition;
            this.flag = flag;
            this.distanceMultiplier = distanceMultiplier;
        }
    }
}

