/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IKeyguardDrawnCallback;
import com.android.internal.policy.IKeyguardExitCallback;
import com.android.internal.policy.IKeyguardStateCallback;

public interface IKeyguardService
extends IInterface {
    public void setOccluded(boolean var1, boolean var2) throws RemoteException;

    public void addStateMonitorCallback(IKeyguardStateCallback var1) throws RemoteException;

    public void verifyUnlock(IKeyguardExitCallback var1) throws RemoteException;

    public void dismiss(IKeyguardDismissCallback var1, CharSequence var2) throws RemoteException;

    public void onDreamingStarted() throws RemoteException;

    public void onDreamingStopped() throws RemoteException;

    public void onStartedGoingToSleep(int var1) throws RemoteException;

    public void onFinishedGoingToSleep(int var1, boolean var2) throws RemoteException;

    public void onStartedWakingUp() throws RemoteException;

    public void onFinishedWakingUp() throws RemoteException;

    public void onScreenTurningOn(IKeyguardDrawnCallback var1) throws RemoteException;

    public void onScreenTurnedOn() throws RemoteException;

    public void onScreenTurningOff() throws RemoteException;

    public void onScreenTurnedOff() throws RemoteException;

    @UnsupportedAppUsage
    public void setKeyguardEnabled(boolean var1) throws RemoteException;

    public void onSystemReady() throws RemoteException;

    @UnsupportedAppUsage
    public void doKeyguardTimeout(Bundle var1) throws RemoteException;

    public void setSwitchingUser(boolean var1) throws RemoteException;

    public void setCurrentUser(int var1) throws RemoteException;

    public void onBootCompleted() throws RemoteException;

    public void startKeyguardExitAnimation(long var1, long var3) throws RemoteException;

    public void onShortPowerPressedGoHome() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IKeyguardService {
        private static final String DESCRIPTOR = "com.android.internal.policy.IKeyguardService";
        static final int TRANSACTION_setOccluded = 1;
        static final int TRANSACTION_addStateMonitorCallback = 2;
        static final int TRANSACTION_verifyUnlock = 3;
        static final int TRANSACTION_dismiss = 4;
        static final int TRANSACTION_onDreamingStarted = 5;
        static final int TRANSACTION_onDreamingStopped = 6;
        static final int TRANSACTION_onStartedGoingToSleep = 7;
        static final int TRANSACTION_onFinishedGoingToSleep = 8;
        static final int TRANSACTION_onStartedWakingUp = 9;
        static final int TRANSACTION_onFinishedWakingUp = 10;
        static final int TRANSACTION_onScreenTurningOn = 11;
        static final int TRANSACTION_onScreenTurnedOn = 12;
        static final int TRANSACTION_onScreenTurningOff = 13;
        static final int TRANSACTION_onScreenTurnedOff = 14;
        static final int TRANSACTION_setKeyguardEnabled = 15;
        static final int TRANSACTION_onSystemReady = 16;
        static final int TRANSACTION_doKeyguardTimeout = 17;
        static final int TRANSACTION_setSwitchingUser = 18;
        static final int TRANSACTION_setCurrentUser = 19;
        static final int TRANSACTION_onBootCompleted = 20;
        static final int TRANSACTION_startKeyguardExitAnimation = 21;
        static final int TRANSACTION_onShortPowerPressedGoHome = 22;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IKeyguardService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IKeyguardService) {
                return (IKeyguardService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setOccluded";
                }
                case 2: {
                    return "addStateMonitorCallback";
                }
                case 3: {
                    return "verifyUnlock";
                }
                case 4: {
                    return "dismiss";
                }
                case 5: {
                    return "onDreamingStarted";
                }
                case 6: {
                    return "onDreamingStopped";
                }
                case 7: {
                    return "onStartedGoingToSleep";
                }
                case 8: {
                    return "onFinishedGoingToSleep";
                }
                case 9: {
                    return "onStartedWakingUp";
                }
                case 10: {
                    return "onFinishedWakingUp";
                }
                case 11: {
                    return "onScreenTurningOn";
                }
                case 12: {
                    return "onScreenTurnedOn";
                }
                case 13: {
                    return "onScreenTurningOff";
                }
                case 14: {
                    return "onScreenTurnedOff";
                }
                case 15: {
                    return "setKeyguardEnabled";
                }
                case 16: {
                    return "onSystemReady";
                }
                case 17: {
                    return "doKeyguardTimeout";
                }
                case 18: {
                    return "setSwitchingUser";
                }
                case 19: {
                    return "setCurrentUser";
                }
                case 20: {
                    return "onBootCompleted";
                }
                case 21: {
                    return "startKeyguardExitAnimation";
                }
                case 22: {
                    return "onShortPowerPressedGoHome";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.setOccluded(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IKeyguardStateCallback _arg0 = IKeyguardStateCallback.Stub.asInterface(data.readStrongBinder());
                    this.addStateMonitorCallback(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IKeyguardExitCallback _arg0 = IKeyguardExitCallback.Stub.asInterface(data.readStrongBinder());
                    this.verifyUnlock(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IKeyguardDismissCallback _arg0 = IKeyguardDismissCallback.Stub.asInterface(data.readStrongBinder());
                    CharSequence _arg1 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    this.dismiss(_arg0, _arg1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.onDreamingStarted();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.onDreamingStopped();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onStartedGoingToSleep(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.onFinishedGoingToSleep(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    this.onStartedWakingUp();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    this.onFinishedWakingUp();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    IKeyguardDrawnCallback _arg0 = IKeyguardDrawnCallback.Stub.asInterface(data.readStrongBinder());
                    this.onScreenTurningOn(_arg0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    this.onScreenTurnedOn();
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    this.onScreenTurningOff();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    this.onScreenTurnedOff();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setKeyguardEnabled(_arg0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    this.onSystemReady();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    Bundle _arg0 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.doKeyguardTimeout(_arg0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setSwitchingUser(_arg0);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setCurrentUser(_arg0);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    this.onBootCompleted();
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    this.startKeyguardExitAnimation(_arg0, _arg1);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    this.onShortPowerPressedGoHome();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IKeyguardService impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IKeyguardService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IKeyguardService {
            private IBinder mRemote;
            public static IKeyguardService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOccluded(boolean isOccluded, boolean animate) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(isOccluded ? 1 : 0);
                    _data.writeInt(animate ? 1 : 0);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setOccluded(isOccluded, animate);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addStateMonitorCallback(IKeyguardStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addStateMonitorCallback(callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void verifyUnlock(IKeyguardExitCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().verifyUnlock(callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismiss(IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (message != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(message, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dismiss(callback, message);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDreamingStarted() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDreamingStarted();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDreamingStopped() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDreamingStopped();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStartedGoingToSleep(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onStartedGoingToSleep(reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFinishedGoingToSleep(int reason, boolean cameraGestureTriggered) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeInt(cameraGestureTriggered ? 1 : 0);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onFinishedGoingToSleep(reason, cameraGestureTriggered);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onStartedWakingUp() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onStartedWakingUp();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onFinishedWakingUp() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onFinishedWakingUp();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onScreenTurningOn(IKeyguardDrawnCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onScreenTurningOn(callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onScreenTurnedOn() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onScreenTurnedOn();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onScreenTurningOff() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onScreenTurningOff();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onScreenTurnedOff() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onScreenTurnedOff();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setKeyguardEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setKeyguardEnabled(enabled);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onSystemReady() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSystemReady();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doKeyguardTimeout(Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (options != null) {
                        _data.writeInt(1);
                        options.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().doKeyguardTimeout(options);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSwitchingUser(boolean switching) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(switching ? 1 : 0);
                    boolean _status = this.mRemote.transact(18, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSwitchingUser(switching);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCurrentUser(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(19, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setCurrentUser(userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onBootCompleted() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBootCompleted();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startKeyguardExitAnimation(long startTime, long fadeoutDuration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(startTime);
                    _data.writeLong(fadeoutDuration);
                    boolean _status = this.mRemote.transact(21, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startKeyguardExitAnimation(startTime, fadeoutDuration);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onShortPowerPressedGoHome() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(22, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onShortPowerPressedGoHome();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IKeyguardService {
        @Override
        public void setOccluded(boolean isOccluded, boolean animate) throws RemoteException {
        }

        @Override
        public void addStateMonitorCallback(IKeyguardStateCallback callback) throws RemoteException {
        }

        @Override
        public void verifyUnlock(IKeyguardExitCallback callback) throws RemoteException {
        }

        @Override
        public void dismiss(IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
        }

        @Override
        public void onDreamingStarted() throws RemoteException {
        }

        @Override
        public void onDreamingStopped() throws RemoteException {
        }

        @Override
        public void onStartedGoingToSleep(int reason) throws RemoteException {
        }

        @Override
        public void onFinishedGoingToSleep(int reason, boolean cameraGestureTriggered) throws RemoteException {
        }

        @Override
        public void onStartedWakingUp() throws RemoteException {
        }

        @Override
        public void onFinishedWakingUp() throws RemoteException {
        }

        @Override
        public void onScreenTurningOn(IKeyguardDrawnCallback callback) throws RemoteException {
        }

        @Override
        public void onScreenTurnedOn() throws RemoteException {
        }

        @Override
        public void onScreenTurningOff() throws RemoteException {
        }

        @Override
        public void onScreenTurnedOff() throws RemoteException {
        }

        @Override
        public void setKeyguardEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void onSystemReady() throws RemoteException {
        }

        @Override
        public void doKeyguardTimeout(Bundle options) throws RemoteException {
        }

        @Override
        public void setSwitchingUser(boolean switching) throws RemoteException {
        }

        @Override
        public void setCurrentUser(int userId) throws RemoteException {
        }

        @Override
        public void onBootCompleted() throws RemoteException {
        }

        @Override
        public void startKeyguardExitAnimation(long startTime, long fadeoutDuration) throws RemoteException {
        }

        @Override
        public void onShortPowerPressedGoHome() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

