/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telecom;

import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telecom.ConnectionRequest;
import android.telecom.DisconnectCause;
import android.telecom.Logging.Session;
import android.telecom.ParcelableConference;
import android.telecom.ParcelableConnection;
import android.telecom.PhoneAccountHandle;
import android.telecom.StatusHints;
import com.android.internal.telecom.IVideoProvider;
import com.android.internal.telecom.RemoteServiceCallback;
import java.util.ArrayList;
import java.util.List;

public interface IConnectionServiceAdapter
extends IInterface {
    public void handleCreateConnectionComplete(String var1, ConnectionRequest var2, ParcelableConnection var3, Session.Info var4) throws RemoteException;

    public void setActive(String var1, Session.Info var2) throws RemoteException;

    public void setRinging(String var1, Session.Info var2) throws RemoteException;

    public void setDialing(String var1, Session.Info var2) throws RemoteException;

    public void setPulling(String var1, Session.Info var2) throws RemoteException;

    public void setDisconnected(String var1, DisconnectCause var2, Session.Info var3) throws RemoteException;

    public void setOnHold(String var1, Session.Info var2) throws RemoteException;

    public void setRingbackRequested(String var1, boolean var2, Session.Info var3) throws RemoteException;

    public void setConnectionCapabilities(String var1, int var2, Session.Info var3) throws RemoteException;

    public void setConnectionProperties(String var1, int var2, Session.Info var3) throws RemoteException;

    public void setIsConferenced(String var1, String var2, Session.Info var3) throws RemoteException;

    public void setConferenceMergeFailed(String var1, Session.Info var2) throws RemoteException;

    public void addConferenceCall(String var1, ParcelableConference var2, Session.Info var3) throws RemoteException;

    public void removeCall(String var1, Session.Info var2) throws RemoteException;

    public void onPostDialWait(String var1, String var2, Session.Info var3) throws RemoteException;

    public void onPostDialChar(String var1, char var2, Session.Info var3) throws RemoteException;

    public void queryRemoteConnectionServices(RemoteServiceCallback var1, String var2, Session.Info var3) throws RemoteException;

    public void setVideoProvider(String var1, IVideoProvider var2, Session.Info var3) throws RemoteException;

    public void setVideoState(String var1, int var2, Session.Info var3) throws RemoteException;

    public void setIsVoipAudioMode(String var1, boolean var2, Session.Info var3) throws RemoteException;

    public void setStatusHints(String var1, StatusHints var2, Session.Info var3) throws RemoteException;

    public void setAddress(String var1, Uri var2, int var3, Session.Info var4) throws RemoteException;

    public void setCallerDisplayName(String var1, String var2, int var3, Session.Info var4) throws RemoteException;

    public void setConferenceableConnections(String var1, List<String> var2, Session.Info var3) throws RemoteException;

    public void addExistingConnection(String var1, ParcelableConnection var2, Session.Info var3) throws RemoteException;

    public void putExtras(String var1, Bundle var2, Session.Info var3) throws RemoteException;

    public void removeExtras(String var1, List<String> var2, Session.Info var3) throws RemoteException;

    public void setAudioRoute(String var1, int var2, String var3, Session.Info var4) throws RemoteException;

    public void onConnectionEvent(String var1, String var2, Bundle var3, Session.Info var4) throws RemoteException;

    public void onRttInitiationSuccess(String var1, Session.Info var2) throws RemoteException;

    public void onRttInitiationFailure(String var1, int var2, Session.Info var3) throws RemoteException;

    public void onRttSessionRemotelyTerminated(String var1, Session.Info var2) throws RemoteException;

    public void onRemoteRttRequest(String var1, Session.Info var2) throws RemoteException;

    public void onPhoneAccountChanged(String var1, PhoneAccountHandle var2, Session.Info var3) throws RemoteException;

    public void onConnectionServiceFocusReleased(Session.Info var1) throws RemoteException;

    public void resetConnectionTime(String var1, Session.Info var2) throws RemoteException;

    public void setConferenceState(String var1, boolean var2, Session.Info var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IConnectionServiceAdapter {
        private static final String DESCRIPTOR = "com.android.internal.telecom.IConnectionServiceAdapter";
        static final int TRANSACTION_handleCreateConnectionComplete = 1;
        static final int TRANSACTION_setActive = 2;
        static final int TRANSACTION_setRinging = 3;
        static final int TRANSACTION_setDialing = 4;
        static final int TRANSACTION_setPulling = 5;
        static final int TRANSACTION_setDisconnected = 6;
        static final int TRANSACTION_setOnHold = 7;
        static final int TRANSACTION_setRingbackRequested = 8;
        static final int TRANSACTION_setConnectionCapabilities = 9;
        static final int TRANSACTION_setConnectionProperties = 10;
        static final int TRANSACTION_setIsConferenced = 11;
        static final int TRANSACTION_setConferenceMergeFailed = 12;
        static final int TRANSACTION_addConferenceCall = 13;
        static final int TRANSACTION_removeCall = 14;
        static final int TRANSACTION_onPostDialWait = 15;
        static final int TRANSACTION_onPostDialChar = 16;
        static final int TRANSACTION_queryRemoteConnectionServices = 17;
        static final int TRANSACTION_setVideoProvider = 18;
        static final int TRANSACTION_setVideoState = 19;
        static final int TRANSACTION_setIsVoipAudioMode = 20;
        static final int TRANSACTION_setStatusHints = 21;
        static final int TRANSACTION_setAddress = 22;
        static final int TRANSACTION_setCallerDisplayName = 23;
        static final int TRANSACTION_setConferenceableConnections = 24;
        static final int TRANSACTION_addExistingConnection = 25;
        static final int TRANSACTION_putExtras = 26;
        static final int TRANSACTION_removeExtras = 27;
        static final int TRANSACTION_setAudioRoute = 28;
        static final int TRANSACTION_onConnectionEvent = 29;
        static final int TRANSACTION_onRttInitiationSuccess = 30;
        static final int TRANSACTION_onRttInitiationFailure = 31;
        static final int TRANSACTION_onRttSessionRemotelyTerminated = 32;
        static final int TRANSACTION_onRemoteRttRequest = 33;
        static final int TRANSACTION_onPhoneAccountChanged = 34;
        static final int TRANSACTION_onConnectionServiceFocusReleased = 35;
        static final int TRANSACTION_resetConnectionTime = 36;
        static final int TRANSACTION_setConferenceState = 37;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IConnectionServiceAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IConnectionServiceAdapter) {
                return (IConnectionServiceAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "handleCreateConnectionComplete";
                }
                case 2: {
                    return "setActive";
                }
                case 3: {
                    return "setRinging";
                }
                case 4: {
                    return "setDialing";
                }
                case 5: {
                    return "setPulling";
                }
                case 6: {
                    return "setDisconnected";
                }
                case 7: {
                    return "setOnHold";
                }
                case 8: {
                    return "setRingbackRequested";
                }
                case 9: {
                    return "setConnectionCapabilities";
                }
                case 10: {
                    return "setConnectionProperties";
                }
                case 11: {
                    return "setIsConferenced";
                }
                case 12: {
                    return "setConferenceMergeFailed";
                }
                case 13: {
                    return "addConferenceCall";
                }
                case 14: {
                    return "removeCall";
                }
                case 15: {
                    return "onPostDialWait";
                }
                case 16: {
                    return "onPostDialChar";
                }
                case 17: {
                    return "queryRemoteConnectionServices";
                }
                case 18: {
                    return "setVideoProvider";
                }
                case 19: {
                    return "setVideoState";
                }
                case 20: {
                    return "setIsVoipAudioMode";
                }
                case 21: {
                    return "setStatusHints";
                }
                case 22: {
                    return "setAddress";
                }
                case 23: {
                    return "setCallerDisplayName";
                }
                case 24: {
                    return "setConferenceableConnections";
                }
                case 25: {
                    return "addExistingConnection";
                }
                case 26: {
                    return "putExtras";
                }
                case 27: {
                    return "removeExtras";
                }
                case 28: {
                    return "setAudioRoute";
                }
                case 29: {
                    return "onConnectionEvent";
                }
                case 30: {
                    return "onRttInitiationSuccess";
                }
                case 31: {
                    return "onRttInitiationFailure";
                }
                case 32: {
                    return "onRttSessionRemotelyTerminated";
                }
                case 33: {
                    return "onRemoteRttRequest";
                }
                case 34: {
                    return "onPhoneAccountChanged";
                }
                case 35: {
                    return "onConnectionServiceFocusReleased";
                }
                case 36: {
                    return "resetConnectionTime";
                }
                case 37: {
                    return "setConferenceState";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ConnectionRequest _arg1 = 0 != data.readInt() ? ConnectionRequest.CREATOR.createFromParcel(data) : null;
                    ParcelableConnection _arg2 = 0 != data.readInt() ? ParcelableConnection.CREATOR.createFromParcel(data) : null;
                    Session.Info _arg3 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.handleCreateConnectionComplete(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Session.Info _arg1 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setActive(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Session.Info _arg1 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setRinging(_arg0, _arg1);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Session.Info _arg1 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setDialing(_arg0, _arg1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Session.Info _arg1 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setPulling(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    DisconnectCause _arg1 = 0 != data.readInt() ? DisconnectCause.CREATOR.createFromParcel(data) : null;
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setDisconnected(_arg0, _arg1, _arg2);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Session.Info _arg1 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setOnHold(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setRingbackRequested(_arg0, _arg1, _arg2);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setConnectionCapabilities(_arg0, _arg1, _arg2);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setConnectionProperties(_arg0, _arg1, _arg2);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setIsConferenced(_arg0, _arg1, _arg2);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Session.Info _arg1 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setConferenceMergeFailed(_arg0, _arg1);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ParcelableConference _arg1 = 0 != data.readInt() ? ParcelableConference.CREATOR.createFromParcel(data) : null;
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.addConferenceCall(_arg0, _arg1, _arg2);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Session.Info _arg1 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.removeCall(_arg0, _arg1);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.onPostDialWait(_arg0, _arg1, _arg2);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    char _arg1 = (char)data.readInt();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.onPostDialChar(_arg0, _arg1, _arg2);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    RemoteServiceCallback _arg0 = RemoteServiceCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.queryRemoteConnectionServices(_arg0, _arg1, _arg2);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IVideoProvider _arg1 = IVideoProvider.Stub.asInterface(data.readStrongBinder());
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setVideoProvider(_arg0, _arg1, _arg2);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setVideoState(_arg0, _arg1, _arg2);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setIsVoipAudioMode(_arg0, _arg1, _arg2);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    StatusHints _arg1 = 0 != data.readInt() ? StatusHints.CREATOR.createFromParcel(data) : null;
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setStatusHints(_arg0, _arg1, _arg2);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Uri _arg1 = 0 != data.readInt() ? Uri.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    Session.Info _arg3 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setAddress(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    Session.Info _arg3 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setCallerDisplayName(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setConferenceableConnections(_arg0, _arg1, _arg2);
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ParcelableConnection _arg1 = 0 != data.readInt() ? ParcelableConnection.CREATOR.createFromParcel(data) : null;
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.addExistingConnection(_arg0, _arg1, _arg2);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.putExtras(_arg0, _arg1, _arg2);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.removeExtras(_arg0, _arg1, _arg2);
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    Session.Info _arg3 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setAudioRoute(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    Session.Info _arg3 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.onConnectionEvent(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Session.Info _arg1 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.onRttInitiationSuccess(_arg0, _arg1);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.onRttInitiationFailure(_arg0, _arg1, _arg2);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Session.Info _arg1 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.onRttSessionRemotelyTerminated(_arg0, _arg1);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Session.Info _arg1 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.onRemoteRttRequest(_arg0, _arg1);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    PhoneAccountHandle _arg1 = 0 != data.readInt() ? PhoneAccountHandle.CREATOR.createFromParcel(data) : null;
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.onPhoneAccountChanged(_arg0, _arg1, _arg2);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    Session.Info _arg0 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.onConnectionServiceFocusReleased(_arg0);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Session.Info _arg1 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.resetConnectionTime(_arg0, _arg1);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    Session.Info _arg2 = 0 != data.readInt() ? Session.Info.CREATOR.createFromParcel(data) : null;
                    this.setConferenceState(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IConnectionServiceAdapter impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IConnectionServiceAdapter getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IConnectionServiceAdapter {
            private IBinder mRemote;
            public static IConnectionServiceAdapter sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleCreateConnectionComplete(String callId, ConnectionRequest request, ParcelableConnection connection, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (connection != null) {
                        _data.writeInt(1);
                        connection.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().handleCreateConnectionComplete(callId, request, connection, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActive(String callId, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setActive(callId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRinging(String callId, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRinging(callId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDialing(String callId, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDialing(callId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPulling(String callId, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPulling(callId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisconnected(String callId, DisconnectCause disconnectCause, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (disconnectCause != null) {
                        _data.writeInt(1);
                        disconnectCause.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDisconnected(callId, disconnectCause, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnHold(String callId, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setOnHold(callId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRingbackRequested(String callId, boolean ringing, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(ringing ? 1 : 0);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRingbackRequested(callId, ringing, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConnectionCapabilities(String callId, int connectionCapabilities, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(connectionCapabilities);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setConnectionCapabilities(callId, connectionCapabilities, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConnectionProperties(String callId, int connectionProperties, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(connectionProperties);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setConnectionProperties(callId, connectionProperties, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIsConferenced(String callId, String conferenceCallId, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeString(conferenceCallId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setIsConferenced(callId, conferenceCallId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConferenceMergeFailed(String callId, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setConferenceMergeFailed(callId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addConferenceCall(String callId, ParcelableConference conference, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (conference != null) {
                        _data.writeInt(1);
                        conference.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addConferenceCall(callId, conference, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCall(String callId, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeCall(callId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPostDialWait(String callId, String remaining, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeString(remaining);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onPostDialWait(callId, remaining, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPostDialChar(String callId, char nextChar, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(nextChar);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onPostDialChar(callId, nextChar, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryRemoteConnectionServices(RemoteServiceCallback callback, String callingPackage, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeString(callingPackage);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().queryRemoteConnectionServices(callback, callingPackage, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVideoProvider(String callId, IVideoProvider videoProvider, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeStrongBinder(videoProvider != null ? videoProvider.asBinder() : null);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(18, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setVideoProvider(callId, videoProvider, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVideoState(String callId, int videoState, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(videoState);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(19, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setVideoState(callId, videoState, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIsVoipAudioMode(String callId, boolean isVoip, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(isVoip ? 1 : 0);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(20, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setIsVoipAudioMode(callId, isVoip, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStatusHints(String callId, StatusHints statusHints, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (statusHints != null) {
                        _data.writeInt(1);
                        statusHints.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(21, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setStatusHints(callId, statusHints, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAddress(String callId, Uri address, int presentation, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (address != null) {
                        _data.writeInt(1);
                        address.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(presentation);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(22, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAddress(callId, address, presentation, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCallerDisplayName(String callId, String callerDisplayName, int presentation, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeString(callerDisplayName);
                    _data.writeInt(presentation);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(23, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setCallerDisplayName(callId, callerDisplayName, presentation, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConferenceableConnections(String callId, List<String> conferenceableCallIds, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeStringList(conferenceableCallIds);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(24, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setConferenceableConnections(callId, conferenceableCallIds, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addExistingConnection(String callId, ParcelableConnection connection, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (connection != null) {
                        _data.writeInt(1);
                        connection.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(25, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addExistingConnection(callId, connection, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void putExtras(String callId, Bundle extras, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(26, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().putExtras(callId, extras, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeExtras(String callId, List<String> keys, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeStringList(keys);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(27, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeExtras(callId, keys, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAudioRoute(String callId, int audioRoute, String bluetoothAddress, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(audioRoute);
                    _data.writeString(bluetoothAddress);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(28, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAudioRoute(callId, audioRoute, bluetoothAddress, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionEvent(String callId, String event, Bundle extras, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeString(event);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(29, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onConnectionEvent(callId, event, extras, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRttInitiationSuccess(String callId, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(30, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRttInitiationSuccess(callId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRttInitiationFailure(String callId, int reason, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(reason);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(31, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRttInitiationFailure(callId, reason, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRttSessionRemotelyTerminated(String callId, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(32, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRttSessionRemotelyTerminated(callId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoteRttRequest(String callId, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(33, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRemoteRttRequest(callId, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPhoneAccountChanged(String callId, PhoneAccountHandle pHandle, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    if (pHandle != null) {
                        _data.writeInt(1);
                        pHandle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(34, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onPhoneAccountChanged(callId, pHandle, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionServiceFocusReleased(Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(35, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onConnectionServiceFocusReleased(sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetConnectionTime(String callIdi, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callIdi);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(36, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().resetConnectionTime(callIdi, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConferenceState(String callId, boolean isConference, Session.Info sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(isConference ? 1 : 0);
                    if (sessionInfo != null) {
                        _data.writeInt(1);
                        sessionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(37, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setConferenceState(callId, isConference, sessionInfo);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IConnectionServiceAdapter {
        @Override
        public void handleCreateConnectionComplete(String callId, ConnectionRequest request, ParcelableConnection connection, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setActive(String callId, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setRinging(String callId, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setDialing(String callId, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setPulling(String callId, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setDisconnected(String callId, DisconnectCause disconnectCause, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setOnHold(String callId, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setRingbackRequested(String callId, boolean ringing, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setConnectionCapabilities(String callId, int connectionCapabilities, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setConnectionProperties(String callId, int connectionProperties, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setIsConferenced(String callId, String conferenceCallId, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setConferenceMergeFailed(String callId, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void addConferenceCall(String callId, ParcelableConference conference, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void removeCall(String callId, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void onPostDialWait(String callId, String remaining, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void onPostDialChar(String callId, char nextChar, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void queryRemoteConnectionServices(RemoteServiceCallback callback, String callingPackage, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setVideoProvider(String callId, IVideoProvider videoProvider, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setVideoState(String callId, int videoState, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setIsVoipAudioMode(String callId, boolean isVoip, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setStatusHints(String callId, StatusHints statusHints, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setAddress(String callId, Uri address, int presentation, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setCallerDisplayName(String callId, String callerDisplayName, int presentation, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setConferenceableConnections(String callId, List<String> conferenceableCallIds, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void addExistingConnection(String callId, ParcelableConnection connection, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void putExtras(String callId, Bundle extras, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void removeExtras(String callId, List<String> keys, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setAudioRoute(String callId, int audioRoute, String bluetoothAddress, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void onConnectionEvent(String callId, String event, Bundle extras, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void onRttInitiationSuccess(String callId, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void onRttInitiationFailure(String callId, int reason, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void onRttSessionRemotelyTerminated(String callId, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void onRemoteRttRequest(String callId, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void onPhoneAccountChanged(String callId, PhoneAccountHandle pHandle, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void onConnectionServiceFocusReleased(Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void resetConnectionTime(String callIdi, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public void setConferenceState(String callId, boolean isConference, Session.Info sessionInfo) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

