/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import com.android.internal.telephony.ATParseEx;

public class ATResponseParser {
    private String mLine;
    private int mNext = 0;
    private int mTokStart;
    private int mTokEnd;

    public ATResponseParser(String line) {
        this.mLine = line;
    }

    public boolean nextBoolean() {
        this.nextTok();
        if (this.mTokEnd - this.mTokStart > 1) {
            throw new ATParseEx();
        }
        char c = this.mLine.charAt(this.mTokStart);
        if (c == '0') {
            return false;
        }
        if (c == '1') {
            return true;
        }
        throw new ATParseEx();
    }

    public int nextInt() {
        int ret = 0;
        this.nextTok();
        for (int i = this.mTokStart; i < this.mTokEnd; ++i) {
            char c = this.mLine.charAt(i);
            if (c < '0' || c > '9') {
                throw new ATParseEx();
            }
            ret *= 10;
            ret += c - 48;
        }
        return ret;
    }

    public String nextString() {
        this.nextTok();
        return this.mLine.substring(this.mTokStart, this.mTokEnd);
    }

    public boolean hasMore() {
        return this.mNext < this.mLine.length();
    }

    private void nextTok() {
        block12: {
            int len = this.mLine.length();
            if (this.mNext == 0) {
                this.skipPrefix();
            }
            if (this.mNext >= len) {
                throw new ATParseEx();
            }
            try {
                char c = this.mLine.charAt(this.mNext++);
                boolean hasQuote = false;
                c = this.skipWhiteSpace(c);
                if (c == '\"') {
                    if (this.mNext >= len) {
                        throw new ATParseEx();
                    }
                    c = this.mLine.charAt(this.mNext++);
                    this.mTokStart = this.mNext - 1;
                    while (c != '\"' && this.mNext < len) {
                        c = this.mLine.charAt(this.mNext++);
                    }
                    if (c != '\"') {
                        throw new ATParseEx();
                    }
                    this.mTokEnd = this.mNext - 1;
                    if (this.mNext < len && this.mLine.charAt(this.mNext++) != ',') {
                        throw new ATParseEx();
                    }
                    break block12;
                }
                this.mTokEnd = this.mTokStart = this.mNext - 1;
                while (c != ',') {
                    if (!Character.isWhitespace(c)) {
                        this.mTokEnd = this.mNext;
                    }
                    if (this.mNext != len) {
                        c = this.mLine.charAt(this.mNext++);
                        continue;
                    }
                    break;
                }
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new ATParseEx();
            }
        }
    }

    private char skipWhiteSpace(char c) {
        int len = this.mLine.length();
        while (this.mNext < len && Character.isWhitespace(c)) {
            c = this.mLine.charAt(this.mNext++);
        }
        if (Character.isWhitespace(c)) {
            throw new ATParseEx();
        }
        return c;
    }

    private void skipPrefix() {
        this.mNext = 0;
        int s = this.mLine.length();
        while (this.mNext < s) {
            char c;
            if ((c = this.mLine.charAt(this.mNext++)) != ':') continue;
            return;
        }
        throw new ATParseEx("missing prefix");
    }
}

