/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.app.role.IRoleManager;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Telephony;
import android.telephony.IFinancialSmsCallback;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.telephony.PackageBasedTokenUtil;
import com.android.internal.util.Preconditions;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class AppSmsManager {
    private static final String LOG_TAG = "AppSmsManager";
    private static final long TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private final SecureRandom mRandom;
    private final Context mContext;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final Map<String, AppRequestInfo> mTokenMap;
    @GuardedBy(value={"mLock"})
    private final Map<String, AppRequestInfo> mPackageMap;

    public AppSmsManager(Context context) {
        this.mRandom = new SecureRandom();
        this.mTokenMap = new ArrayMap<String, AppRequestInfo>();
        this.mPackageMap = new ArrayMap<String, AppRequestInfo>();
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createAppSpecificSmsToken(String callingPkg, PendingIntent intent) {
        AppOpsManager appOps = (AppOpsManager)this.mContext.getSystemService("appops");
        appOps.checkPackage(Binder.getCallingUid(), callingPkg);
        String token = this.generateNonce();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPackageMap.containsKey(callingPkg)) {
                this.removeRequestLocked(this.mPackageMap.get(callingPkg));
            }
            AppRequestInfo info = new AppRequestInfo(callingPkg, intent, token);
            this.addRequestLocked(info);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createAppSpecificSmsTokenWithPackageInfo(int subId, String callingPackageName, String prefixes, PendingIntent intent) {
        Preconditions.checkStringNotEmpty(callingPackageName, "callingPackageName cannot be null or empty.");
        Preconditions.checkNotNull(intent, "intent cannot be null");
        AppOpsManager appOps = (AppOpsManager)this.mContext.getSystemService("appops");
        appOps.checkPackage(Binder.getCallingUid(), callingPackageName);
        String token = PackageBasedTokenUtil.generateToken(this.mContext, callingPackageName);
        if (token != null) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mPackageMap.containsKey(callingPackageName)) {
                    this.removeRequestLocked(this.mPackageMap.get(callingPackageName));
                }
                AppRequestInfo info = new AppRequestInfo(callingPackageName, intent, token, prefixes, subId, true);
                this.addRequestLocked(info);
            }
        }
        return token;
    }

    public void getSmsMessagesForFinancialApp(String callingPkg, Bundle params, IFinancialSmsCallback callback) {
        try {
            IRoleManager roleManager = IRoleManager.Stub.asInterface(ServiceManager.getServiceOrThrow("role"));
            roleManager.getSmsMessagesForFinancialApp(callingPkg, params, callback);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Receive RemoteException.");
        }
        catch (ServiceManager.ServiceNotFoundException e) {
            Log.e(LOG_TAG, "Service not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSmsReceivedIntent(Intent intent) {
        if (intent.getAction() != "android.provider.Telephony.SMS_DELIVER") {
            Log.wtf(LOG_TAG, "Got intent with incorrect action: " + intent.getAction());
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.removeExpiredTokenLocked();
            String message = this.extractMessage(intent);
            if (TextUtils.isEmpty(message)) {
                return false;
            }
            AppRequestInfo info = this.findAppRequestInfoSmsIntentLocked(message);
            if (info == null) {
                return false;
            }
            try {
                Intent fillIn = new Intent().putExtras(intent.getExtras()).putExtra("android.telephony.extra.STATUS", 0).putExtra("android.telephony.extra.SMS_MESSAGE", message).putExtra("android.telephony.extra.SIM_SUBSCRIPTION_ID", info.subId).addFlags(0x200000);
                info.pendingIntent.send(this.mContext, 0, fillIn);
            }
            catch (PendingIntent.CanceledException e) {
                this.removeRequestLocked(info);
                return false;
            }
            this.removeRequestLocked(info);
            return true;
        }
    }

    private void removeExpiredTokenLocked() {
        long currentTimeMillis = System.currentTimeMillis();
        Set<String> keySet = this.mTokenMap.keySet();
        for (String token : keySet) {
            AppRequestInfo request = this.mTokenMap.get(token);
            if (!request.packageBasedToken || currentTimeMillis - TIMEOUT_MILLIS <= request.timestamp) continue;
            try {
                Intent fillIn = new Intent().putExtra("android.telephony.extra.STATUS", 1).addFlags(0x200000);
                request.pendingIntent.send(this.mContext, 0, fillIn);
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
            this.removeRequestLocked(request);
        }
    }

    private String extractMessage(Intent intent) {
        SmsMessage[] messages = Telephony.Sms.Intents.getMessagesFromIntent(intent);
        if (messages == null) {
            return null;
        }
        StringBuilder fullMessageBuilder = new StringBuilder();
        for (SmsMessage message : messages) {
            if (message == null || message.getMessageBody() == null) continue;
            fullMessageBuilder.append(message.getMessageBody());
        }
        return fullMessageBuilder.toString();
    }

    private AppRequestInfo findAppRequestInfoSmsIntentLocked(String fullMessage) {
        for (String token : this.mTokenMap.keySet()) {
            if (!fullMessage.trim().contains(token) || !this.hasPrefix(token, fullMessage)) continue;
            return this.mTokenMap.get(token);
        }
        return null;
    }

    private String generateNonce() {
        byte[] bytes = new byte[8];
        this.mRandom.nextBytes(bytes);
        return Base64.encodeToString(bytes, 11);
    }

    private boolean hasPrefix(String token, String message) {
        String[] prefixes;
        AppRequestInfo request = this.mTokenMap.get(token);
        if (TextUtils.isEmpty(request.prefixes)) {
            return true;
        }
        for (String prefix : prefixes = request.prefixes.split(",")) {
            if (!message.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private void removeRequestLocked(AppRequestInfo info) {
        this.mTokenMap.remove(info.token);
        this.mPackageMap.remove(info.packageName);
    }

    private void addRequestLocked(AppRequestInfo info) {
        this.mTokenMap.put(info.token, info);
        this.mPackageMap.put(info.packageName, info);
    }

    private final class AppRequestInfo {
        public final String packageName;
        public final PendingIntent pendingIntent;
        public final String token;
        public final long timestamp;
        public final String prefixes;
        public final int subId;
        public final boolean packageBasedToken;

        AppRequestInfo(String packageName, PendingIntent pendingIntent, String token) {
            this(packageName, pendingIntent, token, null, -1, false);
        }

        AppRequestInfo(String packageName, PendingIntent pendingIntent, String token, String prefixes, int subId, boolean packageBasedToken) {
            this.packageName = packageName;
            this.pendingIntent = pendingIntent;
            this.token = token;
            this.timestamp = System.currentTimeMillis();
            this.prefixes = prefixes;
            this.subId = subId;
            this.packageBasedToken = packageBasedToken;
        }
    }
}

