/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.telecom.ConferenceParticipant;
import android.telephony.Rlog;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import java.util.ArrayList;
import java.util.List;

public abstract class Call {
    protected final String LOG_TAG = "Call";
    @UnsupportedAppUsage
    public State mState = State.IDLE;
    @UnsupportedAppUsage
    public ArrayList<Connection> mConnections = new ArrayList();

    public static State stateFromDCState(DriverCall.State dcState) {
        switch (dcState) {
            case ACTIVE: {
                return State.ACTIVE;
            }
            case HOLDING: {
                return State.HOLDING;
            }
            case DIALING: {
                return State.DIALING;
            }
            case ALERTING: {
                return State.ALERTING;
            }
            case INCOMING: {
                return State.INCOMING;
            }
            case WAITING: {
                return State.WAITING;
            }
        }
        throw new RuntimeException("illegal call state:" + (Object)((Object)dcState));
    }

    @UnsupportedAppUsage
    public abstract List<Connection> getConnections();

    @UnsupportedAppUsage
    public abstract Phone getPhone();

    @UnsupportedAppUsage
    public abstract boolean isMultiparty();

    @UnsupportedAppUsage
    public abstract void hangup() throws CallStateException;

    public boolean hasConnection(Connection c) {
        return c.getCall() == this;
    }

    public boolean hasConnections() {
        List<Connection> connections = this.getConnections();
        if (connections == null) {
            return false;
        }
        return connections.size() > 0;
    }

    @UnsupportedAppUsage
    public State getState() {
        return this.mState;
    }

    public List<ConferenceParticipant> getConferenceParticipants() {
        return null;
    }

    @UnsupportedAppUsage
    public boolean isIdle() {
        return !this.getState().isAlive();
    }

    @UnsupportedAppUsage
    public Connection getEarliestConnection() {
        long time = Long.MAX_VALUE;
        Connection earliest = null;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return null;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getCreateTime();
            if (t >= time) continue;
            earliest = c;
            time = t;
        }
        return earliest;
    }

    public long getEarliestCreateTime() {
        long time = Long.MAX_VALUE;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return 0L;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getCreateTime();
            time = t < time ? t : time;
        }
        return time;
    }

    public long getEarliestConnectTime() {
        long time = Long.MAX_VALUE;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return 0L;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getConnectTime();
            time = t < time ? t : time;
        }
        return time;
    }

    public boolean isDialingOrAlerting() {
        return this.getState().isDialing();
    }

    public boolean isRinging() {
        return this.getState().isRinging();
    }

    @UnsupportedAppUsage
    public Connection getLatestConnection() {
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return null;
        }
        long time = 0L;
        Connection latest = null;
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getCreateTime();
            if (t <= time) continue;
            latest = c;
            time = t;
        }
        return latest;
    }

    public void hangupIfAlive() {
        if (this.getState().isAlive()) {
            try {
                this.hangup();
            }
            catch (CallStateException ex) {
                Rlog.w("Call", " hangupIfActive: caught " + ex);
            }
        }
    }

    public void clearDisconnected() {
        for (int i = this.mConnections.size() - 1; i >= 0; --i) {
            Connection c = this.mConnections.get(i);
            if (c.getState() != State.DISCONNECTED) continue;
            this.mConnections.remove(i);
        }
        if (this.mConnections.size() == 0) {
            this.setState(State.IDLE);
        }
    }

    protected void setState(State newState) {
        this.mState = newState;
    }

    public static enum SrvccState {
        NONE,
        STARTED,
        COMPLETED,
        FAILED,
        CANCELED;

    }

    public static enum State {
        IDLE,
        ACTIVE,
        HOLDING,
        DIALING,
        ALERTING,
        INCOMING,
        WAITING,
        DISCONNECTED,
        DISCONNECTING;


        @UnsupportedAppUsage
        public boolean isAlive() {
            return this != IDLE && this != DISCONNECTED && this != DISCONNECTING;
        }

        @UnsupportedAppUsage
        public boolean isRinging() {
            return this == INCOMING || this == WAITING;
        }

        public boolean isDialing() {
            return this == DIALING || this == ALERTING;
        }
    }
}

