/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.sip.SipPhone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CallManager {
    private static final String LOG_TAG = "CallManager";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int EVENT_DISCONNECT = 100;
    private static final int EVENT_PRECISE_CALL_STATE_CHANGED = 101;
    private static final int EVENT_NEW_RINGING_CONNECTION = 102;
    private static final int EVENT_UNKNOWN_CONNECTION = 103;
    private static final int EVENT_INCOMING_RING = 104;
    private static final int EVENT_RINGBACK_TONE = 105;
    private static final int EVENT_IN_CALL_VOICE_PRIVACY_ON = 106;
    private static final int EVENT_IN_CALL_VOICE_PRIVACY_OFF = 107;
    private static final int EVENT_CALL_WAITING = 108;
    private static final int EVENT_DISPLAY_INFO = 109;
    private static final int EVENT_SIGNAL_INFO = 110;
    private static final int EVENT_CDMA_OTA_STATUS_CHANGE = 111;
    private static final int EVENT_RESEND_INCALL_MUTE = 112;
    private static final int EVENT_MMI_INITIATE = 113;
    private static final int EVENT_MMI_COMPLETE = 114;
    private static final int EVENT_ECM_TIMER_RESET = 115;
    private static final int EVENT_SUBSCRIPTION_INFO_READY = 116;
    private static final int EVENT_SUPP_SERVICE_FAILED = 117;
    private static final int EVENT_SERVICE_STATE_CHANGED = 118;
    private static final int EVENT_POST_DIAL_CHARACTER = 119;
    private static final int EVENT_ONHOLD_TONE = 120;
    private static final int EVENT_TTY_MODE_RECEIVED = 122;
    private static final CallManager INSTANCE = new CallManager();
    @UnsupportedAppUsage
    private final ArrayList<Phone> mPhones;
    @UnsupportedAppUsage
    private final ArrayList<Call> mRingingCalls;
    @UnsupportedAppUsage
    private final ArrayList<Call> mBackgroundCalls;
    @UnsupportedAppUsage
    private final ArrayList<Call> mForegroundCalls;
    @UnsupportedAppUsage
    private final ArrayList<Connection> mEmptyConnections = new ArrayList();
    private final HashMap<Phone, CallManagerHandler> mHandlerMap = new HashMap();
    private Phone mDefaultPhone = null;
    private boolean mSpeedUpAudioForMtCall = false;
    private Object mRegistrantidentifier = new Object();
    protected final RegistrantList mPreciseCallStateRegistrants = new RegistrantList();
    protected final RegistrantList mNewRingingConnectionRegistrants = new RegistrantList();
    protected final RegistrantList mIncomingRingRegistrants = new RegistrantList();
    protected final RegistrantList mDisconnectRegistrants = new RegistrantList();
    protected final RegistrantList mMmiRegistrants = new RegistrantList();
    protected final RegistrantList mUnknownConnectionRegistrants = new RegistrantList();
    protected final RegistrantList mRingbackToneRegistrants = new RegistrantList();
    protected final RegistrantList mOnHoldToneRegistrants = new RegistrantList();
    protected final RegistrantList mInCallVoicePrivacyOnRegistrants = new RegistrantList();
    protected final RegistrantList mInCallVoicePrivacyOffRegistrants = new RegistrantList();
    protected final RegistrantList mCallWaitingRegistrants = new RegistrantList();
    protected final RegistrantList mDisplayInfoRegistrants = new RegistrantList();
    protected final RegistrantList mSignalInfoRegistrants = new RegistrantList();
    protected final RegistrantList mCdmaOtaStatusChangeRegistrants = new RegistrantList();
    protected final RegistrantList mResendIncallMuteRegistrants = new RegistrantList();
    protected final RegistrantList mMmiInitiateRegistrants = new RegistrantList();
    protected final RegistrantList mMmiCompleteRegistrants = new RegistrantList();
    protected final RegistrantList mEcmTimerResetRegistrants = new RegistrantList();
    protected final RegistrantList mSubscriptionInfoReadyRegistrants = new RegistrantList();
    protected final RegistrantList mSuppServiceFailedRegistrants = new RegistrantList();
    protected final RegistrantList mServiceStateChangedRegistrants = new RegistrantList();
    protected final RegistrantList mPostDialCharacterRegistrants = new RegistrantList();
    protected final RegistrantList mTtyModeReceivedRegistrants = new RegistrantList();

    private CallManager() {
        this.mPhones = new ArrayList();
        this.mRingingCalls = new ArrayList();
        this.mBackgroundCalls = new ArrayList();
        this.mForegroundCalls = new ArrayList();
    }

    @UnsupportedAppUsage
    public static CallManager getInstance() {
        return INSTANCE;
    }

    private Phone getPhone(int subId) {
        Phone p = null;
        for (Phone phone : this.mPhones) {
            if (phone.getSubId() != subId || phone.getPhoneType() == 5) continue;
            p = phone;
            break;
        }
        return p;
    }

    @UnsupportedAppUsage
    public PhoneConstants.State getState() {
        PhoneConstants.State s = PhoneConstants.State.IDLE;
        for (Phone phone : this.mPhones) {
            if (phone.getState() == PhoneConstants.State.RINGING) {
                s = PhoneConstants.State.RINGING;
                continue;
            }
            if (phone.getState() != PhoneConstants.State.OFFHOOK || s != PhoneConstants.State.IDLE) continue;
            s = PhoneConstants.State.OFFHOOK;
        }
        return s;
    }

    @UnsupportedAppUsage
    public PhoneConstants.State getState(int subId) {
        PhoneConstants.State s = PhoneConstants.State.IDLE;
        for (Phone phone : this.mPhones) {
            if (phone.getSubId() != subId) continue;
            if (phone.getState() == PhoneConstants.State.RINGING) {
                s = PhoneConstants.State.RINGING;
                continue;
            }
            if (phone.getState() != PhoneConstants.State.OFFHOOK || s != PhoneConstants.State.IDLE) continue;
            s = PhoneConstants.State.OFFHOOK;
        }
        return s;
    }

    public int getServiceState() {
        int resultState = 1;
        for (Phone phone : this.mPhones) {
            int serviceState = phone.getServiceState().getState();
            if (serviceState == 0) {
                resultState = serviceState;
                break;
            }
            if (serviceState == 1) {
                if (resultState != 2 && resultState != 3) continue;
                resultState = serviceState;
                continue;
            }
            if (serviceState != 2 || resultState != 3) continue;
            resultState = serviceState;
        }
        return resultState;
    }

    public int getServiceState(int subId) {
        int resultState = 1;
        for (Phone phone : this.mPhones) {
            if (phone.getSubId() != subId) continue;
            int serviceState = phone.getServiceState().getState();
            if (serviceState == 0) {
                resultState = serviceState;
                break;
            }
            if (serviceState == 1) {
                if (resultState != 2 && resultState != 3) continue;
                resultState = serviceState;
                continue;
            }
            if (serviceState != 2 || resultState != 3) continue;
            resultState = serviceState;
        }
        return resultState;
    }

    @UnsupportedAppUsage
    public Phone getPhoneInCall() {
        Phone phone = null;
        phone = !this.getFirstActiveRingingCall().isIdle() ? this.getFirstActiveRingingCall().getPhone() : (!this.getActiveFgCall().isIdle() ? this.getActiveFgCall().getPhone() : this.getFirstActiveBgCall().getPhone());
        return phone;
    }

    @UnsupportedAppUsage
    public boolean registerPhone(Phone phone) {
        if (phone != null && !this.mPhones.contains(phone)) {
            Rlog.d(LOG_TAG, "registerPhone(" + phone.getPhoneName() + " " + phone + ")");
            if (this.mPhones.isEmpty()) {
                this.mDefaultPhone = phone;
            }
            this.mPhones.add(phone);
            this.mRingingCalls.add(phone.getRingingCall());
            this.mBackgroundCalls.add(phone.getBackgroundCall());
            this.mForegroundCalls.add(phone.getForegroundCall());
            this.registerForPhoneStates(phone);
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage
    public void unregisterPhone(Phone phone) {
        if (phone != null && this.mPhones.contains(phone)) {
            Rlog.d(LOG_TAG, "unregisterPhone(" + phone.getPhoneName() + " " + phone + ")");
            Phone imsPhone = phone.getImsPhone();
            if (imsPhone != null) {
                this.unregisterPhone(imsPhone);
            }
            this.mPhones.remove(phone);
            this.mRingingCalls.remove(phone.getRingingCall());
            this.mBackgroundCalls.remove(phone.getBackgroundCall());
            this.mForegroundCalls.remove(phone.getForegroundCall());
            this.unregisterForPhoneStates(phone);
            if (phone == this.mDefaultPhone) {
                this.mDefaultPhone = this.mPhones.isEmpty() ? null : this.mPhones.get(0);
            }
        }
    }

    @UnsupportedAppUsage
    public Phone getDefaultPhone() {
        return this.mDefaultPhone;
    }

    @UnsupportedAppUsage
    public Phone getFgPhone() {
        return this.getActiveFgCall().getPhone();
    }

    @UnsupportedAppUsage
    public Phone getFgPhone(int subId) {
        return this.getActiveFgCall(subId).getPhone();
    }

    @UnsupportedAppUsage
    public Phone getBgPhone() {
        return this.getFirstActiveBgCall().getPhone();
    }

    @UnsupportedAppUsage
    public Phone getRingingPhone() {
        return this.getFirstActiveRingingCall().getPhone();
    }

    public Phone getRingingPhone(int subId) {
        return this.getFirstActiveRingingCall(subId).getPhone();
    }

    @UnsupportedAppUsage
    private Context getContext() {
        Phone defaultPhone = this.getDefaultPhone();
        return defaultPhone == null ? null : defaultPhone.getContext();
    }

    public Object getRegistrantIdentifier() {
        return this.mRegistrantidentifier;
    }

    private void registerForPhoneStates(Phone phone) {
        CallManagerHandler handler = this.mHandlerMap.get(phone);
        if (handler != null) {
            Rlog.d(LOG_TAG, "This phone has already been registered.");
            return;
        }
        handler = new CallManagerHandler();
        this.mHandlerMap.put(phone, handler);
        phone.registerForPreciseCallStateChanged(handler, 101, this.mRegistrantidentifier);
        phone.registerForDisconnect(handler, 100, this.mRegistrantidentifier);
        phone.registerForNewRingingConnection(handler, 102, this.mRegistrantidentifier);
        phone.registerForUnknownConnection(handler, 103, this.mRegistrantidentifier);
        phone.registerForIncomingRing(handler, 104, this.mRegistrantidentifier);
        phone.registerForRingbackTone(handler, 105, this.mRegistrantidentifier);
        phone.registerForInCallVoicePrivacyOn(handler, 106, this.mRegistrantidentifier);
        phone.registerForInCallVoicePrivacyOff(handler, 107, this.mRegistrantidentifier);
        phone.registerForDisplayInfo(handler, 109, this.mRegistrantidentifier);
        phone.registerForSignalInfo(handler, 110, this.mRegistrantidentifier);
        phone.registerForResendIncallMute(handler, 112, this.mRegistrantidentifier);
        phone.registerForMmiInitiate(handler, 113, this.mRegistrantidentifier);
        phone.registerForMmiComplete(handler, 114, this.mRegistrantidentifier);
        phone.registerForSuppServiceFailed(handler, 117, this.mRegistrantidentifier);
        phone.registerForServiceStateChanged(handler, 118, this.mRegistrantidentifier);
        phone.setOnPostDialCharacter(handler, 119, null);
        phone.registerForCdmaOtaStatusChange(handler, 111, null);
        phone.registerForSubscriptionInfoReady(handler, 116, null);
        phone.registerForCallWaiting(handler, 108, null);
        phone.registerForEcmTimerReset(handler, 115, null);
        phone.registerForOnHoldTone(handler, 120, null);
        phone.registerForSuppServiceFailed(handler, 117, null);
        phone.registerForTtyModeReceived(handler, 122, null);
    }

    private void unregisterForPhoneStates(Phone phone) {
        CallManagerHandler handler = this.mHandlerMap.get(phone);
        if (handler == null) {
            Rlog.e(LOG_TAG, "Could not find Phone handler for unregistration");
            return;
        }
        this.mHandlerMap.remove(phone);
        phone.unregisterForPreciseCallStateChanged(handler);
        phone.unregisterForDisconnect(handler);
        phone.unregisterForNewRingingConnection(handler);
        phone.unregisterForUnknownConnection(handler);
        phone.unregisterForIncomingRing(handler);
        phone.unregisterForRingbackTone(handler);
        phone.unregisterForInCallVoicePrivacyOn(handler);
        phone.unregisterForInCallVoicePrivacyOff(handler);
        phone.unregisterForDisplayInfo(handler);
        phone.unregisterForSignalInfo(handler);
        phone.unregisterForResendIncallMute(handler);
        phone.unregisterForMmiInitiate(handler);
        phone.unregisterForMmiComplete(handler);
        phone.unregisterForSuppServiceFailed(handler);
        phone.unregisterForServiceStateChanged(handler);
        phone.unregisterForTtyModeReceived(handler);
        phone.setOnPostDialCharacter(null, 119, null);
        phone.unregisterForCdmaOtaStatusChange(handler);
        phone.unregisterForSubscriptionInfoReady(handler);
        phone.unregisterForCallWaiting(handler);
        phone.unregisterForEcmTimerReset(handler);
        phone.unregisterForOnHoldTone(handler);
        phone.unregisterForSuppServiceFailed(handler);
    }

    public void rejectCall(Call ringingCall) throws CallStateException {
        Phone ringingPhone = ringingCall.getPhone();
        ringingPhone.rejectCall();
    }

    public boolean canConference(Call heldCall) {
        Phone activePhone = null;
        Object heldPhone = null;
        if (this.hasActiveFgCall()) {
            activePhone = this.getActiveFgCall().getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        return heldPhone.getClass().equals(activePhone.getClass());
    }

    @UnsupportedAppUsage
    public boolean canConference(Call heldCall, int subId) {
        Phone activePhone = null;
        Object heldPhone = null;
        if (this.hasActiveFgCall(subId)) {
            activePhone = this.getActiveFgCall(subId).getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        return heldPhone.getClass().equals(activePhone.getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UnsupportedAppUsage
    public void conference(Call heldCall) throws CallStateException {
        int subId = heldCall.getPhone().getSubId();
        Phone fgPhone = this.getFgPhone(subId);
        if (fgPhone != null) {
            if (fgPhone instanceof SipPhone) {
                ((SipPhone)fgPhone).conference(heldCall);
                return;
            } else {
                if (!this.canConference(heldCall)) throw new CallStateException("Can't conference foreground and selected background call");
                fgPhone.conference();
            }
            return;
        } else {
            Rlog.d(LOG_TAG, "conference: fgPhone=null");
        }
    }

    public Connection dial(Phone phone, String dialString, int videoState) throws CallStateException {
        int subId = phone.getSubId();
        if (!this.canDial(phone)) {
            String newDialString = PhoneNumberUtils.stripSeparators(dialString);
            if (phone.handleInCallMmiCommands(newDialString)) {
                return null;
            }
            throw new CallStateException("cannot dial in current state");
        }
        if (this.hasActiveFgCall(subId)) {
            Phone activePhone = this.getActiveFgCall(subId).getPhone();
            boolean hasBgCall = !activePhone.getBackgroundCall().isIdle();
            Rlog.d(LOG_TAG, "hasBgCall: " + hasBgCall + " sameChannel:" + (activePhone == phone));
            Phone imsPhone = phone.getImsPhone();
            if (activePhone != phone && (imsPhone == null || imsPhone != activePhone)) {
                if (hasBgCall) {
                    Rlog.d(LOG_TAG, "Hangup");
                    this.getActiveFgCall(subId).hangup();
                } else {
                    Rlog.d(LOG_TAG, "Switch");
                    activePhone.switchHoldingAndActive();
                }
            }
        }
        Connection result = phone.dial(dialString, ((PhoneInternalInterface.DialArgs.Builder)new PhoneInternalInterface.DialArgs.Builder().setVideoState(videoState)).build());
        return result;
    }

    public Connection dial(Phone phone, String dialString, UUSInfo uusInfo, int videoState) throws CallStateException {
        return phone.dial(dialString, ((PhoneInternalInterface.DialArgs.Builder)((PhoneInternalInterface.DialArgs.Builder)new PhoneInternalInterface.DialArgs.Builder().setUusInfo(uusInfo)).setVideoState(videoState)).build());
    }

    public void clearDisconnected() {
        for (Phone phone : this.mPhones) {
            phone.clearDisconnected();
        }
    }

    public void clearDisconnected(int subId) {
        for (Phone phone : this.mPhones) {
            if (phone.getSubId() != subId) continue;
            phone.clearDisconnected();
        }
    }

    @UnsupportedAppUsage
    private boolean canDial(Phone phone) {
        boolean result;
        int serviceState = phone.getServiceState().getState();
        int subId = phone.getSubId();
        boolean hasRingingCall = this.hasActiveRingingCall();
        Call.State fgCallState = this.getActiveFgCallState(subId);
        boolean bl = result = serviceState != 3 && !hasRingingCall && (fgCallState == Call.State.ACTIVE || fgCallState == Call.State.IDLE || fgCallState == Call.State.DISCONNECTED || fgCallState == Call.State.ALERTING);
        if (!result) {
            Rlog.d(LOG_TAG, "canDial serviceState=" + serviceState + " hasRingingCall=" + hasRingingCall + " fgCallState=" + (Object)((Object)fgCallState));
        }
        return result;
    }

    public boolean canTransfer(Call heldCall) {
        Phone activePhone = null;
        Phone heldPhone = null;
        if (this.hasActiveFgCall()) {
            activePhone = this.getActiveFgCall().getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        return heldPhone == activePhone && activePhone.canTransfer();
    }

    public boolean canTransfer(Call heldCall, int subId) {
        Phone activePhone = null;
        Phone heldPhone = null;
        if (this.hasActiveFgCall(subId)) {
            activePhone = this.getActiveFgCall(subId).getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        return heldPhone == activePhone && activePhone.canTransfer();
    }

    public void explicitCallTransfer(Call heldCall) throws CallStateException {
        if (this.canTransfer(heldCall)) {
            heldCall.getPhone().explicitCallTransfer();
        }
    }

    public List<? extends MmiCode> getPendingMmiCodes(Phone phone) {
        Rlog.e(LOG_TAG, "getPendingMmiCodes not implemented");
        return null;
    }

    public boolean sendUssdResponse(Phone phone, String ussdMessge) {
        Rlog.e(LOG_TAG, "sendUssdResponse not implemented");
        return false;
    }

    public void setMute(boolean muted) {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().setMute(muted);
        }
    }

    public boolean getMute() {
        if (this.hasActiveFgCall()) {
            return this.getActiveFgCall().getPhone().getMute();
        }
        if (this.hasActiveBgCall()) {
            return this.getFirstActiveBgCall().getPhone().getMute();
        }
        return false;
    }

    public void setEchoSuppressionEnabled() {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().setEchoSuppressionEnabled();
        }
    }

    public boolean sendDtmf(char c) {
        boolean result = false;
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().sendDtmf(c);
            result = true;
        }
        return result;
    }

    public boolean startDtmf(char c) {
        boolean result = false;
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().startDtmf(c);
            result = true;
        }
        return result;
    }

    public void stopDtmf() {
        if (this.hasActiveFgCall()) {
            this.getFgPhone().stopDtmf();
        }
    }

    public boolean sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().sendBurstDtmf(dtmfString, on, off, onComplete);
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage
    public void registerForDisconnect(Handler h, int what, Object obj) {
        this.mDisconnectRegistrants.addUnique(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForDisconnect(Handler h) {
        this.mDisconnectRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void registerForPreciseCallStateChanged(Handler h, int what, Object obj) {
        this.mPreciseCallStateRegistrants.addUnique(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForPreciseCallStateChanged(Handler h) {
        this.mPreciseCallStateRegistrants.remove(h);
    }

    public void registerForUnknownConnection(Handler h, int what, Object obj) {
        this.mUnknownConnectionRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForUnknownConnection(Handler h) {
        this.mUnknownConnectionRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void registerForNewRingingConnection(Handler h, int what, Object obj) {
        this.mNewRingingConnectionRegistrants.addUnique(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForNewRingingConnection(Handler h) {
        this.mNewRingingConnectionRegistrants.remove(h);
    }

    public void registerForIncomingRing(Handler h, int what, Object obj) {
        this.mIncomingRingRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForIncomingRing(Handler h) {
        this.mIncomingRingRegistrants.remove(h);
    }

    public void registerForRingbackTone(Handler h, int what, Object obj) {
        this.mRingbackToneRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForRingbackTone(Handler h) {
        this.mRingbackToneRegistrants.remove(h);
    }

    public void registerForOnHoldTone(Handler h, int what, Object obj) {
        this.mOnHoldToneRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForOnHoldTone(Handler h) {
        this.mOnHoldToneRegistrants.remove(h);
    }

    public void registerForResendIncallMute(Handler h, int what, Object obj) {
        this.mResendIncallMuteRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForResendIncallMute(Handler h) {
        this.mResendIncallMuteRegistrants.remove(h);
    }

    public void registerForMmiInitiate(Handler h, int what, Object obj) {
        this.mMmiInitiateRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForMmiInitiate(Handler h) {
        this.mMmiInitiateRegistrants.remove(h);
    }

    public void registerForMmiComplete(Handler h, int what, Object obj) {
        Rlog.d(LOG_TAG, "registerForMmiComplete");
        this.mMmiCompleteRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForMmiComplete(Handler h) {
        this.mMmiCompleteRegistrants.remove(h);
    }

    public void registerForEcmTimerReset(Handler h, int what, Object obj) {
        this.mEcmTimerResetRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForEcmTimerReset(Handler h) {
        this.mEcmTimerResetRegistrants.remove(h);
    }

    public void registerForServiceStateChanged(Handler h, int what, Object obj) {
        this.mServiceStateChangedRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForServiceStateChanged(Handler h) {
        this.mServiceStateChangedRegistrants.remove(h);
    }

    public void registerForSuppServiceFailed(Handler h, int what, Object obj) {
        this.mSuppServiceFailedRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForSuppServiceFailed(Handler h) {
        this.mSuppServiceFailedRegistrants.remove(h);
    }

    public void registerForInCallVoicePrivacyOn(Handler h, int what, Object obj) {
        this.mInCallVoicePrivacyOnRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForInCallVoicePrivacyOn(Handler h) {
        this.mInCallVoicePrivacyOnRegistrants.remove(h);
    }

    public void registerForInCallVoicePrivacyOff(Handler h, int what, Object obj) {
        this.mInCallVoicePrivacyOffRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForInCallVoicePrivacyOff(Handler h) {
        this.mInCallVoicePrivacyOffRegistrants.remove(h);
    }

    public void registerForCallWaiting(Handler h, int what, Object obj) {
        this.mCallWaitingRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForCallWaiting(Handler h) {
        this.mCallWaitingRegistrants.remove(h);
    }

    public void registerForSignalInfo(Handler h, int what, Object obj) {
        this.mSignalInfoRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForSignalInfo(Handler h) {
        this.mSignalInfoRegistrants.remove(h);
    }

    public void registerForDisplayInfo(Handler h, int what, Object obj) {
        this.mDisplayInfoRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForDisplayInfo(Handler h) {
        this.mDisplayInfoRegistrants.remove(h);
    }

    public void registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        this.mCdmaOtaStatusChangeRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForCdmaOtaStatusChange(Handler h) {
        this.mCdmaOtaStatusChangeRegistrants.remove(h);
    }

    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        this.mSubscriptionInfoReadyRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForSubscriptionInfoReady(Handler h) {
        this.mSubscriptionInfoReadyRegistrants.remove(h);
    }

    public void registerForPostDialCharacter(Handler h, int what, Object obj) {
        this.mPostDialCharacterRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForPostDialCharacter(Handler h) {
        this.mPostDialCharacterRegistrants.remove(h);
    }

    public void registerForTtyModeReceived(Handler h, int what, Object obj) {
        this.mTtyModeReceivedRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForTtyModeReceived(Handler h) {
        this.mTtyModeReceivedRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public List<Call> getRingingCalls() {
        return Collections.unmodifiableList(this.mRingingCalls);
    }

    public List<Call> getForegroundCalls() {
        return Collections.unmodifiableList(this.mForegroundCalls);
    }

    @UnsupportedAppUsage
    public List<Call> getBackgroundCalls() {
        return Collections.unmodifiableList(this.mBackgroundCalls);
    }

    @UnsupportedAppUsage
    public boolean hasActiveFgCall() {
        return this.getFirstActiveCall(this.mForegroundCalls) != null;
    }

    @UnsupportedAppUsage
    public boolean hasActiveFgCall(int subId) {
        return this.getFirstActiveCall(this.mForegroundCalls, subId) != null;
    }

    @UnsupportedAppUsage
    public boolean hasActiveBgCall() {
        return this.getFirstActiveCall(this.mBackgroundCalls) != null;
    }

    @UnsupportedAppUsage
    public boolean hasActiveBgCall(int subId) {
        return this.getFirstActiveCall(this.mBackgroundCalls, subId) != null;
    }

    public boolean hasActiveRingingCall() {
        return this.getFirstActiveCall(this.mRingingCalls) != null;
    }

    @UnsupportedAppUsage
    public boolean hasActiveRingingCall(int subId) {
        return this.getFirstActiveCall(this.mRingingCalls, subId) != null;
    }

    public Call getActiveFgCall() {
        Call call = this.getFirstNonIdleCall(this.mForegroundCalls);
        if (call == null) {
            call = this.mDefaultPhone == null ? null : this.mDefaultPhone.getForegroundCall();
        }
        return call;
    }

    @UnsupportedAppUsage
    public Call getActiveFgCall(int subId) {
        Call call = this.getFirstNonIdleCall(this.mForegroundCalls, subId);
        if (call == null) {
            Phone phone = this.getPhone(subId);
            call = phone == null ? null : phone.getForegroundCall();
        }
        return call;
    }

    private Call getFirstNonIdleCall(List<Call> calls) {
        Call result = null;
        for (Call call : calls) {
            if (!call.isIdle()) {
                return call;
            }
            if (call.getState() == Call.State.IDLE || result != null) continue;
            result = call;
        }
        return result;
    }

    private Call getFirstNonIdleCall(List<Call> calls, int subId) {
        Call result = null;
        for (Call call : calls) {
            if (call.getPhone().getSubId() != subId && !(call.getPhone() instanceof SipPhone)) continue;
            if (!call.isIdle()) {
                return call;
            }
            if (call.getState() == Call.State.IDLE || result != null) continue;
            result = call;
        }
        return result;
    }

    @UnsupportedAppUsage
    public Call getFirstActiveBgCall() {
        Call call = this.getFirstNonIdleCall(this.mBackgroundCalls);
        if (call == null) {
            call = this.mDefaultPhone == null ? null : this.mDefaultPhone.getBackgroundCall();
        }
        return call;
    }

    @UnsupportedAppUsage
    public Call getFirstActiveBgCall(int subId) {
        Phone phone = this.getPhone(subId);
        if (this.hasMoreThanOneHoldingCall(subId)) {
            return phone.getBackgroundCall();
        }
        Call call = this.getFirstNonIdleCall(this.mBackgroundCalls, subId);
        if (call == null) {
            call = phone == null ? null : phone.getBackgroundCall();
        }
        return call;
    }

    @UnsupportedAppUsage
    public Call getFirstActiveRingingCall() {
        Call call = this.getFirstNonIdleCall(this.mRingingCalls);
        if (call == null) {
            call = this.mDefaultPhone == null ? null : this.mDefaultPhone.getRingingCall();
        }
        return call;
    }

    @UnsupportedAppUsage
    public Call getFirstActiveRingingCall(int subId) {
        Phone phone = this.getPhone(subId);
        Call call = this.getFirstNonIdleCall(this.mRingingCalls, subId);
        if (call == null) {
            call = phone == null ? null : phone.getRingingCall();
        }
        return call;
    }

    public Call.State getActiveFgCallState() {
        Call fgCall = this.getActiveFgCall();
        if (fgCall != null) {
            return fgCall.getState();
        }
        return Call.State.IDLE;
    }

    @UnsupportedAppUsage
    public Call.State getActiveFgCallState(int subId) {
        Call fgCall = this.getActiveFgCall(subId);
        if (fgCall != null) {
            return fgCall.getState();
        }
        return Call.State.IDLE;
    }

    @UnsupportedAppUsage
    public List<Connection> getFgCallConnections() {
        Call fgCall = this.getActiveFgCall();
        if (fgCall != null) {
            return fgCall.getConnections();
        }
        return this.mEmptyConnections;
    }

    public List<Connection> getFgCallConnections(int subId) {
        Call fgCall = this.getActiveFgCall(subId);
        if (fgCall != null) {
            return fgCall.getConnections();
        }
        return this.mEmptyConnections;
    }

    @UnsupportedAppUsage
    public List<Connection> getBgCallConnections() {
        Call bgCall = this.getFirstActiveBgCall();
        if (bgCall != null) {
            return bgCall.getConnections();
        }
        return this.mEmptyConnections;
    }

    public boolean hasDisconnectedFgCall() {
        return this.getFirstCallOfState(this.mForegroundCalls, Call.State.DISCONNECTED) != null;
    }

    public boolean hasDisconnectedFgCall(int subId) {
        return this.getFirstCallOfState(this.mForegroundCalls, Call.State.DISCONNECTED, subId) != null;
    }

    public boolean hasDisconnectedBgCall() {
        return this.getFirstCallOfState(this.mBackgroundCalls, Call.State.DISCONNECTED) != null;
    }

    public boolean hasDisconnectedBgCall(int subId) {
        return this.getFirstCallOfState(this.mBackgroundCalls, Call.State.DISCONNECTED, subId) != null;
    }

    private Call getFirstActiveCall(ArrayList<Call> calls) {
        for (Call call : calls) {
            if (call.isIdle()) continue;
            return call;
        }
        return null;
    }

    private Call getFirstActiveCall(ArrayList<Call> calls, int subId) {
        for (Call call : calls) {
            if (call.isIdle() || call.getPhone().getSubId() != subId && !(call.getPhone() instanceof SipPhone)) continue;
            return call;
        }
        return null;
    }

    private Call getFirstCallOfState(ArrayList<Call> calls, Call.State state) {
        for (Call call : calls) {
            if (call.getState() != state) continue;
            return call;
        }
        return null;
    }

    private Call getFirstCallOfState(ArrayList<Call> calls, Call.State state, int subId) {
        for (Call call : calls) {
            if (call.getState() != state && call.getPhone().getSubId() != subId && !(call.getPhone() instanceof SipPhone)) continue;
            return call;
        }
        return null;
    }

    @UnsupportedAppUsage
    private boolean hasMoreThanOneRingingCall() {
        int count = 0;
        for (Call call : this.mRingingCalls) {
            if (!call.getState().isRinging() || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage
    private boolean hasMoreThanOneRingingCall(int subId) {
        int count = 0;
        for (Call call : this.mRingingCalls) {
            if (!call.getState().isRinging() || call.getPhone().getSubId() != subId && !(call.getPhone() instanceof SipPhone) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean hasMoreThanOneHoldingCall(int subId) {
        int count = 0;
        for (Call call : this.mBackgroundCalls) {
            if (call.getState() != Call.State.HOLDING || call.getPhone().getSubId() != subId && !(call.getPhone() instanceof SipPhone) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    private class CallManagerHandler
    extends Handler {
        private CallManagerHandler() {
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    CallManager.this.mDisconnectRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 101: {
                    CallManager.this.mPreciseCallStateRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 102: {
                    Connection c = (Connection)((AsyncResult)msg.obj).result;
                    int subId = c.getCall().getPhone().getSubId();
                    if (CallManager.this.getActiveFgCallState(subId).isDialing() || CallManager.this.hasMoreThanOneRingingCall()) {
                        try {
                            Rlog.d(CallManager.LOG_TAG, "silently drop incoming call: " + c.getCall());
                            c.getCall().hangup();
                        }
                        catch (CallStateException e) {
                            Rlog.w(CallManager.LOG_TAG, "new ringing connection", e);
                        }
                        break;
                    }
                    CallManager.this.mNewRingingConnectionRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 103: {
                    CallManager.this.mUnknownConnectionRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 104: {
                    if (CallManager.this.hasActiveFgCall()) break;
                    CallManager.this.mIncomingRingRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 105: {
                    CallManager.this.mRingbackToneRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 106: {
                    CallManager.this.mInCallVoicePrivacyOnRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 107: {
                    CallManager.this.mInCallVoicePrivacyOffRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 108: {
                    CallManager.this.mCallWaitingRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 109: {
                    CallManager.this.mDisplayInfoRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 110: {
                    CallManager.this.mSignalInfoRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 111: {
                    CallManager.this.mCdmaOtaStatusChangeRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 112: {
                    CallManager.this.mResendIncallMuteRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 113: {
                    CallManager.this.mMmiInitiateRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 114: {
                    Rlog.d(CallManager.LOG_TAG, "CallManager: handleMessage (EVENT_MMI_COMPLETE)");
                    CallManager.this.mMmiCompleteRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 115: {
                    CallManager.this.mEcmTimerResetRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 116: {
                    CallManager.this.mSubscriptionInfoReadyRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 117: {
                    CallManager.this.mSuppServiceFailedRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 118: {
                    CallManager.this.mServiceStateChangedRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 119: {
                    for (int i = 0; i < CallManager.this.mPostDialCharacterRegistrants.size(); ++i) {
                        Message notifyMsg = ((Registrant)CallManager.this.mPostDialCharacterRegistrants.get(i)).messageForRegistrant();
                        notifyMsg.obj = msg.obj;
                        notifyMsg.arg1 = msg.arg1;
                        notifyMsg.sendToTarget();
                    }
                    break;
                }
                case 120: {
                    CallManager.this.mOnHoldToneRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 122: {
                    CallManager.this.mTtyModeReceivedRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                }
            }
        }
    }
}

