/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AlarmManager;
import android.app.DownloadManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.preference.PreferenceManager;
import android.telephony.CarrierConfigManager;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Phone;
import com.android.org.bouncycastle.util.io.pem.PemReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CarrierKeyDownloadManager
extends Handler {
    private static final String LOG_TAG = "CarrierKeyDownloadManager";
    private static final String MCC_MNC_PREF_TAG = "CARRIER_KEY_DM_MCC_MNC";
    private static final int DAY_IN_MILLIS = 86400000;
    private static final int START_RENEWAL_WINDOW_DAYS = 21;
    private static final int END_RENEWAL_WINDOW_DAYS = 7;
    private static final String INTENT_KEY_RENEWAL_ALARM_PREFIX = "com.android.internal.telephony.carrier_key_download_alarm";
    @VisibleForTesting
    public int mKeyAvailability = 0;
    public static final String MNC = "MNC";
    public static final String MCC = "MCC";
    private static final String SEPARATOR = ":";
    private static final String JSON_CERTIFICATE = "certificate";
    private static final String JSON_CERTIFICATE_ALTERNATE = "public-key";
    private static final String JSON_TYPE = "key-type";
    private static final String JSON_IDENTIFIER = "key-identifier";
    private static final String JSON_CARRIER_KEYS = "carrier-keys";
    private static final String JSON_TYPE_VALUE_WLAN = "WLAN";
    private static final String JSON_TYPE_VALUE_EPDG = "EPDG";
    private static final int EVENT_ALARM_OR_CONFIG_CHANGE = 0;
    private static final int EVENT_DOWNLOAD_COMPLETE = 1;
    private static final int[] CARRIER_KEY_TYPES = new int[]{1, 2};
    private final Phone mPhone;
    private final Context mContext;
    public final DownloadManager mDownloadManager;
    private String mURL;
    private boolean mAllowedOverMeteredNetwork = false;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int slotId = CarrierKeyDownloadManager.this.mPhone.getPhoneId();
            if (action.equals(CarrierKeyDownloadManager.INTENT_KEY_RENEWAL_ALARM_PREFIX + slotId)) {
                Log.d(CarrierKeyDownloadManager.LOG_TAG, "Handling key renewal alarm: " + action);
                CarrierKeyDownloadManager.this.sendEmptyMessage(0);
            } else if (action.equals("com.android.internal.telephony.ACTION_CARRIER_CERTIFICATE_DOWNLOAD")) {
                if (slotId == intent.getIntExtra("phone", -1)) {
                    Log.d(CarrierKeyDownloadManager.LOG_TAG, "Handling reset intent: " + action);
                    CarrierKeyDownloadManager.this.sendEmptyMessage(0);
                }
            } else if (action.equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                if (slotId == intent.getIntExtra("phone", -1)) {
                    Log.d(CarrierKeyDownloadManager.LOG_TAG, "Carrier Config changed: " + action);
                    CarrierKeyDownloadManager.this.sendEmptyMessage(0);
                }
            } else if (action.equals("android.intent.action.DOWNLOAD_COMPLETE")) {
                Log.d(CarrierKeyDownloadManager.LOG_TAG, "Download Complete");
                CarrierKeyDownloadManager.this.sendMessage(CarrierKeyDownloadManager.this.obtainMessage(1, intent.getLongExtra("extra_download_id", 0L)));
            }
        }
    };

    public CarrierKeyDownloadManager(Phone phone) {
        this.mPhone = phone;
        this.mContext = phone.getContext();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        filter.addAction("android.intent.action.DOWNLOAD_COMPLETE");
        filter.addAction(INTENT_KEY_RENEWAL_ALARM_PREFIX + this.mPhone.getPhoneId());
        filter.addAction("com.android.internal.telephony.ACTION_CARRIER_CERTIFICATE_DOWNLOAD");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter, null, phone);
        this.mDownloadManager = (DownloadManager)this.mContext.getSystemService("download");
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.handleAlarmOrConfigChange();
                break;
            }
            case 1: {
                long carrierKeyDownloadIdentifier = (Long)msg.obj;
                String mccMnc = this.getMccMncSetFromPref();
                if (!this.isValidDownload(mccMnc)) break;
                this.onDownloadComplete(carrierKeyDownloadIdentifier, mccMnc);
                this.onPostDownloadProcessing(carrierKeyDownloadIdentifier);
            }
        }
    }

    private void onPostDownloadProcessing(long carrierKeyDownloadIdentifier) {
        this.resetRenewalAlarm();
        this.cleanupDownloadPreferences(carrierKeyDownloadIdentifier);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAlarmOrConfigChange() {
        if (this.carrierUsesKeys()) {
            if (!this.areCarrierKeysAbsentOrExpiring()) return;
            boolean downloadStartedSuccessfully = this.downloadKey();
            if (downloadStartedSuccessfully) return;
            this.resetRenewalAlarm();
            return;
        } else {
            this.cleanupRenewalAlarms();
        }
    }

    private void cleanupDownloadPreferences(long carrierKeyDownloadIdentifier) {
        Log.d(LOG_TAG, "Cleaning up download preferences: " + carrierKeyDownloadIdentifier);
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
        editor.remove(String.valueOf(carrierKeyDownloadIdentifier));
        editor.commit();
    }

    private void cleanupRenewalAlarms() {
        Log.d(LOG_TAG, "Cleaning up existing renewal alarms");
        int slotId = this.mPhone.getPhoneId();
        Intent intent = new Intent(INTENT_KEY_RENEWAL_ALARM_PREFIX + slotId);
        PendingIntent carrierKeyDownloadIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000);
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        alarmManager.cancel(carrierKeyDownloadIntent);
    }

    @VisibleForTesting
    public long getExpirationDate() {
        long minExpirationDate = Long.MAX_VALUE;
        for (int key_type : CARRIER_KEY_TYPES) {
            ImsiEncryptionInfo imsiEncryptionInfo;
            if (!this.isKeyEnabled(key_type) || (imsiEncryptionInfo = this.mPhone.getCarrierInfoForImsiEncryption(key_type)) == null || imsiEncryptionInfo.getExpirationTime() == null || minExpirationDate <= imsiEncryptionInfo.getExpirationTime().getTime()) continue;
            minExpirationDate = imsiEncryptionInfo.getExpirationTime().getTime();
        }
        if (minExpirationDate == Long.MAX_VALUE || minExpirationDate < System.currentTimeMillis() + 604800000L) {
            minExpirationDate = System.currentTimeMillis() + 86400000L;
        } else {
            Random random = new Random();
            int max = 1814400000;
            int min = 604800000;
            int randomTime = random.nextInt(max - min) + min;
            minExpirationDate -= (long)randomTime;
        }
        return minExpirationDate;
    }

    @VisibleForTesting
    public void resetRenewalAlarm() {
        this.cleanupRenewalAlarms();
        int slotId = this.mPhone.getPhoneId();
        long minExpirationDate = this.getExpirationDate();
        Log.d(LOG_TAG, "minExpirationDate: " + new Date(minExpirationDate));
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent intent = new Intent(INTENT_KEY_RENEWAL_ALARM_PREFIX + slotId);
        PendingIntent carrierKeyDownloadIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000);
        alarmManager.set(2, minExpirationDate, carrierKeyDownloadIntent);
        Log.d(LOG_TAG, "setRenewelAlarm: action=" + intent.getAction() + " time=" + new Date(minExpirationDate));
    }

    private String getMccMncSetFromPref() {
        int slotId = this.mPhone.getPhoneId();
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        return preferences.getString(MCC_MNC_PREF_TAG + slotId, null);
    }

    @VisibleForTesting
    public String getSimOperator() {
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        return telephonyManager.getSimOperator(this.mPhone.getSubId());
    }

    @VisibleForTesting
    public boolean isValidDownload(String mccMnc) {
        String mccCurrent = "";
        String mncCurrent = "";
        String mccSource = "";
        String mncSource = "";
        String simOperator = this.getSimOperator();
        if (TextUtils.isEmpty(simOperator) || TextUtils.isEmpty(mccMnc)) {
            Log.e(LOG_TAG, "simOperator or mcc/mnc is empty");
            return false;
        }
        String[] splitValue = mccMnc.split(SEPARATOR);
        mccSource = splitValue[0];
        mncSource = splitValue[1];
        Log.d(LOG_TAG, "values from sharedPrefs mcc, mnc: " + mccSource + "," + mncSource);
        mccCurrent = simOperator.substring(0, 3);
        mncCurrent = simOperator.substring(3);
        Log.d(LOG_TAG, "using values for mcc, mnc: " + mccCurrent + "," + mncCurrent);
        return TextUtils.equals(mncSource, mncCurrent) && TextUtils.equals(mccSource, mccCurrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void onDownloadComplete(long carrierKeyDownloadIdentifier, String mccMnc) {
        Cursor cursor;
        block12: {
            block13: {
                Log.d(LOG_TAG, "onDownloadComplete: " + carrierKeyDownloadIdentifier);
                DownloadManager.Query query = new DownloadManager.Query();
                query.setFilterById(carrierKeyDownloadIdentifier);
                cursor = this.mDownloadManager.query(query);
                FileInputStream source = null;
                if (cursor == null) {
                    return;
                }
                if (!cursor.moveToFirst()) break block12;
                int columnIndex = cursor.getColumnIndex("status");
                if (8 == cursor.getInt(columnIndex)) {
                    source = new FileInputStream(this.mDownloadManager.openDownloadedFile(carrierKeyDownloadIdentifier).getFileDescriptor());
                    String jsonStr = CarrierKeyDownloadManager.convertToString(source);
                    this.parseJsonAndPersistKey(jsonStr, mccMnc);
                    this.mDownloadManager.remove(carrierKeyDownloadIdentifier);
                    try {
                        ((InputStream)source).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break block13;
                    catch (Exception e) {
                        try {
                            Log.e(LOG_TAG, "Error in download:" + carrierKeyDownloadIdentifier + ". " + e);
                        }
                        catch (Throwable throwable) {
                            this.mDownloadManager.remove(carrierKeyDownloadIdentifier);
                            try {
                                ((InputStream)source).close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            throw throwable;
                        }
                        this.mDownloadManager.remove(carrierKeyDownloadIdentifier);
                        try {
                            ((InputStream)source).close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
            }
            Log.d(LOG_TAG, "Completed downloading keys");
        }
        cursor.close();
    }

    private boolean carrierUsesKeys() {
        CarrierConfigManager carrierConfigManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (carrierConfigManager == null) {
            return false;
        }
        int subId = this.mPhone.getSubId();
        PersistableBundle b = carrierConfigManager.getConfigForSubId(subId);
        if (b == null) {
            return false;
        }
        this.mKeyAvailability = b.getInt("imsi_key_availability_int");
        this.mURL = b.getString("imsi_key_download_url_string");
        this.mAllowedOverMeteredNetwork = b.getBoolean("allow_metered_network_for_cert_download_bool");
        if (TextUtils.isEmpty(this.mURL) || this.mKeyAvailability == 0) {
            Log.d(LOG_TAG, "Carrier not enabled or invalid values");
            return false;
        }
        for (int key_type : CARRIER_KEY_TYPES) {
            if (!this.isKeyEnabled(key_type)) continue;
            return true;
        }
        return false;
    }

    private static String convertToString(InputStream is) {
        try {
            String line;
            GZIPInputStream gunzip = new GZIPInputStream(is);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)gunzip, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void parseJsonAndPersistKey(String jsonStr, String mccMnc) {
        if (TextUtils.isEmpty(jsonStr) || TextUtils.isEmpty(mccMnc)) {
            Log.e(LOG_TAG, "jsonStr or mcc, mnc: is empty");
            return;
        }
        PemReader reader = null;
        try {
            String mcc = "";
            String mnc = "";
            String[] splitValue = mccMnc.split(SEPARATOR);
            mcc = splitValue[0];
            mnc = splitValue[1];
            JSONObject jsonObj = new JSONObject(jsonStr);
            JSONArray keys = jsonObj.getJSONArray(JSON_CARRIER_KEYS);
            for (int i = 0; i < keys.length(); ++i) {
                JSONObject key = keys.getJSONObject(i);
                String cert = null;
                cert = key.has(JSON_CERTIFICATE) ? key.getString(JSON_CERTIFICATE) : key.getString(JSON_CERTIFICATE_ALTERNATE);
                int type = 2;
                if (key.has(JSON_TYPE)) {
                    String typeString = key.getString(JSON_TYPE);
                    if (typeString.equals(JSON_TYPE_VALUE_EPDG)) {
                        type = 1;
                    } else if (!typeString.equals(JSON_TYPE_VALUE_WLAN)) {
                        Log.e(LOG_TAG, "Invalid key-type specified: " + typeString);
                    }
                }
                String identifier = key.getString(JSON_IDENTIFIER);
                ByteArrayInputStream inStream = new ByteArrayInputStream(cert.getBytes());
                BufferedReader fReader = new BufferedReader(new InputStreamReader(inStream));
                reader = new PemReader((Reader)fReader);
                Pair<PublicKey, Long> keyInfo = CarrierKeyDownloadManager.getKeyInformation(reader.readPemObject().getContent());
                reader.close();
                this.savePublicKey((PublicKey)keyInfo.first, type, identifier, (Long)keyInfo.second, mcc, mnc);
            }
        }
        catch (JSONException e) {
            Log.e(LOG_TAG, "Json parsing error: " + e.getMessage());
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Exception getting certificate: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "Exception getting certificate: " + e);
            }
        }
    }

    @VisibleForTesting
    public boolean isKeyEnabled(int keyType) {
        int returnValue = this.mKeyAvailability >> keyType - 1 & 1;
        return returnValue == 1;
    }

    @VisibleForTesting
    public boolean areCarrierKeysAbsentOrExpiring() {
        for (int key_type : CARRIER_KEY_TYPES) {
            if (!this.isKeyEnabled(key_type)) continue;
            ImsiEncryptionInfo imsiEncryptionInfo = this.mPhone.getCarrierInfoForImsiEncryption(key_type);
            if (imsiEncryptionInfo == null) {
                Log.d(LOG_TAG, "Key not found for: " + key_type);
                return true;
            }
            Date imsiDate = imsiEncryptionInfo.getExpirationTime();
            long timeToExpire = imsiDate.getTime() - System.currentTimeMillis();
            return timeToExpire < 1814400000L;
        }
        return false;
    }

    private boolean downloadKey() {
        Log.d(LOG_TAG, "starting download from: " + this.mURL);
        String mcc = "";
        String mnc = "";
        String simOperator = this.getSimOperator();
        if (TextUtils.isEmpty(simOperator)) {
            Log.e(LOG_TAG, "mcc, mnc: is empty");
            return false;
        }
        mcc = simOperator.substring(0, 3);
        mnc = simOperator.substring(3);
        Log.d(LOG_TAG, "using values for mcc, mnc: " + mcc + "," + mnc);
        try {
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse(this.mURL));
            request.setAllowedOverMetered(this.mAllowedOverMeteredNetwork);
            request.setVisibleInDownloadsUi(false);
            request.setNotificationVisibility(2);
            Long carrierKeyDownloadRequestId = this.mDownloadManager.enqueue(request);
            SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
            String mccMnc = mcc + SEPARATOR + mnc;
            int slotId = this.mPhone.getPhoneId();
            Log.d(LOG_TAG, "storing values in sharedpref mcc, mnc, days: " + mcc + "," + mnc + "," + carrierKeyDownloadRequestId);
            editor.putString(MCC_MNC_PREF_TAG + slotId, mccMnc);
            editor.commit();
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "exception trying to dowload key from url: " + this.mURL);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public static Pair<PublicKey, Long> getKeyInformation(byte[] certificate) throws Exception {
        ByteArrayInputStream inStream = new ByteArrayInputStream(certificate);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
        Pair<PublicKey, Long> keyInformation = new Pair<PublicKey, Long>(cert.getPublicKey(), cert.getNotAfter().getTime());
        return keyInformation;
    }

    @VisibleForTesting
    public void savePublicKey(PublicKey publicKey, int type, String identifier, long expirationDate, String mcc, String mnc) {
        ImsiEncryptionInfo imsiEncryptionInfo = new ImsiEncryptionInfo(mcc, mnc, type, identifier, publicKey, new Date(expirationDate));
        this.mPhone.setCarrierInfoForImsiEncryption(imsiEncryptionInfo);
    }
}

